// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*************************************************************************
 * @file Simple.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "Simple.h"

#include "fastcdr/Cdr.h"


#include "fastcdr/exceptions/BadParamException.h"
using namespace eprosima::fastcdr::exception;

#include <utility>

SimpleStruct::SimpleStruct()
{
    m_myString = "";
}

SimpleStruct::~SimpleStruct()
{
}

SimpleStruct::SimpleStruct(const SimpleStruct &x)
{
    m_myString = x.m_myString;
}

SimpleStruct::SimpleStruct(SimpleStruct &&x)
{
    m_myString = x.m_myString;
}

SimpleStruct& SimpleStruct::operator=(const SimpleStruct &x)
{
    m_myString = x.m_myString;
    
    return *this;
}

SimpleStruct& SimpleStruct::operator=(SimpleStruct &&x)
{
    m_myString = x.m_myString;
    
    return *this;
}

size_t SimpleStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t current_align = current_alignment;
            
    current_align += 4 + eprosima::fastcdr::Cdr::alignment(current_align, 4) + 255 + 1;

    return current_align;
}
size_t SimpleStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool SimpleStruct::isKeyDefined()
{
 return false;
}

void SimpleStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    if(m_myString.length() <= 255)
    scdr << m_myString;
    else
        throw eprosima::fastcdr::exception::BadParamException(std::string("myString field exceeds the maximum length"));
}

void SimpleStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_myString;
}

void SimpleStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	 
}
