/**
 * @file /include/ecl/devices/detail/exception_handler_pos.hpp
 *
 * @brief Defines exception handlers for posix devices.
 *
 * @date September 2009
 **/
/*****************************************************************************
** Ifdefs
*****************************************************************************/

#ifndef ECL_DEVICES_EXCEPTION_HANDLER_POS_HPP_
#define ECL_DEVICES_EXCEPTION_HANDLER_POS_HPP_

/*****************************************************************************
** Cross Platform Check
*****************************************************************************/

#include <ecl/config/ecl.hpp>

/*****************************************************************************
** Includes
*****************************************************************************/

#include <string>
#include <ecl/exceptions/standard_exception.hpp>

/*****************************************************************************
** Namespaces
*****************************************************************************/

namespace ecl {
namespace devices {

/*****************************************************************************
** Methods
*****************************************************************************/

/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>open/fdopen</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @param file_name : not directly used, but incorporated into the debugging message.
 */
StandardException open_exception(const char* loc, const std::string& file_name);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>close/fclose</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @param file_name : not directly used, but incorporated into the debugging message.
 */
StandardException close_exception(const char* loc, const std::string& file_name);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>fsync</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @param file_name : not directly used, but incorporated into the debugging message.
 */
StandardException sync_exception(const char* loc, const std::string& file_name);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>write</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 */
StandardException write_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>read</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 */
StandardException read_exception(const char* loc);

} // namespace devices
} // namespace ecl

#endif /* ECL_DEVICES_EXCEPTION_HANDLER_POS_HPP_ */
