// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file sample.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "sample.h"

#include <fastcdr/Cdr.h>

#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

sample::sample()
{
    m_index = 0;
    m_key_value = 0;
}

sample::~sample()
{
}

sample::sample(const sample &x)
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
}

sample::sample(sample &&x)
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
}

sample& sample::operator=(const sample &x)
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
    
    return *this;
}

sample& sample::operator=(sample &&x)
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
    
    return *this;
}

size_t sample::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t sample::getCdrSerializedSize(const sample&, size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void sample::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_index;

    scdr << m_key_value;

}

void sample::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_index;
    dcdr >> m_key_value;
}

size_t sample::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

     current_align += 1 + eprosima::fastcdr::Cdr::alignment(current_align, 1);
     

    return current_align;
}

bool sample::isKeyDefined()
{
    return true;
}

void sample::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	 
	 scdr << m_key_value;
	  
}
