
# Sample Code for Intel® RealSense™ Python Wrapper

These Examples demonstrate how to use the python wrapper of the SDK.

## List of Examples:

1. [Tutorial 1](./python-tutorial-1-depth.py) - Demonstrates how to start streaming depth frames from the camera and display the image in the console as an ASCII art.
2. [NumPy and OpenCV](./opencv_viewer_example.py) - Example of rendering depth and color images using the help of OpenCV and Numpy
3. [Stream Alignment](./align-depth2color.py) - Demonstrate a way of performing background removal by aligning depth images to color images and performing simple calculation to strip the background.
4. [RS400 Advanced Mode](./python-rs400-advanced-mode-example.py) - Example of the advanced mode interface for controlling different options of the D400 cameras
5. [Realsense Backend](./pybackend_example_1_general.py) - Example of controlling devices using the backend interface
6. [Read bag file](./read_bag_example.py) - Example on how to read bag file and use colorizer to show recorded depth stream in jet colormap.
7. [Box Dimensioner Multicam](./box_dimensioner_multicam/box_dimensioner_multicam_demo.py) - Simple demonstration for calculating the length, width and height of an object using multiple cameras.
