// Copyright 2018 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Types.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include <uxr/agent/types/XRCETypes.hpp>
#include <fastcdr/Cdr.h>
#include <fastcdr/exceptions/BadParamException.h>

#include <utility>

using namespace eprosima::fastcdr::exception;

dds::xrce::Time_t::Time_t()
{
    m_seconds = 0;
    m_nanoseconds = 0;
}

dds::xrce::Time_t::~Time_t()
{
}

dds::xrce::Time_t::Time_t(const Time_t &x)
{
    m_seconds = x.m_seconds;
    m_nanoseconds = x.m_nanoseconds;
}

dds::xrce::Time_t::Time_t(Time_t &&x)
{
    m_seconds = x.m_seconds;
    m_nanoseconds = x.m_nanoseconds;
}

dds::xrce::Time_t& dds::xrce::Time_t::operator=(const Time_t &x)
{
    m_seconds = x.m_seconds;
    m_nanoseconds = x.m_nanoseconds;
    
    return *this;
}

dds::xrce::Time_t& dds::xrce::Time_t::operator=(Time_t &&x)
{
    m_seconds = x.m_seconds;
    m_nanoseconds = x.m_nanoseconds;
    
    return *this;
}

size_t dds::xrce::Time_t::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::Time_t::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void dds::xrce::Time_t::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_seconds;
    scdr << m_nanoseconds;
}

void dds::xrce::Time_t::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_seconds;
    dcdr >> m_nanoseconds;
}

dds::xrce::TransportAddressSmall::TransportAddressSmall()
{

    m_port = 0;
}

dds::xrce::TransportAddressSmall::~TransportAddressSmall()
{
}

dds::xrce::TransportAddressSmall::TransportAddressSmall(const TransportAddressSmall &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
}

dds::xrce::TransportAddressSmall::TransportAddressSmall(TransportAddressSmall &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
}

dds::xrce::TransportAddressSmall& dds::xrce::TransportAddressSmall::operator=(const TransportAddressSmall &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
    
    return *this;
}

dds::xrce::TransportAddressSmall& dds::xrce::TransportAddressSmall::operator=(TransportAddressSmall &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
    
    return *this;
}

size_t dds::xrce::TransportAddressSmall::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::TransportAddressSmall::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void dds::xrce::TransportAddressSmall::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_address;
    scdr << m_port;
}

void dds::xrce::TransportAddressSmall::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_address;
    dcdr >> m_port;
}

dds::xrce::TransportAddressMedium::TransportAddressMedium()
{

    m_port = 0;
}

dds::xrce::TransportAddressMedium::~TransportAddressMedium()
{
}

dds::xrce::TransportAddressMedium::TransportAddressMedium(const TransportAddressMedium &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
}

dds::xrce::TransportAddressMedium::TransportAddressMedium(TransportAddressMedium &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
}

dds::xrce::TransportAddressMedium& dds::xrce::TransportAddressMedium::operator=(const TransportAddressMedium &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
    
    return *this;
}

dds::xrce::TransportAddressMedium& dds::xrce::TransportAddressMedium::operator=(TransportAddressMedium &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
    
    return *this;
}

size_t dds::xrce::TransportAddressMedium::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::TransportAddressMedium::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void dds::xrce::TransportAddressMedium::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_address;
    scdr << m_port;
}

void dds::xrce::TransportAddressMedium::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_address;
    dcdr >> m_port;
}

dds::xrce::TransportAddressLarge::TransportAddressLarge()
{

    m_port = 0;
}

dds::xrce::TransportAddressLarge::~TransportAddressLarge()
{
}

dds::xrce::TransportAddressLarge::TransportAddressLarge(const TransportAddressLarge &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
}

dds::xrce::TransportAddressLarge::TransportAddressLarge(TransportAddressLarge &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
}

dds::xrce::TransportAddressLarge& dds::xrce::TransportAddressLarge::operator=(const TransportAddressLarge &x)
{
    m_address = x.m_address;
    m_port = x.m_port;
    
    return *this;
}

dds::xrce::TransportAddressLarge& dds::xrce::TransportAddressLarge::operator=(TransportAddressLarge &&x)
{
    m_address = std::move(x.m_address);
    m_port = x.m_port;
    
    return *this;
}

size_t dds::xrce::TransportAddressLarge::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((16) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::TransportAddressLarge::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((16) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void dds::xrce::TransportAddressLarge::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_address;
    scdr << m_port;
}

void dds::xrce::TransportAddressLarge::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_address;
    dcdr >> m_port;
}

dds::xrce::TransportAddressString::TransportAddressString()
{
}

dds::xrce::TransportAddressString::~TransportAddressString()
{
}

dds::xrce::TransportAddressString::TransportAddressString(const TransportAddressString &x)
{
    m_value = x.m_value;
}

dds::xrce::TransportAddressString::TransportAddressString(TransportAddressString &&x)
{
    m_value = std::move(x.m_value);
}

dds::xrce::TransportAddressString& dds::xrce::TransportAddressString::operator=(const TransportAddressString &x)
{
    m_value = x.m_value;
    
    return *this;
}

dds::xrce::TransportAddressString& dds::xrce::TransportAddressString::operator=(TransportAddressString &&x)
{
    m_value = std::move(x.m_value);
    
    return *this;
}

size_t dds::xrce::TransportAddressString::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    return current_alignment - initial_alignment;
}

size_t dds::xrce::TransportAddressString::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_value.size() + 1;

    return current_alignment - initial_alignment;
}

void dds::xrce::TransportAddressString::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_value;
}

void dds::xrce::TransportAddressString::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_value;
}

dds::xrce::TransportAddress::TransportAddress()
{
    m__d = dds::xrce::ADDRESS_FORMAT_SMALL;
}

dds::xrce::TransportAddress::~TransportAddress()
{
}

dds::xrce::TransportAddress::TransportAddress(const TransportAddress &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        m_small_locator = x.m_small_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        m_medium_locator = x.m_medium_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        m_large_locator = x.m_large_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        m_string_locator = x.m_string_locator;
        break;
        default:
        break;
    }
}

dds::xrce::TransportAddress::TransportAddress(TransportAddress &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        m_small_locator = std::move(x.m_small_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        m_medium_locator = std::move(x.m_medium_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        m_large_locator = std::move(x.m_large_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        m_string_locator = std::move(x.m_string_locator);
        break;
        default:
        break;
    }
}

dds::xrce::TransportAddress& dds::xrce::TransportAddress::operator=(const TransportAddress &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        m_small_locator = x.m_small_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        m_medium_locator = x.m_medium_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        m_large_locator = x.m_large_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        m_string_locator = x.m_string_locator;
        break;
        default:
        break;
    }
    
    return *this;
}

dds::xrce::TransportAddress& dds::xrce::TransportAddress::operator=(TransportAddress &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        m_small_locator = std::move(x.m_small_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        m_medium_locator = std::move(x.m_medium_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        m_large_locator = std::move(x.m_large_locator);
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        m_string_locator = std::move(x.m_string_locator);
        break;
        default:
        break;
    }
    
    return *this;
}

void dds::xrce::TransportAddress::_d(dds::xrce::TransportAddressFormat __d)
{
    bool b = false;
    
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        switch(__d)
        {
            case dds::xrce::ADDRESS_FORMAT_SMALL:
            b = true;
            break;
            default:
            break;
        }
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        switch(__d)
        {
            case dds::xrce::ADDRESS_FORMAT_MEDIUM:
            b = true;
            break;
            default:
            break;
        }
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        switch(__d)
        {
            case dds::xrce::ADDRESS_FORMAT_LARGE:
            b = true;
            break;
            default:
            break;
        }
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        switch(__d)
        {
            case dds::xrce::ADDRESS_FORMAT_STRING:
            b = true;
            break;
            default:
            break;
        }
        break;
    }
    
    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");
    
    m__d = __d;
}

dds::xrce::TransportAddressFormat dds::xrce::TransportAddress::_d() const
{
    return m__d;
}

dds::xrce::TransportAddressFormat& dds::xrce::TransportAddress::_d()
{
    return m__d;
}

void dds::xrce::TransportAddress::small_locator(const dds::xrce::TransportAddressSmall &_small_locator)
{
    m_small_locator = _small_locator;
    m__d = dds::xrce::ADDRESS_FORMAT_SMALL;
}

void dds::xrce::TransportAddress::small_locator(dds::xrce::TransportAddressSmall &&_small_locator)
{
    m_small_locator = std::move(_small_locator);
    m__d = dds::xrce::ADDRESS_FORMAT_SMALL;
}

const dds::xrce::TransportAddressSmall& dds::xrce::TransportAddress::small_locator() const
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_small_locator;
}

dds::xrce::TransportAddressSmall& dds::xrce::TransportAddress::small_locator()
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_small_locator;
}
void dds::xrce::TransportAddress::medium_locator(const dds::xrce::TransportAddressMedium &_medium_locator)
{
    m_medium_locator = _medium_locator;
    m__d = dds::xrce::ADDRESS_FORMAT_MEDIUM;
}

void dds::xrce::TransportAddress::medium_locator(dds::xrce::TransportAddressMedium &&_medium_locator)
{
    m_medium_locator = std::move(_medium_locator);
    m__d = dds::xrce::ADDRESS_FORMAT_MEDIUM;
}

const dds::xrce::TransportAddressMedium& dds::xrce::TransportAddress::medium_locator() const
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_medium_locator;
}

dds::xrce::TransportAddressMedium& dds::xrce::TransportAddress::medium_locator()
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_medium_locator;
}
void dds::xrce::TransportAddress::large_locator(const dds::xrce::TransportAddressLarge &_large_locator)
{
    m_large_locator = _large_locator;
    m__d = dds::xrce::ADDRESS_FORMAT_LARGE;
}

void dds::xrce::TransportAddress::large_locator(dds::xrce::TransportAddressLarge &&_large_locator)
{
    m_large_locator = std::move(_large_locator);
    m__d = dds::xrce::ADDRESS_FORMAT_LARGE;
}

const dds::xrce::TransportAddressLarge& dds::xrce::TransportAddress::large_locator() const
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_large_locator;
}

dds::xrce::TransportAddressLarge& dds::xrce::TransportAddress::large_locator()
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_large_locator;
}
void dds::xrce::TransportAddress::string_locator(const dds::xrce::TransportAddressString &_string_locator)
{
    m_string_locator = _string_locator;
    m__d = dds::xrce::ADDRESS_FORMAT_STRING;
}

void dds::xrce::TransportAddress::string_locator(dds::xrce::TransportAddressString &&_string_locator)
{
    m_string_locator = std::move(_string_locator);
    m__d = dds::xrce::ADDRESS_FORMAT_STRING;
}

const dds::xrce::TransportAddressString& dds::xrce::TransportAddress::string_locator() const
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_STRING:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_string_locator;
}

dds::xrce::TransportAddressString& dds::xrce::TransportAddress::string_locator()
{
    bool b = false;
        
    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_STRING:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_string_locator;
}

size_t dds::xrce::TransportAddress::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::TransportAddressSmall::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::TransportAddressMedium::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::TransportAddressLarge::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::TransportAddressString::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

size_t dds::xrce::TransportAddress::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
            current_alignment += m_small_locator.getCdrSerializedSize(current_alignment);
            break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
            current_alignment += m_medium_locator.getCdrSerializedSize(current_alignment);
            break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
            current_alignment += m_large_locator.getCdrSerializedSize(current_alignment);
            break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
            current_alignment += m_string_locator.getCdrSerializedSize(current_alignment);
            break;
        default:
            break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::TransportAddress::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint8_t)m__d;

    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        scdr << m_small_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        scdr << m_medium_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        scdr << m_large_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        scdr << m_string_locator;
        break;
        default:
        break;
    }
}

void dds::xrce::TransportAddress::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> (uint8_t&)m__d;

    switch(m__d)
    {
        case dds::xrce::ADDRESS_FORMAT_SMALL:
        dcdr >> m_small_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_MEDIUM:
        dcdr >> m_medium_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_LARGE:
        dcdr >> m_large_locator;
        break;
        case dds::xrce::ADDRESS_FORMAT_STRING:
        dcdr >> m_string_locator;
        break;
        default:
        break;
    }
}



dds::xrce::Property::Property()
{


}

dds::xrce::Property::~Property()
{
}

dds::xrce::Property::Property(const Property &x)
{
    m_name = x.m_name;
    m_value = x.m_value;
}

dds::xrce::Property::Property(Property &&x)
{
    m_name = std::move(x.m_name);
    m_value = std::move(x.m_value);
}

dds::xrce::Property& dds::xrce::Property::operator=(const Property &x)
{
    m_name = x.m_name;
    m_value = x.m_value;
    
    return *this;
}

dds::xrce::Property& dds::xrce::Property::operator=(Property &&x)
{
    m_name = std::move(x.m_name);
    m_value = std::move(x.m_value);
    
    return *this;
}

size_t dds::xrce::Property::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;


    return current_alignment - initial_alignment;
}

size_t dds::xrce::Property::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_name.size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_value.size() + 1;


    return current_alignment - initial_alignment;
}

void dds::xrce::Property::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_name;
    scdr << m_value;
}

void dds::xrce::Property::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_name;
    dcdr >> m_value;
}

dds::xrce::CLIENT_Representation::CLIENT_Representation()
{
    m_session_id = 0;
}

dds::xrce::CLIENT_Representation::~CLIENT_Representation()
{
}

dds::xrce::CLIENT_Representation::CLIENT_Representation(const CLIENT_Representation &x)
{
    m_xrce_cookie = x.m_xrce_cookie;
    m_xrce_version = x.m_xrce_version;
    m_xrce_vendor_id = x.m_xrce_vendor_id;
    m_client_timestamp = x.m_client_timestamp;
    m_client_key = x.m_client_key;
    m_session_id = x.m_session_id;
}

dds::xrce::CLIENT_Representation::CLIENT_Representation(CLIENT_Representation &&x)
{
    m_xrce_cookie = std::move(x.m_xrce_cookie);
    m_xrce_version = std::move(x.m_xrce_version);
    m_xrce_vendor_id = std::move(x.m_xrce_vendor_id);
    m_client_timestamp = std::move(x.m_client_timestamp);
    m_client_key = std::move(x.m_client_key);
    m_session_id = x.m_session_id;
}

dds::xrce::CLIENT_Representation& dds::xrce::CLIENT_Representation::operator=(const CLIENT_Representation &x)
{
    m_xrce_cookie = x.m_xrce_cookie;
    m_xrce_version = x.m_xrce_version;
    m_xrce_vendor_id = x.m_xrce_vendor_id;
    m_client_timestamp = x.m_client_timestamp;
    m_client_key = x.m_client_key;
    m_session_id = x.m_session_id;
    
    return *this;
}

dds::xrce::CLIENT_Representation& dds::xrce::CLIENT_Representation::operator=(CLIENT_Representation &&x)
{
    m_xrce_cookie = std::move(x.m_xrce_cookie);
    m_xrce_version = std::move(x.m_xrce_version);
    m_xrce_vendor_id = std::move(x.m_xrce_vendor_id);
    m_client_timestamp = std::move(x.m_client_timestamp);
    m_client_key = std::move(x.m_client_key);
    m_session_id = x.m_session_id;
    
    return *this;
}

size_t dds::xrce::CLIENT_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += dds::xrce::Time_t::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::CLIENT_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += m_client_timestamp.getCdrSerializedSize(current_alignment);
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    /* Optinal properties. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_properties)
    {
        for (size_t a = 0; a < (*m_properties).size(); ++a)
        {
            current_alignment += (*m_properties).at(a).getCdrSerializedSize(current_alignment);
        }
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::CLIENT_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_xrce_cookie;
    scdr << m_xrce_version;
    scdr << m_xrce_vendor_id;
    scdr << m_client_timestamp;
    scdr << m_client_key;
    scdr << m_session_id;
    scdr << bool(m_properties);
    if (m_properties)
    {
        scdr << (*m_properties);
    }
}

void dds::xrce::CLIENT_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_xrce_cookie;
    dcdr >> m_xrce_version;
    dcdr >> m_xrce_vendor_id;
    dcdr >> m_client_timestamp;
    dcdr >> m_client_key;
    dcdr >> m_session_id;
    bool m_properties_flag;
    dcdr >> m_properties_flag;
    if (m_properties_flag)
    {
        PropertySeq temp_properties;
        dcdr >> temp_properties;
        m_properties = temp_properties;
    }
}

dds::xrce::AGENT_Representation::AGENT_Representation()
{
}

dds::xrce::AGENT_Representation::~AGENT_Representation()
{
}

dds::xrce::AGENT_Representation::AGENT_Representation(const AGENT_Representation &x)
{
    m_xrce_cookie = x.m_xrce_cookie;
    m_xrce_version = x.m_xrce_version;
    m_xrce_vendor_id = x.m_xrce_vendor_id;
    m_agent_timestamp = x.m_agent_timestamp;
}

dds::xrce::AGENT_Representation::AGENT_Representation(AGENT_Representation &&x)
{
    m_xrce_cookie = std::move(x.m_xrce_cookie);
    m_xrce_version = std::move(x.m_xrce_version);
    m_xrce_vendor_id = std::move(x.m_xrce_vendor_id);
    m_agent_timestamp = std::move(x.m_agent_timestamp);
}

dds::xrce::AGENT_Representation& dds::xrce::AGENT_Representation::operator=(const AGENT_Representation &x)
{
    m_xrce_cookie = x.m_xrce_cookie;
    m_xrce_version = x.m_xrce_version;
    m_xrce_vendor_id = x.m_xrce_vendor_id;
    m_agent_timestamp = x.m_agent_timestamp;
    
    return *this;
}

dds::xrce::AGENT_Representation& dds::xrce::AGENT_Representation::operator=(AGENT_Representation &&x)
{
    m_xrce_cookie = std::move(x.m_xrce_cookie);
    m_xrce_version = std::move(x.m_xrce_version);
    m_xrce_vendor_id = std::move(x.m_xrce_vendor_id);
    m_agent_timestamp = std::move(x.m_agent_timestamp);
    
    return *this;
}

size_t dds::xrce::AGENT_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += dds::xrce::Time_t::getMaxCdrSerializedSize(current_alignment);
    /* TODO (Julian): add optional support for getMaxCrdSerializedSize */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::AGENT_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += m_agent_timestamp.getCdrSerializedSize(current_alignment);

    /* Optional properties. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_properties)
    {
        for (size_t a = 0; a < (*m_properties).size(); ++a)
        {
            current_alignment += (*m_properties).at(a).getCdrSerializedSize(current_alignment);
        }
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::AGENT_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_xrce_cookie;
    scdr << m_xrce_version;
    scdr << m_xrce_vendor_id;
    scdr << m_agent_timestamp;
    scdr << bool(m_properties);
    if (m_properties)
    {
        scdr << (*m_properties);
    }
}

void dds::xrce::AGENT_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_xrce_cookie;
    dcdr >> m_xrce_version;
    dcdr >> m_xrce_vendor_id;
    dcdr >> m_agent_timestamp;
    bool m_properties_flag;
    dcdr >> m_properties_flag;
    if (m_properties_flag)
    {
        PropertySeq temp_properties;
        dcdr >> temp_properties;
        m_properties = temp_properties;
    }
}

dds::xrce::OBJK_Representation3Formats::OBJK_Representation3Formats()
{
    m__d = REPRESENTATION_BY_REFERENCE;
}

dds::xrce::OBJK_Representation3Formats::~OBJK_Representation3Formats()
{
}

dds::xrce::OBJK_Representation3Formats::OBJK_Representation3Formats(const OBJK_Representation3Formats &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            m_object_reference = x.m_object_reference;
            break;
        case REPRESENTATION_AS_XML_STRING:
            m_xml_string_representation = x.m_xml_string_representation;
            break;
        case REPRESENTATION_IN_BINARY:
            m_binary_representation = x.m_binary_representation;
            break;
        default:
            break;
    }
}

dds::xrce::OBJK_Representation3Formats::OBJK_Representation3Formats(OBJK_Representation3Formats &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            m_object_reference = std::move(x.m_object_reference);
            break;
        case REPRESENTATION_AS_XML_STRING:
            m_xml_string_representation = std::move(x.m_xml_string_representation);
            break;
        case REPRESENTATION_IN_BINARY:
            m_binary_representation = std::move(x.m_binary_representation);
            break;
        default:
            break;
    }
}

dds::xrce::OBJK_Representation3Formats& dds::xrce::OBJK_Representation3Formats::operator=(const OBJK_Representation3Formats &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            m_object_reference = x.m_object_reference;
            break;
        case REPRESENTATION_AS_XML_STRING:
            m_xml_string_representation = x.m_xml_string_representation;
            break;
        case REPRESENTATION_IN_BINARY:
            m_binary_representation = x.m_binary_representation;
            break;
        default:
            break;
    }
    
    return *this;
}

dds::xrce::OBJK_Representation3Formats& dds::xrce::OBJK_Representation3Formats::operator=(OBJK_Representation3Formats &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            m_object_reference = std::move(x.m_object_reference);
            break;
        case REPRESENTATION_AS_XML_STRING:
            m_xml_string_representation = std::move(x.m_xml_string_representation);
            break;
        case REPRESENTATION_IN_BINARY:
            m_binary_representation = std::move(x.m_binary_representation);
            break;
        default:
            break;
    }
    
    return *this;
}

void dds::xrce::OBJK_Representation3Formats::_d(dds::xrce::RepresentationFormat __d)
{
    bool b = false;
    
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            switch(__d)
            {
                case REPRESENTATION_BY_REFERENCE:
                    b = true;
                    break;
                default:
                    break;
            }
            break;
        case REPRESENTATION_AS_XML_STRING:
            switch(__d)
            {
                case REPRESENTATION_AS_XML_STRING:
                    b = true;
                    break;
                default:
                    break;
            }
            break;
        case REPRESENTATION_IN_BINARY:
            switch(__d)
            {
                case REPRESENTATION_IN_BINARY:
                b = true;
                break;
                default:
                break;
            }
            break;
    }
    
    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");
    
    m__d = __d;
}

dds::xrce::RepresentationFormat dds::xrce::OBJK_Representation3Formats::_d() const
{
    return m__d;
}

dds::xrce::RepresentationFormat& dds::xrce::OBJK_Representation3Formats::_d()
{
    return m__d;
}

void dds::xrce::OBJK_Representation3Formats::object_reference(const std::string &_object_reference)
{
    m_object_reference  = _object_reference;
    m__d                = REPRESENTATION_BY_REFERENCE;
}

void dds::xrce::OBJK_Representation3Formats::object_reference(std::string &&_object_reference)
{
    m_object_reference  = std::move(_object_reference);
    m__d                = REPRESENTATION_BY_REFERENCE;
}

const std::string& dds::xrce::OBJK_Representation3Formats::object_reference() const
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_object_reference;
}

std::string& dds::xrce::OBJK_Representation3Formats::object_reference()
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_object_reference;
}
void dds::xrce::OBJK_Representation3Formats::xml_string_representation(const std::string &_xml_string_representation)
{
    m_xml_string_representation = _xml_string_representation;
    m__d                        = REPRESENTATION_AS_XML_STRING;
}

void dds::xrce::OBJK_Representation3Formats::xml_string_representation(std::string &&_xml_string_representation)
{
    m_xml_string_representation = std::move(_xml_string_representation);
    m__d                        = REPRESENTATION_AS_XML_STRING;
}

const std::string& dds::xrce::OBJK_Representation3Formats::xml_string_representation() const
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_xml_string_representation;
}

std::string& dds::xrce::OBJK_Representation3Formats::xml_string_representation()
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_xml_string_representation;
}
void dds::xrce::OBJK_Representation3Formats::binary_representation(const std::vector<uint8_t> &_binary_representation)
{
    m_binary_representation = _binary_representation;
    m__d                    = REPRESENTATION_IN_BINARY;
}

void dds::xrce::OBJK_Representation3Formats::binary_representation(std::vector<uint8_t> &&_binary_representation)
{
    m_binary_representation = std::move(_binary_representation);
    m__d                    = REPRESENTATION_IN_BINARY;
}

const std::vector<uint8_t>& dds::xrce::OBJK_Representation3Formats::binary_representation() const
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_binary_representation;
}

std::vector<uint8_t>& dds::xrce::OBJK_Representation3Formats::binary_representation()
{
    bool b = false;
        
    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
            b = true;
            break;
        default:
            break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_binary_representation;
}

size_t dds::xrce::OBJK_Representation3Formats::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment            = current_alignment;
    size_t reset_alignment              = 0;
    size_t union_max_size_serialized    = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    reset_alignment = current_alignment;

    reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + REFERENCE_MAX_LEN + 1;

    if(union_max_size_serialized < reset_alignment)
    {
        union_max_size_serialized = reset_alignment;
    }

    
    reset_alignment = current_alignment;

    reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + 255 + 1;

    if(union_max_size_serialized < reset_alignment)
    {
        union_max_size_serialized = reset_alignment;
    }

    reset_alignment = current_alignment;

    reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);
    reset_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(reset_alignment, 1);

    if(union_max_size_serialized < reset_alignment)
    {
        union_max_size_serialized = reset_alignment;
    }

    return union_max_size_serialized - initial_alignment;
}

size_t dds::xrce::OBJK_Representation3Formats::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_object_reference.size() + 1;
            break;
        case REPRESENTATION_AS_XML_STRING:
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_xml_string_representation.size() + 1;
            break;
        case REPRESENTATION_IN_BINARY:
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
            current_alignment += (m_binary_representation.size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
            break;
        default:
            break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Representation3Formats::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            scdr << m_object_reference;
            break;
        case REPRESENTATION_AS_XML_STRING:
            scdr << m_xml_string_representation;
            break;
        case REPRESENTATION_IN_BINARY:
            scdr << m_binary_representation;
            break;
        default:
            break;
    }
}

void dds::xrce::OBJK_Representation3Formats::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
            dcdr >> m_object_reference;
            break;
        case REPRESENTATION_AS_XML_STRING:
            dcdr >> m_xml_string_representation;
            break;
        case REPRESENTATION_IN_BINARY:
            dcdr >> m_binary_representation;
            break;
        default:
            break;
    }
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats::OBJK_RepresentationRefAndXMLFormats()
{
    m__d = REPRESENTATION_BY_REFERENCE;
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats::~OBJK_RepresentationRefAndXMLFormats()
{
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats::OBJK_RepresentationRefAndXMLFormats(const OBJK_RepresentationRefAndXMLFormats &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        m_object_reference = x.m_object_reference;
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = x.m_string_representation;
        break;
        default:
        break;
    }
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats::OBJK_RepresentationRefAndXMLFormats(OBJK_RepresentationRefAndXMLFormats &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        m_object_reference = std::move(x.m_object_reference);
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = std::move(x.m_string_representation);
        break;
        default:
        break;
    }
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats& dds::xrce::OBJK_RepresentationRefAndXMLFormats::operator=(const OBJK_RepresentationRefAndXMLFormats &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        m_object_reference = x.m_object_reference;
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = x.m_string_representation;
        break;
        default:
        break;
    }

    return *this;
}

dds::xrce::OBJK_RepresentationRefAndXMLFormats& dds::xrce::OBJK_RepresentationRefAndXMLFormats::operator=(OBJK_RepresentationRefAndXMLFormats &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        m_object_reference = std::move(x.m_object_reference);
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = std::move(x.m_string_representation);
        break;
        default:
        break;
    }

    return *this;
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::_d(dds::xrce::RepresentationFormat __d)
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        switch(__d)
        {
            case REPRESENTATION_BY_REFERENCE:
            b = true;
            break;
            default:
            break;
        }
        break;
        case REPRESENTATION_AS_XML_STRING:
        switch(__d)
        {
            case REPRESENTATION_AS_XML_STRING:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");

    m__d = __d;
}

dds::xrce::RepresentationFormat dds::xrce::OBJK_RepresentationRefAndXMLFormats::_d() const
{
    return m__d;
}

dds::xrce::RepresentationFormat& dds::xrce::OBJK_RepresentationRefAndXMLFormats::_d()
{
    return m__d;
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::object_reference(const std::string &_object_reference)
{
    m_object_reference = _object_reference;
    m__d = REPRESENTATION_BY_REFERENCE;
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::object_reference(std::string &&_object_reference)
{
    m_object_reference = std::move(_object_reference);
    m__d = REPRESENTATION_BY_REFERENCE;
}

const std::string& dds::xrce::OBJK_RepresentationRefAndXMLFormats::object_reference() const
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_object_reference;
}

std::string& dds::xrce::OBJK_RepresentationRefAndXMLFormats::object_reference()
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_object_reference;
}
void dds::xrce::OBJK_RepresentationRefAndXMLFormats::string_representation(const std::string &_string_representation)
{
    m_string_representation = _string_representation;
    m__d = REPRESENTATION_AS_XML_STRING;
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::string_representation(std::string &&_string_representation)
{
    m_string_representation = std::move(_string_representation);
    m__d = REPRESENTATION_AS_XML_STRING;
}

const std::string& dds::xrce::OBJK_RepresentationRefAndXMLFormats::string_representation() const
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_string_representation;
}

std::string& dds::xrce::OBJK_RepresentationRefAndXMLFormats::string_representation()
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_string_representation;
}

size_t dds::xrce::OBJK_RepresentationRefAndXMLFormats::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + REFERENCE_MAX_LEN + 1;

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + 255 + 1;

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;



    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t dds::xrce::OBJK_RepresentationRefAndXMLFormats::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_object_reference.size() + 1;
        break;
        case REPRESENTATION_AS_XML_STRING:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_string_representation.size() + 1;
        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        scdr << m_object_reference;
        break;
        case REPRESENTATION_AS_XML_STRING:
        scdr << m_string_representation;
        break;
        default:
        break;
    }
}

void dds::xrce::OBJK_RepresentationRefAndXMLFormats::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case REPRESENTATION_BY_REFERENCE:
        dcdr >> m_object_reference;
        break;
        case REPRESENTATION_AS_XML_STRING:
        dcdr >> m_string_representation;
        break;
        default:
        break;
    }
}


dds::xrce::OBJK_RepresentationBinAndXMLFormats::OBJK_RepresentationBinAndXMLFormats()
{
    m__d = REPRESENTATION_IN_BINARY;
}

dds::xrce::OBJK_RepresentationBinAndXMLFormats::~OBJK_RepresentationBinAndXMLFormats()
{
}

dds::xrce::OBJK_RepresentationBinAndXMLFormats::OBJK_RepresentationBinAndXMLFormats(const OBJK_RepresentationBinAndXMLFormats &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        m_binary_representation = x.m_binary_representation;
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = x.m_string_representation;
        break;
        default:
        break;
    }
}

dds::xrce::OBJK_RepresentationBinAndXMLFormats::OBJK_RepresentationBinAndXMLFormats(OBJK_RepresentationBinAndXMLFormats &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        m_binary_representation = std::move(x.m_binary_representation);
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = std::move(x.m_string_representation);
        break;
        default:
        break;
    }
}

dds::xrce::OBJK_RepresentationBinAndXMLFormats& dds::xrce::OBJK_RepresentationBinAndXMLFormats::operator=(const OBJK_RepresentationBinAndXMLFormats &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        m_binary_representation = x.m_binary_representation;
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = x.m_string_representation;
        break;
        default:
        break;
    }

    return *this;
}

dds::xrce::OBJK_RepresentationBinAndXMLFormats& dds::xrce::OBJK_RepresentationBinAndXMLFormats::operator=(OBJK_RepresentationBinAndXMLFormats &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        m_binary_representation = std::move(x.m_binary_representation);
        break;
        case REPRESENTATION_AS_XML_STRING:
        m_string_representation = std::move(x.m_string_representation);
        break;
        default:
        break;
    }

    return *this;
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::_d(dds::xrce::RepresentationFormat __d)
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        switch(__d)
        {
            case REPRESENTATION_IN_BINARY:
            b = true;
            break;
            default:
            break;
        }
        break;
        case REPRESENTATION_AS_XML_STRING:
        switch(__d)
        {
            case REPRESENTATION_AS_XML_STRING:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");

    m__d = __d;
}

dds::xrce::RepresentationFormat dds::xrce::OBJK_RepresentationBinAndXMLFormats::_d() const
{
    return m__d;
}

dds::xrce::RepresentationFormat& dds::xrce::OBJK_RepresentationBinAndXMLFormats::_d()
{
    return m__d;
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::binary_representation(const std::vector<uint8_t> &_binary_representation)
{
    m_binary_representation = _binary_representation;
    m__d = REPRESENTATION_IN_BINARY;
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::binary_representation(std::vector<uint8_t> &&_binary_representation)
{
    m_binary_representation = std::move(_binary_representation);
    m__d = REPRESENTATION_IN_BINARY;
}

const std::vector<uint8_t>& dds::xrce::OBJK_RepresentationBinAndXMLFormats::binary_representation() const
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_binary_representation;
}

std::vector<uint8_t>& dds::xrce::OBJK_RepresentationBinAndXMLFormats::binary_representation()
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_binary_representation;
}
void dds::xrce::OBJK_RepresentationBinAndXMLFormats::string_representation(const std::string &_string_representation)
{
    m_string_representation = _string_representation;
    m__d = REPRESENTATION_AS_XML_STRING;
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::string_representation(std::string &&_string_representation)
{
    m_string_representation = std::move(_string_representation);
    m__d = REPRESENTATION_AS_XML_STRING;
}

const std::string& dds::xrce::OBJK_RepresentationBinAndXMLFormats::string_representation() const
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_string_representation;
}

std::string& dds::xrce::OBJK_RepresentationBinAndXMLFormats::string_representation()
{
    bool b = false;

    switch(m__d)
    {
        case REPRESENTATION_AS_XML_STRING:
        b = true;
        break;
        default:
        break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_string_representation;
}

size_t dds::xrce::OBJK_RepresentationBinAndXMLFormats::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);
        reset_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(reset_alignment, 1);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + 255 + 1;

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;



    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t dds::xrce::OBJK_RepresentationBinAndXMLFormats::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += (m_binary_representation.size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

        break;
        case REPRESENTATION_AS_XML_STRING:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_string_representation.size() + 1;
        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        scdr << m_binary_representation;
        break;
        case REPRESENTATION_AS_XML_STRING:
        scdr << m_string_representation;
        break;
        default:
        break;
    }
}

void dds::xrce::OBJK_RepresentationBinAndXMLFormats::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case REPRESENTATION_IN_BINARY:
        dcdr >> m_binary_representation;
        break;
        case REPRESENTATION_AS_XML_STRING:
        dcdr >> m_string_representation;
        break;
        default:
        break;
    }
}


dds::xrce::OBJK_RepresentationRefAndXML_Base::OBJK_RepresentationRefAndXML_Base()
{
}

dds::xrce::OBJK_RepresentationRefAndXML_Base::~OBJK_RepresentationRefAndXML_Base()
{
}

dds::xrce::OBJK_RepresentationRefAndXML_Base::OBJK_RepresentationRefAndXML_Base(const OBJK_RepresentationRefAndXML_Base &x)
{
    m_representation = x.m_representation;
}

dds::xrce::OBJK_RepresentationRefAndXML_Base::OBJK_RepresentationRefAndXML_Base(OBJK_RepresentationRefAndXML_Base &&x)
{
    m_representation = std::move(x.m_representation);
}

dds::xrce::OBJK_RepresentationRefAndXML_Base& dds::xrce::OBJK_RepresentationRefAndXML_Base::operator=(const OBJK_RepresentationRefAndXML_Base &x)
{
    m_representation = x.m_representation;

    return *this;
}

dds::xrce::OBJK_RepresentationRefAndXML_Base& dds::xrce::OBJK_RepresentationRefAndXML_Base::operator=(OBJK_RepresentationRefAndXML_Base &&x)
{
    m_representation = std::move(x.m_representation);

    return *this;
}

size_t dds::xrce::OBJK_RepresentationRefAndXML_Base::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += dds::xrce::OBJK_RepresentationRefAndXMLFormats::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_RepresentationRefAndXML_Base::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += m_representation.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_RepresentationRefAndXML_Base::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_representation;
}

void dds::xrce::OBJK_RepresentationRefAndXML_Base::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_representation;
}

dds::xrce::OBJK_RepresentationBinAndXML_Base::OBJK_RepresentationBinAndXML_Base()
{
}

dds::xrce::OBJK_RepresentationBinAndXML_Base::~OBJK_RepresentationBinAndXML_Base()
{
}

dds::xrce::OBJK_RepresentationBinAndXML_Base::OBJK_RepresentationBinAndXML_Base(const OBJK_RepresentationBinAndXML_Base &x)
{
    m_representation = x.m_representation;
}

dds::xrce::OBJK_RepresentationBinAndXML_Base::OBJK_RepresentationBinAndXML_Base(OBJK_RepresentationBinAndXML_Base &&x)
{
    m_representation = std::move(x.m_representation);
}

dds::xrce::OBJK_RepresentationBinAndXML_Base& dds::xrce::OBJK_RepresentationBinAndXML_Base::operator=(const OBJK_RepresentationBinAndXML_Base &x)
{
    m_representation = x.m_representation;

    return *this;
}

dds::xrce::OBJK_RepresentationBinAndXML_Base& dds::xrce::OBJK_RepresentationBinAndXML_Base::operator=(OBJK_RepresentationBinAndXML_Base &&x)
{
    m_representation = std::move(x.m_representation);

    return *this;
}

size_t dds::xrce::OBJK_RepresentationBinAndXML_Base::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += dds::xrce::OBJK_RepresentationBinAndXMLFormats::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_RepresentationBinAndXML_Base::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += m_representation.getCdrSerializedSize(current_alignment);
    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_RepresentationBinAndXML_Base::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_representation;
}

void dds::xrce::OBJK_RepresentationBinAndXML_Base::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_representation;
}

dds::xrce::OBJK_Representation3_Base::OBJK_Representation3_Base()
{
}

dds::xrce::OBJK_Representation3_Base::~OBJK_Representation3_Base()
{
}

dds::xrce::OBJK_Representation3_Base::OBJK_Representation3_Base(const OBJK_Representation3_Base &x)
{
    m_representation = x.m_representation;
}

dds::xrce::OBJK_Representation3_Base::OBJK_Representation3_Base(OBJK_Representation3_Base &&x)
{
    m_representation = std::move(x.m_representation);
}

dds::xrce::OBJK_Representation3_Base& dds::xrce::OBJK_Representation3_Base::operator=(const OBJK_Representation3_Base &x)
{
    m_representation = x.m_representation;
    
    return *this;
}

dds::xrce::OBJK_Representation3_Base& dds::xrce::OBJK_Representation3_Base::operator=(OBJK_Representation3_Base &&x)
{
    m_representation = std::move(x.m_representation);
    
    return *this;
}

size_t dds::xrce::OBJK_Representation3_Base::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3Formats::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_Representation3_Base::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += m_representation.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Representation3_Base::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_representation;
}

void dds::xrce::OBJK_Representation3_Base::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_representation;
}

dds::xrce::OBJK_QOSPROFILE_Representation::OBJK_QOSPROFILE_Representation()
{
}

dds::xrce::OBJK_QOSPROFILE_Representation::~OBJK_QOSPROFILE_Representation()
{
}

dds::xrce::OBJK_QOSPROFILE_Representation::OBJK_QOSPROFILE_Representation(const OBJK_QOSPROFILE_Representation &x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_QOSPROFILE_Representation::OBJK_QOSPROFILE_Representation(OBJK_QOSPROFILE_Representation &&x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_QOSPROFILE_Representation& dds::xrce::OBJK_QOSPROFILE_Representation::operator=(const OBJK_QOSPROFILE_Representation &x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

dds::xrce::OBJK_QOSPROFILE_Representation& dds::xrce::OBJK_QOSPROFILE_Representation::operator=(OBJK_QOSPROFILE_Representation &&x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

size_t dds::xrce::OBJK_QOSPROFILE_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_QOSPROFILE_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_QOSPROFILE_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    dds::xrce::OBJK_RepresentationRefAndXML_Base::serialize(scdr);
}

void dds::xrce::OBJK_QOSPROFILE_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dds::xrce::OBJK_RepresentationRefAndXML_Base::deserialize(dcdr);
}

dds::xrce::OBJK_TYPE_Representation::OBJK_TYPE_Representation()
{
}

dds::xrce::OBJK_TYPE_Representation::~OBJK_TYPE_Representation()
{
}

dds::xrce::OBJK_TYPE_Representation::OBJK_TYPE_Representation(const OBJK_TYPE_Representation &x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_TYPE_Representation::OBJK_TYPE_Representation(OBJK_TYPE_Representation &&x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_TYPE_Representation& dds::xrce::OBJK_TYPE_Representation::operator=(const OBJK_TYPE_Representation &x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

dds::xrce::OBJK_TYPE_Representation& dds::xrce::OBJK_TYPE_Representation::operator=(OBJK_TYPE_Representation &&x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

size_t dds::xrce::OBJK_TYPE_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_TYPE_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_TYPE_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    dds::xrce::OBJK_RepresentationRefAndXML_Base::serialize(scdr);
}

void dds::xrce::OBJK_TYPE_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dds::xrce::OBJK_RepresentationRefAndXML_Base::deserialize(dcdr);
}

dds::xrce::OBJK_DOMAIN_Representation::OBJK_DOMAIN_Representation()
{
}

dds::xrce::OBJK_DOMAIN_Representation::~OBJK_DOMAIN_Representation()
{
}

dds::xrce::OBJK_DOMAIN_Representation::OBJK_DOMAIN_Representation(const OBJK_DOMAIN_Representation &x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_DOMAIN_Representation::OBJK_DOMAIN_Representation(OBJK_DOMAIN_Representation &&x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_DOMAIN_Representation& dds::xrce::OBJK_DOMAIN_Representation::operator=(const OBJK_DOMAIN_Representation &x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

dds::xrce::OBJK_DOMAIN_Representation& dds::xrce::OBJK_DOMAIN_Representation::operator=(OBJK_DOMAIN_Representation &&x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

size_t dds::xrce::OBJK_DOMAIN_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_DOMAIN_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_DOMAIN_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_RepresentationRefAndXML_Base::serialize(scdr);
}

void dds::xrce::OBJK_DOMAIN_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_RepresentationRefAndXML_Base::deserialize(dcdr);
}

dds::xrce::OBJK_APPLICATION_Representation::OBJK_APPLICATION_Representation()
{
}

dds::xrce::OBJK_APPLICATION_Representation::~OBJK_APPLICATION_Representation()
{
}

dds::xrce::OBJK_APPLICATION_Representation::OBJK_APPLICATION_Representation(const OBJK_APPLICATION_Representation &x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_APPLICATION_Representation::OBJK_APPLICATION_Representation(OBJK_APPLICATION_Representation &&x)
    : OBJK_RepresentationRefAndXML_Base(x)
{
}

dds::xrce::OBJK_APPLICATION_Representation& dds::xrce::OBJK_APPLICATION_Representation::operator=(const OBJK_APPLICATION_Representation &x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

dds::xrce::OBJK_APPLICATION_Representation& dds::xrce::OBJK_APPLICATION_Representation::operator=(OBJK_APPLICATION_Representation &&x)
{
    OBJK_RepresentationRefAndXML_Base::operator=(x);
    return *this;
}

size_t dds::xrce::OBJK_APPLICATION_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_APPLICATION_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationRefAndXML_Base::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_APPLICATION_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_RepresentationRefAndXML_Base::serialize(scdr);
}

void dds::xrce::OBJK_APPLICATION_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_RepresentationRefAndXML_Base::deserialize(dcdr);
}

dds::xrce::OBJK_PARTICIPANT_Representation::OBJK_PARTICIPANT_Representation()
{
}

dds::xrce::OBJK_PARTICIPANT_Representation::~OBJK_PARTICIPANT_Representation()
{
}

dds::xrce::OBJK_PARTICIPANT_Representation::OBJK_PARTICIPANT_Representation(const OBJK_PARTICIPANT_Representation &x)
    : OBJK_Representation3_Base(x)
{
    m_domain_id = x.m_domain_id;
}

dds::xrce::OBJK_PARTICIPANT_Representation::OBJK_PARTICIPANT_Representation(OBJK_PARTICIPANT_Representation &&x)
    : OBJK_Representation3_Base(x)
{
    m_domain_id = std::move(x.m_domain_id);
}

dds::xrce::OBJK_PARTICIPANT_Representation& dds::xrce::OBJK_PARTICIPANT_Representation::operator=(const OBJK_PARTICIPANT_Representation &x)
{
    OBJK_Representation3_Base::operator=(x);
    m_domain_id = x.m_domain_id;
    return *this;
}

dds::xrce::OBJK_PARTICIPANT_Representation& dds::xrce::OBJK_PARTICIPANT_Representation::operator=(OBJK_PARTICIPANT_Representation &&x)
{
    OBJK_Representation3_Base::operator=(x); 
    m_domain_id = std::move(x.m_domain_id);
    return *this;
}

size_t dds::xrce::OBJK_PARTICIPANT_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_PARTICIPANT_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getCdrSerializedSize(current_alignment);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_PARTICIPANT_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_Representation3_Base::serialize(scdr);
    scdr << m_domain_id;
}

void dds::xrce::OBJK_PARTICIPANT_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_Representation3_Base::deserialize(dcdr);
    dcdr >> m_domain_id;
}

dds::xrce::OBJK_TOPIC_Representation::OBJK_TOPIC_Representation()
{
}

dds::xrce::OBJK_TOPIC_Representation::~OBJK_TOPIC_Representation()
{
}

dds::xrce::OBJK_TOPIC_Representation::OBJK_TOPIC_Representation(const OBJK_TOPIC_Representation &x)
    : OBJK_Representation3_Base(x)
{
    m_participant_id = x.m_participant_id;
}

dds::xrce::OBJK_TOPIC_Representation::OBJK_TOPIC_Representation(OBJK_TOPIC_Representation &&x)
    : OBJK_Representation3_Base(x)
{
    m_participant_id = std::move(x.m_participant_id);
}

dds::xrce::OBJK_TOPIC_Representation& dds::xrce::OBJK_TOPIC_Representation::operator=(const OBJK_TOPIC_Representation &x)
{
    OBJK_Representation3_Base::operator=(x);
    m_participant_id = x.m_participant_id;
    
    return *this;
}

dds::xrce::OBJK_TOPIC_Representation& dds::xrce::OBJK_TOPIC_Representation::operator=(OBJK_TOPIC_Representation &&x)
{
    OBJK_Representation3_Base::operator=(x);
    m_participant_id = std::move(x.m_participant_id);
    
    return *this;
}

size_t dds::xrce::OBJK_TOPIC_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_TOPIC_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_TOPIC_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_Representation3_Base::serialize(scdr);
    scdr << m_participant_id;
}

void dds::xrce::OBJK_TOPIC_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_Representation3_Base::deserialize(dcdr);
    dcdr >> m_participant_id;
}

dds::xrce::OBJK_PUBLISHER_Representation::OBJK_PUBLISHER_Representation()
{
}

dds::xrce::OBJK_PUBLISHER_Representation::~OBJK_PUBLISHER_Representation()
{
}

dds::xrce::OBJK_PUBLISHER_Representation::OBJK_PUBLISHER_Representation(const OBJK_PUBLISHER_Representation &x)
    : OBJK_RepresentationBinAndXML_Base(x)
{
    m_participant_id = x.m_participant_id;
}

dds::xrce::OBJK_PUBLISHER_Representation::OBJK_PUBLISHER_Representation(OBJK_PUBLISHER_Representation &&x)
    : OBJK_RepresentationBinAndXML_Base(x)
{
    m_participant_id = std::move(x.m_participant_id);
}

dds::xrce::OBJK_PUBLISHER_Representation& dds::xrce::OBJK_PUBLISHER_Representation::operator=(const OBJK_PUBLISHER_Representation &x)
{
    OBJK_RepresentationBinAndXML_Base::operator=(x);
    m_participant_id = x.m_participant_id;

    return *this;
}

dds::xrce::OBJK_PUBLISHER_Representation& dds::xrce::OBJK_PUBLISHER_Representation::operator=(OBJK_PUBLISHER_Representation &&x)
{
    OBJK_RepresentationBinAndXML_Base::operator=(x);
    m_participant_id = std::move(x.m_participant_id);
    
    return *this;
}

size_t dds::xrce::OBJK_PUBLISHER_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_PUBLISHER_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_PUBLISHER_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_RepresentationBinAndXML_Base::serialize(scdr);
    scdr << m_participant_id;
}

void dds::xrce::OBJK_PUBLISHER_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_RepresentationBinAndXML_Base::deserialize(dcdr);
    dcdr >> m_participant_id;
}

dds::xrce::OBJK_SUBSCRIBER_Representation::OBJK_SUBSCRIBER_Representation()
{
}

dds::xrce::OBJK_SUBSCRIBER_Representation::~OBJK_SUBSCRIBER_Representation()
{
}

dds::xrce::OBJK_SUBSCRIBER_Representation::OBJK_SUBSCRIBER_Representation(const OBJK_SUBSCRIBER_Representation &x)
    : OBJK_RepresentationBinAndXML_Base(x)
{
    m_participant_id = x.m_participant_id;
}

dds::xrce::OBJK_SUBSCRIBER_Representation::OBJK_SUBSCRIBER_Representation(OBJK_SUBSCRIBER_Representation &&x)
    : OBJK_RepresentationBinAndXML_Base(x)
{
    m_participant_id = std::move(x.m_participant_id);
}

dds::xrce::OBJK_SUBSCRIBER_Representation& dds::xrce::OBJK_SUBSCRIBER_Representation::operator=(const OBJK_SUBSCRIBER_Representation &x)
{
    OBJK_RepresentationBinAndXML_Base::operator=(x);
    m_participant_id = x.m_participant_id;
    
    return *this;
}

dds::xrce::OBJK_SUBSCRIBER_Representation& dds::xrce::OBJK_SUBSCRIBER_Representation::operator=(OBJK_SUBSCRIBER_Representation &&x)
{
    OBJK_RepresentationBinAndXML_Base::operator=(x);
    m_participant_id = std::move(x.m_participant_id);
    
    return *this;
}

size_t dds::xrce::OBJK_SUBSCRIBER_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_SUBSCRIBER_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_SUBSCRIBER_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_RepresentationBinAndXML_Base::serialize(scdr);
    scdr << m_participant_id;
}

void dds::xrce::OBJK_SUBSCRIBER_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_RepresentationBinAndXML_Base::deserialize(dcdr);
    dcdr >> m_participant_id;
}

dds::xrce::DATAWRITER_Representation::DATAWRITER_Representation()
{
}

dds::xrce::DATAWRITER_Representation::~DATAWRITER_Representation()
{
}

dds::xrce::DATAWRITER_Representation::DATAWRITER_Representation(const DATAWRITER_Representation &x)
    : OBJK_Representation3_Base(x)
{
    m_publisher_id = x.m_publisher_id;
}

dds::xrce::DATAWRITER_Representation::DATAWRITER_Representation(DATAWRITER_Representation &&x)
    : OBJK_Representation3_Base(x)
{
    m_publisher_id = std::move(x.m_publisher_id);
}

dds::xrce::DATAWRITER_Representation& dds::xrce::DATAWRITER_Representation::operator=(const DATAWRITER_Representation &x)
{
    OBJK_Representation3_Base::operator=(x);
    m_publisher_id = x.m_publisher_id;
    
    return *this;
}

dds::xrce::DATAWRITER_Representation& dds::xrce::DATAWRITER_Representation::operator=(DATAWRITER_Representation &&x)
{
    OBJK_Representation3_Base::operator=(x);
    m_publisher_id = std::move(x.m_publisher_id);
    
    return *this;
}

size_t dds::xrce::DATAWRITER_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATAWRITER_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::DATAWRITER_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_Representation3_Base::serialize(scdr);
    scdr << m_publisher_id;
}

void dds::xrce::DATAWRITER_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_Representation3_Base::deserialize(dcdr);
    dcdr >> m_publisher_id;
}

dds::xrce::DATAREADER_Representation::DATAREADER_Representation()
{
}

dds::xrce::DATAREADER_Representation::~DATAREADER_Representation()
{
}

dds::xrce::DATAREADER_Representation::DATAREADER_Representation(const DATAREADER_Representation &x)
    : OBJK_Representation3_Base(x)
{
    m_subscriber_id = x.m_subscriber_id;
}

dds::xrce::DATAREADER_Representation::DATAREADER_Representation(DATAREADER_Representation &&x)
    : OBJK_Representation3_Base(x)
{
    m_subscriber_id = std::move(x.m_subscriber_id);
}

dds::xrce::DATAREADER_Representation& dds::xrce::DATAREADER_Representation::operator=(const DATAREADER_Representation &x)
{
    OBJK_Representation3_Base::operator=(x);
    m_subscriber_id = x.m_subscriber_id;
    
    return *this;
}

dds::xrce::DATAREADER_Representation& dds::xrce::DATAREADER_Representation::operator=(DATAREADER_Representation &&x)
{
    OBJK_Representation3_Base::operator=(x);
    m_subscriber_id = std::move(x.m_subscriber_id);
    
    return *this;
}

size_t dds::xrce::DATAREADER_Representation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_RepresentationBinAndXML_Base::getMaxCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATAREADER_Representation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::OBJK_Representation3_Base::getCdrSerializedSize(current_alignment);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::DATAREADER_Representation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    OBJK_Representation3_Base::serialize(scdr);
    scdr << m_subscriber_id;
}

void dds::xrce::DATAREADER_Representation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    OBJK_Representation3_Base::deserialize(dcdr);
    dcdr >> m_subscriber_id;
}

dds::xrce::OBJK_DomainParticipant_Binary::OBJK_DomainParticipant_Binary()
{
    m_domain_id = 0;


}

dds::xrce::OBJK_DomainParticipant_Binary::~OBJK_DomainParticipant_Binary()
{
}

dds::xrce::OBJK_DomainParticipant_Binary::OBJK_DomainParticipant_Binary(const OBJK_DomainParticipant_Binary &x)
{
    m_domain_id = x.m_domain_id;
    m_domain_referente = x.m_domain_referente;
    m_qos_profile = x.m_qos_profile;
}

dds::xrce::OBJK_DomainParticipant_Binary::OBJK_DomainParticipant_Binary(OBJK_DomainParticipant_Binary &&x)
{
    m_domain_id = x.m_domain_id;
    m_domain_referente = std::move(x.m_domain_referente);
    m_qos_profile = std::move(x.m_qos_profile);
}

dds::xrce::OBJK_DomainParticipant_Binary& dds::xrce::OBJK_DomainParticipant_Binary::operator=(const OBJK_DomainParticipant_Binary &x)
{
    m_domain_id = x.m_domain_id;
    m_domain_referente = x.m_domain_referente;
    m_qos_profile = x.m_qos_profile;
    
    return *this;
}

dds::xrce::OBJK_DomainParticipant_Binary& dds::xrce::OBJK_DomainParticipant_Binary::operator=(OBJK_DomainParticipant_Binary &&x)
{
    m_domain_id = x.m_domain_id;
    m_domain_referente = std::move(x.m_domain_referente);
    m_qos_profile = std::move(x.m_qos_profile);
    
    return *this;
}

size_t dds::xrce::OBJK_DomainParticipant_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 128 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 128 + 1;


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_DomainParticipant_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_domain_referente.size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_qos_profile.size() + 1;


    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_DomainParticipant_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_domain_id;
    scdr << m_domain_referente;
    scdr << m_qos_profile;
}

void dds::xrce::OBJK_DomainParticipant_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_domain_id;
    dcdr >> m_domain_referente;
    dcdr >> m_qos_profile;
}

dds::xrce::OBJK_Topic_Binary::OBJK_Topic_Binary()
{
}

dds::xrce::OBJK_Topic_Binary::~OBJK_Topic_Binary()
{
}

dds::xrce::OBJK_Topic_Binary::OBJK_Topic_Binary(const OBJK_Topic_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_type_name = x.m_type_name;
    m_type_identifier = x.m_type_identifier;
}

dds::xrce::OBJK_Topic_Binary::OBJK_Topic_Binary(OBJK_Topic_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_type_name = std::move(x.m_type_name);
    m_type_identifier = std::move(x.m_type_identifier);
}

dds::xrce::OBJK_Topic_Binary& dds::xrce::OBJK_Topic_Binary::operator=(const OBJK_Topic_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_type_name = x.m_type_name;
    m_type_identifier = x.m_type_identifier;
    
    return *this;
}

dds::xrce::OBJK_Topic_Binary& dds::xrce::OBJK_Topic_Binary::operator=(OBJK_Topic_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_type_name = std::move(x.m_type_name);
    m_type_identifier = std::move(x.m_type_identifier);
    
    return *this;
}

size_t dds::xrce::OBJK_Topic_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 256 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 256 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_Topic_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_topic_name.size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_type_name.size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_type_identifier.size() + 1;


    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Topic_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_topic_name;
    scdr << m_type_name;
    scdr << m_type_identifier;
}

void dds::xrce::OBJK_Topic_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_topic_name;
    dcdr >> m_type_name;
    dcdr >> m_type_identifier;
}

dds::xrce::OBJK_PUBLISHER_QosBinary::OBJK_PUBLISHER_QosBinary()
{
}

dds::xrce::OBJK_PUBLISHER_QosBinary::~OBJK_PUBLISHER_QosBinary()
{
}

dds::xrce::OBJK_PUBLISHER_QosBinary::OBJK_PUBLISHER_QosBinary(const OBJK_PUBLISHER_QosBinary &x)
{
    m_partitions = x.m_partitions;
    m_group_data = x.m_group_data;
}

dds::xrce::OBJK_PUBLISHER_QosBinary::OBJK_PUBLISHER_QosBinary(OBJK_PUBLISHER_QosBinary &&x)
{
    m_partitions = std::move(x.m_partitions);
    m_group_data = std::move(x.m_group_data);
}

dds::xrce::OBJK_PUBLISHER_QosBinary& dds::xrce::OBJK_PUBLISHER_QosBinary::operator=(const OBJK_PUBLISHER_QosBinary &x)
{
    m_partitions = x.m_partitions;
    m_group_data = x.m_group_data;
    
    return *this;
}

dds::xrce::OBJK_PUBLISHER_QosBinary& dds::xrce::OBJK_PUBLISHER_QosBinary::operator=(OBJK_PUBLISHER_QosBinary &&x)
{
    m_partitions = std::move(x.m_partitions);
    m_group_data = std::move(x.m_group_data);
    
    return *this;
}

size_t dds::xrce::OBJK_PUBLISHER_QosBinary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;
    }
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;
    }

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_PUBLISHER_QosBinary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_partitions.size(); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_partitions.at(a).size() + 1;
    }
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_group_data.size(); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_group_data.at(a).size() + 1;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_PUBLISHER_QosBinary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_partitions;
    scdr << m_group_data;
}

void dds::xrce::OBJK_PUBLISHER_QosBinary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_partitions;
    dcdr >> m_group_data;
}

dds::xrce::OBJK_Publisher_Binary::OBJK_Publisher_Binary()
{
}

dds::xrce::OBJK_Publisher_Binary::~OBJK_Publisher_Binary()
{
}

dds::xrce::OBJK_Publisher_Binary::OBJK_Publisher_Binary(const OBJK_Publisher_Binary &x)
{
    m_publisher_name = x.m_publisher_name;
    m_qos = x.m_qos;
}

dds::xrce::OBJK_Publisher_Binary::OBJK_Publisher_Binary(OBJK_Publisher_Binary &&x)
{
    m_publisher_name = std::move(x.m_publisher_name);
    m_qos = std::move(x.m_qos);
}

dds::xrce::OBJK_Publisher_Binary& dds::xrce::OBJK_Publisher_Binary::operator=(const OBJK_Publisher_Binary &x)
{
    m_publisher_name = x.m_publisher_name;
    m_qos = x.m_qos;
    
    return *this;
}

dds::xrce::OBJK_Publisher_Binary& dds::xrce::OBJK_Publisher_Binary::operator=(OBJK_Publisher_Binary &&x)
{
    m_publisher_name = std::move(x.m_publisher_name);
    m_qos = std::move(x.m_qos);
    
    return *this;
}

size_t dds::xrce::OBJK_Publisher_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += dds::xrce::OBJK_PUBLISHER_QosBinary::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_Publisher_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_publisher_name.size() + 1;

    current_alignment += m_qos.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Publisher_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_publisher_name;
    scdr << m_qos;
}

void dds::xrce::OBJK_Publisher_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_publisher_name;
    dcdr >> m_qos;
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary::OBJK_SUBSCRIBER_QosBinary()
{
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary::~OBJK_SUBSCRIBER_QosBinary()
{
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary::OBJK_SUBSCRIBER_QosBinary(const OBJK_SUBSCRIBER_QosBinary &x)
{
    m_partitions = x.m_partitions;
    m_group_data = x.m_group_data;
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary::OBJK_SUBSCRIBER_QosBinary(OBJK_SUBSCRIBER_QosBinary &&x)
{
    m_partitions = std::move(x.m_partitions);
    m_group_data = std::move(x.m_group_data);
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary& dds::xrce::OBJK_SUBSCRIBER_QosBinary::operator=(const OBJK_SUBSCRIBER_QosBinary &x)
{
    m_partitions = x.m_partitions;
    m_group_data = x.m_group_data;
    
    return *this;
}

dds::xrce::OBJK_SUBSCRIBER_QosBinary& dds::xrce::OBJK_SUBSCRIBER_QosBinary::operator=(OBJK_SUBSCRIBER_QosBinary &&x)
{
    m_partitions = std::move(x.m_partitions);
    m_group_data = std::move(x.m_group_data);
    
    return *this;
}

size_t dds::xrce::OBJK_SUBSCRIBER_QosBinary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;
    }
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_SUBSCRIBER_QosBinary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_partitions.size(); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_partitions.at(a).size() + 1;
    }
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (m_group_data.size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_SUBSCRIBER_QosBinary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_partitions;
    scdr << m_group_data;
}

void dds::xrce::OBJK_SUBSCRIBER_QosBinary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_partitions;
    dcdr >> m_group_data;
}

dds::xrce::OBJK_Subscriber_Binary::OBJK_Subscriber_Binary()
{
}

dds::xrce::OBJK_Subscriber_Binary::~OBJK_Subscriber_Binary()
{
}

dds::xrce::OBJK_Subscriber_Binary::OBJK_Subscriber_Binary(const OBJK_Subscriber_Binary &x)
{
    m_subscriber_name = x.m_subscriber_name;
    m_qos = x.m_qos;
}

dds::xrce::OBJK_Subscriber_Binary::OBJK_Subscriber_Binary(OBJK_Subscriber_Binary &&x)
{
    m_subscriber_name = std::move(x.m_subscriber_name);
    m_qos = std::move(x.m_qos);
}

dds::xrce::OBJK_Subscriber_Binary& dds::xrce::OBJK_Subscriber_Binary::operator=(const OBJK_Subscriber_Binary &x)
{
    m_subscriber_name = x.m_subscriber_name;
    m_qos = x.m_qos;
    
    return *this;
}

dds::xrce::OBJK_Subscriber_Binary& dds::xrce::OBJK_Subscriber_Binary::operator=(OBJK_Subscriber_Binary &&x)
{
    m_subscriber_name = std::move(x.m_subscriber_name);
    m_qos = std::move(x.m_qos);
    
    return *this;
}

size_t dds::xrce::OBJK_Subscriber_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += dds::xrce::OBJK_SUBSCRIBER_QosBinary::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_Subscriber_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_subscriber_name.size() + 1;

    current_alignment += m_qos.getCdrSerializedSize();

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Subscriber_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_subscriber_name;
    scdr << m_qos;
}

void dds::xrce::OBJK_Subscriber_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_subscriber_name;
    dcdr >> m_qos;
}

dds::xrce::OBJK_Endpoint_QosBinary::OBJK_Endpoint_QosBinary()
{
    m_qos_flags = dds::xrce::is_reliable;
    m_history_depth = 0;
    m_deadline_msec = 0;
    m_lifespan_msec = 0;

}

dds::xrce::OBJK_Endpoint_QosBinary::~OBJK_Endpoint_QosBinary()
{
}

dds::xrce::OBJK_Endpoint_QosBinary::OBJK_Endpoint_QosBinary(const OBJK_Endpoint_QosBinary &x)
{
    m_qos_flags = x.m_qos_flags;
    m_history_depth = x.m_history_depth;
    m_deadline_msec = x.m_deadline_msec;
    m_lifespan_msec = x.m_lifespan_msec;
    m_user_data = x.m_user_data;
}

dds::xrce::OBJK_Endpoint_QosBinary::OBJK_Endpoint_QosBinary(OBJK_Endpoint_QosBinary &&x)
{
    m_qos_flags = x.m_qos_flags;
    m_history_depth = x.m_history_depth;
    m_deadline_msec = x.m_deadline_msec;
    m_lifespan_msec = x.m_lifespan_msec;
    m_user_data = std::move(x.m_user_data);
}

dds::xrce::OBJK_Endpoint_QosBinary& dds::xrce::OBJK_Endpoint_QosBinary::operator=(const OBJK_Endpoint_QosBinary &x)
{
    m_qos_flags = x.m_qos_flags;
    m_history_depth = x.m_history_depth;
    m_deadline_msec = x.m_deadline_msec;
    m_lifespan_msec = x.m_lifespan_msec;
    m_user_data = x.m_user_data;
    
    return *this;
}

dds::xrce::OBJK_Endpoint_QosBinary& dds::xrce::OBJK_Endpoint_QosBinary::operator=(OBJK_Endpoint_QosBinary &&x)
{
    m_qos_flags = x.m_qos_flags;
    m_history_depth = x.m_history_depth;
    m_deadline_msec = x.m_deadline_msec;
    m_lifespan_msec = x.m_lifespan_msec;
    m_user_data = std::move(x.m_user_data);
    
    return *this;
}

size_t dds::xrce::OBJK_Endpoint_QosBinary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_Endpoint_QosBinary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (m_user_data.size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_Endpoint_QosBinary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint16_t)m_qos_flags;
    scdr << m_history_depth;
    scdr << m_deadline_msec;
    scdr << m_lifespan_msec;
    scdr << m_user_data;
}

void dds::xrce::OBJK_Endpoint_QosBinary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    std::underlying_type<dds::xrce::EndpointQosFlags>::type temp_qos_flags;
    dcdr >> temp_qos_flags;
    m_qos_flags = static_cast<dds::xrce::EndpointQosFlags>(temp_qos_flags);
    dcdr >> m_history_depth;
    dcdr >> m_deadline_msec;
    dcdr >> m_lifespan_msec;
    dcdr >> m_user_data;
}

dds::xrce::OBJK_DataReader_Binary::OBJK_DataReader_Binary()
{
    m_timebasedfilter_msec = 0;
}

dds::xrce::OBJK_DataReader_Binary::~OBJK_DataReader_Binary()
{
}

dds::xrce::OBJK_DataReader_Binary::OBJK_DataReader_Binary(const OBJK_DataReader_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_endpoint_qos = x.m_endpoint_qos;
    m_timebasedfilter_msec = x.m_timebasedfilter_msec;
    m_contentbased_filter = x.m_contentbased_filter;
}

dds::xrce::OBJK_DataReader_Binary::OBJK_DataReader_Binary(OBJK_DataReader_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_endpoint_qos = std::move(x.m_endpoint_qos);
    m_timebasedfilter_msec = x.m_timebasedfilter_msec;
    m_contentbased_filter = std::move(x.m_contentbased_filter);
}

dds::xrce::OBJK_DataReader_Binary& dds::xrce::OBJK_DataReader_Binary::operator=(const OBJK_DataReader_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_endpoint_qos = x.m_endpoint_qos;
    m_timebasedfilter_msec = x.m_timebasedfilter_msec;
    m_contentbased_filter = x.m_contentbased_filter;
    
    return *this;
}

dds::xrce::OBJK_DataReader_Binary& dds::xrce::OBJK_DataReader_Binary::operator=(OBJK_DataReader_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_endpoint_qos = std::move(x.m_endpoint_qos);
    m_timebasedfilter_msec = x.m_timebasedfilter_msec;
    m_contentbased_filter = std::move(x.m_contentbased_filter);
    
    return *this;
}

size_t dds::xrce::OBJK_DataReader_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += dds::xrce::OBJK_Endpoint_QosBinary::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_DataReader_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_topic_name.size() + 1;
    current_alignment += m_endpoint_qos.getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_contentbased_filter.size() + 1;


    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_DataReader_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_topic_name;
    scdr << m_endpoint_qos;
    scdr << m_timebasedfilter_msec;
    scdr << m_contentbased_filter;
}

void dds::xrce::OBJK_DataReader_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_topic_name;
    dcdr >> m_endpoint_qos;
    dcdr >> m_timebasedfilter_msec;
    dcdr >> m_contentbased_filter;
}

dds::xrce::OBJK_DataWriter_Binary::OBJK_DataWriter_Binary()
{
    m_ownership_strength = 0;
}

dds::xrce::OBJK_DataWriter_Binary::~OBJK_DataWriter_Binary()
{
}

dds::xrce::OBJK_DataWriter_Binary::OBJK_DataWriter_Binary(const OBJK_DataWriter_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_endpoint_qos = x.m_endpoint_qos;
    m_ownership_strength = x.m_ownership_strength;
}

dds::xrce::OBJK_DataWriter_Binary::OBJK_DataWriter_Binary(OBJK_DataWriter_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_endpoint_qos = std::move(x.m_endpoint_qos);
    m_ownership_strength = x.m_ownership_strength;
}

dds::xrce::OBJK_DataWriter_Binary& dds::xrce::OBJK_DataWriter_Binary::operator=(const OBJK_DataWriter_Binary &x)
{
    m_topic_name = x.m_topic_name;
    m_endpoint_qos = x.m_endpoint_qos;
    m_ownership_strength = x.m_ownership_strength;
    
    return *this;
}

dds::xrce::OBJK_DataWriter_Binary& dds::xrce::OBJK_DataWriter_Binary::operator=(OBJK_DataWriter_Binary &&x)
{
    m_topic_name = std::move(x.m_topic_name);
    m_endpoint_qos = std::move(x.m_endpoint_qos);
    m_ownership_strength = x.m_ownership_strength;
    
    return *this;
}

size_t dds::xrce::OBJK_DataWriter_Binary::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += dds::xrce::OBJK_Endpoint_QosBinary::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::OBJK_DataWriter_Binary::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + m_topic_name.size() + 1;
    current_alignment += m_endpoint_qos.getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    return current_alignment - initial_alignment;
}

void dds::xrce::OBJK_DataWriter_Binary::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_topic_name;
    scdr << m_endpoint_qos;
    scdr << m_ownership_strength;
}

void dds::xrce::OBJK_DataWriter_Binary::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_topic_name;
    dcdr >> m_endpoint_qos;
    dcdr >> m_ownership_strength;
}

dds::xrce::ObjectVariant::ObjectVariant()
{
    m__d = OBJK_AGENT;
}

dds::xrce::ObjectVariant::~ObjectVariant()
{
}

dds::xrce::ObjectVariant::ObjectVariant(const ObjectVariant &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
        m_agent = x.m_agent;
        break;
        case OBJK_CLIENT:
        m_client = x.m_client;
        break;
        case OBJK_APPLICATION:
        m_application = x.m_application;
        break;
        case OBJK_PARTICIPANT:
        m_participant = x.m_participant;
        break;
        case OBJK_QOSPROFILE:
        m_qos_profile = x.m_qos_profile;
        break;
        case OBJK_TYPE:
        m_type = x.m_type;
        break;
        case OBJK_TOPIC:
        m_topic = x.m_topic;
        break;
        case OBJK_PUBLISHER:
        m_publisher = x.m_publisher;
        break;
        case OBJK_SUBSCRIBER:
        m_subscriber = x.m_subscriber;
        break;
        case OBJK_DATAWRITER:
        m_data_writer = x.m_data_writer;
        break;
        case OBJK_DATAREADER:
        m_data_reader = x.m_data_reader;
        break;
        default:
        break;
    }
}

dds::xrce::ObjectVariant::ObjectVariant(ObjectVariant &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
        m_agent = std::move(x.m_agent);
        break;
        case OBJK_CLIENT:
        m_client = std::move(x.m_client);
        break;
        case OBJK_APPLICATION:
        m_application = std::move(x.m_application);
        break;
        case OBJK_PARTICIPANT:
        m_participant = std::move(x.m_participant);
        break;
        case OBJK_QOSPROFILE:
        m_qos_profile = std::move(x.m_qos_profile);
        break;
        case OBJK_TYPE:
        m_type = std::move(x.m_type);
        break;
        case OBJK_TOPIC:
        m_topic = std::move(x.m_topic);
        break;
        case OBJK_PUBLISHER:
        m_publisher = std::move(x.m_publisher);
        break;
        case OBJK_SUBSCRIBER:
        m_subscriber = std::move(x.m_subscriber);
        break;
        case OBJK_DATAWRITER:
        m_data_writer = std::move(x.m_data_writer);
        break;
        case OBJK_DATAREADER:
        m_data_reader = std::move(x.m_data_reader);
        break;
        default:
        break;
    }
}

dds::xrce::ObjectVariant& dds::xrce::ObjectVariant::operator=(const ObjectVariant &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
        m_agent = x.m_agent;
        break;
        case OBJK_CLIENT:
        m_client = x.m_client;
        break;
        case OBJK_APPLICATION:
        m_application = x.m_application;
        break;
        case OBJK_PARTICIPANT:
        m_participant = x.m_participant;
        break;
        case OBJK_QOSPROFILE:
        m_qos_profile = x.m_qos_profile;
        break;
        case OBJK_TYPE:
        m_type = x.m_type;
        break;
        case OBJK_TOPIC:
        m_topic = x.m_topic;
        break;
        case OBJK_PUBLISHER:
        m_publisher = x.m_publisher;
        break;
        case OBJK_SUBSCRIBER:
        m_subscriber = x.m_subscriber;
        break;
        case OBJK_DATAWRITER:
        m_data_writer = x.m_data_writer;
        break;
        case OBJK_DATAREADER:
        m_data_reader = x.m_data_reader;
        break;
        default:
        break;
    }
    
    return *this;
}

dds::xrce::ObjectVariant& dds::xrce::ObjectVariant::operator=(ObjectVariant &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
        m_agent = std::move(x.m_agent);
        break;
        case OBJK_CLIENT:
        m_client = std::move(x.m_client);
        break;
        case OBJK_APPLICATION:
        m_application = std::move(x.m_application);
        break;
        case OBJK_PARTICIPANT:
        m_participant = std::move(x.m_participant);
        break;
        case OBJK_QOSPROFILE:
        m_qos_profile = std::move(x.m_qos_profile);
        break;
        case OBJK_TYPE:
        m_type = std::move(x.m_type);
        break;
        case OBJK_TOPIC:
        m_topic = std::move(x.m_topic);
        break;
        case OBJK_PUBLISHER:
        m_publisher = std::move(x.m_publisher);
        break;
        case OBJK_SUBSCRIBER:
        m_subscriber = std::move(x.m_subscriber);
        break;
        case OBJK_DATAWRITER:
        m_data_writer = std::move(x.m_data_writer);
        break;
        case OBJK_DATAREADER:
        m_data_reader = std::move(x.m_data_reader);
        break;
        default:
        break;
    }
    
    return *this;
}

void dds::xrce::ObjectVariant::_d(dds::xrce::ObjectKind __d)
{
    bool b = false;
    
    switch(m__d)
    {
        case OBJK_AGENT:
        switch(__d)
        {
            case OBJK_AGENT:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_CLIENT:
        switch(__d)
        {
            case OBJK_CLIENT:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_APPLICATION:
        switch(__d)
        {
            case OBJK_APPLICATION:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_PARTICIPANT:
        switch(__d)
        {
            case OBJK_PARTICIPANT:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_QOSPROFILE:
        switch(__d)
        {
            case OBJK_QOSPROFILE:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_TYPE:
        switch(__d)
        {
            case OBJK_TYPE:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_TOPIC:
        switch(__d)
        {
            case OBJK_TOPIC:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_PUBLISHER:
        switch(__d)
        {
            case OBJK_PUBLISHER:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_SUBSCRIBER:
        switch(__d)
        {
            case OBJK_SUBSCRIBER:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_DATAWRITER:
        switch(__d)
        {
            case OBJK_DATAWRITER:
            b = true;
            break;
            default:
            break;
        }
        break;
        case OBJK_DATAREADER:
        switch(__d)
        {
            case OBJK_DATAREADER:
            b = true;
            break;
            default:
            break;
        }
        break;
    }
    
    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");
    
    m__d = __d;
}

dds::xrce::ObjectKind dds::xrce::ObjectVariant::_d() const
{
    return m__d;
}

dds::xrce::ObjectKind& dds::xrce::ObjectVariant::_d()
{
    return m__d;
}

void dds::xrce::ObjectVariant::agent(const dds::xrce::AGENT_Representation &_agent)
{
    m_agent = _agent;
    m__d = OBJK_AGENT;
}

void dds::xrce::ObjectVariant::agent(dds::xrce::AGENT_Representation &&_agent)
{
    m_agent = std::move(_agent);
    m__d = OBJK_AGENT;
}

const dds::xrce::AGENT_Representation& dds::xrce::ObjectVariant::agent() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_AGENT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_agent;
}

dds::xrce::AGENT_Representation& dds::xrce::ObjectVariant::agent()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_AGENT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_agent;
}
void dds::xrce::ObjectVariant::client(const dds::xrce::CLIENT_Representation &_client)
{
    m_client = _client;
    m__d = OBJK_CLIENT;
}

void dds::xrce::ObjectVariant::client(dds::xrce::CLIENT_Representation &&_client)
{
    m_client = std::move(_client);
    m__d = OBJK_CLIENT;
}

const dds::xrce::CLIENT_Representation& dds::xrce::ObjectVariant::client() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_CLIENT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_client;
}

dds::xrce::CLIENT_Representation& dds::xrce::ObjectVariant::client()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_CLIENT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_client;
}
void dds::xrce::ObjectVariant::application(const dds::xrce::OBJK_APPLICATION_Representation &_application)
{
    m_application = _application;
    m__d = OBJK_APPLICATION;
}

void dds::xrce::ObjectVariant::application(dds::xrce::OBJK_APPLICATION_Representation &&_application)
{
    m_application = std::move(_application);
    m__d = OBJK_APPLICATION;
}

const dds::xrce::OBJK_APPLICATION_Representation& dds::xrce::ObjectVariant::application() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_APPLICATION:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_application;
}

dds::xrce::OBJK_APPLICATION_Representation& dds::xrce::ObjectVariant::application()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_APPLICATION:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_application;
}
void dds::xrce::ObjectVariant::participant(const dds::xrce::OBJK_PARTICIPANT_Representation &_participant)
{
    m_participant = _participant;
    m__d = OBJK_PARTICIPANT;
}

void dds::xrce::ObjectVariant::participant(dds::xrce::OBJK_PARTICIPANT_Representation &&_participant)
{
    m_participant = std::move(_participant);
    m__d = OBJK_PARTICIPANT;
}

const dds::xrce::OBJK_PARTICIPANT_Representation& dds::xrce::ObjectVariant::participant() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_PARTICIPANT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_participant;
}

dds::xrce::OBJK_PARTICIPANT_Representation& dds::xrce::ObjectVariant::participant()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_PARTICIPANT:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_participant;
}
void dds::xrce::ObjectVariant::qos_profile(const dds::xrce::OBJK_QOSPROFILE_Representation &_qos_profile)
{
    m_qos_profile = _qos_profile;
    m__d = OBJK_QOSPROFILE;
}

void dds::xrce::ObjectVariant::qos_profile(dds::xrce::OBJK_QOSPROFILE_Representation &&_qos_profile)
{
    m_qos_profile = std::move(_qos_profile);
    m__d = OBJK_QOSPROFILE;
}

const dds::xrce::OBJK_QOSPROFILE_Representation& dds::xrce::ObjectVariant::qos_profile() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_QOSPROFILE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_qos_profile;
}

dds::xrce::OBJK_QOSPROFILE_Representation& dds::xrce::ObjectVariant::qos_profile()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_QOSPROFILE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_qos_profile;
}
void dds::xrce::ObjectVariant::type(const dds::xrce::OBJK_TYPE_Representation &_type)
{
    m_type = _type;
    m__d = OBJK_TYPE;
}

void dds::xrce::ObjectVariant::type(dds::xrce::OBJK_TYPE_Representation &&_type)
{
    m_type = std::move(_type);
    m__d = OBJK_TYPE;
}

const dds::xrce::OBJK_TYPE_Representation& dds::xrce::ObjectVariant::type() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_TYPE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_type;
}

dds::xrce::OBJK_TYPE_Representation& dds::xrce::ObjectVariant::type()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_TYPE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_type;
}
void dds::xrce::ObjectVariant::topic(const dds::xrce::OBJK_TOPIC_Representation &_topic)
{
    m_topic = _topic;
    m__d = OBJK_TOPIC;
}

void dds::xrce::ObjectVariant::topic(dds::xrce::OBJK_TOPIC_Representation &&_topic)
{
    m_topic = std::move(_topic);
    m__d = OBJK_TOPIC;
}

const dds::xrce::OBJK_TOPIC_Representation& dds::xrce::ObjectVariant::topic() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_TOPIC:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_topic;
}

dds::xrce::OBJK_TOPIC_Representation& dds::xrce::ObjectVariant::topic()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_TOPIC:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_topic;
}
void dds::xrce::ObjectVariant::publisher(const dds::xrce::OBJK_PUBLISHER_Representation &_publisher)
{
    m_publisher = _publisher;
    m__d = OBJK_PUBLISHER;
}

void dds::xrce::ObjectVariant::publisher(dds::xrce::OBJK_PUBLISHER_Representation &&_publisher)
{
    m_publisher = std::move(_publisher);
    m__d = OBJK_PUBLISHER;
}

const dds::xrce::OBJK_PUBLISHER_Representation& dds::xrce::ObjectVariant::publisher() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_PUBLISHER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_publisher;
}

dds::xrce::OBJK_PUBLISHER_Representation& dds::xrce::ObjectVariant::publisher()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_PUBLISHER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_publisher;
}
void dds::xrce::ObjectVariant::subscriber(const dds::xrce::OBJK_SUBSCRIBER_Representation &_subscriber)
{
    m_subscriber = _subscriber;
    m__d = OBJK_SUBSCRIBER;
}

void dds::xrce::ObjectVariant::subscriber(dds::xrce::OBJK_SUBSCRIBER_Representation &&_subscriber)
{
    m_subscriber = std::move(_subscriber);
    m__d = OBJK_SUBSCRIBER;
}

const dds::xrce::OBJK_SUBSCRIBER_Representation& dds::xrce::ObjectVariant::subscriber() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_SUBSCRIBER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_subscriber;
}

dds::xrce::OBJK_SUBSCRIBER_Representation& dds::xrce::ObjectVariant::subscriber()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_SUBSCRIBER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_subscriber;
}
void dds::xrce::ObjectVariant::data_writer(const dds::xrce::DATAWRITER_Representation &_data_writer)
{
    m_data_writer = _data_writer;
    m__d = OBJK_DATAWRITER;
}

void dds::xrce::ObjectVariant::data_writer(dds::xrce::DATAWRITER_Representation &&_data_writer)
{
    m_data_writer = std::move(_data_writer);
    m__d = OBJK_DATAWRITER;
}

const dds::xrce::DATAWRITER_Representation& dds::xrce::ObjectVariant::data_writer() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAWRITER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_writer;
}

dds::xrce::DATAWRITER_Representation& dds::xrce::ObjectVariant::data_writer()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAWRITER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_writer;
}
void dds::xrce::ObjectVariant::data_reader(const dds::xrce::DATAREADER_Representation &_data_reader)
{
    m_data_reader = _data_reader;
    m__d = OBJK_DATAREADER;
}

void dds::xrce::ObjectVariant::data_reader(dds::xrce::DATAREADER_Representation &&_data_reader)
{
    m_data_reader = std::move(_data_reader);
    m__d = OBJK_DATAREADER;
}

const dds::xrce::DATAREADER_Representation& dds::xrce::ObjectVariant::data_reader() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAREADER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_reader;
}

dds::xrce::DATAREADER_Representation& dds::xrce::ObjectVariant::data_reader()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAREADER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_reader;
}

size_t dds::xrce::ObjectVariant::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::AGENT_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::CLIENT_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_APPLICATION_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_PARTICIPANT_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_QOSPROFILE_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_TYPE_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_TOPIC_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_PUBLISHER_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::OBJK_SUBSCRIBER_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::DATAWRITER_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::DATAREADER_Representation::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

size_t dds::xrce::ObjectVariant::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case OBJK_AGENT:
            current_alignment += m_agent.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_CLIENT:
            current_alignment += m_client.getCdrSerializedSize (current_alignment);
            break;
        case OBJK_APPLICATION:
            current_alignment += m_application.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_PARTICIPANT:
            current_alignment += m_participant.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_QOSPROFILE:
            current_alignment += m_qos_profile.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_TYPE:
            current_alignment += m_type.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_TOPIC:
            current_alignment += m_topic.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_PUBLISHER:
            current_alignment += m_publisher.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_SUBSCRIBER:
            current_alignment += m_subscriber.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_DATAWRITER:
            current_alignment += m_data_writer.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_DATAREADER:
            current_alignment += m_data_reader.getCdrSerializedSize(current_alignment);
            break;
        default:
            break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::ObjectVariant::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case OBJK_AGENT:
        scdr << m_agent;
        break;
        case OBJK_CLIENT:
        scdr << m_client;
        break;
        case OBJK_APPLICATION:
        scdr << m_application;
        break;
        case OBJK_PARTICIPANT:
        scdr << m_participant;
        break;
        case OBJK_QOSPROFILE:
        scdr << m_qos_profile;
        break;
        case OBJK_TYPE:
        scdr << m_type;
        break;
        case OBJK_TOPIC:
        scdr << m_topic;
        break;
        case OBJK_PUBLISHER:
        scdr << m_publisher;
        break;
        case OBJK_SUBSCRIBER:
        scdr << m_subscriber;
        break;
        case OBJK_DATAWRITER:
        scdr << m_data_writer;
        break;
        case OBJK_DATAREADER:
        scdr << m_data_reader;
        break;
        default:
        break;
    }
}

void dds::xrce::ObjectVariant::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case OBJK_AGENT:
        dcdr >> m_agent;
        break;
        case OBJK_CLIENT:
        dcdr >> m_client;
        break;
        case OBJK_APPLICATION:
        dcdr >> m_application;
        break;
        case OBJK_PARTICIPANT:
        dcdr >> m_participant;
        break;
        case OBJK_QOSPROFILE:
        dcdr >> m_qos_profile;
        break;
        case OBJK_TYPE:
        dcdr >> m_type;
        break;
        case OBJK_TOPIC:
        dcdr >> m_topic;
        break;
        case OBJK_PUBLISHER:
        dcdr >> m_publisher;
        break;
        case OBJK_SUBSCRIBER:
        dcdr >> m_subscriber;
        break;
        case OBJK_DATAWRITER:
        dcdr >> m_data_writer;
        break;
        case OBJK_DATAREADER:
        dcdr >> m_data_reader;
        break;
        default:
        break;
    }
}


dds::xrce::CreationMode::CreationMode()
{
    m_reuse = false;
    m_replace = false;
}

dds::xrce::CreationMode::~CreationMode()
{
}

dds::xrce::CreationMode::CreationMode(const CreationMode &x)
{
    m_reuse = x.m_reuse;
    m_replace = x.m_replace;
}

dds::xrce::CreationMode::CreationMode(CreationMode &&x)
{
    m_reuse = x.m_reuse;
    m_replace = x.m_replace;
}

dds::xrce::CreationMode& dds::xrce::CreationMode::operator=(const CreationMode &x)
{
    m_reuse = x.m_reuse;
    m_replace = x.m_replace;
    
    return *this;
}

dds::xrce::CreationMode& dds::xrce::CreationMode::operator=(CreationMode &&x)
{
    m_reuse = x.m_reuse;
    m_replace = x.m_replace;
    
    return *this;
}

size_t dds::xrce::CreationMode::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::CreationMode::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void dds::xrce::CreationMode::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_reuse;
    scdr << m_replace;
}

void dds::xrce::CreationMode::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_reuse;
    dcdr >> m_replace;
}

dds::xrce::ResultStatus::ResultStatus()
{
    m_status = dds::xrce::STATUS_OK;
    m_implementation_status = 0;
}

dds::xrce::ResultStatus::~ResultStatus()
{
}

dds::xrce::ResultStatus::ResultStatus(const ResultStatus &x)
{
    m_status = x.m_status;
    m_implementation_status = x.m_implementation_status;
}

dds::xrce::ResultStatus::ResultStatus(ResultStatus &&x)
{
    m_status = x.m_status;
    m_implementation_status = x.m_implementation_status;
}

dds::xrce::ResultStatus& dds::xrce::ResultStatus::operator=(const ResultStatus &x)
{
    m_status = x.m_status;
    m_implementation_status = x.m_implementation_status;
    
    return *this;
}

dds::xrce::ResultStatus& dds::xrce::ResultStatus::operator=(ResultStatus &&x)
{
    m_status = x.m_status;
    m_implementation_status = x.m_implementation_status;
    
    return *this;
}

size_t dds::xrce::ResultStatus::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::ResultStatus::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void dds::xrce::ResultStatus::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint8_t)m_status;
    scdr << m_implementation_status;
}

void dds::xrce::ResultStatus::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> (uint8_t&)m_status;
    dcdr >> m_implementation_status;
}


dds::xrce::AGENT_ActivityInfo::AGENT_ActivityInfo()
{
    m_availability = 0;
}

dds::xrce::AGENT_ActivityInfo::~AGENT_ActivityInfo()
{
}

dds::xrce::AGENT_ActivityInfo::AGENT_ActivityInfo(const AGENT_ActivityInfo &x)
{
    m_availability = x.m_availability;
    m_address_seq = x.m_address_seq;
}

dds::xrce::AGENT_ActivityInfo::AGENT_ActivityInfo(AGENT_ActivityInfo &&x)
{
    m_availability = x.m_availability;
    m_address_seq = std::move(x.m_address_seq);
}

dds::xrce::AGENT_ActivityInfo& dds::xrce::AGENT_ActivityInfo::operator=(const AGENT_ActivityInfo &x)
{
    m_availability = x.m_availability;
    m_address_seq = x.m_address_seq;
    
    return *this;
}

dds::xrce::AGENT_ActivityInfo& dds::xrce::AGENT_ActivityInfo::operator=(AGENT_ActivityInfo &&x)
{
    m_availability = x.m_availability;
    m_address_seq = std::move(x.m_address_seq);
    
    return *this;
}

size_t dds::xrce::AGENT_ActivityInfo::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::TransportAddress::getMaxCdrSerializedSize(current_alignment);
    }


    return current_alignment - initial_alignment;
}

size_t dds::xrce::AGENT_ActivityInfo::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_address_seq.size(); ++a)
    {
        current_alignment += m_address_seq.at(a).getCdrSerializedSize(current_alignment);
    }


    return current_alignment - initial_alignment;
}

void dds::xrce::AGENT_ActivityInfo::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_availability;
    scdr << m_address_seq;
}

void dds::xrce::AGENT_ActivityInfo::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_availability;
    dcdr >> m_address_seq;
}

dds::xrce::DATAREADER_ActivityInfo::DATAREADER_ActivityInfo()
{
    m_highest_acked_num = 0;
}

dds::xrce::DATAREADER_ActivityInfo::~DATAREADER_ActivityInfo()
{
}

dds::xrce::DATAREADER_ActivityInfo::DATAREADER_ActivityInfo(const DATAREADER_ActivityInfo &x)
{
    m_highest_acked_num = x.m_highest_acked_num;
}

dds::xrce::DATAREADER_ActivityInfo::DATAREADER_ActivityInfo(DATAREADER_ActivityInfo &&x)
{
    m_highest_acked_num = x.m_highest_acked_num;
}

dds::xrce::DATAREADER_ActivityInfo& dds::xrce::DATAREADER_ActivityInfo::operator=(const DATAREADER_ActivityInfo &x)
{
    m_highest_acked_num = x.m_highest_acked_num;
    
    return *this;
}

dds::xrce::DATAREADER_ActivityInfo& dds::xrce::DATAREADER_ActivityInfo::operator=(DATAREADER_ActivityInfo &&x)
{
    m_highest_acked_num = x.m_highest_acked_num;
    
    return *this;
}

size_t dds::xrce::DATAREADER_ActivityInfo::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATAREADER_ActivityInfo::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void dds::xrce::DATAREADER_ActivityInfo::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_highest_acked_num;
}

void dds::xrce::DATAREADER_ActivityInfo::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_highest_acked_num;
}

dds::xrce::DATAWRITER_ActivityInfo::DATAWRITER_ActivityInfo()
{
    m_stream_seq_num = 0;
    m_sample_seq_num = 0;
}

dds::xrce::DATAWRITER_ActivityInfo::~DATAWRITER_ActivityInfo()
{
}

dds::xrce::DATAWRITER_ActivityInfo::DATAWRITER_ActivityInfo(const DATAWRITER_ActivityInfo &x)
{
    m_stream_seq_num = x.m_stream_seq_num;
    m_sample_seq_num = x.m_sample_seq_num;
}

dds::xrce::DATAWRITER_ActivityInfo::DATAWRITER_ActivityInfo(DATAWRITER_ActivityInfo &&x)
{
    m_stream_seq_num = x.m_stream_seq_num;
    m_sample_seq_num = x.m_sample_seq_num;
}

dds::xrce::DATAWRITER_ActivityInfo& dds::xrce::DATAWRITER_ActivityInfo::operator=(const DATAWRITER_ActivityInfo &x)
{
    m_stream_seq_num = x.m_stream_seq_num;
    m_sample_seq_num = x.m_sample_seq_num;
    
    return *this;
}

dds::xrce::DATAWRITER_ActivityInfo& dds::xrce::DATAWRITER_ActivityInfo::operator=(DATAWRITER_ActivityInfo &&x)
{
    m_stream_seq_num = x.m_stream_seq_num;
    m_sample_seq_num = x.m_sample_seq_num;
    
    return *this;
}

size_t dds::xrce::DATAWRITER_ActivityInfo::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATAWRITER_ActivityInfo::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

void dds::xrce::DATAWRITER_ActivityInfo::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_stream_seq_num;
    scdr << m_sample_seq_num;
}

void dds::xrce::DATAWRITER_ActivityInfo::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_stream_seq_num;
    dcdr >> m_sample_seq_num;
}

dds::xrce::ActivityInfoVariant::ActivityInfoVariant()
{
    m__d = OBJK_DATAWRITER;
}

dds::xrce::ActivityInfoVariant::~ActivityInfoVariant()
{
}

dds::xrce::ActivityInfoVariant::ActivityInfoVariant(const ActivityInfoVariant &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
            m_agent = x.m_agent;
            break;
        case OBJK_DATAWRITER:
            m_data_writer = x.m_data_writer;
            break;
        case OBJK_DATAREADER:
            m_data_reader = x.m_data_reader;
            break;
        default:
            break;
    }
}

dds::xrce::ActivityInfoVariant::ActivityInfoVariant(ActivityInfoVariant &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
            m_agent = std::move(x.m_agent);
            break;
        case OBJK_DATAWRITER:
            m_data_writer = std::move(x.m_data_writer);
            break;
        case OBJK_DATAREADER:
            m_data_reader = std::move(x.m_data_reader);
            break;
        default:
            break;
    }
}

dds::xrce::ActivityInfoVariant& dds::xrce::ActivityInfoVariant::operator=(const ActivityInfoVariant &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
            m_agent = x.m_agent;
            break;
        case OBJK_DATAWRITER:
            m_data_writer = x.m_data_writer;
            break;
        case OBJK_DATAREADER:
            m_data_reader = x.m_data_reader;
            break;
        default:
            break;
    }
    
    return *this;
}

dds::xrce::ActivityInfoVariant& dds::xrce::ActivityInfoVariant::operator=(ActivityInfoVariant &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case OBJK_AGENT:
            m_agent = std::move(x.m_agent);
            break;
        case OBJK_DATAWRITER:
            m_data_writer = std::move(x.m_data_writer);
            break;
        case OBJK_DATAREADER:
            m_data_reader = std::move(x.m_data_reader);
            break;
        default:
            break;
    }
    
    return *this;
}

void dds::xrce::ActivityInfoVariant::_d(dds::xrce::ObjectKind __d)
{
    bool b = false;
    
    switch(m__d)
    {
        case OBJK_AGENT:
            switch(__d)
            {
                case OBJK_AGENT:
                    b = true;
                    break;
                default:
                    break;
            }
            break;
        case OBJK_DATAWRITER:
            switch(__d)
            {
                case OBJK_DATAWRITER:
                    b = true;
                    break;
                default:
                    break;
            }
            break;
        case OBJK_DATAREADER:
            switch(__d)
            {
                case OBJK_DATAREADER:
                    b = true;
                    break;
                default:
                    break;
            }
            break;
    }
    
    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");
    
    m__d = __d;
}

dds::xrce::ObjectKind dds::xrce::ActivityInfoVariant::_d() const
{
    return m__d;
}

dds::xrce::ObjectKind& dds::xrce::ActivityInfoVariant::_d()
{
    return m__d;
}

void dds::xrce::ActivityInfoVariant::agent(const dds::xrce::AGENT_ActivityInfo &_agent)
{
    m_agent = _agent;
    m__d = OBJK_AGENT;
}

void dds::xrce::ActivityInfoVariant::agent(dds::xrce::AGENT_ActivityInfo &&_agent)
{
    m_agent = std::move(_agent);
    m__d = OBJK_AGENT;
}

const dds::xrce::AGENT_ActivityInfo& dds::xrce::ActivityInfoVariant::agent() const
{
    bool b = false;

    switch(m__d)
    {
        case OBJK_AGENT:
            b = true;
            break;
        default:
            break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_agent;
}

dds::xrce::AGENT_ActivityInfo& dds::xrce::ActivityInfoVariant::agent()
{
    bool b = false;

    switch(m__d)
    {
        case OBJK_AGENT:
            b = true;
            break;
        default:
            break;
    }
    if(!b) throw BadParamException("This member is not been selected");

    return m_agent;
}

void dds::xrce::ActivityInfoVariant::data_writer(const dds::xrce::DATAWRITER_ActivityInfo &_data_writer)
{
    m_data_writer = _data_writer;
    m__d = OBJK_DATAWRITER;
}

void dds::xrce::ActivityInfoVariant::data_writer(dds::xrce::DATAWRITER_ActivityInfo &&_data_writer)
{
    m_data_writer = std::move(_data_writer);
    m__d = OBJK_DATAWRITER;
}

const dds::xrce::DATAWRITER_ActivityInfo& dds::xrce::ActivityInfoVariant::data_writer() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAWRITER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_writer;
}

dds::xrce::DATAWRITER_ActivityInfo& dds::xrce::ActivityInfoVariant::data_writer()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAWRITER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_writer;
}

void dds::xrce::ActivityInfoVariant::data_reader(const dds::xrce::DATAREADER_ActivityInfo &_data_reader)
{
    m_data_reader = _data_reader;
    m__d = OBJK_DATAREADER;
}

void dds::xrce::ActivityInfoVariant::data_reader(dds::xrce::DATAREADER_ActivityInfo &&_data_reader)
{
    m_data_reader = std::move(_data_reader);
    m__d = OBJK_DATAREADER;
}

const dds::xrce::DATAREADER_ActivityInfo& dds::xrce::ActivityInfoVariant::data_reader() const
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAREADER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_reader;
}

dds::xrce::DATAREADER_ActivityInfo& dds::xrce::ActivityInfoVariant::data_reader()
{
    bool b = false;
        
    switch(m__d)
    {
        case OBJK_DATAREADER:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_reader;
}

size_t dds::xrce::ActivityInfoVariant::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::AGENT_ActivityInfo::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::DATAWRITER_ActivityInfo::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::DATAREADER_ActivityInfo::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

size_t dds::xrce::ActivityInfoVariant::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case OBJK_AGENT:
            current_alignment += m_agent.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_DATAWRITER:
            current_alignment += m_data_writer.getCdrSerializedSize(current_alignment);
            break;
        case OBJK_DATAREADER:
            current_alignment += m_data_reader.getCdrSerializedSize(current_alignment);
            break;
        default:
            break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::ActivityInfoVariant::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case OBJK_AGENT:
            scdr << m_agent;
            break;
        case OBJK_DATAWRITER:
            scdr << m_data_writer;
            break;
        case OBJK_DATAREADER:
            scdr << m_data_reader;
            break;
        default:
            break;
    }
}

void dds::xrce::ActivityInfoVariant::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case OBJK_AGENT:
            dcdr >> m_agent;
            break;
        case OBJK_DATAWRITER:
            dcdr >> m_data_writer;
            break;
        case OBJK_DATAREADER:
            dcdr >> m_data_reader;
            break;
        default:
            break;
    }
}


dds::xrce::ObjectInfo::ObjectInfo()
{
}

dds::xrce::ObjectInfo::~ObjectInfo()
{
}

dds::xrce::ObjectInfo::ObjectInfo(const ObjectInfo &x)
{
    m_config = x.m_config;
    m_activity = x.m_activity;
}

dds::xrce::ObjectInfo::ObjectInfo(ObjectInfo &&x)
{
    m_config = std::move(x.m_config);
    m_activity = std::move(x.m_activity);
}

dds::xrce::ObjectInfo& dds::xrce::ObjectInfo::operator=(const ObjectInfo &x)
{
    m_config = x.m_config;
    m_activity = x.m_activity;
    
    return *this;
}

dds::xrce::ObjectInfo& dds::xrce::ObjectInfo::operator=(ObjectInfo &&x)
{
    m_config = std::move(x.m_config);
    m_activity = std::move(x.m_activity);
    
    return *this;
}

size_t dds::xrce::ObjectInfo::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += dds::xrce::ObjectVariant::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += dds::xrce::ActivityInfoVariant::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::ObjectInfo::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    /* Optional config. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_config)
    {
        current_alignment += (*m_config).getCdrSerializedSize(current_alignment);
    }

    /* Optional activity. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_activity)
    {
        current_alignment += (*m_activity).getCdrSerializedSize(current_alignment);
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::ObjectInfo::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << bool(m_config);
    if (m_config)
    {
        scdr << (*m_config);
    }
    scdr << bool(m_activity);
    if (m_activity)
    {
        scdr << (*m_activity);
    }
}

void dds::xrce::ObjectInfo::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    bool m_temp_flag;
    dcdr >> m_temp_flag;
    if (m_temp_flag)
    {
        ObjectVariant temp_config;
        dcdr >> temp_config;
        m_config = temp_config;
    }

    dcdr >> m_temp_flag;
    if (m_temp_flag)
    {
        ActivityInfoVariant temp_activity;
        dcdr >> temp_activity;
        m_activity = temp_activity;
    }
}

dds::xrce::BaseObjectRequest::BaseObjectRequest()
{
}

dds::xrce::BaseObjectRequest::~BaseObjectRequest()
{
}

dds::xrce::BaseObjectRequest::BaseObjectRequest(const BaseObjectRequest &x)
{
    m_request_id = x.m_request_id;
    m_object_id = x.m_object_id;
}

dds::xrce::BaseObjectRequest::BaseObjectRequest(BaseObjectRequest &&x)
{
    m_request_id = std::move(x.m_request_id);
    m_object_id = std::move(x.m_object_id);
}

dds::xrce::BaseObjectRequest& dds::xrce::BaseObjectRequest::operator=(const BaseObjectRequest &x)
{
    m_request_id = x.m_request_id;
    m_object_id = x.m_object_id;
    
    return *this;
}

dds::xrce::BaseObjectRequest& dds::xrce::BaseObjectRequest::operator=(BaseObjectRequest &&x)
{
    m_request_id = std::move(x.m_request_id);
    m_object_id = std::move(x.m_object_id);
    
    return *this;
}

size_t dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::BaseObjectRequest::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::BaseObjectRequest::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_request_id;
    scdr << m_object_id;
}

void dds::xrce::BaseObjectRequest::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_request_id;
    dcdr >> m_object_id;
}

dds::xrce::BaseObjectReply::BaseObjectReply()
{
}

dds::xrce::BaseObjectReply::~BaseObjectReply()
{
}

dds::xrce::BaseObjectReply::BaseObjectReply(const BaseObjectReply &x)
{
    m_related_request = x.m_related_request;
    m_result = x.m_result;
}

dds::xrce::BaseObjectReply::BaseObjectReply(BaseObjectReply &&x)
{
    m_related_request = std::move(x.m_related_request);
    m_result = std::move(x.m_result);
}

dds::xrce::BaseObjectReply& dds::xrce::BaseObjectReply::operator=(const BaseObjectReply &x)
{
    m_related_request = x.m_related_request;
    m_result = x.m_result;
    
    return *this;
}

dds::xrce::BaseObjectReply& dds::xrce::BaseObjectReply::operator=(BaseObjectReply &&x)
{
    m_related_request = std::move(x.m_related_request);
    m_result = std::move(x.m_result);
    
    return *this;
}

size_t dds::xrce::BaseObjectReply::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::ResultStatus::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::BaseObjectReply::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += m_related_request.getCdrSerializedSize(current_alignment);
    current_alignment += m_result.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::BaseObjectReply::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_related_request;
    scdr << m_result;
}

void dds::xrce::BaseObjectReply::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_related_request;
    dcdr >> m_result;
}

dds::xrce::DataDeliveryControl::DataDeliveryControl()
{
    m_max_samples = 0;
    m_max_elapsed_time = 0;
    m_max_bytes_per_second = 0;
    m_min_pace_period = 0;
}

dds::xrce::DataDeliveryControl::~DataDeliveryControl()
{
}

dds::xrce::DataDeliveryControl::DataDeliveryControl(const DataDeliveryControl &x)
{
    m_max_samples = x.m_max_samples;
    m_max_elapsed_time = x.m_max_elapsed_time;
    m_max_bytes_per_second = x.m_max_bytes_per_second;
    m_min_pace_period = x.m_min_pace_period;
}

dds::xrce::DataDeliveryControl::DataDeliveryControl(DataDeliveryControl &&x)
{
    m_max_samples = x.m_max_samples;
    m_max_elapsed_time = x.m_max_elapsed_time;
    m_max_bytes_per_second = x.m_max_bytes_per_second;
    m_min_pace_period = x.m_min_pace_period;
}

dds::xrce::DataDeliveryControl& dds::xrce::DataDeliveryControl::operator=(const DataDeliveryControl &x)
{
    m_max_samples = x.m_max_samples;
    m_max_elapsed_time = x.m_max_elapsed_time;
    m_max_bytes_per_second = x.m_max_bytes_per_second;
    m_min_pace_period = x.m_min_pace_period;
    
    return *this;
}

dds::xrce::DataDeliveryControl& dds::xrce::DataDeliveryControl::operator=(DataDeliveryControl &&x)
{
    m_max_samples = x.m_max_samples;
    m_max_elapsed_time = x.m_max_elapsed_time;
    m_max_bytes_per_second = x.m_max_bytes_per_second;
    m_min_pace_period = x.m_min_pace_period;
    
    return *this;
}

size_t dds::xrce::DataDeliveryControl::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::DataDeliveryControl::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    return current_alignment - initial_alignment;
}

void dds::xrce::DataDeliveryControl::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_max_samples;
    scdr << m_max_elapsed_time;
    scdr << m_max_bytes_per_second;
    scdr << m_min_pace_period;
}

void dds::xrce::DataDeliveryControl::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_max_samples;
    dcdr >> m_max_elapsed_time;
    dcdr >> m_max_bytes_per_second;
    dcdr >> m_min_pace_period;
}

dds::xrce::ReadSpecification::ReadSpecification()
{
    m_data_stream_id = 0;
    m_data_format = 0;
}

dds::xrce::ReadSpecification::~ReadSpecification()
{
}

dds::xrce::ReadSpecification::ReadSpecification(const ReadSpecification &x)
{
    m_data_stream_id = x.m_data_stream_id;
    m_data_format = x.m_data_format;
    m_content_filter_expression = x.m_content_filter_expression;
    m_delivery_control = x.m_delivery_control;
}

dds::xrce::ReadSpecification::ReadSpecification(ReadSpecification &&x)
{
    m_data_stream_id = x.m_data_stream_id;
    m_data_format = x.m_data_format;
    m_content_filter_expression = std::move(x.m_content_filter_expression);
    m_delivery_control = std::move(x.m_delivery_control);
}

dds::xrce::ReadSpecification& dds::xrce::ReadSpecification::operator=(const ReadSpecification &x)
{
    m_data_stream_id = x.m_data_stream_id;
    m_data_format = x.m_data_format;
    m_content_filter_expression = x.m_content_filter_expression;
    m_delivery_control = x.m_delivery_control;
    
    return *this;
}

dds::xrce::ReadSpecification& dds::xrce::ReadSpecification::operator=(ReadSpecification &&x)
{
    m_data_stream_id = x.m_data_stream_id;
    m_data_format = x.m_data_format;
    m_content_filter_expression = std::move(x.m_content_filter_expression);
    m_delivery_control = std::move(x.m_delivery_control);
    
    return *this;
}

size_t dds::xrce::ReadSpecification::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;
    current_alignment += dds::xrce::DataDeliveryControl::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::ReadSpecification::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    /* Optional content_filter_expression. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_content_filter_expression)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4)
                               + (*m_content_filter_expression).size() + 1;
    }

    /* Optional delivery_control. */
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
    if (m_delivery_control)
    {
        current_alignment += (*m_delivery_control).getCdrSerializedSize(current_alignment);
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::ReadSpecification::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_data_stream_id;
    scdr << m_data_format;
    scdr << bool(m_content_filter_expression);
    if (m_content_filter_expression)
    {
        scdr << *m_content_filter_expression;
    }
    scdr << bool(m_delivery_control);
    if (m_delivery_control)
    {
        scdr << *m_delivery_control;
    }
}

void dds::xrce::ReadSpecification::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_data_stream_id;
    dcdr >> m_data_format;
    bool temp;
    dcdr >> temp;
    if (temp)
    {
        std::string temp_content_filter_expression;
        dcdr >> temp_content_filter_expression;
        m_content_filter_expression = temp_content_filter_expression;
    }
    dcdr >> temp;
    if (temp)
    {
        dds::xrce::DataDeliveryControl temp_delivery_control;
        dcdr >> temp_delivery_control;
        m_delivery_control = temp_delivery_control;
    }
}

dds::xrce::SampleInfo::SampleInfo()
{
    m_state = dds::xrce::INSTANCE_STATE_UNREGISTERED;
    m_sequence_number = 0;
    m_session_time_offset = 0;
}

dds::xrce::SampleInfo::~SampleInfo()
{
}

dds::xrce::SampleInfo::SampleInfo(const SampleInfo &x)
{
    m_state = x.m_state;
    m_sequence_number = x.m_sequence_number;
    m_session_time_offset = x.m_session_time_offset;
}

dds::xrce::SampleInfo::SampleInfo(SampleInfo &&x)
{
    m_state = x.m_state;
    m_sequence_number = x.m_sequence_number;
    m_session_time_offset = x.m_session_time_offset;
}

dds::xrce::SampleInfo& dds::xrce::SampleInfo::operator=(const SampleInfo &x)
{
    m_state = x.m_state;
    m_sequence_number = x.m_sequence_number;
    m_session_time_offset = x.m_session_time_offset;
    
    return *this;
}

dds::xrce::SampleInfo& dds::xrce::SampleInfo::operator=(SampleInfo &&x)
{
    m_state = x.m_state;
    m_sequence_number = x.m_sequence_number;
    m_session_time_offset = x.m_session_time_offset;
    
    return *this;
}

size_t dds::xrce::SampleInfo::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::SampleInfo::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    return current_alignment - initial_alignment;
}

void dds::xrce::SampleInfo::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint8_t)m_state;
    scdr << m_sequence_number;
    scdr << m_session_time_offset;
}

void dds::xrce::SampleInfo::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> (uint8_t&)m_state;
    dcdr >> m_sequence_number;
    dcdr >> m_session_time_offset;
}

dds::xrce::SampleInfoDelta::SampleInfoDelta()
{
    m_state = dds::xrce::INSTANCE_STATE_UNREGISTERED;
    m_seq_number_delta = 0;
    m_timestamp_delta = 0;
}

dds::xrce::SampleInfoDelta::~SampleInfoDelta()
{
}

dds::xrce::SampleInfoDelta::SampleInfoDelta(const SampleInfoDelta &x)
{
    m_state = x.m_state;
    m_seq_number_delta = x.m_seq_number_delta;
    m_timestamp_delta = x.m_timestamp_delta;
}

dds::xrce::SampleInfoDelta::SampleInfoDelta(SampleInfoDelta &&x)
{
    m_state = x.m_state;
    m_seq_number_delta = x.m_seq_number_delta;
    m_timestamp_delta = x.m_timestamp_delta;
}

dds::xrce::SampleInfoDelta& dds::xrce::SampleInfoDelta::operator=(const SampleInfoDelta &x)
{
    m_state = x.m_state;
    m_seq_number_delta = x.m_seq_number_delta;
    m_timestamp_delta = x.m_timestamp_delta;
    
    return *this;
}

dds::xrce::SampleInfoDelta& dds::xrce::SampleInfoDelta::operator=(SampleInfoDelta &&x)
{
    m_state = x.m_state;
    m_seq_number_delta = x.m_seq_number_delta;
    m_timestamp_delta = x.m_timestamp_delta;
    
    return *this;
}

size_t dds::xrce::SampleInfoDelta::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::SampleInfoDelta::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void dds::xrce::SampleInfoDelta::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint8_t)m_state;
    scdr << m_seq_number_delta;
    scdr << m_timestamp_delta;
}

void dds::xrce::SampleInfoDelta::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> (uint8_t&)m_state;
    dcdr >> m_seq_number_delta;
    dcdr >> m_timestamp_delta;
}

dds::xrce::SampleData::SampleData()
{
}

dds::xrce::SampleData::~SampleData()
{
}

dds::xrce::SampleData::SampleData(const SampleData &x)
{
    m_serialized_data = x.m_serialized_data;
}

dds::xrce::SampleData::SampleData(SampleData &&x)
{
    m_serialized_data = std::move(x.m_serialized_data);
}

dds::xrce::SampleData& dds::xrce::SampleData::operator=(const SampleData &x)
{
    m_serialized_data = x.m_serialized_data;
    
    return *this;
}

dds::xrce::SampleData& dds::xrce::SampleData::operator=(SampleData &&x)
{
    m_serialized_data = std::move(x.m_serialized_data);
    
    return *this;
}

size_t dds::xrce::SampleData::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::SampleData::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += (m_serialized_data.size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void dds::xrce::SampleData::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_serialized_data;
}

void dds::xrce::SampleData::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_serialized_data;
}

dds::xrce::Sample::Sample()
{
}

dds::xrce::Sample::~Sample()
{
}

dds::xrce::Sample::Sample(const Sample &x)
{
    m_info = x.m_info;
    m_data = x.m_data;
}

dds::xrce::Sample::Sample(Sample &&x)
{
    m_info = std::move(x.m_info);
    m_data = std::move(x.m_data);
}

dds::xrce::Sample& dds::xrce::Sample::operator=(const Sample &x)
{
    m_info = x.m_info;
    m_data = x.m_data;
    
    return *this;
}

dds::xrce::Sample& dds::xrce::Sample::operator=(Sample &&x)
{
    m_info = std::move(x.m_info);
    m_data = std::move(x.m_data);
    
    return *this;
}

size_t dds::xrce::Sample::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::SampleInfo::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::Sample::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += m_info.getCdrSerializedSize(current_alignment);
    current_alignment += m_data.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::Sample::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_info;
    scdr << m_data;
}

void dds::xrce::Sample::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_info;
    dcdr >> m_data;
}

dds::xrce::SampleDelta::SampleDelta()
{
}

dds::xrce::SampleDelta::~SampleDelta()
{
}

dds::xrce::SampleDelta::SampleDelta(const SampleDelta &x)
{
    m_info_delta = x.m_info_delta;
    m_data = x.m_data;
}

dds::xrce::SampleDelta::SampleDelta(SampleDelta &&x)
{
    m_info_delta = std::move(x.m_info_delta);
    m_data = std::move(x.m_data);
}

dds::xrce::SampleDelta& dds::xrce::SampleDelta::operator=(const SampleDelta &x)
{
    m_info_delta = x.m_info_delta;
    m_data = x.m_data;
    
    return *this;
}

dds::xrce::SampleDelta& dds::xrce::SampleDelta::operator=(SampleDelta &&x)
{
    m_info_delta = std::move(x.m_info_delta);
    m_data = std::move(x.m_data);
    
    return *this;
}

size_t dds::xrce::SampleDelta::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::SampleInfoDelta::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::SampleDelta::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += m_info_delta.getCdrSerializedSize(current_alignment);
    current_alignment += m_data.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::SampleDelta::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_info_delta;
    scdr << m_data;
}

void dds::xrce::SampleDelta::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_info_delta;
    dcdr >> m_data;
}

dds::xrce::PackedSamples::PackedSamples()
{
}

dds::xrce::PackedSamples::~PackedSamples()
{
}

dds::xrce::PackedSamples::PackedSamples(const PackedSamples &x)
{
    m_info_base = x.m_info_base;
    m_sample_delta_seq = x.m_sample_delta_seq;
}

dds::xrce::PackedSamples::PackedSamples(PackedSamples &&x)
{
    m_info_base = std::move(x.m_info_base);
    m_sample_delta_seq = std::move(x.m_sample_delta_seq);
}

dds::xrce::PackedSamples& dds::xrce::PackedSamples::operator=(const PackedSamples &x)
{
    m_info_base = x.m_info_base;
    m_sample_delta_seq = x.m_sample_delta_seq;
    
    return *this;
}

dds::xrce::PackedSamples& dds::xrce::PackedSamples::operator=(PackedSamples &&x)
{
    m_info_base = std::move(x.m_info_base);
    m_sample_delta_seq = std::move(x.m_sample_delta_seq);
    
    return *this;
}

size_t dds::xrce::PackedSamples::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::SampleInfo::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::SampleDelta::getMaxCdrSerializedSize(current_alignment);}


    return current_alignment - initial_alignment;
}

size_t dds::xrce::PackedSamples::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += m_info_base.getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_sample_delta_seq.size(); ++a)
    {
        current_alignment += m_sample_delta_seq.at(a).getCdrSerializedSize(current_alignment);
    }


    return current_alignment - initial_alignment;
}

void dds::xrce::PackedSamples::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_info_base;
    scdr << m_sample_delta_seq;
}

void dds::xrce::PackedSamples::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_info_base;
    dcdr >> m_sample_delta_seq;
}

dds::xrce::DataRepresentation::DataRepresentation()
{
    m__d = FORMAT_DATA;
}

dds::xrce::DataRepresentation::~DataRepresentation()
{
}

dds::xrce::DataRepresentation::DataRepresentation(const DataRepresentation &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case FORMAT_DATA:
        m_data = x.m_data;
        break;
        case FORMAT_SAMPLE:
        m_sample = x.m_sample;
        break;
        case FORMAT_DATA_SEQ:
        m_data_seq = x.m_data_seq;
        break;
        case FORMAT_SAMPLE_SEQ:
        m_sample_seq = x.m_sample_seq;
        break;
        case FORMAT_PACKED_SAMPLES:
        m_packed_samples = x.m_packed_samples;
        break;
        default:
        break;
    }
}

dds::xrce::DataRepresentation::DataRepresentation(DataRepresentation &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case FORMAT_DATA:
        m_data = std::move(x.m_data);
        break;
        case FORMAT_SAMPLE:
        m_sample = std::move(x.m_sample);
        break;
        case FORMAT_DATA_SEQ:
        m_data_seq = std::move(x.m_data_seq);
        break;
        case FORMAT_SAMPLE_SEQ:
        m_sample_seq = std::move(x.m_sample_seq);
        break;
        case FORMAT_PACKED_SAMPLES:
        m_packed_samples = std::move(x.m_packed_samples);
        break;
        default:
        break;
    }
}

dds::xrce::DataRepresentation& dds::xrce::DataRepresentation::operator=(const DataRepresentation &x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case FORMAT_DATA:
        m_data = x.m_data;
        break;
        case FORMAT_SAMPLE:
        m_sample = x.m_sample;
        break;
        case FORMAT_DATA_SEQ:
        m_data_seq = x.m_data_seq;
        break;
        case FORMAT_SAMPLE_SEQ:
        m_sample_seq = x.m_sample_seq;
        break;
        case FORMAT_PACKED_SAMPLES:
        m_packed_samples = x.m_packed_samples;
        break;
        default:
        break;
    }
    
    return *this;
}

dds::xrce::DataRepresentation& dds::xrce::DataRepresentation::operator=(DataRepresentation &&x)
{
    m__d = x.m__d;
    
    switch(m__d)
    {
        case FORMAT_DATA:
        m_data = std::move(x.m_data);
        break;
        case FORMAT_SAMPLE:
        m_sample = std::move(x.m_sample);
        break;
        case FORMAT_DATA_SEQ:
        m_data_seq = std::move(x.m_data_seq);
        break;
        case FORMAT_SAMPLE_SEQ:
        m_sample_seq = std::move(x.m_sample_seq);
        break;
        case FORMAT_PACKED_SAMPLES:
        m_packed_samples = std::move(x.m_packed_samples);
        break;
        default:
        break;
    }
    
    return *this;
}

void dds::xrce::DataRepresentation::_d(dds::xrce::DataFormat __d)
{
    bool b = false;
    
    switch(m__d)
    {
        case FORMAT_DATA:
        switch(__d)
        {
            case FORMAT_DATA:
            b = true;
            break;
            default:
            break;
        }
        break;
        case FORMAT_SAMPLE:
        switch(__d)
        {
            case FORMAT_SAMPLE:
            b = true;
            break;
            default:
            break;
        }
        break;
        case FORMAT_DATA_SEQ:
        switch(__d)
        {
            case FORMAT_DATA_SEQ:
            b = true;
            break;
            default:
            break;
        }
        break;
        case FORMAT_SAMPLE_SEQ:
        switch(__d)
        {
            case FORMAT_SAMPLE_SEQ:
            b = true;
            break;
            default:
            break;
        }
        break;
        case FORMAT_PACKED_SAMPLES:
        switch(__d)
        {
            case FORMAT_PACKED_SAMPLES:
            b = true;
            break;
            default:
            break;
        }
        break;
    }
    
    if(!b) throw BadParamException("Discriminator doesn't correspond with the selected union member");
    
    m__d = __d;
}

dds::xrce::DataFormat dds::xrce::DataRepresentation::_d() const
{
    return m__d;
}

dds::xrce::DataFormat& dds::xrce::DataRepresentation::_d()
{
    return m__d;
}

void dds::xrce::DataRepresentation::data(const dds::xrce::SampleData &_data)
{
    m_data = _data;
    m__d = FORMAT_DATA;
}

void dds::xrce::DataRepresentation::data(dds::xrce::SampleData &&_data)
{
    m_data = std::move(_data);
    m__d = FORMAT_DATA;
}

const dds::xrce::SampleData& dds::xrce::DataRepresentation::data() const
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_DATA:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data;
}

dds::xrce::SampleData& dds::xrce::DataRepresentation::data()
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_DATA:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data;
}
void dds::xrce::DataRepresentation::sample(const dds::xrce::Sample &_sample)
{
    m_sample = _sample;
    m__d = FORMAT_SAMPLE;
}

void dds::xrce::DataRepresentation::sample(dds::xrce::Sample &&_sample)
{
    m_sample = std::move(_sample);
    m__d = FORMAT_SAMPLE;
}

const dds::xrce::Sample& dds::xrce::DataRepresentation::sample() const
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_SAMPLE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_sample;
}

dds::xrce::Sample& dds::xrce::DataRepresentation::sample()
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_SAMPLE:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_sample;
}
void dds::xrce::DataRepresentation::data_seq(const dds::xrce::SampleDataSeq &_data_seq)
{
    m_data_seq = _data_seq;
    m__d = FORMAT_DATA_SEQ;
}

void dds::xrce::DataRepresentation::data_seq(dds::xrce::SampleDataSeq &&_data_seq)
{
    m_data_seq = std::move(_data_seq);
    m__d = FORMAT_DATA_SEQ;
}

const dds::xrce::SampleDataSeq& dds::xrce::DataRepresentation::data_seq() const
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_DATA_SEQ:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_seq;
}

dds::xrce::SampleDataSeq& dds::xrce::DataRepresentation::data_seq()
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_DATA_SEQ:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_data_seq;
}
void dds::xrce::DataRepresentation::sample_seq(const dds::xrce::SampleSeq &_sample_seq)
{
    m_sample_seq = _sample_seq;
    m__d = FORMAT_SAMPLE_SEQ;
}

void dds::xrce::DataRepresentation::sample_seq(dds::xrce::SampleSeq &&_sample_seq)
{
    m_sample_seq = std::move(_sample_seq);
    m__d = FORMAT_SAMPLE_SEQ;
}

const dds::xrce::SampleSeq& dds::xrce::DataRepresentation::sample_seq() const
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_SAMPLE_SEQ:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_sample_seq;
}

dds::xrce::SampleSeq& dds::xrce::DataRepresentation::sample_seq()
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_SAMPLE_SEQ:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_sample_seq;
}
void dds::xrce::DataRepresentation::packed_samples(const dds::xrce::PackedSamples &_packed_samples)
{
    m_packed_samples = _packed_samples;
    m__d = FORMAT_PACKED_SAMPLES;
}

void dds::xrce::DataRepresentation::packed_samples(dds::xrce::PackedSamples &&_packed_samples)
{
    m_packed_samples = std::move(_packed_samples);
    m__d = FORMAT_PACKED_SAMPLES;
}

const dds::xrce::PackedSamples& dds::xrce::DataRepresentation::packed_samples() const
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_PACKED_SAMPLES:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_packed_samples;
}

dds::xrce::PackedSamples& dds::xrce::DataRepresentation::packed_samples()
{
    bool b = false;
        
    switch(m__d)
    {
        case FORMAT_PACKED_SAMPLES:
        b = true;
        break;
        default:
        break;
    }    
    if(!b) throw BadParamException("This member is not been selected");
    
    return m_packed_samples;
}

size_t dds::xrce::DataRepresentation::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);
        for(size_t a = 0; a < 100; ++a)
        {
            reset_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(reset_alignment);}

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);
        for(size_t a = 0; a < 100; ++a)
        {
            reset_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(reset_alignment);}

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += dds::xrce::PackedSamples::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

size_t dds::xrce::DataRepresentation::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(m__d)
    {
        case FORMAT_DATA:
            m_data.getCdrSerializedSize(current_alignment);
            break;
        case FORMAT_SAMPLE:
            m_sample.getCdrSerializedSize(current_alignment);
            break;
        case FORMAT_DATA_SEQ:
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
            for(size_t a = 0; a < m_data_seq.size(); ++a)
            {
                current_alignment += m_data_seq.at(a).getCdrSerializedSize(current_alignment);
            }
            break;
        case FORMAT_SAMPLE_SEQ:
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
            for(size_t a = 0; a < m_sample_seq.size(); ++a)
            {
                current_alignment += m_sample_seq.at(a).getCdrSerializedSize(current_alignment);
            }
            break;
        case FORMAT_PACKED_SAMPLES:
            current_alignment += m_packed_samples.getCdrSerializedSize(current_alignment);
            break;
        default:
            break;
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::DataRepresentation::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case FORMAT_DATA:
        scdr << m_data;
        break;
        case FORMAT_SAMPLE:
        scdr << m_sample;
        break;
        case FORMAT_DATA_SEQ:
        scdr << m_data_seq;
        break;
        case FORMAT_SAMPLE_SEQ:
        scdr << m_sample_seq;
        break;
        case FORMAT_PACKED_SAMPLES:
        scdr << m_packed_samples;
        break;
        default:
        break;
    }
}

void dds::xrce::DataRepresentation::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case FORMAT_DATA:
        dcdr >> m_data;
        break;
        case FORMAT_SAMPLE:
        dcdr >> m_sample;
        break;
        case FORMAT_DATA_SEQ:
        dcdr >> m_data_seq;
        break;
        case FORMAT_SAMPLE_SEQ:
        dcdr >> m_sample_seq;
        break;
        case FORMAT_PACKED_SAMPLES:
        dcdr >> m_packed_samples;
        break;
        default:
        break;
    }
}

dds::xrce::CREATE_CLIENT_Payload::CREATE_CLIENT_Payload()
{
}

dds::xrce::CREATE_CLIENT_Payload::~CREATE_CLIENT_Payload()
{
}

dds::xrce::CREATE_CLIENT_Payload::CREATE_CLIENT_Payload(const CREATE_CLIENT_Payload &x)
    : BaseObjectRequest(x)
{
    m_client_representation = x.m_client_representation;
}

dds::xrce::CREATE_CLIENT_Payload::CREATE_CLIENT_Payload(CREATE_CLIENT_Payload &&x)
    : BaseObjectRequest(x)
{
    m_client_representation = std::move(x.m_client_representation);
}

dds::xrce::CREATE_CLIENT_Payload& dds::xrce::CREATE_CLIENT_Payload::operator=(const CREATE_CLIENT_Payload &x)
{
    BaseObjectRequest::operator=(x);
    m_client_representation = x.m_client_representation;
    
    return *this;
}

dds::xrce::CREATE_CLIENT_Payload& dds::xrce::CREATE_CLIENT_Payload::operator=(CREATE_CLIENT_Payload &&x)
{
    BaseObjectRequest::operator=(x);
    m_client_representation = std::move(x.m_client_representation);
    
    return *this;
}

size_t dds::xrce::CREATE_CLIENT_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::CLIENT_Representation::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::CREATE_CLIENT_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_client_representation.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::CREATE_CLIENT_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_client_representation;
}

void dds::xrce::CREATE_CLIENT_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_client_representation;
}

dds::xrce::CREATE_Payload::CREATE_Payload()
{
}

dds::xrce::CREATE_Payload::~CREATE_Payload()
{
}

dds::xrce::CREATE_Payload::CREATE_Payload(const CREATE_Payload &x)
    : BaseObjectRequest(x)
{
    m_object_representation = x.m_object_representation;
}

dds::xrce::CREATE_Payload::CREATE_Payload(CREATE_Payload &&x)
    : BaseObjectRequest(x)
{
    m_object_representation = std::move(x.m_object_representation);
}

dds::xrce::CREATE_Payload& dds::xrce::CREATE_Payload::operator=(const CREATE_Payload &x)
{
    BaseObjectRequest::operator=(x);
    m_object_representation = x.m_object_representation;
    
    return *this;
}

dds::xrce::CREATE_Payload& dds::xrce::CREATE_Payload::operator=(CREATE_Payload &&x)
{
    BaseObjectRequest::operator=(x);
    m_object_representation = std::move(x.m_object_representation);
    
    return *this;
}

size_t dds::xrce::CREATE_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::ObjectVariant::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::CREATE_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_object_representation.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::CREATE_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_object_representation;
}

void dds::xrce::CREATE_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_object_representation;
}

dds::xrce::GET_INFO_Payload::GET_INFO_Payload()
{
    m_info_mask = dds::xrce::INFO_CONFIGURATION;
}

dds::xrce::GET_INFO_Payload::~GET_INFO_Payload()
{
}

dds::xrce::GET_INFO_Payload::GET_INFO_Payload(const GET_INFO_Payload &x)
    : BaseObjectRequest(x)
{
    m_info_mask = x.m_info_mask;
}

dds::xrce::GET_INFO_Payload::GET_INFO_Payload(GET_INFO_Payload &&x)
    : BaseObjectRequest(x)
{
    m_info_mask = x.m_info_mask;
}

dds::xrce::GET_INFO_Payload& dds::xrce::GET_INFO_Payload::operator=(const GET_INFO_Payload &x)
{
    BaseObjectRequest::operator=(x);
    m_info_mask = x.m_info_mask;
    
    return *this;
}

dds::xrce::GET_INFO_Payload& dds::xrce::GET_INFO_Payload::operator=(GET_INFO_Payload &&x)
{
    BaseObjectRequest::operator=(x);
    m_info_mask = x.m_info_mask;
    
    return *this;
}

size_t dds::xrce::GET_INFO_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::GET_INFO_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    return current_alignment - initial_alignment;
}

void dds::xrce::GET_INFO_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << (uint32_t)m_info_mask;
}

void dds::xrce::GET_INFO_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    std::underlying_type<dds::xrce::InfoMask>::type temp_info_mask;
    dcdr >> temp_info_mask;
    m_info_mask = static_cast<dds::xrce::InfoMask>(temp_info_mask);
}

dds::xrce::DELETE_Payload::DELETE_Payload()
{
}

dds::xrce::DELETE_Payload::~DELETE_Payload()
{
}

dds::xrce::DELETE_Payload::DELETE_Payload(const DELETE_Payload &x)
    : BaseObjectRequest(x)
{
}

dds::xrce::DELETE_Payload::DELETE_Payload(DELETE_Payload &&x)
    : BaseObjectRequest(x)
{
}

dds::xrce::DELETE_Payload& dds::xrce::DELETE_Payload::operator=(const DELETE_Payload &x)
{
    BaseObjectRequest::operator=(x);
    
    return *this;
}

dds::xrce::DELETE_Payload& dds::xrce::DELETE_Payload::operator=(DELETE_Payload &&x)
{
    BaseObjectRequest::operator=(x);
    
    return *this;
}

size_t dds::xrce::DELETE_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::DELETE_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::DELETE_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
}

void dds::xrce::DELETE_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
}

dds::xrce::STATUS_AGENT_Payload::STATUS_AGENT_Payload()
{
}

dds::xrce::STATUS_AGENT_Payload::~STATUS_AGENT_Payload()
{
}

dds::xrce::STATUS_AGENT_Payload::STATUS_AGENT_Payload(const STATUS_AGENT_Payload &x)
    : BaseObjectReply(x)
{
    m_agent_info = x.m_agent_info;
}

dds::xrce::STATUS_AGENT_Payload::STATUS_AGENT_Payload(STATUS_AGENT_Payload &&x)
    : BaseObjectReply(x)
{
    m_agent_info = std::move(x.m_agent_info);
}

dds::xrce::STATUS_AGENT_Payload& dds::xrce::STATUS_AGENT_Payload::operator=(const STATUS_AGENT_Payload &x)
{
    BaseObjectReply::operator=(x);
    m_agent_info = x.m_agent_info;
    
    return *this;
}

dds::xrce::STATUS_AGENT_Payload& dds::xrce::STATUS_AGENT_Payload::operator=(STATUS_AGENT_Payload &&x)
{
    BaseObjectReply::operator=(x);
    m_agent_info = std::move(x.m_agent_info);
    
    return *this;
}

size_t dds::xrce::STATUS_AGENT_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::AGENT_Representation::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::STATUS_AGENT_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getCdrSerializedSize(current_alignment);
    current_alignment += m_agent_info.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::STATUS_AGENT_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectReply::serialize(scdr);
    scdr << m_agent_info;
}

void dds::xrce::STATUS_AGENT_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectReply::deserialize(dcdr);
    dcdr >> m_agent_info;
}

dds::xrce::STATUS_Payload::STATUS_Payload()
{
}

dds::xrce::STATUS_Payload::~STATUS_Payload()
{
}

dds::xrce::STATUS_Payload::STATUS_Payload(const STATUS_Payload &x)
    : BaseObjectReply(x)
{
}

dds::xrce::STATUS_Payload::STATUS_Payload(STATUS_Payload &&x)
    : BaseObjectReply(x)
{
}

dds::xrce::STATUS_Payload& dds::xrce::STATUS_Payload::operator=(const STATUS_Payload &x)
{
    BaseObjectReply::operator=(x);
    
    return *this;
}

dds::xrce::STATUS_Payload& dds::xrce::STATUS_Payload::operator=(STATUS_Payload &&x)
{
    BaseObjectReply::operator=(x);
    
    return *this;
}

size_t dds::xrce::STATUS_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::STATUS_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::STATUS_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectReply::serialize(scdr);
}

void dds::xrce::STATUS_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectReply::deserialize(dcdr);
}

dds::xrce::INFO_Payload::INFO_Payload()
{
}

dds::xrce::INFO_Payload::~INFO_Payload()
{
}

dds::xrce::INFO_Payload::INFO_Payload(const INFO_Payload &x)
    : BaseObjectReply(x)
{
    m_object_info = x.m_object_info;
}

dds::xrce::INFO_Payload::INFO_Payload(INFO_Payload &&x)
    : BaseObjectReply(x)
{
    m_object_info = std::move(x.m_object_info);
}

dds::xrce::INFO_Payload& dds::xrce::INFO_Payload::operator=(const INFO_Payload &x)
{
    BaseObjectReply::operator=(x);
    m_object_info = x.m_object_info;
    
    return *this;
}

dds::xrce::INFO_Payload& dds::xrce::INFO_Payload::operator=(INFO_Payload &&x)
{
    BaseObjectReply::operator=(x);
    m_object_info = std::move(x.m_object_info);
    
    return *this;
}

size_t dds::xrce::INFO_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::ObjectInfo::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::INFO_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectReply::getCdrSerializedSize(current_alignment);
    current_alignment += m_object_info.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::INFO_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectReply::serialize(scdr);
    scdr << m_object_info;
}

void dds::xrce::INFO_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectReply::deserialize(dcdr);
    dcdr >> m_object_info;
}

dds::xrce::READ_DATA_Payload::READ_DATA_Payload()
{
}

dds::xrce::READ_DATA_Payload::~READ_DATA_Payload()
{
}

dds::xrce::READ_DATA_Payload::READ_DATA_Payload(const READ_DATA_Payload &x)
    : BaseObjectRequest(x)
{
    m_read_specification = x.m_read_specification;
}

dds::xrce::READ_DATA_Payload::READ_DATA_Payload(READ_DATA_Payload &&x)
    : BaseObjectRequest(x)
{
    m_read_specification = std::move(x.m_read_specification);
}

dds::xrce::READ_DATA_Payload& dds::xrce::READ_DATA_Payload::operator=(const READ_DATA_Payload &x)
{
    BaseObjectRequest::operator=(x);
    m_read_specification = x.m_read_specification;
    
    return *this;
}

dds::xrce::READ_DATA_Payload& dds::xrce::READ_DATA_Payload::operator=(READ_DATA_Payload &&x)
{
    BaseObjectRequest::operator=(x);
    m_read_specification = std::move(x.m_read_specification);
    
    return *this;
}

size_t dds::xrce::READ_DATA_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::ReadSpecification::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::READ_DATA_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_read_specification.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::READ_DATA_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_read_specification;
}

void dds::xrce::READ_DATA_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_read_specification;
}

dds::xrce::WRITE_DATA_Payload_Data::WRITE_DATA_Payload_Data()
{
}

dds::xrce::WRITE_DATA_Payload_Data::~WRITE_DATA_Payload_Data()
{
}

dds::xrce::WRITE_DATA_Payload_Data::WRITE_DATA_Payload_Data(const WRITE_DATA_Payload_Data &x)
    : BaseObjectRequest(x)
{
    m_data = x.m_data;
}

dds::xrce::WRITE_DATA_Payload_Data::WRITE_DATA_Payload_Data(WRITE_DATA_Payload_Data &&x)
    : BaseObjectRequest(x)
{
    m_data = std::move(x.m_data);
}

dds::xrce::WRITE_DATA_Payload_Data& dds::xrce::WRITE_DATA_Payload_Data::operator=(const WRITE_DATA_Payload_Data &x)
{
    BaseObjectRequest::operator=(x);
    m_data = x.m_data;
    
    return *this;
}

dds::xrce::WRITE_DATA_Payload_Data& dds::xrce::WRITE_DATA_Payload_Data::operator=(WRITE_DATA_Payload_Data &&x)
{
    BaseObjectRequest::operator=(x);    
    m_data = std::move(x.m_data);
    
    return *this;
}

size_t dds::xrce::WRITE_DATA_Payload_Data::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::WRITE_DATA_Payload_Data::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_data.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::WRITE_DATA_Payload_Data::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr); 
    scdr << m_data;
}

void dds::xrce::WRITE_DATA_Payload_Data::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_data;
}

dds::xrce::WRITE_DATA_Payload_Sample::WRITE_DATA_Payload_Sample()
{
}

dds::xrce::WRITE_DATA_Payload_Sample::~WRITE_DATA_Payload_Sample()
{
}

dds::xrce::WRITE_DATA_Payload_Sample::WRITE_DATA_Payload_Sample(const WRITE_DATA_Payload_Sample &x)
    : BaseObjectRequest(x)
{
    m_sample = x.m_sample;
}

dds::xrce::WRITE_DATA_Payload_Sample::WRITE_DATA_Payload_Sample(WRITE_DATA_Payload_Sample &&x)
    : BaseObjectRequest(x)
{
    m_sample = std::move(x.m_sample);
}

dds::xrce::WRITE_DATA_Payload_Sample& dds::xrce::WRITE_DATA_Payload_Sample::operator=(const WRITE_DATA_Payload_Sample &x)
{
    BaseObjectRequest::operator=(x);
    m_sample = x.m_sample;
    
    return *this;
}

dds::xrce::WRITE_DATA_Payload_Sample& dds::xrce::WRITE_DATA_Payload_Sample::operator=(WRITE_DATA_Payload_Sample &&x)
{
    BaseObjectRequest::operator=(x);
    m_sample = std::move(x.m_sample);
    
    return *this;
}

size_t dds::xrce::WRITE_DATA_Payload_Sample::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::WRITE_DATA_Payload_Sample::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_sample.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::WRITE_DATA_Payload_Sample::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_sample;
}

void dds::xrce::WRITE_DATA_Payload_Sample::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_sample;
}

dds::xrce::WRITE_DATA_Payload_DataSeq::WRITE_DATA_Payload_DataSeq()
{
}

dds::xrce::WRITE_DATA_Payload_DataSeq::~WRITE_DATA_Payload_DataSeq()
{
}

dds::xrce::WRITE_DATA_Payload_DataSeq::WRITE_DATA_Payload_DataSeq(const WRITE_DATA_Payload_DataSeq &x)
    : BaseObjectRequest(x)
{
    m_data_seq = x.m_data_seq;
}

dds::xrce::WRITE_DATA_Payload_DataSeq::WRITE_DATA_Payload_DataSeq(WRITE_DATA_Payload_DataSeq &&x)
    : BaseObjectRequest(x)
{
    m_data_seq = std::move(x.m_data_seq);
}

dds::xrce::WRITE_DATA_Payload_DataSeq& dds::xrce::WRITE_DATA_Payload_DataSeq::operator=(const WRITE_DATA_Payload_DataSeq &x)
{
    BaseObjectRequest::operator=(x);
    m_data_seq = x.m_data_seq;
    
    return *this;
}

dds::xrce::WRITE_DATA_Payload_DataSeq& dds::xrce::WRITE_DATA_Payload_DataSeq::operator=(WRITE_DATA_Payload_DataSeq &&x)
{
    BaseObjectRequest::operator=(x);
    m_data_seq = std::move(x.m_data_seq);
    
    return *this;
}

size_t dds::xrce::WRITE_DATA_Payload_DataSeq::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);}


    return current_alignment - initial_alignment;
}

size_t dds::xrce::WRITE_DATA_Payload_DataSeq::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_data_seq.size(); ++a)
    {
        current_alignment += m_data_seq.at(a).getCdrSerializedSize(current_alignment);
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::WRITE_DATA_Payload_DataSeq::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_data_seq;
}

void dds::xrce::WRITE_DATA_Payload_DataSeq::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_data_seq;
}

dds::xrce::WRITE_DATA_Payload_SampleSeq::WRITE_DATA_Payload_SampleSeq()
{
}

dds::xrce::WRITE_DATA_Payload_SampleSeq::~WRITE_DATA_Payload_SampleSeq()
{
}

dds::xrce::WRITE_DATA_Payload_SampleSeq::WRITE_DATA_Payload_SampleSeq(const WRITE_DATA_Payload_SampleSeq &x)
    : BaseObjectRequest(x)
{
    m_sample_seq = x.m_sample_seq;
}

dds::xrce::WRITE_DATA_Payload_SampleSeq::WRITE_DATA_Payload_SampleSeq(WRITE_DATA_Payload_SampleSeq &&x)
    : BaseObjectRequest(x)
{
    m_sample_seq = std::move(x.m_sample_seq);
}

dds::xrce::WRITE_DATA_Payload_SampleSeq& dds::xrce::WRITE_DATA_Payload_SampleSeq::operator=(const WRITE_DATA_Payload_SampleSeq &x)
{
    BaseObjectRequest::operator=(x);
    m_sample_seq = x.m_sample_seq;
    
    return *this;
}

dds::xrce::WRITE_DATA_Payload_SampleSeq& dds::xrce::WRITE_DATA_Payload_SampleSeq::operator=(WRITE_DATA_Payload_SampleSeq &&x)
{
    BaseObjectRequest::operator=(x);
    m_sample_seq = std::move(x.m_sample_seq);
    
    return *this;
}

size_t dds::xrce::WRITE_DATA_Payload_SampleSeq::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(current_alignment);}


    return current_alignment - initial_alignment;
}

size_t dds::xrce::WRITE_DATA_Payload_SampleSeq::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_sample_seq.size(); ++a)
    {
        current_alignment += m_sample_seq.at(a).getCdrSerializedSize(current_alignment);
    }


    return current_alignment - initial_alignment;
}

void dds::xrce::WRITE_DATA_Payload_SampleSeq::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_sample_seq;
}

void dds::xrce::WRITE_DATA_Payload_SampleSeq::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_sample_seq;
}

dds::xrce::WRITE_DATA_Payload_PackedSamples::WRITE_DATA_Payload_PackedSamples()
{
}

dds::xrce::WRITE_DATA_Payload_PackedSamples::~WRITE_DATA_Payload_PackedSamples()
{
}

dds::xrce::WRITE_DATA_Payload_PackedSamples::WRITE_DATA_Payload_PackedSamples(const WRITE_DATA_Payload_PackedSamples &x)
    : BaseObjectRequest(x)
{
    m_packed_samples = x.m_packed_samples;
}

dds::xrce::WRITE_DATA_Payload_PackedSamples::WRITE_DATA_Payload_PackedSamples(WRITE_DATA_Payload_PackedSamples &&x)
    : BaseObjectRequest(x)
{
    m_packed_samples = std::move(x.m_packed_samples);
}

dds::xrce::WRITE_DATA_Payload_PackedSamples& dds::xrce::WRITE_DATA_Payload_PackedSamples::operator=(const WRITE_DATA_Payload_PackedSamples &x)
{
    BaseObjectRequest::operator=(x);
    m_packed_samples = x.m_packed_samples;
    
    return *this;
}

dds::xrce::WRITE_DATA_Payload_PackedSamples& dds::xrce::WRITE_DATA_Payload_PackedSamples::operator=(WRITE_DATA_Payload_PackedSamples &&x)
{
    BaseObjectRequest::operator=(x);
    m_packed_samples = std::move(x.m_packed_samples);
    
    return *this;
}

size_t dds::xrce::WRITE_DATA_Payload_PackedSamples::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::PackedSamples::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::WRITE_DATA_Payload_PackedSamples::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_packed_samples.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::WRITE_DATA_Payload_PackedSamples::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_packed_samples;
}

void dds::xrce::WRITE_DATA_Payload_PackedSamples::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_packed_samples;
}

dds::xrce::DATA_Payload_Data::DATA_Payload_Data()
{
}

dds::xrce::DATA_Payload_Data::~DATA_Payload_Data()
{
}

dds::xrce::DATA_Payload_Data::DATA_Payload_Data(const DATA_Payload_Data &x)
    : BaseObjectRequest(x)
{
    m_data = x.m_data;
}

dds::xrce::DATA_Payload_Data::DATA_Payload_Data(DATA_Payload_Data &&x)
    : BaseObjectRequest(x)
{
    m_data = std::move(x.m_data);
}

dds::xrce::DATA_Payload_Data& dds::xrce::DATA_Payload_Data::operator=(const DATA_Payload_Data &x)
{
    BaseObjectRequest::operator=(x);
    m_data = x.m_data;
    
    return *this;
}

dds::xrce::DATA_Payload_Data& dds::xrce::DATA_Payload_Data::operator=(DATA_Payload_Data &&x)
{
    BaseObjectRequest::operator=(x);
    m_data = std::move(x.m_data);
    
    return *this;
}

size_t dds::xrce::DATA_Payload_Data::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATA_Payload_Data::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_data.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::DATA_Payload_Data::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_data;
}

void dds::xrce::DATA_Payload_Data::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_data;
}

dds::xrce::DATA_Payload_Sample::DATA_Payload_Sample()
{
}

dds::xrce::DATA_Payload_Sample::~DATA_Payload_Sample()
{
}

dds::xrce::DATA_Payload_Sample::DATA_Payload_Sample(const DATA_Payload_Sample &x)
    : BaseObjectRequest(x)
{
    m_sample = x.m_sample;
}

dds::xrce::DATA_Payload_Sample::DATA_Payload_Sample(DATA_Payload_Sample &&x)
    : BaseObjectRequest(x)
{
    m_sample = std::move(x.m_sample);
}

dds::xrce::DATA_Payload_Sample& dds::xrce::DATA_Payload_Sample::operator=(const DATA_Payload_Sample &x)
{
    BaseObjectRequest::operator=(x);
    m_sample = x.m_sample;
    
    return *this;
}

dds::xrce::DATA_Payload_Sample& dds::xrce::DATA_Payload_Sample::operator=(DATA_Payload_Sample &&x)
{
    BaseObjectRequest::operator=(x);
    m_sample = std::move(x.m_sample);
    
    return *this;
}

size_t dds::xrce::DATA_Payload_Sample::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATA_Payload_Sample::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_sample.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::DATA_Payload_Sample::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_sample;
}

void dds::xrce::DATA_Payload_Sample::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_sample;
}

dds::xrce::DATA_Payload_DataSeq::DATA_Payload_DataSeq()
{
}

dds::xrce::DATA_Payload_DataSeq::~DATA_Payload_DataSeq()
{
}

dds::xrce::DATA_Payload_DataSeq::DATA_Payload_DataSeq(const DATA_Payload_DataSeq &x)
    : BaseObjectRequest(x)
{
    m_data_seq = x.m_data_seq;
}

dds::xrce::DATA_Payload_DataSeq::DATA_Payload_DataSeq(DATA_Payload_DataSeq &&x)
    : BaseObjectRequest(x)
{
    m_data_seq = std::move(x.m_data_seq);
}

dds::xrce::DATA_Payload_DataSeq& dds::xrce::DATA_Payload_DataSeq::operator=(const DATA_Payload_DataSeq &x)
{
    BaseObjectRequest::operator=(x);
    m_data_seq = x.m_data_seq;
    
    return *this;
}

dds::xrce::DATA_Payload_DataSeq& dds::xrce::DATA_Payload_DataSeq::operator=(DATA_Payload_DataSeq &&x)
{
    BaseObjectRequest::operator=(x);
    m_data_seq = std::move(x.m_data_seq);
    
    return *this;
}

size_t dds::xrce::DATA_Payload_DataSeq::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::SampleData::getMaxCdrSerializedSize(current_alignment);}


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATA_Payload_DataSeq::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_data_seq.size(); ++a)
    {
        current_alignment += m_data_seq.at(a).getCdrSerializedSize(current_alignment); 
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::DATA_Payload_DataSeq::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_data_seq;
}

void dds::xrce::DATA_Payload_DataSeq::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_data_seq;
}

dds::xrce::DATA_Payload_SampleSeq::DATA_Payload_SampleSeq()
{
}

dds::xrce::DATA_Payload_SampleSeq::~DATA_Payload_SampleSeq()
{
}

dds::xrce::DATA_Payload_SampleSeq::DATA_Payload_SampleSeq(const DATA_Payload_SampleSeq &x)
    : BaseObjectRequest(x)
{
    m_sample_seq = x.m_sample_seq;
}

dds::xrce::DATA_Payload_SampleSeq::DATA_Payload_SampleSeq(DATA_Payload_SampleSeq &&x)
    : BaseObjectRequest(x)
{
    m_sample_seq = std::move(x.m_sample_seq);
}

dds::xrce::DATA_Payload_SampleSeq& dds::xrce::DATA_Payload_SampleSeq::operator=(const DATA_Payload_SampleSeq &x)
{
    BaseObjectRequest::operator=(x);
    m_sample_seq = x.m_sample_seq;
    
    return *this;
}

dds::xrce::DATA_Payload_SampleSeq& dds::xrce::DATA_Payload_SampleSeq::operator=(DATA_Payload_SampleSeq &&x)
{
    BaseObjectRequest::operator=(x);
    m_sample_seq = std::move(x.m_sample_seq);
    
    return *this;
}

size_t dds::xrce::DATA_Payload_SampleSeq::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += dds::xrce::Sample::getMaxCdrSerializedSize(current_alignment);}


    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATA_Payload_SampleSeq::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    for(size_t a = 0; a < m_sample_seq.size(); ++a)
    {
        current_alignment += m_sample_seq.at(a).getCdrSerializedSize(current_alignment);
    }

    return current_alignment - initial_alignment;
}

void dds::xrce::DATA_Payload_SampleSeq::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_sample_seq;
}

void dds::xrce::DATA_Payload_SampleSeq::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_sample_seq;
}

dds::xrce::DATA_Payload_PackedSamples::DATA_Payload_PackedSamples()
{
}

dds::xrce::DATA_Payload_PackedSamples::~DATA_Payload_PackedSamples()
{
}

dds::xrce::DATA_Payload_PackedSamples::DATA_Payload_PackedSamples(const DATA_Payload_PackedSamples &x)
    : BaseObjectRequest(x)
{
    m_packed_samples = x.m_packed_samples;
}

dds::xrce::DATA_Payload_PackedSamples::DATA_Payload_PackedSamples(DATA_Payload_PackedSamples &&x)
    : BaseObjectRequest(x)
{
    m_packed_samples = std::move(x.m_packed_samples);
}

dds::xrce::DATA_Payload_PackedSamples& dds::xrce::DATA_Payload_PackedSamples::operator=(const DATA_Payload_PackedSamples &x)
{
    BaseObjectRequest::operator=(x);
    m_packed_samples = x.m_packed_samples;
    
    return *this;
}

dds::xrce::DATA_Payload_PackedSamples& dds::xrce::DATA_Payload_PackedSamples::operator=(DATA_Payload_PackedSamples &&x)
{
    BaseObjectRequest::operator=(x);
    m_packed_samples = std::move(x.m_packed_samples);
    
    return *this;
}

size_t dds::xrce::DATA_Payload_PackedSamples::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getMaxCdrSerializedSize(current_alignment);
    current_alignment += dds::xrce::PackedSamples::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t dds::xrce::DATA_Payload_PackedSamples::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += dds::xrce::BaseObjectRequest::getCdrSerializedSize(current_alignment);
    current_alignment += m_packed_samples.getCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

void dds::xrce::DATA_Payload_PackedSamples::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    BaseObjectRequest::serialize(scdr);
    scdr << m_packed_samples;
}

void dds::xrce::DATA_Payload_PackedSamples::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    BaseObjectRequest::deserialize(dcdr);
    dcdr >> m_packed_samples;
}

dds::xrce::ACKNACK_Payload::ACKNACK_Payload()
{
    m_first_unacked_seq_num = 0;
}

dds::xrce::ACKNACK_Payload::~ACKNACK_Payload()
{
}

dds::xrce::ACKNACK_Payload::ACKNACK_Payload(const ACKNACK_Payload &x)
{
    m_first_unacked_seq_num = x.m_first_unacked_seq_num;
    m_nack_bitmap = x.m_nack_bitmap;
}

dds::xrce::ACKNACK_Payload::ACKNACK_Payload(ACKNACK_Payload &&x)
{
    m_first_unacked_seq_num = x.m_first_unacked_seq_num;
    m_nack_bitmap = std::move(x.m_nack_bitmap);
}

dds::xrce::ACKNACK_Payload& dds::xrce::ACKNACK_Payload::operator=(const ACKNACK_Payload &x)
{
    m_first_unacked_seq_num = x.m_first_unacked_seq_num;
    m_nack_bitmap = x.m_nack_bitmap;
    
    return *this;
}

dds::xrce::ACKNACK_Payload& dds::xrce::ACKNACK_Payload::operator=(ACKNACK_Payload &&x)
{
    m_first_unacked_seq_num = x.m_first_unacked_seq_num;
    m_nack_bitmap = std::move(x.m_nack_bitmap);
    
    return *this;
}

size_t dds::xrce::ACKNACK_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::ACKNACK_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += ((2) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    return current_alignment - initial_alignment;
}

void dds::xrce::ACKNACK_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_first_unacked_seq_num;
    scdr << m_nack_bitmap;
}

void dds::xrce::ACKNACK_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_first_unacked_seq_num;
    dcdr >> m_nack_bitmap;
}

dds::xrce::HEARTBEAT_Payload::HEARTBEAT_Payload()
{
    m_first_unacked_seq_nr = 0;
    m_last_unacked_seq_nr = 0;
}

dds::xrce::HEARTBEAT_Payload::~HEARTBEAT_Payload()
{
}

dds::xrce::HEARTBEAT_Payload::HEARTBEAT_Payload(const HEARTBEAT_Payload &x)
{
    m_first_unacked_seq_nr = x.m_first_unacked_seq_nr;
    m_last_unacked_seq_nr = x.m_last_unacked_seq_nr;
}

dds::xrce::HEARTBEAT_Payload::HEARTBEAT_Payload(HEARTBEAT_Payload &&x)
{
    m_first_unacked_seq_nr = x.m_first_unacked_seq_nr;
    m_last_unacked_seq_nr = x.m_last_unacked_seq_nr;
}

dds::xrce::HEARTBEAT_Payload& dds::xrce::HEARTBEAT_Payload::operator=(const HEARTBEAT_Payload &x)
{
    m_first_unacked_seq_nr = x.m_first_unacked_seq_nr;
    m_last_unacked_seq_nr = x.m_last_unacked_seq_nr;
    
    return *this;
}

dds::xrce::HEARTBEAT_Payload& dds::xrce::HEARTBEAT_Payload::operator=(HEARTBEAT_Payload &&x)
{
    m_first_unacked_seq_nr = x.m_first_unacked_seq_nr;
    m_last_unacked_seq_nr = x.m_last_unacked_seq_nr;
    
    return *this;
}

size_t dds::xrce::HEARTBEAT_Payload::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t dds::xrce::HEARTBEAT_Payload::getCdrSerializedSize(size_t current_alignment) const
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void dds::xrce::HEARTBEAT_Payload::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_first_unacked_seq_nr;
    scdr << m_last_unacked_seq_nr;
}

void dds::xrce::HEARTBEAT_Payload::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_first_unacked_seq_nr;
    dcdr >> m_last_unacked_seq_nr;
}
