// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file BasicTypeObject.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "Basic.h"
#include "BasicTypeObject.h"
#include <utility>
#include <sstream>
#include <fastrtps/rtps/common/SerializedPayload.h>
#include <fastrtps/utils/md5.h>
#include <fastrtps/types/TypeObjectFactory.h>
#include <fastrtps/types/TypeNamesGenerator.h>
#include <fastcdr/FastBuffer.h>
#include <fastcdr/Cdr.h>

using namespace eprosima::fastrtps::rtps;

void registerBasicTypes()
{
    TypeObjectFactory *factory = TypeObjectFactory::GetInstance();
    factory->AddTypeObject("MyEnum", GetMyEnumIdentifier(true), GetMyEnumObject(true));
    factory->AddTypeObject("MyEnum", GetMyEnumIdentifier(false), GetMyEnumObject(false));
    factory->AddTypeObject("MyAliasEnum", GetMyAliasEnumIdentifier(true), GetMyAliasEnumObject(true));
    factory->AddTypeObject("MyAliasEnum", GetMyAliasEnumIdentifier(false), GetMyAliasEnumObject(false));
    factory->AddTypeObject("MyAliasAliasEnum", GetMyAliasAliasEnumIdentifier(true), GetMyAliasAliasEnumObject(true));
    factory->AddTypeObject("MyAliasAliasEnum", GetMyAliasAliasEnumIdentifier(false), GetMyAliasAliasEnumObject(false));
    factory->AddTypeObject("EnumStruct", GetEnumStructIdentifier(true), GetEnumStructObject(true));
    factory->AddTypeObject("EnumStruct", GetEnumStructIdentifier(false), GetEnumStructObject(false));
    factory->AddTypeObject("AliasStruct", GetAliasStructIdentifier(true), GetAliasStructObject(true));
    factory->AddTypeObject("AliasStruct", GetAliasStructIdentifier(false), GetAliasStructObject(false));
    factory->AddTypeObject("AliasAliasStruct", GetAliasAliasStructIdentifier(true), GetAliasAliasStructObject(true));
    factory->AddTypeObject("AliasAliasStruct", GetAliasAliasStructIdentifier(false), GetAliasAliasStructObject(false));
    factory->AddTypeObject("BoolStruct", GetBoolStructIdentifier(true), GetBoolStructObject(true));
    factory->AddTypeObject("BoolStruct", GetBoolStructIdentifier(false), GetBoolStructObject(false));
    factory->AddTypeObject("OctetStruct", GetOctetStructIdentifier(true), GetOctetStructObject(true));
    factory->AddTypeObject("OctetStruct", GetOctetStructIdentifier(false), GetOctetStructObject(false));
    factory->AddTypeObject("ShortStruct", GetShortStructIdentifier(true), GetShortStructObject(true));
    factory->AddTypeObject("ShortStruct", GetShortStructIdentifier(false), GetShortStructObject(false));
    factory->AddTypeObject("LongStruct", GetLongStructIdentifier(true), GetLongStructObject(true));
    factory->AddTypeObject("LongStruct", GetLongStructIdentifier(false), GetLongStructObject(false));
    factory->AddTypeObject("LongLongStruct", GetLongLongStructIdentifier(true), GetLongLongStructObject(true));
    factory->AddTypeObject("LongLongStruct", GetLongLongStructIdentifier(false), GetLongLongStructObject(false));
    factory->AddTypeObject("UShortStruct", GetUShortStructIdentifier(true), GetUShortStructObject(true));
    factory->AddTypeObject("UShortStruct", GetUShortStructIdentifier(false), GetUShortStructObject(false));
    factory->AddTypeObject("ULongStruct", GetULongStructIdentifier(true), GetULongStructObject(true));
    factory->AddTypeObject("ULongStruct", GetULongStructIdentifier(false), GetULongStructObject(false));
    factory->AddTypeObject("ULongLongStruct", GetULongLongStructIdentifier(true), GetULongLongStructObject(true));
    factory->AddTypeObject("ULongLongStruct", GetULongLongStructIdentifier(false), GetULongLongStructObject(false));
    factory->AddTypeObject("FloatStruct", GetFloatStructIdentifier(true), GetFloatStructObject(true));
    factory->AddTypeObject("FloatStruct", GetFloatStructIdentifier(false), GetFloatStructObject(false));
    factory->AddTypeObject("DoubleStruct", GetDoubleStructIdentifier(true), GetDoubleStructObject(true));
    factory->AddTypeObject("DoubleStruct", GetDoubleStructIdentifier(false), GetDoubleStructObject(false));
    factory->AddTypeObject("LongDoubleStruct", GetLongDoubleStructIdentifier(true), GetLongDoubleStructObject(true));
    factory->AddTypeObject("LongDoubleStruct", GetLongDoubleStructIdentifier(false), GetLongDoubleStructObject(false));
    factory->AddTypeObject("CharStruct", GetCharStructIdentifier(true), GetCharStructObject(true));
    factory->AddTypeObject("CharStruct", GetCharStructIdentifier(false), GetCharStructObject(false));
    factory->AddTypeObject("WCharStruct", GetWCharStructIdentifier(true), GetWCharStructObject(true));
    factory->AddTypeObject("WCharStruct", GetWCharStructIdentifier(false), GetWCharStructObject(false));
    factory->AddTypeObject("StringStruct", GetStringStructIdentifier(true), GetStringStructObject(true));
    factory->AddTypeObject("StringStruct", GetStringStructIdentifier(false), GetStringStructObject(false));
    factory->AddTypeObject("WStringStruct", GetWStringStructIdentifier(true), GetWStringStructObject(true));
    factory->AddTypeObject("WStringStruct", GetWStringStructIdentifier(false), GetWStringStructObject(false));
    factory->AddTypeObject("LargeStringStruct", GetLargeStringStructIdentifier(true), GetLargeStringStructObject(true));
    factory->AddTypeObject("LargeStringStruct", GetLargeStringStructIdentifier(false), GetLargeStringStructObject(false));
    factory->AddTypeObject("LargeWStringStruct", GetLargeWStringStructIdentifier(true), GetLargeWStringStructObject(true));
    factory->AddTypeObject("LargeWStringStruct", GetLargeWStringStructIdentifier(false), GetLargeWStringStructObject(false));
    factory->AddTypeObject("ArraytStruct", GetArraytStructIdentifier(true), GetArraytStructObject(true));
    factory->AddTypeObject("ArraytStruct", GetArraytStructIdentifier(false), GetArraytStructObject(false));
    factory->AddTypeObject("MyArray", GetMyArrayIdentifier(true), GetMyArrayObject(true));
    factory->AddTypeObject("MyArray", GetMyArrayIdentifier(false), GetMyArrayObject(false));
    factory->AddTypeObject("ArrayArrayStruct", GetArrayArrayStructIdentifier(true), GetArrayArrayStructObject(true));
    factory->AddTypeObject("ArrayArrayStruct", GetArrayArrayStructIdentifier(false), GetArrayArrayStructObject(false));
    factory->AddTypeObject("SequenceStruct", GetSequenceStructIdentifier(true), GetSequenceStructObject(true));
    factory->AddTypeObject("SequenceStruct", GetSequenceStructIdentifier(false), GetSequenceStructObject(false));
    factory->AddTypeObject("SequenceSequenceStruct", GetSequenceSequenceStructIdentifier(true), GetSequenceSequenceStructObject(true));
    factory->AddTypeObject("SequenceSequenceStruct", GetSequenceSequenceStructIdentifier(false), GetSequenceSequenceStructObject(false));
    factory->AddTypeObject("MapStruct", GetMapStructIdentifier(true), GetMapStructObject(true));
    factory->AddTypeObject("MapStruct", GetMapStructIdentifier(false), GetMapStructObject(false));
    factory->AddTypeObject("MapMapStruct", GetMapMapStructIdentifier(true), GetMapMapStructObject(true));
    factory->AddTypeObject("MapMapStruct", GetMapMapStructIdentifier(false), GetMapMapStructObject(false));
    factory->AddTypeObject("StructStruct", GetStructStructIdentifier(true), GetStructStructObject(true));
    factory->AddTypeObject("StructStruct", GetStructStructIdentifier(false), GetStructStructObject(false));
    factory->AddTypeObject("StructStructStruct", GetStructStructStructIdentifier(true), GetStructStructStructObject(true));
    factory->AddTypeObject("StructStructStruct", GetStructStructStructIdentifier(false), GetStructStructStructObject(false));
    factory->AddTypeObject("SimpleUnion", GetSimpleUnionIdentifier(true), GetSimpleUnionObject(true));
    factory->AddTypeObject("SimpleUnion", GetSimpleUnionIdentifier(false), GetSimpleUnionObject(false));
    factory->AddTypeObject("UnionUnion", GetUnionUnionIdentifier(true), GetUnionUnionObject(true));
    factory->AddTypeObject("UnionUnion", GetUnionUnionIdentifier(false), GetUnionUnionObject(false));
    factory->AddTypeObject("WCharUnion", GetWCharUnionIdentifier(true), GetWCharUnionObject(true));
    factory->AddTypeObject("WCharUnion", GetWCharUnionIdentifier(false), GetWCharUnionObject(false));
    factory->AddTypeObject("SimpleUnionStruct", GetSimpleUnionStructIdentifier(true), GetSimpleUnionStructObject(true));
    factory->AddTypeObject("SimpleUnionStruct", GetSimpleUnionStructIdentifier(false), GetSimpleUnionStructObject(false));
    factory->AddTypeObject("UnionUnionUnionStruct", GetUnionUnionUnionStructIdentifier(true), GetUnionUnionUnionStructObject(true));
    factory->AddTypeObject("UnionUnionUnionStruct", GetUnionUnionUnionStructIdentifier(false), GetUnionUnionUnionStructObject(false));
    factory->AddTypeObject("WCharUnionStruct", GetWCharUnionStructIdentifier(true), GetWCharUnionStructObject(true));
    factory->AddTypeObject("WCharUnionStruct", GetWCharUnionStructIdentifier(false), GetWCharUnionStructObject(false));
}

const TypeIdentifier* GetMyEnumIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyEnum", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMyEnumObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyEnum", complete);
}

const TypeObject* GetMyEnumObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyEnum", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMyEnumObject();
    }
    // else
    return GetMinimalMyEnumObject();
}

const TypeObject* GetMinimalMyEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyEnum", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ENUM);
    // Unused
    //type_object->minimal().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->minimal().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?

    uint32_t value = 0;
    MinimalEnumeratedLiteral mel_A;
    mel_A.common().flags().TRY_CONSTRUCT1(false);
    mel_A.common().flags().TRY_CONSTRUCT2(false);
    mel_A.common().flags().IS_EXTERNAL(false);
    mel_A.common().flags().IS_OPTIONAL(false);
    mel_A.common().flags().IS_MUST_UNDERSTAND(false);
    mel_A.common().flags().IS_KEY(false);
    mel_A.common().flags().IS_DEFAULT(false);
    mel_A.common().flags().IS_DEFAULT(false);
    mel_A.common().value(value++);
    MD5 A_hash("A");
    for(int i = 0; i < 4; ++i)
    {
        mel_A.detail().name_hash()[i] = A_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_A);

    MinimalEnumeratedLiteral mel_B;
    mel_B.common().flags().TRY_CONSTRUCT1(false);
    mel_B.common().flags().TRY_CONSTRUCT2(false);
    mel_B.common().flags().IS_EXTERNAL(false);
    mel_B.common().flags().IS_OPTIONAL(false);
    mel_B.common().flags().IS_MUST_UNDERSTAND(false);
    mel_B.common().flags().IS_KEY(false);
    mel_B.common().flags().IS_DEFAULT(false);
    mel_B.common().flags().IS_DEFAULT(false);
    mel_B.common().value(value++);
    MD5 B_hash("B");
    for(int i = 0; i < 4; ++i)
    {
        mel_B.detail().name_hash()[i] = B_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_B);

    MinimalEnumeratedLiteral mel_C;
    mel_C.common().flags().TRY_CONSTRUCT1(false);
    mel_C.common().flags().TRY_CONSTRUCT2(false);
    mel_C.common().flags().IS_EXTERNAL(false);
    mel_C.common().flags().IS_OPTIONAL(false);
    mel_C.common().flags().IS_MUST_UNDERSTAND(false);
    mel_C.common().flags().IS_KEY(false);
    mel_C.common().flags().IS_DEFAULT(false);
    mel_C.common().flags().IS_DEFAULT(false);
    mel_C.common().value(value++);
    MD5 C_hash("C");
    for(int i = 0; i < 4; ++i)
    {
        mel_C.detail().name_hash()[i] = C_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_C);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalEnumeratedType::getCdrSerializedSize(type_object->minimal().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MyEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyEnum", false);
}

const TypeObject* GetCompleteMyEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyEnum", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ENUM);

    type_object->complete().enumerated_type().enum_flags().IS_FINAL(false);
    type_object->complete().enumerated_type().enum_flags().IS_APPENDABLE(false);
    type_object->complete().enumerated_type().enum_flags().IS_MUTABLE(false);
    type_object->complete().enumerated_type().enum_flags().IS_NESTED(false);
    type_object->complete().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->complete().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?
    //type_object->complete().enumerated_type().header().detail().ann_builtin()...
    //type_object->complete().enumerated_type().header().detail().ann_custom()...
    type_object->complete().enumerated_type().header().detail().type_name("MyEnum");

    uint32_t value = 0;
    CompleteEnumeratedLiteral cel_A;
    cel_A.common().flags().TRY_CONSTRUCT1(false);
    cel_A.common().flags().TRY_CONSTRUCT2(false);
    cel_A.common().flags().IS_EXTERNAL(false);
    cel_A.common().flags().IS_OPTIONAL(false);
    cel_A.common().flags().IS_MUST_UNDERSTAND(false);
    cel_A.common().flags().IS_KEY(false);
    cel_A.common().flags().IS_DEFAULT(false);
    cel_A.common().flags().IS_DEFAULT(false);
    cel_A.common().value(value++);
    cel_A.detail().name("A");
    //cel_A.detail().ann_builtin()...
    //cel_A.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_A);

    CompleteEnumeratedLiteral cel_B;
    cel_B.common().flags().TRY_CONSTRUCT1(false);
    cel_B.common().flags().TRY_CONSTRUCT2(false);
    cel_B.common().flags().IS_EXTERNAL(false);
    cel_B.common().flags().IS_OPTIONAL(false);
    cel_B.common().flags().IS_MUST_UNDERSTAND(false);
    cel_B.common().flags().IS_KEY(false);
    cel_B.common().flags().IS_DEFAULT(false);
    cel_B.common().flags().IS_DEFAULT(false);
    cel_B.common().value(value++);
    cel_B.detail().name("B");
    //cel_B.detail().ann_builtin()...
    //cel_B.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_B);

    CompleteEnumeratedLiteral cel_C;
    cel_C.common().flags().TRY_CONSTRUCT1(false);
    cel_C.common().flags().TRY_CONSTRUCT2(false);
    cel_C.common().flags().IS_EXTERNAL(false);
    cel_C.common().flags().IS_OPTIONAL(false);
    cel_C.common().flags().IS_MUST_UNDERSTAND(false);
    cel_C.common().flags().IS_KEY(false);
    cel_C.common().flags().IS_DEFAULT(false);
    cel_C.common().flags().IS_DEFAULT(false);
    cel_C.common().value(value++);
    cel_C.detail().name("C");
    //cel_C.detail().ann_builtin()...
    //cel_C.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_C);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteEnumeratedType::getCdrSerializedSize(type_object->complete().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MyEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyEnum", true);
}

const TypeIdentifier* GetMyAliasEnumIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyAliasEnum", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMyAliasEnumObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyAliasEnum", complete);
}

const TypeObject* GetMyAliasEnumObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasEnum", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMyAliasEnumObject();
    }
    else
    {
        return GetMinimalMyAliasEnumObject();
    }
}

const TypeObject* GetMinimalMyAliasEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasEnum", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ALIAS);
    type_object->minimal().alias_type().alias_flags().IS_FINAL(false);
    type_object->minimal().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_NESTED(false);
    type_object->minimal().alias_type().alias_flags().IS_AUTOID_HASH(false);

    // type_object->minimal().alias_type().header()... Is empty

    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_DEFAULT(false);

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyEnum", false);


    if (relatedType != nullptr)
    {
        type_object->minimal().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAliasType::getCdrSerializedSize(type_object->minimal().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyAliasEnum", "MyEnum");

    TypeObjectFactory::GetInstance()->AddTypeObject("MyAliasEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasEnum", false);
}

const TypeObject* GetCompleteMyAliasEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasEnum", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ALIAS);
    type_object->complete().alias_type().alias_flags().IS_FINAL(false);
    type_object->complete().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->complete().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->complete().alias_type().alias_flags().IS_NESTED(false);
    type_object->complete().alias_type().alias_flags().IS_AUTOID_HASH(false);

    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().placement("placement");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().language("language");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().text("text");
    //type_object->complete().alias_type().header().detail().ann_custom().push_back(...);
    type_object->complete().alias_type().header().detail().type_name("MyAliasEnum");

    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->complete().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->complete().alias_type().body().common().related_flags().IS_DEFAULT(false);

    //type_object->complete().alias_type().body().common().ann_builtin()
    //type_object->complete().alias_type().body().common().ann_custom()

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifierTryingComplete("MyEnum");


    if (relatedType != nullptr)
    {
        type_object->complete().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAliasType::getCdrSerializedSize(type_object->complete().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyAliasEnum", "MyEnum");

    TypeObjectFactory::GetInstance()->AddTypeObject("MyAliasEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasEnum", true);
}

const TypeIdentifier* GetMyAliasAliasEnumIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyAliasAliasEnum", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMyAliasAliasEnumObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyAliasAliasEnum", complete);
}

const TypeObject* GetMyAliasAliasEnumObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasAliasEnum", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMyAliasAliasEnumObject();
    }
    else
    {
        return GetMinimalMyAliasAliasEnumObject();
    }
}

const TypeObject* GetMinimalMyAliasAliasEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasAliasEnum", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ALIAS);
    type_object->minimal().alias_type().alias_flags().IS_FINAL(false);
    type_object->minimal().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_NESTED(false);
    type_object->minimal().alias_type().alias_flags().IS_AUTOID_HASH(false);

    // type_object->minimal().alias_type().header()... Is empty

    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_DEFAULT(false);

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyAliasEnum", false);


    if (relatedType != nullptr)
    {
        type_object->minimal().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAliasType::getCdrSerializedSize(type_object->minimal().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyAliasAliasEnum", "MyAliasEnum");

    TypeObjectFactory::GetInstance()->AddTypeObject("MyAliasAliasEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasAliasEnum", false);
}

const TypeObject* GetCompleteMyAliasAliasEnumObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasAliasEnum", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ALIAS);
    type_object->complete().alias_type().alias_flags().IS_FINAL(false);
    type_object->complete().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->complete().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->complete().alias_type().alias_flags().IS_NESTED(false);
    type_object->complete().alias_type().alias_flags().IS_AUTOID_HASH(false);

    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().placement("placement");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().language("language");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().text("text");
    //type_object->complete().alias_type().header().detail().ann_custom().push_back(...);
    type_object->complete().alias_type().header().detail().type_name("MyAliasAliasEnum");

    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->complete().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->complete().alias_type().body().common().related_flags().IS_DEFAULT(false);

    //type_object->complete().alias_type().body().common().ann_builtin()
    //type_object->complete().alias_type().body().common().ann_custom()

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifierTryingComplete("MyAliasEnum");


    if (relatedType != nullptr)
    {
        type_object->complete().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAliasType::getCdrSerializedSize(type_object->complete().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyAliasAliasEnum", "MyAliasEnum");

    TypeObjectFactory::GetInstance()->AddTypeObject("MyAliasAliasEnum", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyAliasAliasEnum", true);
}

const TypeIdentifier* GetEnumStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("EnumStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetEnumStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("EnumStruct", complete);
}

const TypeObject* GetEnumStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("EnumStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteEnumStructObject();
    }
    //else
    return GetMinimalEnumStructObject();
}

const TypeObject* GetMinimalEnumStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("EnumStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_enum;
    mst_my_enum.common().member_id(memberId++);
    mst_my_enum.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_enum.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_enum.common().member_flags().IS_EXTERNAL(false);
    mst_my_enum.common().member_flags().IS_OPTIONAL(false);
    mst_my_enum.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_enum.common().member_flags().IS_KEY(false);
    mst_my_enum.common().member_flags().IS_DEFAULT(false);
    mst_my_enum.common().member_type_id(*GetMyEnumIdentifier(false));
    MD5 my_enum_hash("my_enum");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_enum.detail().name_hash()[i] = my_enum_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_enum);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("EnumStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("EnumStruct", false);
}

const TypeObject* GetCompleteEnumStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("EnumStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_enum;
    cst_my_enum.common().member_id(memberId++);
    cst_my_enum.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_enum.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_enum.common().member_flags().IS_EXTERNAL(false);
    cst_my_enum.common().member_flags().IS_OPTIONAL(false);
    cst_my_enum.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_enum.common().member_flags().IS_KEY(false);
    cst_my_enum.common().member_flags().IS_DEFAULT(false);
    cst_my_enum.common().member_type_id(*GetMyEnumIdentifier(true));
    cst_my_enum.detail().name("my_enum");
    //cst_my_enum.detail().ann_builtin()...
    //cst_my_enum.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_enum);


    // Header
    type_object->complete().struct_type().header().detail().type_name("EnumStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("EnumStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("EnumStruct", true);
}

const TypeIdentifier* GetAliasStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("AliasStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetAliasStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("AliasStruct", complete);
}

const TypeObject* GetAliasStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteAliasStructObject();
    }
    //else
    return GetMinimalAliasStructObject();
}

const TypeObject* GetMinimalAliasStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_alias;
    mst_my_alias.common().member_id(memberId++);
    mst_my_alias.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_alias.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_alias.common().member_flags().IS_EXTERNAL(false);
    mst_my_alias.common().member_flags().IS_OPTIONAL(false);
    mst_my_alias.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_alias.common().member_flags().IS_KEY(false);
    mst_my_alias.common().member_flags().IS_DEFAULT(false);
    mst_my_alias.common().member_type_id(*GetMyAliasEnumIdentifier(false));
    MD5 my_alias_hash("my_alias");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_alias.detail().name_hash()[i] = my_alias_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_alias);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("AliasStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("AliasStruct", false);
}

const TypeObject* GetCompleteAliasStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_alias;
    cst_my_alias.common().member_id(memberId++);
    cst_my_alias.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_alias.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_alias.common().member_flags().IS_EXTERNAL(false);
    cst_my_alias.common().member_flags().IS_OPTIONAL(false);
    cst_my_alias.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_alias.common().member_flags().IS_KEY(false);
    cst_my_alias.common().member_flags().IS_DEFAULT(false);
    cst_my_alias.common().member_type_id(*GetMyAliasEnumIdentifier(true));
    cst_my_alias.detail().name("my_alias");
    //cst_my_alias.detail().ann_builtin()...
    //cst_my_alias.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_alias);


    // Header
    type_object->complete().struct_type().header().detail().type_name("AliasStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("AliasStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("AliasStruct", true);
}

const TypeIdentifier* GetAliasAliasStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("AliasAliasStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetAliasAliasStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("AliasAliasStruct", complete);
}

const TypeObject* GetAliasAliasStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasAliasStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteAliasAliasStructObject();
    }
    //else
    return GetMinimalAliasAliasStructObject();
}

const TypeObject* GetMinimalAliasAliasStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasAliasStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_alias_alias;
    mst_my_alias_alias.common().member_id(memberId++);
    mst_my_alias_alias.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_alias_alias.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_alias_alias.common().member_flags().IS_EXTERNAL(false);
    mst_my_alias_alias.common().member_flags().IS_OPTIONAL(false);
    mst_my_alias_alias.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_alias_alias.common().member_flags().IS_KEY(false);
    mst_my_alias_alias.common().member_flags().IS_DEFAULT(false);
    mst_my_alias_alias.common().member_type_id(*GetMyAliasAliasEnumIdentifier(false));
    MD5 my_alias_alias_hash("my_alias_alias");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_alias_alias.detail().name_hash()[i] = my_alias_alias_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_alias_alias);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("AliasAliasStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("AliasAliasStruct", false);
}

const TypeObject* GetCompleteAliasAliasStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("AliasAliasStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_alias_alias;
    cst_my_alias_alias.common().member_id(memberId++);
    cst_my_alias_alias.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_alias_alias.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_alias_alias.common().member_flags().IS_EXTERNAL(false);
    cst_my_alias_alias.common().member_flags().IS_OPTIONAL(false);
    cst_my_alias_alias.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_alias_alias.common().member_flags().IS_KEY(false);
    cst_my_alias_alias.common().member_flags().IS_DEFAULT(false);
    cst_my_alias_alias.common().member_type_id(*GetMyAliasAliasEnumIdentifier(true));
    cst_my_alias_alias.detail().name("my_alias_alias");
    //cst_my_alias_alias.detail().ann_builtin()...
    //cst_my_alias_alias.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_alias_alias);


    // Header
    type_object->complete().struct_type().header().detail().type_name("AliasAliasStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("AliasAliasStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("AliasAliasStruct", true);
}

const TypeIdentifier* GetBoolStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("BoolStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetBoolStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("BoolStruct", complete);
}

const TypeObject* GetBoolStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("BoolStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteBoolStructObject();
    }
    //else
    return GetMinimalBoolStructObject();
}

const TypeObject* GetMinimalBoolStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("BoolStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_bool;
    mst_my_bool.common().member_id(memberId++);
    mst_my_bool.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_bool.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_bool.common().member_flags().IS_EXTERNAL(false);
    mst_my_bool.common().member_flags().IS_OPTIONAL(false);
    mst_my_bool.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_bool.common().member_flags().IS_KEY(false);
    mst_my_bool.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "bool";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_bool.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_bool_hash("my_bool");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_bool.detail().name_hash()[i] = my_bool_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_bool);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("BoolStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("BoolStruct", false);
}

const TypeObject* GetCompleteBoolStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("BoolStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_bool;
    cst_my_bool.common().member_id(memberId++);
    cst_my_bool.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_bool.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_bool.common().member_flags().IS_EXTERNAL(false);
    cst_my_bool.common().member_flags().IS_OPTIONAL(false);
    cst_my_bool.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_bool.common().member_flags().IS_KEY(false);
    cst_my_bool.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "bool";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_bool.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_bool.detail().name("my_bool");
    //cst_my_bool.detail().ann_builtin()...
    //cst_my_bool.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_bool);


    // Header
    type_object->complete().struct_type().header().detail().type_name("BoolStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("BoolStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("BoolStruct", true);
}

const TypeIdentifier* GetOctetStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("OctetStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetOctetStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("OctetStruct", complete);
}

const TypeObject* GetOctetStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("OctetStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteOctetStructObject();
    }
    //else
    return GetMinimalOctetStructObject();
}

const TypeObject* GetMinimalOctetStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("OctetStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_octet;
    mst_my_octet.common().member_id(memberId++);
    mst_my_octet.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_octet.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_octet.common().member_flags().IS_EXTERNAL(false);
    mst_my_octet.common().member_flags().IS_OPTIONAL(false);
    mst_my_octet.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_octet.common().member_flags().IS_KEY(false);
    mst_my_octet.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint8_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_octet.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_octet_hash("my_octet");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_octet.detail().name_hash()[i] = my_octet_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_octet);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("OctetStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("OctetStruct", false);
}

const TypeObject* GetCompleteOctetStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("OctetStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_octet;
    cst_my_octet.common().member_id(memberId++);
    cst_my_octet.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_octet.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_octet.common().member_flags().IS_EXTERNAL(false);
    cst_my_octet.common().member_flags().IS_OPTIONAL(false);
    cst_my_octet.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_octet.common().member_flags().IS_KEY(false);
    cst_my_octet.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint8_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_octet.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_octet.detail().name("my_octet");
    //cst_my_octet.detail().ann_builtin()...
    //cst_my_octet.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_octet);


    // Header
    type_object->complete().struct_type().header().detail().type_name("OctetStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("OctetStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("OctetStruct", true);
}

const TypeIdentifier* GetShortStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("ShortStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetShortStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("ShortStruct", complete);
}

const TypeObject* GetShortStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ShortStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteShortStructObject();
    }
    //else
    return GetMinimalShortStructObject();
}

const TypeObject* GetMinimalShortStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ShortStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_int16;
    mst_my_int16.common().member_id(memberId++);
    mst_my_int16.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_int16.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_int16.common().member_flags().IS_EXTERNAL(false);
    mst_my_int16.common().member_flags().IS_OPTIONAL(false);
    mst_my_int16.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_int16.common().member_flags().IS_KEY(false);
    mst_my_int16.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int16_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_int16.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_int16_hash("my_int16");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_int16.detail().name_hash()[i] = my_int16_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_int16);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ShortStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ShortStruct", false);
}

const TypeObject* GetCompleteShortStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ShortStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_int16;
    cst_my_int16.common().member_id(memberId++);
    cst_my_int16.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_int16.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_int16.common().member_flags().IS_EXTERNAL(false);
    cst_my_int16.common().member_flags().IS_OPTIONAL(false);
    cst_my_int16.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_int16.common().member_flags().IS_KEY(false);
    cst_my_int16.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int16_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_int16.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_int16.detail().name("my_int16");
    //cst_my_int16.detail().ann_builtin()...
    //cst_my_int16.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_int16);


    // Header
    type_object->complete().struct_type().header().detail().type_name("ShortStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ShortStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ShortStruct", true);
}

const TypeIdentifier* GetLongStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetLongStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongStruct", complete);
}

const TypeObject* GetLongStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteLongStructObject();
    }
    //else
    return GetMinimalLongStructObject();
}

const TypeObject* GetMinimalLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_int32;
    mst_my_int32.common().member_id(memberId++);
    mst_my_int32.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_int32.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_int32.common().member_flags().IS_EXTERNAL(false);
    mst_my_int32.common().member_flags().IS_OPTIONAL(false);
    mst_my_int32.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_int32.common().member_flags().IS_KEY(false);
    mst_my_int32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_int32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_int32_hash("my_int32");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_int32.detail().name_hash()[i] = my_int32_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_int32);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongStruct", false);
}

const TypeObject* GetCompleteLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_int32;
    cst_my_int32.common().member_id(memberId++);
    cst_my_int32.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_int32.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_int32.common().member_flags().IS_EXTERNAL(false);
    cst_my_int32.common().member_flags().IS_OPTIONAL(false);
    cst_my_int32.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_int32.common().member_flags().IS_KEY(false);
    cst_my_int32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_int32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_int32.detail().name("my_int32");
    //cst_my_int32.detail().ann_builtin()...
    //cst_my_int32.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_int32);


    // Header
    type_object->complete().struct_type().header().detail().type_name("LongStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongStruct", true);
}

const TypeIdentifier* GetLongLongStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongLongStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetLongLongStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongLongStruct", complete);
}

const TypeObject* GetLongLongStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongLongStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteLongLongStructObject();
    }
    //else
    return GetMinimalLongLongStructObject();
}

const TypeObject* GetMinimalLongLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongLongStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_int64;
    mst_my_int64.common().member_id(memberId++);
    mst_my_int64.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_int64.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_int64.common().member_flags().IS_EXTERNAL(false);
    mst_my_int64.common().member_flags().IS_OPTIONAL(false);
    mst_my_int64.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_int64.common().member_flags().IS_KEY(false);
    mst_my_int64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_int64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_int64_hash("my_int64");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_int64.detail().name_hash()[i] = my_int64_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_int64);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongLongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongLongStruct", false);
}

const TypeObject* GetCompleteLongLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongLongStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_int64;
    cst_my_int64.common().member_id(memberId++);
    cst_my_int64.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_int64.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_int64.common().member_flags().IS_EXTERNAL(false);
    cst_my_int64.common().member_flags().IS_OPTIONAL(false);
    cst_my_int64.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_int64.common().member_flags().IS_KEY(false);
    cst_my_int64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_int64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_int64.detail().name("my_int64");
    //cst_my_int64.detail().ann_builtin()...
    //cst_my_int64.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_int64);


    // Header
    type_object->complete().struct_type().header().detail().type_name("LongLongStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongLongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongLongStruct", true);
}

const TypeIdentifier* GetUShortStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("UShortStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetUShortStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("UShortStruct", complete);
}

const TypeObject* GetUShortStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UShortStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteUShortStructObject();
    }
    //else
    return GetMinimalUShortStructObject();
}

const TypeObject* GetMinimalUShortStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UShortStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_uint16;
    mst_my_uint16.common().member_id(memberId++);
    mst_my_uint16.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_uint16.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_uint16.common().member_flags().IS_EXTERNAL(false);
    mst_my_uint16.common().member_flags().IS_OPTIONAL(false);
    mst_my_uint16.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_uint16.common().member_flags().IS_KEY(false);
    mst_my_uint16.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint16_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_uint16.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_uint16_hash("my_uint16");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_uint16.detail().name_hash()[i] = my_uint16_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_uint16);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UShortStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UShortStruct", false);
}

const TypeObject* GetCompleteUShortStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UShortStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_uint16;
    cst_my_uint16.common().member_id(memberId++);
    cst_my_uint16.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_uint16.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_uint16.common().member_flags().IS_EXTERNAL(false);
    cst_my_uint16.common().member_flags().IS_OPTIONAL(false);
    cst_my_uint16.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_uint16.common().member_flags().IS_KEY(false);
    cst_my_uint16.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint16_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_uint16.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_uint16.detail().name("my_uint16");
    //cst_my_uint16.detail().ann_builtin()...
    //cst_my_uint16.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_uint16);


    // Header
    type_object->complete().struct_type().header().detail().type_name("UShortStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UShortStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UShortStruct", true);
}

const TypeIdentifier* GetULongStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("ULongStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetULongStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("ULongStruct", complete);
}

const TypeObject* GetULongStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteULongStructObject();
    }
    //else
    return GetMinimalULongStructObject();
}

const TypeObject* GetMinimalULongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_uint32;
    mst_my_uint32.common().member_id(memberId++);
    mst_my_uint32.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_uint32.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_uint32.common().member_flags().IS_EXTERNAL(false);
    mst_my_uint32.common().member_flags().IS_OPTIONAL(false);
    mst_my_uint32.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_uint32.common().member_flags().IS_KEY(false);
    mst_my_uint32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_uint32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_uint32_hash("my_uint32");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_uint32.detail().name_hash()[i] = my_uint32_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_uint32);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ULongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ULongStruct", false);
}

const TypeObject* GetCompleteULongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_uint32;
    cst_my_uint32.common().member_id(memberId++);
    cst_my_uint32.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_uint32.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_uint32.common().member_flags().IS_EXTERNAL(false);
    cst_my_uint32.common().member_flags().IS_OPTIONAL(false);
    cst_my_uint32.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_uint32.common().member_flags().IS_KEY(false);
    cst_my_uint32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_uint32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_uint32.detail().name("my_uint32");
    //cst_my_uint32.detail().ann_builtin()...
    //cst_my_uint32.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_uint32);


    // Header
    type_object->complete().struct_type().header().detail().type_name("ULongStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ULongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ULongStruct", true);
}

const TypeIdentifier* GetULongLongStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("ULongLongStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetULongLongStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("ULongLongStruct", complete);
}

const TypeObject* GetULongLongStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongLongStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteULongLongStructObject();
    }
    //else
    return GetMinimalULongLongStructObject();
}

const TypeObject* GetMinimalULongLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongLongStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_uint64;
    mst_my_uint64.common().member_id(memberId++);
    mst_my_uint64.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_uint64.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_uint64.common().member_flags().IS_EXTERNAL(false);
    mst_my_uint64.common().member_flags().IS_OPTIONAL(false);
    mst_my_uint64.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_uint64.common().member_flags().IS_KEY(false);
    mst_my_uint64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_uint64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_uint64_hash("my_uint64");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_uint64.detail().name_hash()[i] = my_uint64_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_uint64);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ULongLongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ULongLongStruct", false);
}

const TypeObject* GetCompleteULongLongStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ULongLongStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_uint64;
    cst_my_uint64.common().member_id(memberId++);
    cst_my_uint64.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_uint64.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_uint64.common().member_flags().IS_EXTERNAL(false);
    cst_my_uint64.common().member_flags().IS_OPTIONAL(false);
    cst_my_uint64.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_uint64.common().member_flags().IS_KEY(false);
    cst_my_uint64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "uint64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_uint64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_uint64.detail().name("my_uint64");
    //cst_my_uint64.detail().ann_builtin()...
    //cst_my_uint64.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_uint64);


    // Header
    type_object->complete().struct_type().header().detail().type_name("ULongLongStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ULongLongStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ULongLongStruct", true);
}

const TypeIdentifier* GetFloatStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("FloatStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetFloatStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("FloatStruct", complete);
}

const TypeObject* GetFloatStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("FloatStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteFloatStructObject();
    }
    //else
    return GetMinimalFloatStructObject();
}

const TypeObject* GetMinimalFloatStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("FloatStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_float32;
    mst_my_float32.common().member_id(memberId++);
    mst_my_float32.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_float32.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_float32.common().member_flags().IS_EXTERNAL(false);
    mst_my_float32.common().member_flags().IS_OPTIONAL(false);
    mst_my_float32.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_float32.common().member_flags().IS_KEY(false);
    mst_my_float32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "float";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_float32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_float32_hash("my_float32");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_float32.detail().name_hash()[i] = my_float32_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_float32);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("FloatStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("FloatStruct", false);
}

const TypeObject* GetCompleteFloatStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("FloatStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_float32;
    cst_my_float32.common().member_id(memberId++);
    cst_my_float32.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_float32.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_float32.common().member_flags().IS_EXTERNAL(false);
    cst_my_float32.common().member_flags().IS_OPTIONAL(false);
    cst_my_float32.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_float32.common().member_flags().IS_KEY(false);
    cst_my_float32.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "float";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_float32.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_float32.detail().name("my_float32");
    //cst_my_float32.detail().ann_builtin()...
    //cst_my_float32.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_float32);


    // Header
    type_object->complete().struct_type().header().detail().type_name("FloatStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("FloatStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("FloatStruct", true);
}

const TypeIdentifier* GetDoubleStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("DoubleStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetDoubleStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("DoubleStruct", complete);
}

const TypeObject* GetDoubleStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("DoubleStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteDoubleStructObject();
    }
    //else
    return GetMinimalDoubleStructObject();
}

const TypeObject* GetMinimalDoubleStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("DoubleStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_float64;
    mst_my_float64.common().member_id(memberId++);
    mst_my_float64.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_float64.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_float64.common().member_flags().IS_EXTERNAL(false);
    mst_my_float64.common().member_flags().IS_OPTIONAL(false);
    mst_my_float64.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_float64.common().member_flags().IS_KEY(false);
    mst_my_float64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "double";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_float64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_float64_hash("my_float64");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_float64.detail().name_hash()[i] = my_float64_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_float64);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("DoubleStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("DoubleStruct", false);
}

const TypeObject* GetCompleteDoubleStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("DoubleStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_float64;
    cst_my_float64.common().member_id(memberId++);
    cst_my_float64.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_float64.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_float64.common().member_flags().IS_EXTERNAL(false);
    cst_my_float64.common().member_flags().IS_OPTIONAL(false);
    cst_my_float64.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_float64.common().member_flags().IS_KEY(false);
    cst_my_float64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "double";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_float64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_float64.detail().name("my_float64");
    //cst_my_float64.detail().ann_builtin()...
    //cst_my_float64.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_float64);


    // Header
    type_object->complete().struct_type().header().detail().type_name("DoubleStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("DoubleStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("DoubleStruct", true);
}

const TypeIdentifier* GetLongDoubleStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongDoubleStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetLongDoubleStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("LongDoubleStruct", complete);
}

const TypeObject* GetLongDoubleStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongDoubleStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteLongDoubleStructObject();
    }
    //else
    return GetMinimalLongDoubleStructObject();
}

const TypeObject* GetMinimalLongDoubleStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongDoubleStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_float128;
    mst_my_float128.common().member_id(memberId++);
    mst_my_float128.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_float128.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_float128.common().member_flags().IS_EXTERNAL(false);
    mst_my_float128.common().member_flags().IS_OPTIONAL(false);
    mst_my_float128.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_float128.common().member_flags().IS_KEY(false);
    mst_my_float128.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "long double";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_float128.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_float128_hash("my_float128");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_float128.detail().name_hash()[i] = my_float128_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_float128);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongDoubleStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongDoubleStruct", false);
}

const TypeObject* GetCompleteLongDoubleStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LongDoubleStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_float128;
    cst_my_float128.common().member_id(memberId++);
    cst_my_float128.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_float128.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_float128.common().member_flags().IS_EXTERNAL(false);
    cst_my_float128.common().member_flags().IS_OPTIONAL(false);
    cst_my_float128.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_float128.common().member_flags().IS_KEY(false);
    cst_my_float128.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "long double";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_float128.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_float128.detail().name("my_float128");
    //cst_my_float128.detail().ann_builtin()...
    //cst_my_float128.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_float128);


    // Header
    type_object->complete().struct_type().header().detail().type_name("LongDoubleStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LongDoubleStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LongDoubleStruct", true);
}

const TypeIdentifier* GetCharStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("CharStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetCharStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("CharStruct", complete);
}

const TypeObject* GetCharStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("CharStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteCharStructObject();
    }
    //else
    return GetMinimalCharStructObject();
}

const TypeObject* GetMinimalCharStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("CharStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_char;
    mst_my_char.common().member_id(memberId++);
    mst_my_char.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_char.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_char.common().member_flags().IS_EXTERNAL(false);
    mst_my_char.common().member_flags().IS_OPTIONAL(false);
    mst_my_char.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_char.common().member_flags().IS_KEY(false);
    mst_my_char.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "char";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_char.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_char_hash("my_char");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_char.detail().name_hash()[i] = my_char_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_char);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("CharStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("CharStruct", false);
}

const TypeObject* GetCompleteCharStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("CharStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_char;
    cst_my_char.common().member_id(memberId++);
    cst_my_char.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_char.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_char.common().member_flags().IS_EXTERNAL(false);
    cst_my_char.common().member_flags().IS_OPTIONAL(false);
    cst_my_char.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_char.common().member_flags().IS_KEY(false);
    cst_my_char.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "char";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_char.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_char.detail().name("my_char");
    //cst_my_char.detail().ann_builtin()...
    //cst_my_char.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_char);


    // Header
    type_object->complete().struct_type().header().detail().type_name("CharStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("CharStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("CharStruct", true);
}

const TypeIdentifier* GetWCharStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetWCharStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharStruct", complete);
}

const TypeObject* GetWCharStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteWCharStructObject();
    }
    //else
    return GetMinimalWCharStructObject();
}

const TypeObject* GetMinimalWCharStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_wchar;
    mst_my_wchar.common().member_id(memberId++);
    mst_my_wchar.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_wchar.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_wchar.common().member_flags().IS_EXTERNAL(false);
    mst_my_wchar.common().member_flags().IS_OPTIONAL(false);
    mst_my_wchar.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_wchar.common().member_flags().IS_KEY(false);
    mst_my_wchar.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "wchar_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_my_wchar.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 my_wchar_hash("my_wchar");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_wchar.detail().name_hash()[i] = my_wchar_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_wchar);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharStruct", false);
}

const TypeObject* GetCompleteWCharStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_wchar;
    cst_my_wchar.common().member_id(memberId++);
    cst_my_wchar.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_wchar.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_wchar.common().member_flags().IS_EXTERNAL(false);
    cst_my_wchar.common().member_flags().IS_OPTIONAL(false);
    cst_my_wchar.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_wchar.common().member_flags().IS_KEY(false);
    cst_my_wchar.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "wchar_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_my_wchar.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_my_wchar.detail().name("my_wchar");
    //cst_my_wchar.detail().ann_builtin()...
    //cst_my_wchar.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_wchar);


    // Header
    type_object->complete().struct_type().header().detail().type_name("WCharStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharStruct", true);
}

const TypeIdentifier* GetStringStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("StringStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetStringStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("StringStruct", complete);
}

const TypeObject* GetStringStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StringStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteStringStructObject();
    }
    //else
    return GetMinimalStringStructObject();
}

const TypeObject* GetMinimalStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StringStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_string;
    mst_my_string.common().member_id(memberId++);
    mst_my_string.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_string.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_string.common().member_flags().IS_EXTERNAL(false);
    mst_my_string.common().member_flags().IS_OPTIONAL(false);
    mst_my_string.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_string.common().member_flags().IS_KEY(false);
    mst_my_string.common().member_flags().IS_DEFAULT(false);
    mst_my_string.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(255, false));


    MD5 my_string_hash("my_string");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_string.detail().name_hash()[i] = my_string_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_string);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StringStruct", false);
}

const TypeObject* GetCompleteStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StringStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_string;
    cst_my_string.common().member_id(memberId++);
    cst_my_string.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_string.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_string.common().member_flags().IS_EXTERNAL(false);
    cst_my_string.common().member_flags().IS_OPTIONAL(false);
    cst_my_string.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_string.common().member_flags().IS_KEY(false);
    cst_my_string.common().member_flags().IS_DEFAULT(false);
    cst_my_string.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(255, false));


    cst_my_string.detail().name("my_string");
    //cst_my_string.detail().ann_builtin()...
    //cst_my_string.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_string);


    // Header
    type_object->complete().struct_type().header().detail().type_name("StringStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StringStruct", true);
}

const TypeIdentifier* GetWStringStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("WStringStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetWStringStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("WStringStruct", complete);
}

const TypeObject* GetWStringStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WStringStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteWStringStructObject();
    }
    //else
    return GetMinimalWStringStructObject();
}

const TypeObject* GetMinimalWStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WStringStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_wstring;
    mst_my_wstring.common().member_id(memberId++);
    mst_my_wstring.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_wstring.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_wstring.common().member_flags().IS_EXTERNAL(false);
    mst_my_wstring.common().member_flags().IS_OPTIONAL(false);
    mst_my_wstring.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_wstring.common().member_flags().IS_KEY(false);
    mst_my_wstring.common().member_flags().IS_DEFAULT(false);
    mst_my_wstring.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(255, true));


    MD5 my_wstring_hash("my_wstring");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_wstring.detail().name_hash()[i] = my_wstring_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_wstring);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WStringStruct", false);
}

const TypeObject* GetCompleteWStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WStringStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_wstring;
    cst_my_wstring.common().member_id(memberId++);
    cst_my_wstring.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_wstring.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_wstring.common().member_flags().IS_EXTERNAL(false);
    cst_my_wstring.common().member_flags().IS_OPTIONAL(false);
    cst_my_wstring.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_wstring.common().member_flags().IS_KEY(false);
    cst_my_wstring.common().member_flags().IS_DEFAULT(false);
    cst_my_wstring.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(255, true));


    cst_my_wstring.detail().name("my_wstring");
    //cst_my_wstring.detail().ann_builtin()...
    //cst_my_wstring.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_wstring);


    // Header
    type_object->complete().struct_type().header().detail().type_name("WStringStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WStringStruct", true);
}

const TypeIdentifier* GetLargeStringStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("LargeStringStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetLargeStringStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("LargeStringStruct", complete);
}

const TypeObject* GetLargeStringStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeStringStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteLargeStringStructObject();
    }
    //else
    return GetMinimalLargeStringStructObject();
}

const TypeObject* GetMinimalLargeStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeStringStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_large_string;
    mst_my_large_string.common().member_id(memberId++);
    mst_my_large_string.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_large_string.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_large_string.common().member_flags().IS_EXTERNAL(false);
    mst_my_large_string.common().member_flags().IS_OPTIONAL(false);
    mst_my_large_string.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_large_string.common().member_flags().IS_KEY(false);
    mst_my_large_string.common().member_flags().IS_DEFAULT(false);
    mst_my_large_string.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(41925, false));


    MD5 my_large_string_hash("my_large_string");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_large_string.detail().name_hash()[i] = my_large_string_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_large_string);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LargeStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LargeStringStruct", false);
}

const TypeObject* GetCompleteLargeStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeStringStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_large_string;
    cst_my_large_string.common().member_id(memberId++);
    cst_my_large_string.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_large_string.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_large_string.common().member_flags().IS_EXTERNAL(false);
    cst_my_large_string.common().member_flags().IS_OPTIONAL(false);
    cst_my_large_string.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_large_string.common().member_flags().IS_KEY(false);
    cst_my_large_string.common().member_flags().IS_DEFAULT(false);
    cst_my_large_string.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(41925, false));


    cst_my_large_string.detail().name("my_large_string");
    //cst_my_large_string.detail().ann_builtin()...
    //cst_my_large_string.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_large_string);


    // Header
    type_object->complete().struct_type().header().detail().type_name("LargeStringStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LargeStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LargeStringStruct", true);
}

const TypeIdentifier* GetLargeWStringStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("LargeWStringStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetLargeWStringStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("LargeWStringStruct", complete);
}

const TypeObject* GetLargeWStringStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeWStringStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteLargeWStringStructObject();
    }
    //else
    return GetMinimalLargeWStringStructObject();
}

const TypeObject* GetMinimalLargeWStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeWStringStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_large_wstring;
    mst_my_large_wstring.common().member_id(memberId++);
    mst_my_large_wstring.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_large_wstring.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_large_wstring.common().member_flags().IS_EXTERNAL(false);
    mst_my_large_wstring.common().member_flags().IS_OPTIONAL(false);
    mst_my_large_wstring.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_large_wstring.common().member_flags().IS_KEY(false);
    mst_my_large_wstring.common().member_flags().IS_DEFAULT(false);
    mst_my_large_wstring.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(41925, true));


    MD5 my_large_wstring_hash("my_large_wstring");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_large_wstring.detail().name_hash()[i] = my_large_wstring_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_large_wstring);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LargeWStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LargeWStringStruct", false);
}

const TypeObject* GetCompleteLargeWStringStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("LargeWStringStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_large_wstring;
    cst_my_large_wstring.common().member_id(memberId++);
    cst_my_large_wstring.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_large_wstring.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_large_wstring.common().member_flags().IS_EXTERNAL(false);
    cst_my_large_wstring.common().member_flags().IS_OPTIONAL(false);
    cst_my_large_wstring.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_large_wstring.common().member_flags().IS_KEY(false);
    cst_my_large_wstring.common().member_flags().IS_DEFAULT(false);
    cst_my_large_wstring.common().member_type_id(*TypeObjectFactory::GetInstance()->GetStringIdentifier(41925, true));


    cst_my_large_wstring.detail().name("my_large_wstring");
    //cst_my_large_wstring.detail().ann_builtin()...
    //cst_my_large_wstring.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_large_wstring);


    // Header
    type_object->complete().struct_type().header().detail().type_name("LargeWStringStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("LargeWStringStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("LargeWStringStruct", true);
}

const TypeIdentifier* GetArraytStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("ArraytStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetArraytStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("ArraytStruct", complete);
}

const TypeObject* GetArraytStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArraytStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteArraytStructObject();
    }
    //else
    return GetMinimalArraytStructObject();
}

const TypeObject* GetMinimalArraytStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArraytStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_array;
    mst_my_array.common().member_id(memberId++);
    mst_my_array.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_array.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_array.common().member_flags().IS_EXTERNAL(false);
    mst_my_array.common().member_flags().IS_OPTIONAL(false);
    mst_my_array.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_array.common().member_flags().IS_KEY(false);
    mst_my_array.common().member_flags().IS_DEFAULT(false);
    mst_my_array.common().member_type_id(*TypeObjectFactory::GetInstance()->GetArrayIdentifier("int32_t", {2, 2, 2}, false));


    MD5 my_array_hash("my_array");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_array.detail().name_hash()[i] = my_array_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_array);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ArraytStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ArraytStruct", false);
}

const TypeObject* GetCompleteArraytStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArraytStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_array;
    cst_my_array.common().member_id(memberId++);
    cst_my_array.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_array.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_array.common().member_flags().IS_EXTERNAL(false);
    cst_my_array.common().member_flags().IS_OPTIONAL(false);
    cst_my_array.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_array.common().member_flags().IS_KEY(false);
    cst_my_array.common().member_flags().IS_DEFAULT(false);
    cst_my_array.common().member_type_id(*TypeObjectFactory::GetInstance()->GetArrayIdentifier("int32_t", {2, 2, 2}, true));


    cst_my_array.detail().name("my_array");
    //cst_my_array.detail().ann_builtin()...
    //cst_my_array.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_array);


    // Header
    type_object->complete().struct_type().header().detail().type_name("ArraytStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ArraytStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ArraytStruct", true);
}

const TypeIdentifier* GetMyArrayIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyArray", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMyArrayObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MyArray", complete);
}

const TypeObject* GetMyArrayObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyArray", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMyArrayObject();
    }
    else
    {
        return GetMinimalMyArrayObject();
    }
}

const TypeObject* GetMinimalMyArrayObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyArray", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ALIAS);
    type_object->minimal().alias_type().alias_flags().IS_FINAL(false);
    type_object->minimal().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->minimal().alias_type().alias_flags().IS_NESTED(false);
    type_object->minimal().alias_type().alias_flags().IS_AUTOID_HASH(false);

    // type_object->minimal().alias_type().header()... Is empty

    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->minimal().alias_type().body().common().related_flags().IS_DEFAULT(false);

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifier(TypeNamesGenerator::getArrayTypeName("int32_t", {2, 2}), false);


    if (relatedType != nullptr)
    {
        type_object->minimal().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAliasType::getCdrSerializedSize(type_object->minimal().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyArray", TypeNamesGenerator::getArrayTypeName("int32_t", {2, 2}));

    TypeObjectFactory::GetInstance()->AddTypeObject("MyArray", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyArray", false);
}

const TypeObject* GetCompleteMyArrayObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MyArray", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ALIAS);
    type_object->complete().alias_type().alias_flags().IS_FINAL(false);
    type_object->complete().alias_type().alias_flags().IS_APPENDABLE(false);
    type_object->complete().alias_type().alias_flags().IS_MUTABLE(false);
    type_object->complete().alias_type().alias_flags().IS_NESTED(false);
    type_object->complete().alias_type().alias_flags().IS_AUTOID_HASH(false);

    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().placement("placement");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().language("language");
    //type_object->complete().alias_type().header().detail().ann_builtin().verbatim().text("text");
    //type_object->complete().alias_type().header().detail().ann_custom().push_back(...);
    type_object->complete().alias_type().header().detail().type_name("MyArray");

    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT1(false);
    type_object->complete().alias_type().body().common().related_flags().TRY_CONSTRUCT2(false);
    type_object->complete().alias_type().body().common().related_flags().IS_EXTERNAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_OPTIONAL(false);
    type_object->complete().alias_type().body().common().related_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().alias_type().body().common().related_flags().IS_KEY(false);
    type_object->complete().alias_type().body().common().related_flags().IS_DEFAULT(false);

    //type_object->complete().alias_type().body().common().ann_builtin()
    //type_object->complete().alias_type().body().common().ann_custom()

    // Must be defined already, if don't, may be an recursive alias
    const TypeIdentifier *relatedType = TypeObjectFactory::GetInstance()->GetTypeIdentifierTryingComplete(TypeNamesGenerator::getArrayTypeName("int32_t", {2, 2}));


    if (relatedType != nullptr)
    {
        type_object->complete().alias_type().body().common().related_type() = *relatedType; // Make a copy
    }
    else
    {
        // Cannot determine base type
        delete type_object;
        return nullptr;
    }

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAliasType::getCdrSerializedSize(type_object->complete().alias_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    // Don't add our TypeIdentifier but our alias
    TypeObjectFactory::GetInstance()->AddAlias("MyArray", TypeNamesGenerator::getArrayTypeName("int32_t", {2, 2}));

    TypeObjectFactory::GetInstance()->AddTypeObject("MyArray", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MyArray", true);
}

const TypeIdentifier* GetArrayArrayStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("ArrayArrayStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetArrayArrayStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("ArrayArrayStruct", complete);
}

const TypeObject* GetArrayArrayStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArrayArrayStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteArrayArrayStructObject();
    }
    //else
    return GetMinimalArrayArrayStructObject();
}

const TypeObject* GetMinimalArrayArrayStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArrayArrayStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_array_array;
    mst_my_array_array.common().member_id(memberId++);
    mst_my_array_array.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_array_array.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_array_array.common().member_flags().IS_EXTERNAL(false);
    mst_my_array_array.common().member_flags().IS_OPTIONAL(false);
    mst_my_array_array.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_array_array.common().member_flags().IS_KEY(false);
    mst_my_array_array.common().member_flags().IS_DEFAULT(false);
    mst_my_array_array.common().member_type_id(*TypeObjectFactory::GetInstance()->GetArrayIdentifier("MyArray", {2, 2}, false));


    MD5 my_array_array_hash("my_array_array");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_array_array.detail().name_hash()[i] = my_array_array_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_array_array);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ArrayArrayStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ArrayArrayStruct", false);
}

const TypeObject* GetCompleteArrayArrayStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("ArrayArrayStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_array_array;
    cst_my_array_array.common().member_id(memberId++);
    cst_my_array_array.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_array_array.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_array_array.common().member_flags().IS_EXTERNAL(false);
    cst_my_array_array.common().member_flags().IS_OPTIONAL(false);
    cst_my_array_array.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_array_array.common().member_flags().IS_KEY(false);
    cst_my_array_array.common().member_flags().IS_DEFAULT(false);
    cst_my_array_array.common().member_type_id(*TypeObjectFactory::GetInstance()->GetArrayIdentifier("MyArray", {2, 2}, true));


    cst_my_array_array.detail().name("my_array_array");
    //cst_my_array_array.detail().ann_builtin()...
    //cst_my_array_array.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_array_array);


    // Header
    type_object->complete().struct_type().header().detail().type_name("ArrayArrayStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("ArrayArrayStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("ArrayArrayStruct", true);
}

const TypeIdentifier* GetSequenceStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("SequenceStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetSequenceStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("SequenceStruct", complete);
}

const TypeObject* GetSequenceStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteSequenceStructObject();
    }
    //else
    return GetMinimalSequenceStructObject();
}

const TypeObject* GetMinimalSequenceStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_sequence;
    mst_my_sequence.common().member_id(memberId++);
    mst_my_sequence.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_sequence.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_sequence.common().member_flags().IS_EXTERNAL(false);
    mst_my_sequence.common().member_flags().IS_OPTIONAL(false);
    mst_my_sequence.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_sequence.common().member_flags().IS_KEY(false);
    mst_my_sequence.common().member_flags().IS_DEFAULT(false);
    mst_my_sequence.common().member_type_id(*TypeObjectFactory::GetInstance()->GetSequenceIdentifier("int32_t", 2, false));


    MD5 my_sequence_hash("my_sequence");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_sequence.detail().name_hash()[i] = my_sequence_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_sequence);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SequenceStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SequenceStruct", false);
}

const TypeObject* GetCompleteSequenceStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_sequence;
    cst_my_sequence.common().member_id(memberId++);
    cst_my_sequence.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_sequence.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_sequence.common().member_flags().IS_EXTERNAL(false);
    cst_my_sequence.common().member_flags().IS_OPTIONAL(false);
    cst_my_sequence.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_sequence.common().member_flags().IS_KEY(false);
    cst_my_sequence.common().member_flags().IS_DEFAULT(false);
    cst_my_sequence.common().member_type_id(*TypeObjectFactory::GetInstance()->GetSequenceIdentifier("int32_t", 2, true));


    cst_my_sequence.detail().name("my_sequence");
    //cst_my_sequence.detail().ann_builtin()...
    //cst_my_sequence.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_sequence);


    // Header
    type_object->complete().struct_type().header().detail().type_name("SequenceStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SequenceStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SequenceStruct", true);
}

const TypeIdentifier* GetSequenceSequenceStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("SequenceSequenceStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetSequenceSequenceStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("SequenceSequenceStruct", complete);
}

const TypeObject* GetSequenceSequenceStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceSequenceStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteSequenceSequenceStructObject();
    }
    //else
    return GetMinimalSequenceSequenceStructObject();
}

const TypeObject* GetMinimalSequenceSequenceStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceSequenceStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_sequence_sequence;
    mst_my_sequence_sequence.common().member_id(memberId++);
    mst_my_sequence_sequence.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_sequence_sequence.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_sequence_sequence.common().member_flags().IS_EXTERNAL(false);
    mst_my_sequence_sequence.common().member_flags().IS_OPTIONAL(false);
    mst_my_sequence_sequence.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_sequence_sequence.common().member_flags().IS_KEY(false);
    mst_my_sequence_sequence.common().member_flags().IS_DEFAULT(false);
    mst_my_sequence_sequence.common().member_type_id(*TypeObjectFactory::GetInstance()->GetSequenceIdentifier(TypeNamesGenerator::getSequenceTypeName("int32_t", 2), 3, false));


    MD5 my_sequence_sequence_hash("my_sequence_sequence");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_sequence_sequence.detail().name_hash()[i] = my_sequence_sequence_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_sequence_sequence);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SequenceSequenceStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SequenceSequenceStruct", false);
}

const TypeObject* GetCompleteSequenceSequenceStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SequenceSequenceStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_sequence_sequence;
    cst_my_sequence_sequence.common().member_id(memberId++);
    cst_my_sequence_sequence.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_sequence_sequence.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_sequence_sequence.common().member_flags().IS_EXTERNAL(false);
    cst_my_sequence_sequence.common().member_flags().IS_OPTIONAL(false);
    cst_my_sequence_sequence.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_sequence_sequence.common().member_flags().IS_KEY(false);
    cst_my_sequence_sequence.common().member_flags().IS_DEFAULT(false);
    cst_my_sequence_sequence.common().member_type_id(*TypeObjectFactory::GetInstance()->GetSequenceIdentifier(TypeNamesGenerator::getSequenceTypeName("int32_t", 2), 3, true));


    cst_my_sequence_sequence.detail().name("my_sequence_sequence");
    //cst_my_sequence_sequence.detail().ann_builtin()...
    //cst_my_sequence_sequence.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_sequence_sequence);


    // Header
    type_object->complete().struct_type().header().detail().type_name("SequenceSequenceStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SequenceSequenceStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SequenceSequenceStruct", true);
}

const TypeIdentifier* GetMapStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MapStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMapStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MapStruct", complete);
}

const TypeObject* GetMapStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMapStructObject();
    }
    //else
    return GetMinimalMapStructObject();
}

const TypeObject* GetMinimalMapStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_map;
    mst_my_map.common().member_id(memberId++);
    mst_my_map.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_map.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_map.common().member_flags().IS_EXTERNAL(false);
    mst_my_map.common().member_flags().IS_OPTIONAL(false);
    mst_my_map.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_map.common().member_flags().IS_KEY(false);
    mst_my_map.common().member_flags().IS_DEFAULT(false);
    mst_my_map.common().member_type_id(*TypeObjectFactory::GetInstance()->GetMapIdentifier("int32_t", "int32_t", 2, false));


    MD5 my_map_hash("my_map");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_map.detail().name_hash()[i] = my_map_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_map);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MapStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MapStruct", false);
}

const TypeObject* GetCompleteMapStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_map;
    cst_my_map.common().member_id(memberId++);
    cst_my_map.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_map.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_map.common().member_flags().IS_EXTERNAL(false);
    cst_my_map.common().member_flags().IS_OPTIONAL(false);
    cst_my_map.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_map.common().member_flags().IS_KEY(false);
    cst_my_map.common().member_flags().IS_DEFAULT(false);
    cst_my_map.common().member_type_id(*TypeObjectFactory::GetInstance()->GetMapIdentifier("int32_t", "int32_t", 2, true));


    cst_my_map.detail().name("my_map");
    //cst_my_map.detail().ann_builtin()...
    //cst_my_map.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_map);


    // Header
    type_object->complete().struct_type().header().detail().type_name("MapStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MapStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MapStruct", true);
}

const TypeIdentifier* GetMapMapStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("MapMapStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetMapMapStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("MapMapStruct", complete);
}

const TypeObject* GetMapMapStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapMapStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteMapMapStructObject();
    }
    //else
    return GetMinimalMapMapStructObject();
}

const TypeObject* GetMinimalMapMapStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapMapStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_map_map;
    mst_my_map_map.common().member_id(memberId++);
    mst_my_map_map.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_map_map.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_map_map.common().member_flags().IS_EXTERNAL(false);
    mst_my_map_map.common().member_flags().IS_OPTIONAL(false);
    mst_my_map_map.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_map_map.common().member_flags().IS_KEY(false);
    mst_my_map_map.common().member_flags().IS_DEFAULT(false);
    mst_my_map_map.common().member_type_id(*TypeObjectFactory::GetInstance()->GetMapIdentifier("int32_t", TypeNamesGenerator::getMapTypeName("int32_t", "int32_t", 2), 2, false));


    MD5 my_map_map_hash("my_map_map");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_map_map.detail().name_hash()[i] = my_map_map_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_map_map);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MapMapStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MapMapStruct", false);
}

const TypeObject* GetCompleteMapMapStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("MapMapStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_map_map;
    cst_my_map_map.common().member_id(memberId++);
    cst_my_map_map.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_map_map.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_map_map.common().member_flags().IS_EXTERNAL(false);
    cst_my_map_map.common().member_flags().IS_OPTIONAL(false);
    cst_my_map_map.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_map_map.common().member_flags().IS_KEY(false);
    cst_my_map_map.common().member_flags().IS_DEFAULT(false);
    cst_my_map_map.common().member_type_id(*TypeObjectFactory::GetInstance()->GetMapIdentifier("int32_t", TypeNamesGenerator::getMapTypeName("int32_t", "int32_t", 2), 2, true));


    cst_my_map_map.detail().name("my_map_map");
    //cst_my_map_map.detail().ann_builtin()...
    //cst_my_map_map.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_map_map);


    // Header
    type_object->complete().struct_type().header().detail().type_name("MapMapStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("MapMapStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("MapMapStruct", true);
}

const TypeIdentifier* GetStructStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("StructStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetStructStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("StructStruct", complete);
}

const TypeObject* GetStructStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteStructStructObject();
    }
    //else
    return GetMinimalStructStructObject();
}

const TypeObject* GetMinimalStructStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_a;
    mst_a.common().member_id(memberId++);
    mst_a.common().member_flags().TRY_CONSTRUCT1(false);
    mst_a.common().member_flags().TRY_CONSTRUCT2(false);
    mst_a.common().member_flags().IS_EXTERNAL(false);
    mst_a.common().member_flags().IS_OPTIONAL(false);
    mst_a.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_a.common().member_flags().IS_KEY(false);
    mst_a.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_a.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 a_hash("a");
    for(int i = 0; i < 4; ++i)
    {
        mst_a.detail().name_hash()[i] = a_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_a);

    MinimalStructMember mst_b;
    mst_b.common().member_id(memberId++);
    mst_b.common().member_flags().TRY_CONSTRUCT1(false);
    mst_b.common().member_flags().TRY_CONSTRUCT2(false);
    mst_b.common().member_flags().IS_EXTERNAL(false);
    mst_b.common().member_flags().IS_OPTIONAL(false);
    mst_b.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_b.common().member_flags().IS_KEY(false);
    mst_b.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_b.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 b_hash("b");
    for(int i = 0; i < 4; ++i)
    {
        mst_b.detail().name_hash()[i] = b_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_b);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StructStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StructStruct", false);
}

const TypeObject* GetCompleteStructStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_a;
    cst_a.common().member_id(memberId++);
    cst_a.common().member_flags().TRY_CONSTRUCT1(false);
    cst_a.common().member_flags().TRY_CONSTRUCT2(false);
    cst_a.common().member_flags().IS_EXTERNAL(false);
    cst_a.common().member_flags().IS_OPTIONAL(false);
    cst_a.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_a.common().member_flags().IS_KEY(false);
    cst_a.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_a.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_a.detail().name("a");
    //cst_a.detail().ann_builtin()...
    //cst_a.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_a);

    CompleteStructMember cst_b;
    cst_b.common().member_id(memberId++);
    cst_b.common().member_flags().TRY_CONSTRUCT1(false);
    cst_b.common().member_flags().TRY_CONSTRUCT2(false);
    cst_b.common().member_flags().IS_EXTERNAL(false);
    cst_b.common().member_flags().IS_OPTIONAL(false);
    cst_b.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_b.common().member_flags().IS_KEY(false);
    cst_b.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_b.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_b.detail().name("b");
    //cst_b.detail().ann_builtin()...
    //cst_b.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_b);


    // Header
    type_object->complete().struct_type().header().detail().type_name("StructStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StructStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StructStruct", true);
}

const TypeIdentifier* GetStructStructStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("StructStructStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetStructStructStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("StructStructStruct", complete);
}

const TypeObject* GetStructStructStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStructStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteStructStructStructObject();
    }
    //else
    return GetMinimalStructStructStructObject();
}

const TypeObject* GetMinimalStructStructStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStructStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_child_struct;
    mst_child_struct.common().member_id(memberId++);
    mst_child_struct.common().member_flags().TRY_CONSTRUCT1(false);
    mst_child_struct.common().member_flags().TRY_CONSTRUCT2(false);
    mst_child_struct.common().member_flags().IS_EXTERNAL(false);
    mst_child_struct.common().member_flags().IS_OPTIONAL(false);
    mst_child_struct.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_child_struct.common().member_flags().IS_KEY(false);
    mst_child_struct.common().member_flags().IS_DEFAULT(false);
    mst_child_struct.common().member_type_id(*GetStructStructIdentifier(false));
    MD5 child_struct_hash("child_struct");
    for(int i = 0; i < 4; ++i)
    {
        mst_child_struct.detail().name_hash()[i] = child_struct_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_child_struct);

    MinimalStructMember mst_child_int64;
    mst_child_int64.common().member_id(memberId++);
    mst_child_int64.common().member_flags().TRY_CONSTRUCT1(false);
    mst_child_int64.common().member_flags().TRY_CONSTRUCT2(false);
    mst_child_int64.common().member_flags().IS_EXTERNAL(false);
    mst_child_int64.common().member_flags().IS_OPTIONAL(false);
    mst_child_int64.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_child_int64.common().member_flags().IS_KEY(false);
    mst_child_int64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_child_int64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    MD5 child_int64_hash("child_int64");
    for(int i = 0; i < 4; ++i)
    {
        mst_child_int64.detail().name_hash()[i] = child_int64_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_child_int64);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StructStructStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StructStructStruct", false);
}

const TypeObject* GetCompleteStructStructStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("StructStructStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_child_struct;
    cst_child_struct.common().member_id(memberId++);
    cst_child_struct.common().member_flags().TRY_CONSTRUCT1(false);
    cst_child_struct.common().member_flags().TRY_CONSTRUCT2(false);
    cst_child_struct.common().member_flags().IS_EXTERNAL(false);
    cst_child_struct.common().member_flags().IS_OPTIONAL(false);
    cst_child_struct.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_child_struct.common().member_flags().IS_KEY(false);
    cst_child_struct.common().member_flags().IS_DEFAULT(false);
    cst_child_struct.common().member_type_id(*GetStructStructIdentifier(true));
    cst_child_struct.detail().name("child_struct");
    //cst_child_struct.detail().ann_builtin()...
    //cst_child_struct.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_child_struct);

    CompleteStructMember cst_child_int64;
    cst_child_int64.common().member_id(memberId++);
    cst_child_int64.common().member_flags().TRY_CONSTRUCT1(false);
    cst_child_int64.common().member_flags().TRY_CONSTRUCT2(false);
    cst_child_int64.common().member_flags().IS_EXTERNAL(false);
    cst_child_int64.common().member_flags().IS_OPTIONAL(false);
    cst_child_int64.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_child_int64.common().member_flags().IS_KEY(false);
    cst_child_int64.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_child_int64.common().member_type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_child_int64.detail().name("child_int64");
    //cst_child_int64.detail().ann_builtin()...
    //cst_child_int64.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_child_int64);


    // Header
    type_object->complete().struct_type().header().detail().type_name("StructStructStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("StructStructStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("StructStructStruct", true);
}

const TypeIdentifier* GetSimpleUnionIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("SimpleUnion", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetSimpleUnionObject(complete);
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("SimpleUnion", complete);
}

const TypeObject* GetSimpleUnionObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnion", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteSimpleUnionObject();
    }
    // else
    return GetMinimalSimpleUnionObject();
}

const TypeObject* GetMinimalSimpleUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnion", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_UNION);

    type_object->minimal().union_type().union_flags().IS_FINAL(false);
    type_object->minimal().union_type().union_flags().IS_APPENDABLE(false);
    type_object->minimal().union_type().union_flags().IS_MUTABLE(false);
    type_object->minimal().union_type().union_flags().IS_NESTED(false);
    type_object->minimal().union_type().union_flags().IS_AUTOID_HASH(false);

    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->minimal().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("int32_t", false));

    MemberId memberId = 0;
    MinimalUnionMember mst_first;
    mst_first.common().member_id(memberId++);
    mst_first.common().member_flags().TRY_CONSTRUCT1(false);
    mst_first.common().member_flags().TRY_CONSTRUCT2(false);
    mst_first.common().member_flags().IS_EXTERNAL(false);
    mst_first.common().member_flags().IS_OPTIONAL(false);
    mst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_first.common().member_flags().IS_KEY(false);
    mst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    mst_first.common().label_seq().emplace_back(A);
    MD5 first_hash("first");
    for(int i = 0; i < 4; ++i)
    {
        mst_first.detail().name_hash()[i] = first_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_first);

    MinimalUnionMember mst_second;
    mst_second.common().member_id(memberId++);
    mst_second.common().member_flags().TRY_CONSTRUCT1(false);
    mst_second.common().member_flags().TRY_CONSTRUCT2(false);
    mst_second.common().member_flags().IS_EXTERNAL(false);
    mst_second.common().member_flags().IS_OPTIONAL(false);
    mst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_second.common().member_flags().IS_KEY(false);
    mst_second.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_second.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    mst_second.common().label_seq().emplace_back(B);
    MD5 second_hash("second");
    for(int i = 0; i < 4; ++i)
    {
        mst_second.detail().name_hash()[i] = second_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_second);


    // Header
    //type_object->minimal().union_type().header().detail()... // Empty

    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalUnionType::getCdrSerializedSize(type_object->minimal().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SimpleUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnion", false);
}

const TypeObject* GetCompleteSimpleUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnion", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_UNION);

    type_object->complete().union_type().union_flags().IS_FINAL(false);
    type_object->complete().union_type().union_flags().IS_APPENDABLE(false);
    type_object->complete().union_type().union_flags().IS_MUTABLE(false);
    type_object->complete().union_type().union_flags().IS_NESTED(false);
    type_object->complete().union_type().union_flags().IS_AUTOID_HASH(false);

    //type_object->complete().union_type().discriminator().ann_builtin()...
    //type_object->complete().union_type().discriminator().ann_custom()...
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->complete().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("int32_t", false));

    MemberId memberId = 0;
    CompleteUnionMember cst_first;
    cst_first.common().member_id(memberId++);
    cst_first.common().member_flags().TRY_CONSTRUCT1(false);
    cst_first.common().member_flags().TRY_CONSTRUCT2(false);
    cst_first.common().member_flags().IS_EXTERNAL(false);
    cst_first.common().member_flags().IS_OPTIONAL(false);
    cst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_first.common().member_flags().IS_KEY(false);
    cst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_first.common().label_seq().emplace_back(A);

    cst_first.detail().name("first");
    //cst_first.detail().ann_builtin()...
    //cst_first.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_first);

    CompleteUnionMember cst_second;
    cst_second.common().member_id(memberId++);
    cst_second.common().member_flags().TRY_CONSTRUCT1(false);
    cst_second.common().member_flags().TRY_CONSTRUCT2(false);
    cst_second.common().member_flags().IS_EXTERNAL(false);
    cst_second.common().member_flags().IS_OPTIONAL(false);
    cst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_second.common().member_flags().IS_KEY(false);
    cst_second.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_second.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_second.common().label_seq().emplace_back(B);

    cst_second.detail().name("second");
    //cst_second.detail().ann_builtin()...
    //cst_second.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_second);


    // Header
    //type_object->complete().union_type().header().detail().ann_builtin()..
    //type_object->complete().union_type().header().detail().ann_builtin()..
    type_object->complete().union_type().header().detail().type_name("SimpleUnion");


    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteUnionType::getCdrSerializedSize(type_object->complete().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SimpleUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnion", true);
}

const TypeIdentifier* GetUnionUnionIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("UnionUnion", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetUnionUnionObject(complete);
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("UnionUnion", complete);
}

const TypeObject* GetUnionUnionObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnion", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteUnionUnionObject();
    }
    // else
    return GetMinimalUnionUnionObject();
}

const TypeObject* GetMinimalUnionUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnion", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_UNION);

    type_object->minimal().union_type().union_flags().IS_FINAL(false);
    type_object->minimal().union_type().union_flags().IS_APPENDABLE(false);
    type_object->minimal().union_type().union_flags().IS_MUTABLE(false);
    type_object->minimal().union_type().union_flags().IS_NESTED(false);
    type_object->minimal().union_type().union_flags().IS_AUTOID_HASH(false);

    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->minimal().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("int32_t", false));

    MemberId memberId = 0;
    MinimalUnionMember mst_first;
    mst_first.common().member_id(memberId++);
    mst_first.common().member_flags().TRY_CONSTRUCT1(false);
    mst_first.common().member_flags().TRY_CONSTRUCT2(false);
    mst_first.common().member_flags().IS_EXTERNAL(false);
    mst_first.common().member_flags().IS_OPTIONAL(false);
    mst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_first.common().member_flags().IS_KEY(false);
    mst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    mst_first.common().label_seq().emplace_back(A);
    MD5 first_hash("first");
    for(int i = 0; i < 4; ++i)
    {
        mst_first.detail().name_hash()[i] = first_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_first);

    MinimalUnionMember mst_second;
    mst_second.common().member_id(memberId++);
    mst_second.common().member_flags().TRY_CONSTRUCT1(false);
    mst_second.common().member_flags().TRY_CONSTRUCT2(false);
    mst_second.common().member_flags().IS_EXTERNAL(false);
    mst_second.common().member_flags().IS_OPTIONAL(false);
    mst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_second.common().member_flags().IS_KEY(false);
    mst_second.common().member_flags().IS_DEFAULT(false);
    mst_second.common().type_id(*GetSimpleUnionIdentifier(false));
    mst_second.common().label_seq().emplace_back(B);
    MD5 second_hash("second");
    for(int i = 0; i < 4; ++i)
    {
        mst_second.detail().name_hash()[i] = second_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_second);


    // Header
    //type_object->minimal().union_type().header().detail()... // Empty

    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalUnionType::getCdrSerializedSize(type_object->minimal().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UnionUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnion", false);
}

const TypeObject* GetCompleteUnionUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnion", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_UNION);

    type_object->complete().union_type().union_flags().IS_FINAL(false);
    type_object->complete().union_type().union_flags().IS_APPENDABLE(false);
    type_object->complete().union_type().union_flags().IS_MUTABLE(false);
    type_object->complete().union_type().union_flags().IS_NESTED(false);
    type_object->complete().union_type().union_flags().IS_AUTOID_HASH(false);

    //type_object->complete().union_type().discriminator().ann_builtin()...
    //type_object->complete().union_type().discriminator().ann_custom()...
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->complete().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("int32_t", false));

    MemberId memberId = 0;
    CompleteUnionMember cst_first;
    cst_first.common().member_id(memberId++);
    cst_first.common().member_flags().TRY_CONSTRUCT1(false);
    cst_first.common().member_flags().TRY_CONSTRUCT2(false);
    cst_first.common().member_flags().IS_EXTERNAL(false);
    cst_first.common().member_flags().IS_OPTIONAL(false);
    cst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_first.common().member_flags().IS_KEY(false);
    cst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_first.common().label_seq().emplace_back(A);

    cst_first.detail().name("first");
    //cst_first.detail().ann_builtin()...
    //cst_first.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_first);

    CompleteUnionMember cst_second;
    cst_second.common().member_id(memberId++);
    cst_second.common().member_flags().TRY_CONSTRUCT1(false);
    cst_second.common().member_flags().TRY_CONSTRUCT2(false);
    cst_second.common().member_flags().IS_EXTERNAL(false);
    cst_second.common().member_flags().IS_OPTIONAL(false);
    cst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_second.common().member_flags().IS_KEY(false);
    cst_second.common().member_flags().IS_DEFAULT(false);
    cst_second.common().type_id(*GetSimpleUnionIdentifier(true));
    cst_second.common().label_seq().emplace_back(B);

    cst_second.detail().name("second");
    //cst_second.detail().ann_builtin()...
    //cst_second.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_second);


    // Header
    //type_object->complete().union_type().header().detail().ann_builtin()..
    //type_object->complete().union_type().header().detail().ann_builtin()..
    type_object->complete().union_type().header().detail().type_name("UnionUnion");


    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteUnionType::getCdrSerializedSize(type_object->complete().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UnionUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnion", true);
}

const TypeIdentifier* GetWCharUnionIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharUnion", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetWCharUnionObject(complete);
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharUnion", complete);
}

const TypeObject* GetWCharUnionObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnion", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteWCharUnionObject();
    }
    // else
    return GetMinimalWCharUnionObject();
}

const TypeObject* GetMinimalWCharUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnion", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_UNION);

    type_object->minimal().union_type().union_flags().IS_FINAL(false);
    type_object->minimal().union_type().union_flags().IS_APPENDABLE(false);
    type_object->minimal().union_type().union_flags().IS_MUTABLE(false);
    type_object->minimal().union_type().union_flags().IS_NESTED(false);
    type_object->minimal().union_type().union_flags().IS_AUTOID_HASH(false);

    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->minimal().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->minimal().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->minimal().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("wchar_t", false));

    MemberId memberId = 0;
    MinimalUnionMember mst_first;
    mst_first.common().member_id(memberId++);
    mst_first.common().member_flags().TRY_CONSTRUCT1(false);
    mst_first.common().member_flags().TRY_CONSTRUCT2(false);
    mst_first.common().member_flags().IS_EXTERNAL(false);
    mst_first.common().member_flags().IS_OPTIONAL(false);
    mst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_first.common().member_flags().IS_KEY(false);
    mst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    mst_first.common().label_seq().emplace_back(A);
    MD5 first_hash("first");
    for(int i = 0; i < 4; ++i)
    {
        mst_first.detail().name_hash()[i] = first_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_first);

    MinimalUnionMember mst_second;
    mst_second.common().member_id(memberId++);
    mst_second.common().member_flags().TRY_CONSTRUCT1(false);
    mst_second.common().member_flags().TRY_CONSTRUCT2(false);
    mst_second.common().member_flags().IS_EXTERNAL(false);
    mst_second.common().member_flags().IS_OPTIONAL(false);
    mst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_second.common().member_flags().IS_KEY(false);
    mst_second.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        mst_second.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    mst_second.common().label_seq().emplace_back(B);
    MD5 second_hash("second");
    for(int i = 0; i < 4; ++i)
    {
        mst_second.detail().name_hash()[i] = second_hash.digest[i];
    }
    type_object->minimal().union_type().member_seq().emplace_back(mst_second);


    // Header
    //type_object->minimal().union_type().header().detail()... // Empty

    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalUnionType::getCdrSerializedSize(type_object->minimal().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnion", false);
}

const TypeObject* GetCompleteWCharUnionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnion", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_UNION);

    type_object->complete().union_type().union_flags().IS_FINAL(false);
    type_object->complete().union_type().union_flags().IS_APPENDABLE(false);
    type_object->complete().union_type().union_flags().IS_MUTABLE(false);
    type_object->complete().union_type().union_flags().IS_NESTED(false);
    type_object->complete().union_type().union_flags().IS_AUTOID_HASH(false);

    //type_object->complete().union_type().discriminator().ann_builtin()...
    //type_object->complete().union_type().discriminator().ann_custom()...
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT1(false);
    type_object->complete().union_type().discriminator().common().member_flags().TRY_CONSTRUCT2(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_EXTERNAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_OPTIONAL(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_MUST_UNDERSTAND(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_KEY(false);
    type_object->complete().union_type().discriminator().common().member_flags().IS_DEFAULT(false);

    type_object->complete().union_type().discriminator().common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier("wchar_t", false));

    MemberId memberId = 0;
    CompleteUnionMember cst_first;
    cst_first.common().member_id(memberId++);
    cst_first.common().member_flags().TRY_CONSTRUCT1(false);
    cst_first.common().member_flags().TRY_CONSTRUCT2(false);
    cst_first.common().member_flags().IS_EXTERNAL(false);
    cst_first.common().member_flags().IS_OPTIONAL(false);
    cst_first.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_first.common().member_flags().IS_KEY(false);
    cst_first.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int32_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_first.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_first.common().label_seq().emplace_back(A);

    cst_first.detail().name("first");
    //cst_first.detail().ann_builtin()...
    //cst_first.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_first);

    CompleteUnionMember cst_second;
    cst_second.common().member_id(memberId++);
    cst_second.common().member_flags().TRY_CONSTRUCT1(false);
    cst_second.common().member_flags().TRY_CONSTRUCT2(false);
    cst_second.common().member_flags().IS_EXTERNAL(false);
    cst_second.common().member_flags().IS_OPTIONAL(false);
    cst_second.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_second.common().member_flags().IS_KEY(false);
    cst_second.common().member_flags().IS_DEFAULT(false);
    {
        std::string cppType = "int64_t";
        if (cppType == "long double")
        {
            cppType = "longdouble";
        }
        cst_second.common().type_id(*TypeObjectFactory::GetInstance()->GetTypeIdentifier(cppType, false));
    }

    cst_second.common().label_seq().emplace_back(B);

    cst_second.detail().name("second");
    //cst_second.detail().ann_builtin()...
    //cst_second.detail().ann_custom()...

    type_object->complete().union_type().member_seq().emplace_back(cst_second);


    // Header
    //type_object->complete().union_type().header().detail().ann_builtin()..
    //type_object->complete().union_type().header().detail().ann_builtin()..
    type_object->complete().union_type().header().detail().type_name("WCharUnion");


    TypeIdentifier* identifier = new TypeIdentifier();
    identifier->_d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteUnionType::getCdrSerializedSize(type_object->complete().union_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier->equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharUnion", identifier, type_object);
    delete type_object;
    delete identifier;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnion", true);
}

const TypeIdentifier* GetSimpleUnionStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("SimpleUnionStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetSimpleUnionStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("SimpleUnionStruct", complete);
}

const TypeObject* GetSimpleUnionStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnionStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteSimpleUnionStructObject();
    }
    //else
    return GetMinimalSimpleUnionStructObject();
}

const TypeObject* GetMinimalSimpleUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnionStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_union;
    mst_my_union.common().member_id(memberId++);
    mst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_union.common().member_flags().IS_EXTERNAL(false);
    mst_my_union.common().member_flags().IS_OPTIONAL(false);
    mst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_union.common().member_flags().IS_KEY(false);
    mst_my_union.common().member_flags().IS_DEFAULT(false);
    mst_my_union.common().member_type_id(*GetSimpleUnionIdentifier(false));
    MD5 my_union_hash("my_union");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_union.detail().name_hash()[i] = my_union_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_union);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SimpleUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnionStruct", false);
}

const TypeObject* GetCompleteSimpleUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnionStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_union;
    cst_my_union.common().member_id(memberId++);
    cst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_union.common().member_flags().IS_EXTERNAL(false);
    cst_my_union.common().member_flags().IS_OPTIONAL(false);
    cst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_union.common().member_flags().IS_KEY(false);
    cst_my_union.common().member_flags().IS_DEFAULT(false);
    cst_my_union.common().member_type_id(*GetSimpleUnionIdentifier(true));
    cst_my_union.detail().name("my_union");
    //cst_my_union.detail().ann_builtin()...
    //cst_my_union.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_union);


    // Header
    type_object->complete().struct_type().header().detail().type_name("SimpleUnionStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("SimpleUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("SimpleUnionStruct", true);
}

const TypeIdentifier* GetUnionUnionUnionStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("UnionUnionUnionStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetUnionUnionUnionStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("UnionUnionUnionStruct", complete);
}

const TypeObject* GetUnionUnionUnionStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnionUnionStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteUnionUnionUnionStructObject();
    }
    //else
    return GetMinimalUnionUnionUnionStructObject();
}

const TypeObject* GetMinimalUnionUnionUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnionUnionStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_union;
    mst_my_union.common().member_id(memberId++);
    mst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_union.common().member_flags().IS_EXTERNAL(false);
    mst_my_union.common().member_flags().IS_OPTIONAL(false);
    mst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_union.common().member_flags().IS_KEY(false);
    mst_my_union.common().member_flags().IS_DEFAULT(false);
    mst_my_union.common().member_type_id(*GetUnionUnionIdentifier(false));
    MD5 my_union_hash("my_union");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_union.detail().name_hash()[i] = my_union_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_union);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UnionUnionUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnionUnionStruct", false);
}

const TypeObject* GetCompleteUnionUnionUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnionUnionStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_union;
    cst_my_union.common().member_id(memberId++);
    cst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_union.common().member_flags().IS_EXTERNAL(false);
    cst_my_union.common().member_flags().IS_OPTIONAL(false);
    cst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_union.common().member_flags().IS_KEY(false);
    cst_my_union.common().member_flags().IS_DEFAULT(false);
    cst_my_union.common().member_type_id(*GetUnionUnionIdentifier(true));
    cst_my_union.detail().name("my_union");
    //cst_my_union.detail().ann_builtin()...
    //cst_my_union.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_union);


    // Header
    type_object->complete().struct_type().header().detail().type_name("UnionUnionUnionStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("UnionUnionUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("UnionUnionUnionStruct", true);
}

const TypeIdentifier* GetWCharUnionStructIdentifier(bool complete)
{
    const TypeIdentifier * c_identifier = TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharUnionStruct", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetWCharUnionStructObject(complete); // Generated inside
    return TypeObjectFactory::GetInstance()->GetTypeIdentifier("WCharUnionStruct", complete);
}

const TypeObject* GetWCharUnionStructObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnionStruct", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteWCharUnionStructObject();
    }
    //else
    return GetMinimalWCharUnionStructObject();
}

const TypeObject* GetMinimalWCharUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnionStruct", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_STRUCTURE);

    type_object->minimal().struct_type().struct_flags().IS_FINAL(false);
    type_object->minimal().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->minimal().struct_type().struct_flags().IS_NESTED(false);
    type_object->minimal().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    MinimalStructMember mst_my_union;
    mst_my_union.common().member_id(memberId++);
    mst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    mst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    mst_my_union.common().member_flags().IS_EXTERNAL(false);
    mst_my_union.common().member_flags().IS_OPTIONAL(false);
    mst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    mst_my_union.common().member_flags().IS_KEY(false);
    mst_my_union.common().member_flags().IS_DEFAULT(false);
    mst_my_union.common().member_type_id(*GetWCharUnionIdentifier(false));
    MD5 my_union_hash("my_union");
    for(int i = 0; i < 4; ++i)
    {
        mst_my_union.detail().name_hash()[i] = my_union_hash.digest[i];
    }
    type_object->minimal().struct_type().member_seq().emplace_back(mst_my_union);


    // Header
    // TODO Inheritance
    //type_object->minimal().struct_type().header().base_type()._d(EK_MINIMAL);
    //type_object->minimal().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalStructType::getCdrSerializedSize(type_object->minimal().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnionStruct", false);
}

const TypeObject* GetCompleteWCharUnionStructObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnionStruct", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_STRUCTURE);

    type_object->complete().struct_type().struct_flags().IS_FINAL(false);
    type_object->complete().struct_type().struct_flags().IS_APPENDABLE(false);
    type_object->complete().struct_type().struct_flags().IS_MUTABLE(false);
    type_object->complete().struct_type().struct_flags().IS_NESTED(false);
    type_object->complete().struct_type().struct_flags().IS_AUTOID_HASH(false);

    MemberId memberId = 0;
    CompleteStructMember cst_my_union;
    cst_my_union.common().member_id(memberId++);
    cst_my_union.common().member_flags().TRY_CONSTRUCT1(false);
    cst_my_union.common().member_flags().TRY_CONSTRUCT2(false);
    cst_my_union.common().member_flags().IS_EXTERNAL(false);
    cst_my_union.common().member_flags().IS_OPTIONAL(false);
    cst_my_union.common().member_flags().IS_MUST_UNDERSTAND(false);
    cst_my_union.common().member_flags().IS_KEY(false);
    cst_my_union.common().member_flags().IS_DEFAULT(false);
    cst_my_union.common().member_type_id(*GetWCharUnionIdentifier(true));
    cst_my_union.detail().name("my_union");
    //cst_my_union.detail().ann_builtin()...
    //cst_my_union.detail().ann_custom()...
    type_object->complete().struct_type().member_seq().emplace_back(cst_my_union);


    // Header
    type_object->complete().struct_type().header().detail().type_name("WCharUnionStruct");
    //type_object->complete().struct_type().header().detail().ann_builtin()...
    //type_object->complete().struct_type().header().detail().ann_custom()...
    // TODO inheritance
    //type_object->complete().struct_type().header().base_type()._d(EK_COMPLETE);
    //type_object->complete().struct_type().header().base_type().equivalence_hash()[0..13];

    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteStructType::getCdrSerializedSize(type_object->complete().struct_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::GetInstance()->AddTypeObject("WCharUnionStruct", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::GetInstance()->GetTypeObject("WCharUnionStruct", true);
}
