// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*************************************************************************
 * @file MetaTestTypes.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _MetaTestTypes_H_
#define _MetaTestTypes_H_

// TODO Poner en el contexto.

#include <stdint.h>
#include <array>
#include <string>
#include <vector>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif
#else
#define eProsima_user_DllExport
#endif

namespace eprosima
{
    namespace fastcdr
    {
        class Cdr;
    }
}


/*!
 * @brief This class represents the enumeration TestKind defined by the user in the IDL file.
 * @ingroup METATESTTYPES
 */
enum TestKind : uint32_t
{
    T_RTPS_SOCKET,
    T_RTPS_REG,
    T_CLIENT_SERVER,
    T_HELLO_WORLD,
    STOP_ALL_TESTS
};
/*!
 * @brief This class represents the enumeration TestStatus defined by the user in the IDL file.
 * @ingroup METATESTTYPES
 */
enum TestStatus : uint32_t
{
    T_PUB_STARTS,
    T_SUB_READY,
    T_SUB_FAILED,
    T_SUB_OK,
    T_PUB_FINISH
};
/*!
 * @brief This class represents the structure MetaTestType defined by the user in the IDL file.
 * @ingroup METATESTTYPES
 */
class MetaTestType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MetaTestType();
    
    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MetaTestType();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MetaTestType that will be copied.
     */
    eProsima_user_DllExport MetaTestType(const MetaTestType &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object MetaTestType that will be copied.
     */
    eProsima_user_DllExport MetaTestType(MetaTestType &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MetaTestType that will be copied.
     */
    eProsima_user_DllExport MetaTestType& operator=(const MetaTestType &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object MetaTestType that will be copied.
     */
    eProsima_user_DllExport MetaTestType& operator=(MetaTestType &&x);
    
    /*!
     * @brief This function sets a value in member kind
     * @param _kind New value for member kind
     */
    inline eProsima_user_DllExport void kind(TestKind _kind)
    {
        m_kind = _kind;
    }

    /*!
     * @brief This function returns the value of member kind
     * @return Value of member kind
     */
    inline eProsima_user_DllExport TestKind kind() const
    {
        return m_kind;
    }

    /*!
     * @brief This function returns a reference to member kind
     * @return Reference to member kind
     */
    inline eProsima_user_DllExport TestKind& kind()
    {
        return m_kind;
    }
    /*!
     * @brief This function sets a value in member status
     * @param _status New value for member status
     */
    inline eProsima_user_DllExport void status(TestStatus _status)
    {
        m_status = _status;
    }

    /*!
     * @brief This function returns the value of member status
     * @return Value of member status
     */
    inline eProsima_user_DllExport TestStatus status() const
    {
        return m_status;
    }

    /*!
     * @brief This function returns a reference to member status
     * @return Reference to member status
     */
    inline eProsima_user_DllExport TestStatus& status()
    {
        return m_status;
    }
    /*!
     * @brief This function sets a value in member ip_string
     * @param _ip_string New value for member ip_string
     */
    inline eProsima_user_DllExport void ip_string(std::string _ip_string)
    {
        m_ip_string = _ip_string;
    }

    /*!
     * @brief This function returns the value of member ip_string
     * @return Value of member ip_string
     */
    inline eProsima_user_DllExport std::string ip_string() const
    {
        return m_ip_string;
    }

    /*!
     * @brief This function returns a reference to member ip_string
     * @return Reference to member ip_string
     */
    inline eProsima_user_DllExport std::string& ip_string()
    {
        return m_ip_string;
    }
    /*!
     * @brief This function sets a value in member ip_port
     * @param _ip_port New value for member ip_port
     */
    inline eProsima_user_DllExport void ip_port(int16_t _ip_port)
    {
        m_ip_port = _ip_port;
    }

    /*!
     * @brief This function returns the value of member ip_port
     * @return Value of member ip_port
     */
    inline eProsima_user_DllExport int16_t ip_port() const
    {
        return m_ip_port;
    }

    /*!
     * @brief This function returns a reference to member ip_port
     * @return Reference to member ip_port
     */
    inline eProsima_user_DllExport int16_t& ip_port()
    {
        return m_ip_port;
    }
    /*!
     * @brief This function sets a value in member samples
     * @param _samples New value for member samples
     */
    inline eProsima_user_DllExport void samples(int16_t _samples)
    {
        m_samples = _samples;
    }

    /*!
     * @brief This function returns the value of member samples
     * @return Value of member samples
     */
    inline eProsima_user_DllExport int16_t samples() const
    {
        return m_samples;
    }

    /*!
     * @brief This function returns a reference to member samples
     * @return Reference to member samples
     */
    inline eProsima_user_DllExport int16_t& samples()
    {
        return m_samples;
    }
    /*!
     * @brief This function sets a value in member comment
     * @param _comment New value for member comment
     */
    inline eProsima_user_DllExport void comment(std::string _comment)
    {
        m_comment = _comment;
    }

    /*!
     * @brief This function returns the value of member comment
     * @return Value of member comment
     */
    inline eProsima_user_DllExport std::string comment() const
    {
        return m_comment;
    }

    /*!
     * @brief This function returns a reference to member comment
     * @return Reference to member comment
     */
    inline eProsima_user_DllExport std::string& comment()
    {
        return m_comment;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the maximum serialized size of the Key of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getKeyMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function tells you if the Key has beedn defined for this type
     */
    eProsima_user_DllExport static bool isKeyDefined();

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void deserialize(eprosima::fastcdr::Cdr &cdr);

    /*!
     * @brief This function serializes the key memebers of an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serializeKey(eprosima::fastcdr::Cdr &cdr) const;

    
private:
    TestKind m_kind;
    TestStatus m_status;
    std::string m_ip_string;
    int16_t m_ip_port;
    int16_t m_samples;
    std::string m_comment;
};

#endif // _MetaTestTypes_H_
