// Copyright 2018 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XRCETypes.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _UXR_AGENT_TYPES_XRCETYPES_HPP_
#define _UXR_AGENT_TYPES_XRCETYPES_HPP_

#include <uxr/agent/types/Optional.hpp>
#include <fastcdr/exceptions/BadParamException.h>

#include <cstdint>
#include <array>
#include <string>
#include <vector>

namespace eprosima { namespace fastcdr {

class Cdr;

} } // namespace eprosima::fastcdr

namespace dds { namespace xrce {

typedef std::array<uint8_t, 4> ClientKey;

typedef uint8_t ObjectKind;

const ObjectKind OBJK_INVALID       = 0x00;
const ObjectKind OBJK_PARTICIPANT   = 0x01;
const ObjectKind OBJK_TOPIC         = 0x02;
const ObjectKind OBJK_PUBLISHER     = 0x03;
const ObjectKind OBJK_SUBSCRIBER    = 0x04;
const ObjectKind OBJK_DATAWRITER    = 0x05;
const ObjectKind OBJK_DATAREADER    = 0x06;
const ObjectKind OBJK_TYPE          = 0x0A;
const ObjectKind OBJK_QOSPROFILE    = 0x0B;
const ObjectKind OBJK_APPLICATION   = 0x0C;
const ObjectKind OBJK_AGENT         = 0x0D;
const ObjectKind OBJK_CLIENT        = 0x0E;
const ObjectKind OBJK_OTHER         = 0x0F;

typedef std::array<uint8_t, 2> ObjectId;
typedef std::array<uint8_t, 2> ObjectPrefix;
typedef std::array<uint8_t, 4> XrceCookie;
typedef std::array<uint8_t, 2> XrceVersion;
typedef std::array<uint8_t, 2> XrceVendorId;

const ClientKey CLIENTKEY_INVALID = {0x00, 0x00, 0x00, 0x00};

const ObjectId OBJECTID_INVALID   = {0x00, 0x00};
const ObjectId OBJECTID_AGENT     = {0xFF, 0xFD};
const ObjectId OBJECTID_CLIENT    = {0xFF, 0xFE};
const ObjectId OBJECTID_SESSION   = {0xFF, 0xFF};

const XrceCookie XRCE_COOKIE = {0x58, 0x52, 0x43, 0x45};

const uint8_t XRCE_VERSION_MAJOR = 0x01;
const uint8_t XRCE_VERSION_MINOR = 0x00;
const XrceVersion XRCE_VERSION = {XRCE_VERSION_MAJOR, XRCE_VERSION_MINOR};

const uint8_t XRCE_VENDOR_INVALID1 = 0x00;
const uint8_t XRCE_VENDOR_INVALID2 = 0x00;

/*!
 * @brief This class represents the structure Time_t defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class Time_t
{
public:

    /*!
     * @brief Default constructor.
     */
    Time_t();
    
    /*!
     * @brief Default destructor.
     */
    ~Time_t();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Time_t that will be copied.
     */
    Time_t(const Time_t &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object Time_t that will be copied.
     */
    Time_t(Time_t &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Time_t that will be copied.
     */
    Time_t& operator=(const Time_t &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object Time_t that will be copied.
     */
    Time_t& operator=(Time_t &&x);
    
    /*!
     * @brief This function sets a value in member seconds
     * @param _seconds New value for member seconds
     */
    inline void seconds(int32_t _seconds)
    {
        m_seconds = _seconds;
    }

    /*!
     * @brief This function returns the value of member seconds
     * @return Value of member seconds
     */
    inline int32_t seconds() const
    {
        return m_seconds;
    }

    /*!
     * @brief This function returns a reference to member seconds
     * @return Reference to member seconds
     */
    inline int32_t& seconds()
    {
        return m_seconds;
    }
    /*!
     * @brief This function sets a value in member nanoseconds
     * @param _nanoseconds New value for member nanoseconds
     */
    inline void nanoseconds(uint32_t _nanoseconds)
    {
        m_nanoseconds = _nanoseconds;
    }

    /*!
     * @brief This function returns the value of member nanoseconds
     * @return Value of member nanoseconds
     */
    inline uint32_t nanoseconds() const
    {
        return m_nanoseconds;
    }

    /*!
     * @brief This function returns a reference to member nanoseconds
     * @return Reference to member nanoseconds
     */
    inline uint32_t& nanoseconds()
    {
        return m_nanoseconds;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    int32_t m_seconds;
    uint32_t m_nanoseconds;
};

typedef uint8_t SessionId;
const SessionId SESSIONID_NONE_WITH_CLIENT_KEY    = 0x00;
const SessionId SESSIONID_NONE_WITHOUT_CLIENT_KEY = 0x80;

typedef uint8_t StreamId;
const SessionId STREAMID_NONE                 = 0x00;
const SessionId STREAMID_BUILTIN_BEST_EFFORTS = 0x01;
const SessionId STREAMID_BUILTIN_RELIABLE     = 0x80;

typedef uint16_t SequenceNr;

/*!
 * @brief This class represents the enumeration TransportAddressFormat defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum TransportAddressFormat : uint8_t
{
    ADDRESS_FORMAT_SMALL,
    ADDRESS_FORMAT_MEDIUM,
    ADDRESS_FORMAT_LARGE,
    ADDRESS_FORMAT_STRING
};

/*!
 * @brief This class represents the structure TransportAddressSmall defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class TransportAddressSmall
{
public:

    /*!
     * @brief Default constructor.
     */
    TransportAddressSmall();
    
    /*!
     * @brief Default destructor.
     */
    ~TransportAddressSmall();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TransportAddressSmall that will be copied.
     */
    TransportAddressSmall(const TransportAddressSmall &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object TransportAddressSmall that will be copied.
     */
    TransportAddressSmall(TransportAddressSmall &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TransportAddressSmall that will be copied.
     */
    TransportAddressSmall& operator=(const TransportAddressSmall &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object TransportAddressSmall that will be copied.
     */
    TransportAddressSmall& operator=(TransportAddressSmall &&x);
    
    /*!
     * @brief This function copies the value in member address
     * @param _address New value to be copied in member address
     */
    inline void address(const std::array<uint8_t, 2> &_address)
    {
        m_address = _address;
    }

    /*!
     * @brief This function moves the value in member address
     * @param _address New value to be moved in member address
     */
    inline void address(std::array<uint8_t, 2> &&_address)
    {
        m_address = std::move(_address);
    }

    /*!
     * @brief This function returns a constant reference to member address
     * @return Constant reference to member address
     */
    inline const std::array<uint8_t, 2>& address() const
    {
        return m_address;
    }

    /*!
     * @brief This function returns a reference to member address
     * @return Reference to member address
     */
    inline std::array<uint8_t, 2>& address()
    {
        return m_address;
    }
    /*!
     * @brief This function sets a value in member port
     * @param _port New value for member port
     */
    inline void port(uint8_t _port)
    {
        m_port = _port;
    }

    /*!
     * @brief This function returns the value of member port
     * @return Value of member port
     */
    inline uint8_t port() const
    {
        return m_port;
    }

    /*!
     * @brief This function returns a reference to member port
     * @return Reference to member port
     */
    inline uint8_t& port()
    {
        return m_port;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
    
private:
    std::array<uint8_t, 2> m_address;
    uint8_t m_port;
};
/*!
 * @brief This class represents the structure TransportAddressMedium defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class TransportAddressMedium
{
public:

    /*!
     * @brief Default constructor.
     */
    TransportAddressMedium();
    
    /*!
     * @brief Default destructor.
     */
    ~TransportAddressMedium();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TransportAddressMedium that will be copied.
     */
    TransportAddressMedium(const TransportAddressMedium &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object TransportAddressMedium that will be copied.
     */
    TransportAddressMedium(TransportAddressMedium &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TransportAddressMedium that will be copied.
     */
    TransportAddressMedium& operator=(const TransportAddressMedium &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object TransportAddressMedium that will be copied.
     */
    TransportAddressMedium& operator=(TransportAddressMedium &&x);
    
    /*!
     * @brief This function copies the value in member address
     * @param _address New value to be copied in member address
     */
    inline void address(const std::array<uint8_t, 4> &_address)
    {
        m_address = _address;
    }

    /*!
     * @brief This function moves the value in member address
     * @param _address New value to be moved in member address
     */
    inline void address(std::array<uint8_t, 4> &&_address)
    {
        m_address = std::move(_address);
    }

    /*!
     * @brief This function returns a constant reference to member address
     * @return Constant reference to member address
     */
    inline const std::array<uint8_t, 4>& address() const
    {
        return m_address;
    }

    /*!
     * @brief This function returns a reference to member address
     * @return Reference to member address
     */
    inline std::array<uint8_t, 4>& address()
    {
        return m_address;
    }
    /*!
     * @brief This function sets a value in member port
     * @param _port New value for member port
     */
    inline void port(uint16_t _port)
    {
        m_port = _port;
    }

    /*!
     * @brief This function returns the value of member port
     * @return Value of member port
     */
    inline uint16_t port() const
    {
        return m_port;
    }

    /*!
     * @brief This function returns a reference to member port
     * @return Reference to member port
     */
    inline uint16_t& port()
    {
        return m_port;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::array<uint8_t, 4> m_address;
    uint16_t m_port;
};

/*!
 * @brief This class represents the structure TransportAddressLarge defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class TransportAddressLarge
{
public:

    /*!
     * @brief Default constructor.
     */
    TransportAddressLarge();
    
    /*!
     * @brief Default destructor.
     */
    ~TransportAddressLarge();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TransportAddressLarge that will be copied.
     */
    TransportAddressLarge(const TransportAddressLarge &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object TransportAddressLarge that will be copied.
     */
    TransportAddressLarge(TransportAddressLarge &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TransportAddressLarge that will be copied.
     */
    TransportAddressLarge& operator=(const TransportAddressLarge &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object TransportAddressLarge that will be copied.
     */
    TransportAddressLarge& operator=(TransportAddressLarge &&x);
    
    /*!
     * @brief This function copies the value in member address
     * @param _address New value to be copied in member address
     */
    inline void address(const std::array<uint8_t, 16> &_address)
    {
        m_address = _address;
    }

    /*!
     * @brief This function moves the value in member address
     * @param _address New value to be moved in member address
     */
    inline void address(std::array<uint8_t, 16> &&_address)
    {
        m_address = std::move(_address);
    }

    /*!
     * @brief This function returns a constant reference to member address
     * @return Constant reference to member address
     */
    inline const std::array<uint8_t, 16>& address() const
    {
        return m_address;
    }

    /*!
     * @brief This function returns a reference to member address
     * @return Reference to member address
     */
    inline std::array<uint8_t, 16>& address()
    {
        return m_address;
    }
    /*!
     * @brief This function sets a value in member port
     * @param _port New value for member port
     */
    inline void port(uint32_t _port)
    {
        m_port = _port;
    }

    /*!
     * @brief This function returns the value of member port
     * @return Value of member port
     */
    inline uint32_t port() const
    {
        return m_port;
    }

    /*!
     * @brief This function returns a reference to member port
     * @return Reference to member port
     */
    inline uint32_t& port()
    {
        return m_port;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
    
private:
    std::array<uint8_t, 16> m_address;
    uint32_t m_port;
};
/*!
 * @brief This class represents the structure TransportAddressString defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class TransportAddressString
{
public:

    /*!
     * @brief Default constructor.
     */
    TransportAddressString();
    
    /*!
     * @brief Default destructor.
     */
    ~TransportAddressString();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TransportAddressString that will be copied.
     */
    TransportAddressString(const TransportAddressString &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object TransportAddressString that will be copied.
     */
    TransportAddressString(TransportAddressString &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TransportAddressString that will be copied.
     */
    TransportAddressString& operator=(const TransportAddressString &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object TransportAddressString that will be copied.
     */
    TransportAddressString& operator=(TransportAddressString &&x);
    
    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    inline void value(const std::string &_value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    inline void value(std::string &&_value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    inline const std::string& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    inline std::string& value()
    {
        return m_value;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_value;
};
/*!
 * @brief This class represents the union TransportAddress defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class TransportAddress
{
public:

    /*!
     * @brief Default constructor.
     */
    TransportAddress();
    
    /*!
     * @brief Default destructor.
     */
    ~TransportAddress();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TransportAddress that will be copied.
     */
    TransportAddress(const TransportAddress &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object TransportAddress that will be copied.
     */
    TransportAddress(TransportAddress &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TransportAddress that will be copied.
     */
    TransportAddress& operator=(const TransportAddress &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object TransportAddress that will be copied.
     */
    TransportAddress& operator=(TransportAddress &&x);
    
    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(TransportAddressFormat __d);
    
    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    TransportAddressFormat _d() const;
    
    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    TransportAddressFormat& _d();
    
    /*!
     * @brief This function copies the value in member small_locator
     * @param _small_locator New value to be copied in member small_locator
     */
    void small_locator(const TransportAddressSmall &_small_locator);

    /*!
     * @brief This function moves the value in member small_locator
     * @param _small_locator New value to be moved in member small_locator
     */
    void small_locator(TransportAddressSmall &&_small_locator);

    /*!
     * @brief This function returns a constant reference to member small_locator
     * @return Constant reference to member small_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const TransportAddressSmall& small_locator() const;

    /*!
     * @brief This function returns a reference to member small_locator
     * @return Reference to member small_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    TransportAddressSmall& small_locator();
    /*!
     * @brief This function copies the value in member medium_locator
     * @param _medium_locator New value to be copied in member medium_locator
     */
    void medium_locator(const TransportAddressMedium &_medium_locator);

    /*!
     * @brief This function moves the value in member medium_locator
     * @param _medium_locator New value to be moved in member medium_locator
     */
    void medium_locator(TransportAddressMedium &&_medium_locator);

    /*!
     * @brief This function returns a constant reference to member medium_locator
     * @return Constant reference to member medium_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const TransportAddressMedium& medium_locator() const;

    /*!
     * @brief This function returns a reference to member medium_locator
     * @return Reference to member medium_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    TransportAddressMedium& medium_locator();
    /*!
     * @brief This function copies the value in member large_locator
     * @param _large_locator New value to be copied in member large_locator
     */
    void large_locator(const TransportAddressLarge &_large_locator);

    /*!
     * @brief This function moves the value in member large_locator
     * @param _large_locator New value to be moved in member large_locator
     */
    void large_locator(TransportAddressLarge &&_large_locator);

    /*!
     * @brief This function returns a constant reference to member large_locator
     * @return Constant reference to member large_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const TransportAddressLarge& large_locator() const;

    /*!
     * @brief This function returns a reference to member large_locator
     * @return Reference to member large_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    TransportAddressLarge& large_locator();
    /*!
     * @brief This function copies the value in member string_locator
     * @param _string_locator New value to be copied in member string_locator
     */
    void string_locator(const TransportAddressString &_string_locator);

    /*!
     * @brief This function moves the value in member string_locator
     * @param _string_locator New value to be moved in member string_locator
     */
    void string_locator(TransportAddressString &&_string_locator);

    /*!
     * @brief This function returns a constant reference to member string_locator
     * @return Constant reference to member string_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const TransportAddressString& string_locator() const;

    /*!
     * @brief This function returns a reference to member string_locator
     * @return Reference to member string_locator
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    TransportAddressString& string_locator();
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
    
private:
    TransportAddressFormat m__d;
    
    TransportAddressSmall m_small_locator;
    TransportAddressMedium m_medium_locator;
    TransportAddressLarge m_large_locator;
    TransportAddressString m_string_locator;
};

typedef std::vector<TransportAddress> TransportAddressSeq;

/*!
 * @brief This class represents the structure Property defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class Property
{
public:

    /*!
     * @brief Default constructor.
     */
    Property();
    
    /*!
     * @brief Default destructor.
     */
    ~Property();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Property that will be copied.
     */
    Property(const Property &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object Property that will be copied.
     */
    Property(Property &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Property that will be copied.
     */
    Property& operator=(const Property &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object Property that will be copied.
     */
    Property& operator=(Property &&x);
    
    /*!
     * @brief This function copies the value in member name
     * @param _name New value to be copied in member name
     */
    inline void name(const std::string &_name)
    {
        m_name = _name;
    }

    /*!
     * @brief This function moves the value in member name
     * @param _name New value to be moved in member name
     */
    inline void name(std::string &&_name)
    {
        m_name = std::move(_name);
    }

    /*!
     * @brief This function returns a constant reference to member name
     * @return Constant reference to member name
     */
    inline const std::string& name() const
    {
        return m_name;
    }

    /*!
     * @brief This function returns a reference to member name
     * @return Reference to member name
     */
    inline std::string& name()
    {
        return m_name;
    }
    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    inline void value(const std::string &_value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    inline void value(std::string &&_value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    inline const std::string& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    inline std::string& value()
    {
        return m_value;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_name;
    std::string m_value;
};

typedef std::vector<Property> PropertySeq;

/*!
 * @brief This class represents the structure CLIENT_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class CLIENT_Representation
{
public:

    /*!
     * @brief Default constructor.
     */
    CLIENT_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~CLIENT_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CLIENT_Representation that will be copied.
     */
    CLIENT_Representation(const CLIENT_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object CLIENT_Representation that will be copied.
     */
    CLIENT_Representation(CLIENT_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CLIENT_Representation that will be copied.
     */
    CLIENT_Representation& operator=(const CLIENT_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object CLIENT_Representation that will be copied.
     */
    CLIENT_Representation& operator=(CLIENT_Representation &&x);
    
    /*!
     * @brief This function copies the value in member xrce_cookie
     * @param _xrce_cookie New value to be copied in member xrce_cookie
     */
    inline void xrce_cookie(const XrceCookie &_xrce_cookie)
    {
        m_xrce_cookie = _xrce_cookie;
    }

    /*!
     * @brief This function moves the value in member xrce_cookie
     * @param _xrce_cookie New value to be moved in member xrce_cookie
     */
    inline void xrce_cookie(XrceCookie &&_xrce_cookie)
    {
        m_xrce_cookie = std::move(_xrce_cookie);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_cookie
     * @return Constant reference to member xrce_cookie
     */
    inline const XrceCookie& xrce_cookie() const
    {
        return m_xrce_cookie;
    }

    /*!
     * @brief This function returns a reference to member xrce_cookie
     * @return Reference to member xrce_cookie
     */
    inline XrceCookie& xrce_cookie()
    {
        return m_xrce_cookie;
    }
    /*!
     * @brief This function copies the value in member xrce_version
     * @param _xrce_version New value to be copied in member xrce_version
     */
    inline void xrce_version(const XrceVersion &_xrce_version)
    {
        m_xrce_version = _xrce_version;
    }

    /*!
     * @brief This function moves the value in member xrce_version
     * @param _xrce_version New value to be moved in member xrce_version
     */
    inline void xrce_version(XrceVersion &&_xrce_version)
    {
        m_xrce_version = std::move(_xrce_version);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_version
     * @return Constant reference to member xrce_version
     */
    inline const XrceVersion& xrce_version() const
    {
        return m_xrce_version;
    }

    /*!
     * @brief This function returns a reference to member xrce_version
     * @return Reference to member xrce_version
     */
    inline XrceVersion& xrce_version()
    {
        return m_xrce_version;
    }
    /*!
     * @brief This function copies the value in member xrce_vendor_id
     * @param _xrce_vendor_id New value to be copied in member xrce_vendor_id
     */
    inline void xrce_vendor_id(const XrceVendorId &_xrce_vendor_id)
    {
        m_xrce_vendor_id = _xrce_vendor_id;
    }

    /*!
     * @brief This function moves the value in member xrce_vendor_id
     * @param _xrce_vendor_id New value to be moved in member xrce_vendor_id
     */
    inline void xrce_vendor_id(XrceVendorId &&_xrce_vendor_id)
    {
        m_xrce_vendor_id = std::move(_xrce_vendor_id);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_vendor_id
     * @return Constant reference to member xrce_vendor_id
     */
    inline const XrceVendorId& xrce_vendor_id() const
    {
        return m_xrce_vendor_id;
    }

    /*!
     * @brief This function returns a reference to member xrce_vendor_id
     * @return Reference to member xrce_vendor_id
     */
    inline XrceVendorId& xrce_vendor_id()
    {
        return m_xrce_vendor_id;
    }
    /*!
     * @brief This function copies the value in member client_timestamp
     * @param _client_timestamp New value to be copied in member client_timestamp
     */
    inline void client_timestamp(const Time_t &_client_timestamp)
    {
        m_client_timestamp = _client_timestamp;
    }

    /*!
     * @brief This function moves the value in member client_timestamp
     * @param _client_timestamp New value to be moved in member client_timestamp
     */
    inline void client_timestamp(Time_t &&_client_timestamp)
    {
        m_client_timestamp = std::move(_client_timestamp);
    }

    /*!
     * @brief This function returns a constant reference to member client_timestamp
     * @return Constant reference to member client_timestamp
     */
    inline const Time_t& client_timestamp() const
    {
        return m_client_timestamp;
    }

    /*!
     * @brief This function returns a reference to member client_timestamp
     * @return Reference to member client_timestamp
     */
    inline Time_t& client_timestamp()
    {
        return m_client_timestamp;
    }
    /*!
     * @brief This function copies the value in member client_key
     * @param _client_key New value to be copied in member client_key
     */
    inline void client_key(const ClientKey &_client_key)
    {
        m_client_key = _client_key;
    }

    /*!
     * @brief This function moves the value in member client_key
     * @param _client_key New value to be moved in member client_key
     */
    inline void client_key(ClientKey &&_client_key)
    {
        m_client_key = std::move(_client_key);
    }

    /*!
     * @brief This function returns a constant reference to member client_key
     * @return Constant reference to member client_key
     */
    inline const ClientKey& client_key() const
    {
        return m_client_key;
    }

    /*!
     * @brief This function returns a reference to member client_key
     * @return Reference to member client_key
     */
    inline ClientKey& client_key()
    {
        return m_client_key;
    }

    /*!
     * @brief This function sets a value in member session_id
     * @param _session_id New value for member session_id
     */
    inline void session_id(SessionId _session_id)
    {
        m_session_id = _session_id;
    }

    /*!
     * @brief This function returns the value of member session_id
     * @return Value of member session_id
     */
    inline SessionId session_id() const
    {
        return m_session_id;
    }

    /*!
     * @brief This function returns a reference to member session_id
     * @return Reference to member session_id
     */
    inline SessionId& session_id()
    {
        return m_session_id;
    }

    /*!
     * @brief This function sets a value in member properties
     * @param _properties New value for member properties
     */
    inline void properties(eprosima::Optional<PropertySeq> _properties)
    {
        m_properties = _properties;
    }

    /*!
     * @brief This function returns the value of member properties
     * @return Value of member properties
     */
    inline eprosima::Optional<PropertySeq> properties() const
    {
        return m_properties;
    }

    /*!
     * @brief This function returns a reference to member properties
     * @return Reference to member properties
     */
    inline eprosima::Optional<PropertySeq>& properties()
    {
        return m_properties;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
    
private:
    XrceCookie m_xrce_cookie;
    XrceVersion m_xrce_version;
    XrceVendorId m_xrce_vendor_id;
    Time_t m_client_timestamp;
    ClientKey m_client_key;
    SessionId m_session_id;
    eprosima::Optional<PropertySeq> m_properties;
};

/*!
 * @brief This class represents the structure AGENT_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class AGENT_Representation
{
public:

    /*!
     * @brief Default constructor.
     */
    AGENT_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~AGENT_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AGENT_Representation that will be copied.
     */
    AGENT_Representation(const AGENT_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object AGENT_Representation that will be copied.
     */
    AGENT_Representation(AGENT_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AGENT_Representation that will be copied.
     */
    AGENT_Representation& operator=(const AGENT_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object AGENT_Representation that will be copied.
     */
    AGENT_Representation& operator=(AGENT_Representation &&x);
    
    /*!
     * @brief This function copies the value in member xrce_cookie
     * @param _xrce_cookie New value to be copied in member xrce_cookie
     */
    inline void xrce_cookie(const XrceCookie &_xrce_cookie)
    {
        m_xrce_cookie = _xrce_cookie;
    }

    /*!
     * @brief This function moves the value in member xrce_cookie
     * @param _xrce_cookie New value to be moved in member xrce_cookie
     */
    inline void xrce_cookie(XrceCookie &&_xrce_cookie)
    {
        m_xrce_cookie = std::move(_xrce_cookie);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_cookie
     * @return Constant reference to member xrce_cookie
     */
    inline const XrceCookie& xrce_cookie() const
    {
        return m_xrce_cookie;
    }

    /*!
     * @brief This function returns a reference to member xrce_cookie
     * @return Reference to member xrce_cookie
     */
    inline XrceCookie& xrce_cookie()
    {
        return m_xrce_cookie;
    }
    /*!
     * @brief This function copies the value in member xrce_version
     * @param _xrce_version New value to be copied in member xrce_version
     */
    inline void xrce_version(const XrceVersion &_xrce_version)
    {
        m_xrce_version = _xrce_version;
    }

    /*!
     * @brief This function moves the value in member xrce_version
     * @param _xrce_version New value to be moved in member xrce_version
     */
    inline void xrce_version(XrceVersion &&_xrce_version)
    {
        m_xrce_version = std::move(_xrce_version);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_version
     * @return Constant reference to member xrce_version
     */
    inline const XrceVersion& xrce_version() const
    {
        return m_xrce_version;
    }

    /*!
     * @brief This function returns a reference to member xrce_version
     * @return Reference to member xrce_version
     */
    inline XrceVersion& xrce_version()
    {
        return m_xrce_version;
    }
    /*!
     * @brief This function copies the value in member xrce_vendor_id
     * @param _xrce_vendor_id New value to be copied in member xrce_vendor_id
     */
    inline void xrce_vendor_id(const XrceVendorId &_xrce_vendor_id)
    {
        m_xrce_vendor_id = _xrce_vendor_id;
    }

    /*!
     * @brief This function moves the value in member xrce_vendor_id
     * @param _xrce_vendor_id New value to be moved in member xrce_vendor_id
     */
    inline void xrce_vendor_id(XrceVendorId &&_xrce_vendor_id)
    {
        m_xrce_vendor_id = std::move(_xrce_vendor_id);
    }

    /*!
     * @brief This function returns a constant reference to member xrce_vendor_id
     * @return Constant reference to member xrce_vendor_id
     */
    inline const XrceVendorId& xrce_vendor_id() const
    {
        return m_xrce_vendor_id;
    }

    /*!
     * @brief This function returns a reference to member xrce_vendor_id
     * @return Reference to member xrce_vendor_id
     */
    inline XrceVendorId& xrce_vendor_id()
    {
        return m_xrce_vendor_id;
    }

    /*!
     * @brief This function copies the value in member agent_timestamp
     * @param _agent_timestamp New value to be copied in member agent_timestamp
     */
    inline void agent_timestamp(const Time_t &_agent_timestamp)
    {
        m_agent_timestamp = _agent_timestamp;
    }

    /*!
     * @brief This function moves the value in member agent_timestamp
     * @param _agent_timestamp New value to be moved in member agent_timestamp
     */
    inline void agent_timestamp(Time_t &&_agent_timestamp)
    {
        m_agent_timestamp = std::move(_agent_timestamp);
    }

    /*!
     * @brief This function returns a constant reference to member agent_timestamp
     * @return Constant reference to member agent_timestamp
     */
    inline const Time_t& agent_timestamp() const
    {
        return m_agent_timestamp;
    }

    /*!
     * @brief This function returns a reference to member agent_timestamp
     * @return Reference to member agent_timestamp
     */
    inline Time_t& agent_timestamp()
    {
        return m_agent_timestamp;
    }

    /*!
     * @brief This function sets a value in member properties
     * @param _properties New value for member properties
     */
    inline void properties(eprosima::Optional<PropertySeq> _properties)
    {
        m_properties = _properties;
    }

    /*!
     * @brief This function returns the value of member properties
     * @return Value of member properties
     */
    inline eprosima::Optional<PropertySeq> properties() const
    {
        return m_properties;
    }

    /*!
     * @brief This function returns a reference to member properties
     * @return Reference to member properties
     */
    inline eprosima::Optional<PropertySeq>& properties()
    {
        return m_properties;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    XrceCookie m_xrce_cookie;
    XrceVersion m_xrce_version;
    XrceVendorId m_xrce_vendor_id;
    Time_t m_agent_timestamp;
    eprosima::Optional<PropertySeq> m_properties;
};

typedef uint8_t RepresentationFormat;

const RepresentationFormat REPRESENTATION_BY_REFERENCE  = 0x01;
const RepresentationFormat REPRESENTATION_AS_XML_STRING = 0x02;
const RepresentationFormat REPRESENTATION_IN_BINARY     = 0x03;
const int32_t REFERENCE_MAX_LEN = 128;

/*!
 * @brief This class represents the union OBJK_Representation3Formats defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Representation3Formats
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Representation3Formats();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Representation3Formats();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Representation3Formats that will be copied.
     */
    OBJK_Representation3Formats(const OBJK_Representation3Formats &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Representation3Formats that will be copied.
     */
    OBJK_Representation3Formats(OBJK_Representation3Formats &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Representation3Formats that will be copied.
     */
    OBJK_Representation3Formats& operator=(const OBJK_Representation3Formats &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Representation3Formats that will be copied.
     */
    OBJK_Representation3Formats& operator=(OBJK_Representation3Formats &&x);
    
    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(RepresentationFormat __d);
    
    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    RepresentationFormat _d() const;
    
    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    RepresentationFormat& _d();
    
    /*!
     * @brief This function copies the value in member object_reference
     * @param _object_reference New value to be copied in member object_reference
     */
    void object_reference(const std::string &_object_reference);

    /*!
     * @brief This function moves the value in member object_reference
     * @param _object_reference New value to be moved in member object_reference
     */
    void object_reference(std::string &&_object_reference);

    /*!
     * @brief This function returns a constant reference to member object_reference
     * @return Constant reference to member object_reference
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::string& object_reference() const;

    /*!
     * @brief This function returns a reference to member object_reference
     * @return Reference to member object_reference
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::string& object_reference();
    /*!
     * @brief This function copies the value in member xml_string_representation
     * @param _xml_string_representation New value to be copied in member xml_string_representation
     */
    void xml_string_representation(const std::string &_xml_string_representation);

    /*!
     * @brief This function moves the value in member xml_string_representation
     * @param _xml_string_representation New value to be moved in member xml_string_representation
     */
    void xml_string_representation(std::string &&_xml_string_representation);

    /*!
     * @brief This function returns a constant reference to member xml_string_representation
     * @return Constant reference to member xml_string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::string& xml_string_representation() const;

    /*!
     * @brief This function returns a reference to member xml_string_representation
     * @return Reference to member xml_string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */

    std::string& xml_string_representation();
    /*!
     * @brief This function copies the value in member binary_representation
     * @param _binary_representation New value to be copied in member binary_representation
     */

    void binary_representation(const std::vector<uint8_t> &_binary_representation);

    /*!
     * @brief This function moves the value in member binary_representation
     * @param _binary_representation New value to be moved in member binary_representation
     */
    void binary_representation(std::vector<uint8_t> &&_binary_representation);

    /*!
     * @brief This function returns a constant reference to member binary_representation
     * @return Constant reference to member binary_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::vector<uint8_t>& binary_representation() const;

    /*!
     * @brief This function returns a reference to member binary_representation
     * @return Reference to member binary_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::vector<uint8_t>& binary_representation();
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
    
private:
    RepresentationFormat m__d;
    
    std::string m_object_reference;
    std::string m_xml_string_representation;
    std::vector<uint8_t> m_binary_representation;
};

/*!
 * @brief This class represents the union OBJK_RepresentationRefAndXMLFormats defined by the user in the IDL file.
 * @ingroup TEMPV4
 */
class OBJK_RepresentationRefAndXMLFormats
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_RepresentationRefAndXMLFormats();

    /*!
     * @brief Default destructor.
     */
    ~OBJK_RepresentationRefAndXMLFormats();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_RepresentationRefAndXMLFormats that will be copied.
     */
    OBJK_RepresentationRefAndXMLFormats(const OBJK_RepresentationRefAndXMLFormats &x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_RepresentationRefAndXMLFormats that will be copied.
     */
    OBJK_RepresentationRefAndXMLFormats(OBJK_RepresentationRefAndXMLFormats &&x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_RepresentationRefAndXMLFormats that will be copied.
     */
    OBJK_RepresentationRefAndXMLFormats& operator=(const OBJK_RepresentationRefAndXMLFormats &x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_RepresentationRefAndXMLFormats that will be copied.
     */
    OBJK_RepresentationRefAndXMLFormats& operator=(OBJK_RepresentationRefAndXMLFormats &&x);

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(RepresentationFormat __d);

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    RepresentationFormat _d() const;

    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    RepresentationFormat& _d();

    /*!
     * @brief This function copies the value in member object_reference
     * @param _object_reference New value to be copied in member object_reference
     */
    void object_reference(const std::string &_object_reference);

    /*!
     * @brief This function moves the value in member object_reference
     * @param _object_reference New value to be moved in member object_reference
     */
    void object_reference(std::string &&_object_reference);

    /*!
     * @brief This function returns a constant reference to member object_reference
     * @return Constant reference to member object_reference
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::string& object_reference() const;

    /*!
     * @brief This function returns a reference to member object_reference
     * @return Reference to member object_reference
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::string& object_reference();
    /*!
     * @brief This function copies the value in member string_representation
     * @param _string_representation New value to be copied in member string_representation
     */
    void string_representation(const std::string &_string_representation);

    /*!
     * @brief This function moves the value in member string_representation
     * @param _string_representation New value to be moved in member string_representation
     */
    void string_representation(std::string &&_string_representation);

    /*!
     * @brief This function returns a constant reference to member string_representation
     * @return Constant reference to member string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::string& string_representation() const;

    /*!
     * @brief This function returns a reference to member string_representation
     * @return Reference to member string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::string& string_representation();

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void deserialize(eprosima::fastcdr::Cdr &cdr);
private:
    RepresentationFormat m__d;

    std::string m_object_reference;
    std::string m_string_representation;
};

/*!
 * @brief This class represents the union OBJK_RepresentationBinAndXMLFormats defined by the user in the IDL file.
 * @ingroup TEMPV4
 */
class OBJK_RepresentationBinAndXMLFormats
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_RepresentationBinAndXMLFormats();

    /*!
     * @brief Default destructor.
     */
    ~OBJK_RepresentationBinAndXMLFormats();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_RepresentationBinAndXMLFormats that will be copied.
     */
    OBJK_RepresentationBinAndXMLFormats(const OBJK_RepresentationBinAndXMLFormats &x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_RepresentationBinAndXMLFormats that will be copied.
     */
    OBJK_RepresentationBinAndXMLFormats(OBJK_RepresentationBinAndXMLFormats &&x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_RepresentationBinAndXMLFormats that will be copied.
     */
    OBJK_RepresentationBinAndXMLFormats& operator=(const OBJK_RepresentationBinAndXMLFormats &x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_RepresentationBinAndXMLFormats that will be copied.
     */
    OBJK_RepresentationBinAndXMLFormats& operator=(OBJK_RepresentationBinAndXMLFormats &&x);

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(RepresentationFormat __d);

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    RepresentationFormat _d() const;

    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    RepresentationFormat& _d();

    /*!
     * @brief This function copies the value in member binary_representation
     * @param _binary_representation New value to be copied in member binary_representation
     */
    void binary_representation(const std::vector<uint8_t> &_binary_representation);

    /*!
     * @brief This function moves the value in member binary_representation
     * @param _binary_representation New value to be moved in member binary_representation
     */
    void binary_representation(std::vector<uint8_t> &&_binary_representation);

    /*!
     * @brief This function returns a constant reference to member binary_representation
     * @return Constant reference to member binary_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::vector<uint8_t>& binary_representation() const;

    /*!
     * @brief This function returns a reference to member binary_representation
     * @return Reference to member binary_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::vector<uint8_t>& binary_representation();
    /*!
     * @brief This function copies the value in member string_representation
     * @param _string_representation New value to be copied in member string_representation
     */
    void string_representation(const std::string &_string_representation);

    /*!
     * @brief This function moves the value in member string_representation
     * @param _string_representation New value to be moved in member string_representation
     */
    void string_representation(std::string &&_string_representation);

    /*!
     * @brief This function returns a constant reference to member string_representation
     * @return Constant reference to member string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const std::string& string_representation() const;

    /*!
     * @brief This function returns a reference to member string_representation
     * @return Reference to member string_representation
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    std::string& string_representation();

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    RepresentationFormat m__d;

    std::vector<uint8_t> m_binary_representation;
    std::string m_string_representation;
};

/*!
 * @brief This class represents the structure OBJK_RepresentationRefAndXML_Base defined by the user in the IDL file.
 * @ingroup TEMPV4
 */
class OBJK_RepresentationRefAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_RepresentationRefAndXML_Base();

    /*!
     * @brief Default destructor.
     */
    ~OBJK_RepresentationRefAndXML_Base();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_RepresentationRefAndXML_Base that will be copied.
     */
    OBJK_RepresentationRefAndXML_Base(const OBJK_RepresentationRefAndXML_Base &x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_RepresentationRefAndXML_Base that will be copied.
     */
    OBJK_RepresentationRefAndXML_Base(OBJK_RepresentationRefAndXML_Base &&x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_RepresentationRefAndXML_Base that will be copied.
     */
    OBJK_RepresentationRefAndXML_Base& operator=(const OBJK_RepresentationRefAndXML_Base &x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_RepresentationRefAndXML_Base that will be copied.
     */
    OBJK_RepresentationRefAndXML_Base& operator=(OBJK_RepresentationRefAndXML_Base &&x);

    /*!
     * @brief This function copies the value in member representation
     * @param _representation New value to be copied in member representation
     */
    inline void representation(const OBJK_RepresentationRefAndXMLFormats &_representation)
    {
        m_representation = _representation;
    }

    /*!
     * @brief This function moves the value in member representation
     * @param _representation New value to be moved in member representation
     */
    inline void representation(OBJK_RepresentationRefAndXMLFormats &&_representation)
    {
        m_representation = std::move(_representation);
    }

    /*!
     * @brief This function returns a constant reference to member representation
     * @return Constant reference to member representation
     */
    inline const OBJK_RepresentationRefAndXMLFormats& representation() const
    {
        return m_representation;
    }

    /*!
     * @brief This function returns a reference to member representation
     * @return Reference to member representation
     */
    inline OBJK_RepresentationRefAndXMLFormats& representation()
    {
        return m_representation;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
     virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void deserialize(eprosima::fastcdr::Cdr &cdr);



    /*!
     * @brief This function returns the maximum serialized size of the Key of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getKeyMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function tells you if the Key has been defined for this type
     */
    static bool isKeyDefined();

    /*!
     * @brief This function serializes the key members of an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void serializeKey(eprosima::fastcdr::Cdr &cdr) const;

private:
    OBJK_RepresentationRefAndXMLFormats m_representation;
};
/*!
 * @brief This class represents the structure OBJK_RepresentationBinAndXML_Base defined by the user in the IDL file.
 * @ingroup TEMPV4
 */
class OBJK_RepresentationBinAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_RepresentationBinAndXML_Base();

    /*!
     * @brief Default destructor.
     */
    ~OBJK_RepresentationBinAndXML_Base();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_RepresentationBinAndXML_Base that will be copied.
     */
    OBJK_RepresentationBinAndXML_Base(const OBJK_RepresentationBinAndXML_Base &x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_RepresentationBinAndXML_Base that will be copied.
     */
    OBJK_RepresentationBinAndXML_Base(OBJK_RepresentationBinAndXML_Base &&x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_RepresentationBinAndXML_Base that will be copied.
     */
    OBJK_RepresentationBinAndXML_Base& operator=(const OBJK_RepresentationBinAndXML_Base &x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_RepresentationBinAndXML_Base that will be copied.
     */
    OBJK_RepresentationBinAndXML_Base& operator=(OBJK_RepresentationBinAndXML_Base &&x);

    /*!
     * @brief This function copies the value in member representation
     * @param _representation New value to be copied in member representation
     */
    inline void representation(const OBJK_RepresentationBinAndXMLFormats &_representation)
    {
        m_representation = _representation;
    }

    /*!
     * @brief This function moves the value in member representation
     * @param _representation New value to be moved in member representation
     */
    inline void representation(OBJK_RepresentationBinAndXMLFormats &&_representation)
    {
        m_representation = std::move(_representation);
    }

    /*!
     * @brief This function returns a constant reference to member representation
     * @return Constant reference to member representation
     */
    inline const OBJK_RepresentationBinAndXMLFormats& representation() const
    {
        return m_representation;
    }

    /*!
     * @brief This function returns a reference to member representation
     * @return Reference to member representation
     */
    inline OBJK_RepresentationBinAndXMLFormats& representation()
    {
        return m_representation;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    OBJK_RepresentationBinAndXMLFormats m_representation;
};

/*!
 * @brief This class represents the structure OBJK_Representation3_Base defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Representation3_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Representation3_Base();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Representation3_Base();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Representation3_Base that will be copied.
     */
    OBJK_Representation3_Base(const OBJK_Representation3_Base &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Representation3_Base that will be copied.
     */
    OBJK_Representation3_Base(OBJK_Representation3_Base &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Representation3_Base that will be copied.
     */
    OBJK_Representation3_Base& operator=(const OBJK_Representation3_Base &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Representation3_Base that will be copied.
     */
    OBJK_Representation3_Base& operator=(OBJK_Representation3_Base &&x);
    
    /*!
     * @brief This function copies the value in member representation
     * @param _representation New value to be copied in member representation
     */
    inline void representation(const OBJK_Representation3Formats &_representation)
    {
        m_representation = _representation;
    }

    /*!
     * @brief This function moves the value in member representation
     * @param _representation New value to be moved in member representation
     */
    inline void representation(OBJK_Representation3Formats &&_representation)
    {
        m_representation = std::move(_representation);
    }

    /*!
     * @brief This function returns a constant reference to member representation
     * @return Constant reference to member representation
     */
    inline const OBJK_Representation3Formats& representation() const
    {
        return m_representation;
    }

    /*!
     * @brief This function returns a reference to member representation
     * @return Reference to member representation
     */
    inline OBJK_Representation3Formats& representation()
    {
        return m_representation;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    OBJK_Representation3Formats m_representation;
};

/*!
 * @brief This class represents the structure OBJK_QOSPROFILE_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_QOSPROFILE_Representation : public OBJK_RepresentationRefAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_QOSPROFILE_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_QOSPROFILE_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_QOSPROFILE_Representation that will be copied.
     */
    OBJK_QOSPROFILE_Representation(const OBJK_QOSPROFILE_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_QOSPROFILE_Representation that will be copied.
     */
    OBJK_QOSPROFILE_Representation(OBJK_QOSPROFILE_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_QOSPROFILE_Representation that will be copied.
     */
    OBJK_QOSPROFILE_Representation& operator=(const OBJK_QOSPROFILE_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_QOSPROFILE_Representation that will be copied.
     */
    OBJK_QOSPROFILE_Representation& operator=(OBJK_QOSPROFILE_Representation &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};

/*!
 * @brief This class represents the structure OBJK_TYPE_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_TYPE_Representation : public OBJK_RepresentationRefAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_TYPE_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_TYPE_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_TYPE_Representation that will be copied.
     */
    OBJK_TYPE_Representation(const OBJK_TYPE_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_TYPE_Representation that will be copied.
     */
    OBJK_TYPE_Representation(OBJK_TYPE_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_TYPE_Representation that will be copied.
     */
    OBJK_TYPE_Representation& operator=(const OBJK_TYPE_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_TYPE_Representation that will be copied.
     */
    OBJK_TYPE_Representation& operator=(OBJK_TYPE_Representation &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};

/*!
 * @brief This class represents the structure OBJK_DOMAIN_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_DOMAIN_Representation : public OBJK_RepresentationRefAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_DOMAIN_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_DOMAIN_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_DOMAIN_Representation that will be copied.
     */
    OBJK_DOMAIN_Representation(const OBJK_DOMAIN_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_DOMAIN_Representation that will be copied.
     */
    OBJK_DOMAIN_Representation(OBJK_DOMAIN_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_DOMAIN_Representation that will be copied.
     */
    OBJK_DOMAIN_Representation& operator=(const OBJK_DOMAIN_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_DOMAIN_Representation that will be copied.
     */
    OBJK_DOMAIN_Representation& operator=(OBJK_DOMAIN_Representation &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};

/*!
 * @brief This class represents the structure OBJK_APPLICATION_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_APPLICATION_Representation : public OBJK_RepresentationRefAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_APPLICATION_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_APPLICATION_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_APPLICATION_Representation that will be copied.
     */
    OBJK_APPLICATION_Representation(const OBJK_APPLICATION_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_APPLICATION_Representation that will be copied.
     */
    OBJK_APPLICATION_Representation(OBJK_APPLICATION_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_APPLICATION_Representation that will be copied.
     */
    OBJK_APPLICATION_Representation& operator=(const OBJK_APPLICATION_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_APPLICATION_Representation that will be copied.
     */
    OBJK_APPLICATION_Representation& operator=(OBJK_APPLICATION_Representation &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};

/*!
 * @brief This class represents the structure OBJK_PARTICIPANT_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_PARTICIPANT_Representation : public OBJK_Representation3_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_PARTICIPANT_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_PARTICIPANT_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_PARTICIPANT_Representation that will be copied.
     */
    OBJK_PARTICIPANT_Representation(const OBJK_PARTICIPANT_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_PARTICIPANT_Representation that will be copied.
     */
    OBJK_PARTICIPANT_Representation(OBJK_PARTICIPANT_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_PARTICIPANT_Representation that will be copied.
     */
    OBJK_PARTICIPANT_Representation& operator=(const OBJK_PARTICIPANT_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_PARTICIPANT_Representation that will be copied.
     */
    OBJK_PARTICIPANT_Representation& operator=(OBJK_PARTICIPANT_Representation &&x);

    /*!
     * @brief This function sets a value in member availability
     * @param _domain_id New value for member domain_id
     */
    inline void domain_id(int16_t _domain_id)
    {
        m_domain_id = _domain_id;
    }

    /*!
     * @brief This function returns the value of member domain_id
     * @return Value of member domain_id
     */
    inline int16_t domain_id() const
    {
        return m_domain_id;
    }

    /*!
     * @brief This function returns a reference to member domain_id
     * @return Reference to member domain_id
     */
    inline int16_t& domain_id()
    {
        return m_domain_id;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    int16_t m_domain_id;
};

/*!
 * @brief This class represents the structure OBJK_TOPIC_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_TOPIC_Representation : public OBJK_Representation3_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_TOPIC_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_TOPIC_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_TOPIC_Representation that will be copied.
     */
    OBJK_TOPIC_Representation(const OBJK_TOPIC_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_TOPIC_Representation that will be copied.
     */
    OBJK_TOPIC_Representation(OBJK_TOPIC_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_TOPIC_Representation that will be copied.
     */
    OBJK_TOPIC_Representation& operator=(const OBJK_TOPIC_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_TOPIC_Representation that will be copied.
     */
    OBJK_TOPIC_Representation& operator=(OBJK_TOPIC_Representation &&x);
    
    /*!
     * @brief This function copies the value in member participant_id
     * @param _participant_id New value to be copied in member participant_id
     */
    inline void participant_id(const ObjectId &_participant_id)
    {
        m_participant_id = _participant_id;
    }

    /*!
     * @brief This function moves the value in member participant_id
     * @param _participant_id New value to be moved in member participant_id
     */
    inline void participant_id(ObjectId &&_participant_id)
    {
        m_participant_id = std::move(_participant_id);
    }

    /*!
     * @brief This function returns a constant reference to member participant_id
     * @return Constant reference to member participant_id
     */
    inline const ObjectId& participant_id() const
    {
        return m_participant_id;
    }

    /*!
     * @brief This function returns a reference to member participant_id
     * @return Reference to member participant_id
     */
    inline ObjectId& participant_id()
    {
        return m_participant_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectId m_participant_id;
};

/*!
 * @brief This class represents the structure OBJK_PUBLISHER_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_PUBLISHER_Representation : public OBJK_RepresentationBinAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_PUBLISHER_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_PUBLISHER_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_PUBLISHER_Representation that will be copied.
     */
    OBJK_PUBLISHER_Representation(const OBJK_PUBLISHER_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_PUBLISHER_Representation that will be copied.
     */
    OBJK_PUBLISHER_Representation(OBJK_PUBLISHER_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_PUBLISHER_Representation that will be copied.
     */
    OBJK_PUBLISHER_Representation& operator=(const OBJK_PUBLISHER_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_PUBLISHER_Representation that will be copied.
     */
    OBJK_PUBLISHER_Representation& operator=(OBJK_PUBLISHER_Representation &&x);
    
    /*!
     * @brief This function copies the value in member participant_id
     * @param _participant_id New value to be copied in member participant_id
     */
    inline void participant_id(const ObjectId &_participant_id)
    {
        m_participant_id = _participant_id;
    }

    /*!
     * @brief This function moves the value in member participant_id
     * @param _participant_id New value to be moved in member participant_id
     */
    inline void participant_id(ObjectId &&_participant_id)
    {
        m_participant_id = std::move(_participant_id);
    }

    /*!
     * @brief This function returns a constant reference to member participant_id
     * @return Constant reference to member participant_id
     */
    inline const ObjectId& participant_id() const
    {
        return m_participant_id;
    }

    /*!
     * @brief This function returns a reference to member participant_id
     * @return Reference to member participant_id
     */
    inline ObjectId& participant_id()
    {
        return m_participant_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectId m_participant_id;
};

/*!
 * @brief This class represents the structure OBJK_SUBSCRIBER_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_SUBSCRIBER_Representation : public OBJK_RepresentationBinAndXML_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_SUBSCRIBER_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_SUBSCRIBER_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_SUBSCRIBER_Representation that will be copied.
     */
    OBJK_SUBSCRIBER_Representation(const OBJK_SUBSCRIBER_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_SUBSCRIBER_Representation that will be copied.
     */
    OBJK_SUBSCRIBER_Representation(OBJK_SUBSCRIBER_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_SUBSCRIBER_Representation that will be copied.
     */
    OBJK_SUBSCRIBER_Representation& operator=(const OBJK_SUBSCRIBER_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_SUBSCRIBER_Representation that will be copied.
     */
    OBJK_SUBSCRIBER_Representation& operator=(OBJK_SUBSCRIBER_Representation &&x);
    
    /*!
     * @brief This function copies the value in member participant_id
     * @param _participant_id New value to be copied in member participant_id
     */
    inline void participant_id(const ObjectId &_participant_id)
    {
        m_participant_id = _participant_id;
    }

    /*!
     * @brief This function moves the value in member participant_id
     * @param _participant_id New value to be moved in member participant_id
     */
    inline void participant_id(ObjectId &&_participant_id)
    {
        m_participant_id = std::move(_participant_id);
    }

    /*!
     * @brief This function returns a constant reference to member participant_id
     * @return Constant reference to member participant_id
     */
    inline const ObjectId& participant_id() const
    {
        return m_participant_id;
    }

    /*!
     * @brief This function returns a reference to member participant_id
     * @return Reference to member participant_id
     */
    inline ObjectId& participant_id()
    {
        return m_participant_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectId m_participant_id;
};
/*!
 * @brief This class represents the structure DATAWRITER_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATAWRITER_Representation : public OBJK_Representation3_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    DATAWRITER_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~DATAWRITER_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATAWRITER_Representation that will be copied.
     */
    DATAWRITER_Representation(const DATAWRITER_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATAWRITER_Representation that will be copied.
     */
    DATAWRITER_Representation(DATAWRITER_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATAWRITER_Representation that will be copied.
     */
    DATAWRITER_Representation& operator=(const DATAWRITER_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATAWRITER_Representation that will be copied.
     */
    DATAWRITER_Representation& operator=(DATAWRITER_Representation &&x);
    
    /*!
     * @brief This function copies the value in member publisher_id
     * @param _publisher_id New value to be copied in member publisher_id
     */
    inline void publisher_id(const ObjectId &_publisher_id)
    {
        m_publisher_id = _publisher_id;
    }

    /*!
     * @brief This function moves the value in member publisher_id
     * @param _publisher_id New value to be moved in member publisher_id
     */
    inline void publisher_id(ObjectId &&_publisher_id)
    {
        m_publisher_id = std::move(_publisher_id);
    }

    /*!
     * @brief This function returns a constant reference to member publisher_id
     * @return Constant reference to member publisher_id
     */
    inline const ObjectId& publisher_id() const
    {
        return m_publisher_id;
    }

    /*!
     * @brief This function returns a reference to member publisher_id
     * @return Reference to member publisher_id
     */
    inline ObjectId& publisher_id()
    {
        return m_publisher_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectId m_publisher_id;
};

/*!
 * @brief This class represents the structure DATAREADER_Representation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATAREADER_Representation : public OBJK_Representation3_Base
{
public:

    /*!
     * @brief Default constructor.
     */
    DATAREADER_Representation();
    
    /*!
     * @brief Default destructor.
     */
    ~DATAREADER_Representation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATAREADER_Representation that will be copied.
     */
    DATAREADER_Representation(const DATAREADER_Representation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATAREADER_Representation that will be copied.
     */
    DATAREADER_Representation(DATAREADER_Representation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATAREADER_Representation that will be copied.
     */
    DATAREADER_Representation& operator=(const DATAREADER_Representation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATAREADER_Representation that will be copied.
     */
    DATAREADER_Representation& operator=(DATAREADER_Representation &&x);
    
    /*!
     * @brief This function copies the value in member subscriber_id
     * @param _subscriber_id New value to be copied in member subscriber_id
     */
    inline void subscriber_id(const ObjectId &_subscriber_id)
    {
        m_subscriber_id = _subscriber_id;
    }

    /*!
     * @brief This function moves the value in member subscriber_id
     * @param _subscriber_id New value to be moved in member subscriber_id
     */
    inline void subscriber_id(ObjectId &&_subscriber_id)
    {
        m_subscriber_id = std::move(_subscriber_id);
    }

    /*!
     * @brief This function returns a constant reference to member subscriber_id
     * @return Constant reference to member subscriber_id
     */
    inline const ObjectId& subscriber_id() const
    {
        return m_subscriber_id;
    }

    /*!
     * @brief This function returns a reference to member subscriber_id
     * @return Reference to member subscriber_id
     */
    inline ObjectId& subscriber_id()
    {
        return m_subscriber_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectId m_subscriber_id;
};

/*!
 * @brief This class represents the structure OBJK_DomainParticipant_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_DomainParticipant_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_DomainParticipant_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_DomainParticipant_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_DomainParticipant_Binary that will be copied.
     */
    OBJK_DomainParticipant_Binary(const OBJK_DomainParticipant_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_DomainParticipant_Binary that will be copied.
     */
    OBJK_DomainParticipant_Binary(OBJK_DomainParticipant_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_DomainParticipant_Binary that will be copied.
     */
    OBJK_DomainParticipant_Binary& operator=(const OBJK_DomainParticipant_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_DomainParticipant_Binary that will be copied.
     */
    OBJK_DomainParticipant_Binary& operator=(OBJK_DomainParticipant_Binary &&x);
    
    /*!
     * @brief This function sets a value in member domain_id
     * @param _domain_id New value for member domain_id
     */
    inline void domain_id(int32_t _domain_id)
    {
        m_domain_id = _domain_id;
    }

    /*!
     * @brief This function returns the value of member domain_id
     * @return Value of member domain_id
     */
    inline int32_t domain_id() const
    {
        return m_domain_id;
    }

    /*!
     * @brief This function returns a reference to member domain_id
     * @return Reference to member domain_id
     */
    inline int32_t& domain_id()
    {
        return m_domain_id;
    }
    /*!
     * @brief This function copies the value in member domain_referente
     * @param _domain_referente New value to be copied in member domain_referente
     */
    inline void domain_referente(const std::string &_domain_referente)
    {
        m_domain_referente = _domain_referente;
    }

    /*!
     * @brief This function moves the value in member domain_referente
     * @param _domain_referente New value to be moved in member domain_referente
     */
    inline void domain_referente(std::string &&_domain_referente)
    {
        m_domain_referente = std::move(_domain_referente);
    }

    /*!
     * @brief This function returns a constant reference to member domain_referente
     * @return Constant reference to member domain_referente
     */
    inline const std::string& domain_referente() const
    {
        return m_domain_referente;
    }

    /*!
     * @brief This function returns a reference to member domain_referente
     * @return Reference to member domain_referente
     */
    inline std::string& domain_referente()
    {
        return m_domain_referente;
    }
    /*!
     * @brief This function copies the value in member qos_profile
     * @param _qos_profile New value to be copied in member qos_profile
     */
    inline void qos_profile(const std::string &_qos_profile)
    {
        m_qos_profile = _qos_profile;
    }

    /*!
     * @brief This function moves the value in member qos_profile
     * @param _qos_profile New value to be moved in member qos_profile
     */
    inline void qos_profile(std::string &&_qos_profile)
    {
        m_qos_profile = std::move(_qos_profile);
    }

    /*!
     * @brief This function returns a constant reference to member qos_profile
     * @return Constant reference to member qos_profile
     */
    inline const std::string& qos_profile() const
    {
        return m_qos_profile;
    }

    /*!
     * @brief This function returns a reference to member qos_profile
     * @return Reference to member qos_profile
     */
    inline std::string& qos_profile()
    {
        return m_qos_profile;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    int32_t m_domain_id;
    std::string m_domain_referente;
    std::string m_qos_profile;
};
/*!
 * @brief This class represents the structure OBJK_Topic_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Topic_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Topic_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Topic_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Topic_Binary that will be copied.
     */
    OBJK_Topic_Binary(const OBJK_Topic_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Topic_Binary that will be copied.
     */
    OBJK_Topic_Binary(OBJK_Topic_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Topic_Binary that will be copied.
     */
    OBJK_Topic_Binary& operator=(const OBJK_Topic_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Topic_Binary that will be copied.
     */
    OBJK_Topic_Binary& operator=(OBJK_Topic_Binary &&x);
    
    /*!
     * @brief This function copies the value in member topic_name
     * @param _topic_name New value to be copied in member topic_name
     */
    inline void topic_name(const std::string &_topic_name)
    {
        m_topic_name = _topic_name;
    }

    /*!
     * @brief This function moves the value in member topic_name
     * @param _topic_name New value to be moved in member topic_name
     */
    inline void topic_name(std::string &&_topic_name)
    {
        m_topic_name = std::move(_topic_name);
    }

    /*!
     * @brief This function returns a constant reference to member topic_name
     * @return Constant reference to member topic_name
     */
    inline const std::string& topic_name() const
    {
        return m_topic_name;
    }

    /*!
     * @brief This function returns a reference to member topic_name
     * @return Reference to member topic_name
     */
    inline std::string& topic_name()
    {
        return m_topic_name;
    }
    /*!
     * @brief This function copies the value in member type_name
     * @param _type_name New value to be copied in member type_name
     */
    inline void type_name(const std::string &_type_name)
    {
        m_type_name = _type_name;
    }

    /*!
     * @brief This function moves the value in member type_name
     * @param _type_name New value to be moved in member type_name
     */
    inline void type_name(std::string &&_type_name)
    {
        m_type_name = std::move(_type_name);
    }

    /*!
     * @brief This function returns a constant reference to member type_name
     * @return Constant reference to member type_name
     */
    inline const std::string& type_name() const
    {
        return m_type_name;
    }

    /*!
     * @brief This function returns a reference to member type_name
     * @return Reference to member type_name
     */
    inline std::string& type_name()
    {
        return m_type_name;
    }
    /*!
     * @brief This function copies the value in member type_identifier
     * @param _type_identifier New value to be copied in member type_identifier
     */
    inline void type_identifier(const std::string &_type_identifier)
    {
        m_type_identifier = _type_identifier;
    }

    /*!
     * @brief This function moves the value in member type_identifier
     * @param _type_identifier New value to be moved in member type_identifier
     */
    inline void type_identifier(std::string &&_type_identifier)
    {
        m_type_identifier = std::move(_type_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member type_identifier
     * @return Constant reference to member type_identifier
     */
    inline const std::string& type_identifier() const
    {
        return m_type_identifier;
    }

    /*!
     * @brief This function returns a reference to member type_identifier
     * @return Reference to member type_identifier
     */
    inline std::string& type_identifier()
    {
        return m_type_identifier;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_topic_name;
    std::string m_type_name;
    std::string m_type_identifier;
};
/*!
 * @brief This class represents the structure OBJK_PUBLISHER_QosBinary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_PUBLISHER_QosBinary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_PUBLISHER_QosBinary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_PUBLISHER_QosBinary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_PUBLISHER_QosBinary that will be copied.
     */
    OBJK_PUBLISHER_QosBinary(const OBJK_PUBLISHER_QosBinary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_PUBLISHER_QosBinary that will be copied.
     */
    OBJK_PUBLISHER_QosBinary(OBJK_PUBLISHER_QosBinary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_PUBLISHER_QosBinary that will be copied.
     */
    OBJK_PUBLISHER_QosBinary& operator=(const OBJK_PUBLISHER_QosBinary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_PUBLISHER_QosBinary that will be copied.
     */
    OBJK_PUBLISHER_QosBinary& operator=(OBJK_PUBLISHER_QosBinary &&x);
    
    /*!
     * @brief This function copies the value in member partitions
     * @param _partitions New value to be copied in member partitions
     */
    inline void partitions(const std::vector<std::string> &_partitions)
    {
        m_partitions = _partitions;
    }

    /*!
     * @brief This function moves the value in member partitions
     * @param _partitions New value to be moved in member partitions
     */
    inline void partitions(std::vector<std::string> &&_partitions)
    {
        m_partitions = std::move(_partitions);
    }

    /*!
     * @brief This function returns a constant reference to member partitions
     * @return Constant reference to member partitions
     */
    inline const std::vector<std::string>& partitions() const
    {
        return m_partitions;
    }

    /*!
     * @brief This function returns a reference to member partitions
     * @return Reference to member partitions
     */
    inline std::vector<std::string>& partitions()
    {
        return m_partitions;
    }
    /*!
     * @brief This function copies the value in member group_data
     * @param _group_data New value to be copied in member group_data
     */
    inline void group_data(const std::vector<std::string> &_group_data)
    {
        m_group_data = _group_data;
    }

    /*!
     * @brief This function moves the value in member group_data
     * @param _group_data New value to be moved in member group_data
     */
    inline void group_data(std::vector<std::string> &&_group_data)
    {
        m_group_data = std::move(_group_data);
    }

    /*!
     * @brief This function returns a constant reference to member group_data
     * @return Constant reference to member group_data
     */
    inline const std::vector<std::string>& group_data() const
    {
        return m_group_data;
    }

    /*!
     * @brief This function returns a reference to member group_data
     * @return Reference to member group_data
     */
    inline std::vector<std::string>& group_data()
    {
        return m_group_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<std::string> m_partitions;
    std::vector<std::string> m_group_data;
};
/*!
 * @brief This class represents the structure OBJK_Publisher_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Publisher_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Publisher_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Publisher_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Publisher_Binary that will be copied.
     */
    OBJK_Publisher_Binary(const OBJK_Publisher_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Publisher_Binary that will be copied.
     */
    OBJK_Publisher_Binary(OBJK_Publisher_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Publisher_Binary that will be copied.
     */
    OBJK_Publisher_Binary& operator=(const OBJK_Publisher_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Publisher_Binary that will be copied.
     */
    OBJK_Publisher_Binary& operator=(OBJK_Publisher_Binary &&x);
    
    /*!
     * @brief This function copies the value in member publisher_name
     * @param _publisher_name New value to be copied in member publisher_name
     */
    inline void publisher_name(const std::string &_publisher_name)
    {
        m_publisher_name = _publisher_name;
    }

    /*!
     * @brief This function moves the value in member publisher_name
     * @param _publisher_name New value to be moved in member publisher_name
     */
    inline void publisher_name(std::string &&_publisher_name)
    {
        m_publisher_name = std::move(_publisher_name);
    }

    /*!
     * @brief This function returns a constant reference to member publisher_name
     * @return Constant reference to member publisher_name
     */
    inline const std::string& publisher_name() const
    {
        return m_publisher_name;
    }

    /*!
     * @brief This function returns a reference to member publisher_name
     * @return Reference to member publisher_name
     */
    inline std::string& publisher_name()
    {
        return m_publisher_name;
    }
    /*!
     * @brief This function copies the value in member qos
     * @param _qos New value to be copied in member qos
     */
    inline void qos(const OBJK_PUBLISHER_QosBinary &_qos)
    {
        m_qos = _qos;
    }

    /*!
     * @brief This function moves the value in member qos
     * @param _qos New value to be moved in member qos
     */
    inline void qos(OBJK_PUBLISHER_QosBinary &&_qos)
    {
        m_qos = std::move(_qos);
    }

    /*!
     * @brief This function returns a constant reference to member qos
     * @return Constant reference to member qos
     */
    inline const OBJK_PUBLISHER_QosBinary& qos() const
    {
        return m_qos;
    }

    /*!
     * @brief This function returns a reference to member qos
     * @return Reference to member qos
     */
    inline OBJK_PUBLISHER_QosBinary& qos()
    {
        return m_qos;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_publisher_name;
    OBJK_PUBLISHER_QosBinary m_qos;
};
/*!
 * @brief This class represents the structure OBJK_SUBSCRIBER_QosBinary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_SUBSCRIBER_QosBinary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_SUBSCRIBER_QosBinary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_SUBSCRIBER_QosBinary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_SUBSCRIBER_QosBinary that will be copied.
     */
    OBJK_SUBSCRIBER_QosBinary(const OBJK_SUBSCRIBER_QosBinary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_SUBSCRIBER_QosBinary that will be copied.
     */
    OBJK_SUBSCRIBER_QosBinary(OBJK_SUBSCRIBER_QosBinary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_SUBSCRIBER_QosBinary that will be copied.
     */
    OBJK_SUBSCRIBER_QosBinary& operator=(const OBJK_SUBSCRIBER_QosBinary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_SUBSCRIBER_QosBinary that will be copied.
     */
    OBJK_SUBSCRIBER_QosBinary& operator=(OBJK_SUBSCRIBER_QosBinary &&x);
    
    /*!
     * @brief This function copies the value in member partitions
     * @param _partitions New value to be copied in member partitions
     */
    inline void partitions(const std::vector<std::string> &_partitions)
    {
        m_partitions = _partitions;
    }

    /*!
     * @brief This function moves the value in member partitions
     * @param _partitions New value to be moved in member partitions
     */
    inline void partitions(std::vector<std::string> &&_partitions)
    {
        m_partitions = std::move(_partitions);
    }

    /*!
     * @brief This function returns a constant reference to member partitions
     * @return Constant reference to member partitions
     */
    inline const std::vector<std::string>& partitions() const
    {
        return m_partitions;
    }

    /*!
     * @brief This function returns a reference to member partitions
     * @return Reference to member partitions
     */
    inline std::vector<std::string>& partitions()
    {
        return m_partitions;
    }
    /*!
     * @brief This function copies the value in member group_data
     * @param _group_data New value to be copied in member group_data
     */
    inline void group_data(const std::vector<uint8_t> &_group_data)
    {
        m_group_data = _group_data;
    }

    /*!
     * @brief This function moves the value in member group_data
     * @param _group_data New value to be moved in member group_data
     */
    inline void group_data(std::vector<uint8_t> &&_group_data)
    {
        m_group_data = std::move(_group_data);
    }

    /*!
     * @brief This function returns a constant reference to member group_data
     * @return Constant reference to member group_data
     */
    inline const std::vector<uint8_t>& group_data() const
    {
        return m_group_data;
    }

    /*!
     * @brief This function returns a reference to member group_data
     * @return Reference to member group_data
     */
    inline std::vector<uint8_t>& group_data()
    {
        return m_group_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<std::string> m_partitions;
    std::vector<uint8_t> m_group_data;
};
/*!
 * @brief This class represents the structure OBJK_Subscriber_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Subscriber_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Subscriber_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Subscriber_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Subscriber_Binary that will be copied.
     */
    OBJK_Subscriber_Binary(const OBJK_Subscriber_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Subscriber_Binary that will be copied.
     */
    OBJK_Subscriber_Binary(OBJK_Subscriber_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Subscriber_Binary that will be copied.
     */
    OBJK_Subscriber_Binary& operator=(const OBJK_Subscriber_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Subscriber_Binary that will be copied.
     */
    OBJK_Subscriber_Binary& operator=(OBJK_Subscriber_Binary &&x);
    
    /*!
     * @brief This function copies the value in member subscriber_name
     * @param _subscriber_name New value to be copied in member subscriber_name
     */
    inline void subscriber_name(const std::string &_subscriber_name)
    {
        m_subscriber_name = _subscriber_name;
    }

    /*!
     * @brief This function moves the value in member subscriber_name
     * @param _subscriber_name New value to be moved in member subscriber_name
     */
    inline void subscriber_name(std::string &&_subscriber_name)
    {
        m_subscriber_name = std::move(_subscriber_name);
    }

    /*!
     * @brief This function returns a constant reference to member subscriber_name
     * @return Constant reference to member subscriber_name
     */
    inline const std::string& subscriber_name() const
    {
        return m_subscriber_name;
    }

    /*!
     * @brief This function returns a reference to member subscriber_name
     * @return Reference to member subscriber_name
     */
    inline std::string& subscriber_name()
    {
        return m_subscriber_name;
    }
    /*!
     * @brief This function copies the value in member qos
     * @param _qos New value to be copied in member qos
     */
    inline void qos(const OBJK_SUBSCRIBER_QosBinary &_qos)
    {
        m_qos = _qos;
    }

    /*!
     * @brief This function moves the value in member qos
     * @param _qos New value to be moved in member qos
     */
    inline void qos(OBJK_SUBSCRIBER_QosBinary &&_qos)
    {
        m_qos = std::move(_qos);
    }

    /*!
     * @brief This function returns a constant reference to member qos
     * @return Constant reference to member qos
     */
    inline const OBJK_SUBSCRIBER_QosBinary& qos() const
    {
        return m_qos;
    }

    /*!
     * @brief This function returns a reference to member qos
     * @return Reference to member qos
     */
    inline OBJK_SUBSCRIBER_QosBinary& qos()
    {
        return m_qos;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_subscriber_name;
    OBJK_SUBSCRIBER_QosBinary m_qos;
};
/*!
 * @brief This class represents the enumeration EndpointQosFlags defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum EndpointQosFlags : uint16_t
{
    is_reliable						= 0x01 << 0,
    is_history_keep_last			= 0x01 << 1,
    is_ownership_exclusive			= 0x01 << 2,
    is_durability_transient_local	= 0x01 << 3,
    is_durability_transient			= 0x01 << 4,
    is_durability_persistent		= 0x01 << 5
};
/*!
 * @brief This class represents the structure OBJK_Endpoint_QosBinary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_Endpoint_QosBinary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_Endpoint_QosBinary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_Endpoint_QosBinary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_Endpoint_QosBinary that will be copied.
     */
    OBJK_Endpoint_QosBinary(const OBJK_Endpoint_QosBinary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_Endpoint_QosBinary that will be copied.
     */
    OBJK_Endpoint_QosBinary(OBJK_Endpoint_QosBinary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_Endpoint_QosBinary that will be copied.
     */
    OBJK_Endpoint_QosBinary& operator=(const OBJK_Endpoint_QosBinary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_Endpoint_QosBinary that will be copied.
     */
    OBJK_Endpoint_QosBinary& operator=(OBJK_Endpoint_QosBinary &&x);
    
    /*!
     * @brief This function sets a value in member qos_flags
     * @param _qos_flags New value for member qos_flags
     */
    inline void qos_flags(EndpointQosFlags _qos_flags)
    {
        m_qos_flags = _qos_flags;
    }

    /*!
     * @brief This function returns the value of member qos_flags
     * @return Value of member qos_flags
     */
    inline EndpointQosFlags qos_flags() const
    {
        return m_qos_flags;
    }

    /*!
     * @brief This function returns a reference to member qos_flags
     * @return Reference to member qos_flags
     */
    inline EndpointQosFlags& qos_flags()
    {
        return m_qos_flags;
    }
    /*!
     * @brief This function sets a value in member history_depth
     * @param _history_depth New value for member history_depth
     */
    inline void history_depth(uint16_t _history_depth)
    {
        m_history_depth = _history_depth;
    }

    /*!
     * @brief This function returns the value of member history_depth
     * @return Value of member history_depth
     */
    inline uint16_t history_depth() const
    {
        return m_history_depth;
    }

    /*!
     * @brief This function returns a reference to member history_depth
     * @return Reference to member history_depth
     */
    inline uint16_t& history_depth()
    {
        return m_history_depth;
    }
    /*!
     * @brief This function sets a value in member deadline_msec
     * @param _deadline_msec New value for member deadline_msec
     */
    inline void deadline_msec(uint32_t _deadline_msec)
    {
        m_deadline_msec = _deadline_msec;
    }

    /*!
     * @brief This function returns the value of member deadline_msec
     * @return Value of member deadline_msec
     */
    inline uint32_t deadline_msec() const
    {
        return m_deadline_msec;
    }

    /*!
     * @brief This function returns a reference to member deadline_msec
     * @return Reference to member deadline_msec
     */
    inline uint32_t& deadline_msec()
    {
        return m_deadline_msec;
    }
    /*!
     * @brief This function sets a value in member lifespan_msec
     * @param _lifespan_msec New value for member lifespan_msec
     */
    inline void lifespan_msec(uint32_t _lifespan_msec)
    {
        m_lifespan_msec = _lifespan_msec;
    }

    /*!
     * @brief This function returns the value of member lifespan_msec
     * @return Value of member lifespan_msec
     */
    inline uint32_t lifespan_msec() const
    {
        return m_lifespan_msec;
    }

    /*!
     * @brief This function returns a reference to member lifespan_msec
     * @return Reference to member lifespan_msec
     */
    inline uint32_t& lifespan_msec()
    {
        return m_lifespan_msec;
    }
    /*!
     * @brief This function copies the value in member user_data
     * @param _user_data New value to be copied in member user_data
     */
    inline void user_data(const std::vector<uint8_t> &_user_data)
    {
        m_user_data = _user_data;
    }

    /*!
     * @brief This function moves the value in member user_data
     * @param _user_data New value to be moved in member user_data
     */
    inline void user_data(std::vector<uint8_t> &&_user_data)
    {
        m_user_data = std::move(_user_data);
    }

    /*!
     * @brief This function returns a constant reference to member user_data
     * @return Constant reference to member user_data
     */
    inline const std::vector<uint8_t>& user_data() const
    {
        return m_user_data;
    }

    /*!
     * @brief This function returns a reference to member user_data
     * @return Reference to member user_data
     */
    inline std::vector<uint8_t>& user_data()
    {
        return m_user_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    EndpointQosFlags m_qos_flags;
    uint16_t m_history_depth;
    uint32_t m_deadline_msec;
    uint32_t m_lifespan_msec;
    std::vector<uint8_t> m_user_data;
};
/*!
 * @brief This class represents the structure OBJK_DataReader_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_DataReader_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_DataReader_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_DataReader_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_DataReader_Binary that will be copied.
     */
    OBJK_DataReader_Binary(const OBJK_DataReader_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_DataReader_Binary that will be copied.
     */
    OBJK_DataReader_Binary(OBJK_DataReader_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_DataReader_Binary that will be copied.
     */
    OBJK_DataReader_Binary& operator=(const OBJK_DataReader_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_DataReader_Binary that will be copied.
     */
    OBJK_DataReader_Binary& operator=(OBJK_DataReader_Binary &&x);
    
    /*!
     * @brief This function copies the value in member topic_name
     * @param _topic_name New value to be copied in member topic_name
     */
    inline void topic_name(const std::string &_topic_name)
    {
        m_topic_name = _topic_name;
    }

    /*!
     * @brief This function moves the value in member topic_name
     * @param _topic_name New value to be moved in member topic_name
     */
    inline void topic_name(std::string &&_topic_name)
    {
        m_topic_name = std::move(_topic_name);
    }

    /*!
     * @brief This function returns a constant reference to member topic_name
     * @return Constant reference to member topic_name
     */
    inline const std::string& topic_name() const
    {
        return m_topic_name;
    }

    /*!
     * @brief This function returns a reference to member topic_name
     * @return Reference to member topic_name
     */
    inline std::string& topic_name()
    {
        return m_topic_name;
    }
    /*!
     * @brief This function copies the value in member endpoint_qos
     * @param _endpoint_qos New value to be copied in member endpoint_qos
     */
    inline void endpoint_qos(const OBJK_Endpoint_QosBinary &_endpoint_qos)
    {
        m_endpoint_qos = _endpoint_qos;
    }

    /*!
     * @brief This function moves the value in member endpoint_qos
     * @param _endpoint_qos New value to be moved in member endpoint_qos
     */
    inline void endpoint_qos(OBJK_Endpoint_QosBinary &&_endpoint_qos)
    {
        m_endpoint_qos = std::move(_endpoint_qos);
    }

    /*!
     * @brief This function returns a constant reference to member endpoint_qos
     * @return Constant reference to member endpoint_qos
     */
    inline const OBJK_Endpoint_QosBinary& endpoint_qos() const
    {
        return m_endpoint_qos;
    }

    /*!
     * @brief This function returns a reference to member endpoint_qos
     * @return Reference to member endpoint_qos
     */
    inline OBJK_Endpoint_QosBinary& endpoint_qos()
    {
        return m_endpoint_qos;
    }
    /*!
     * @brief This function sets a value in member timebasedfilter_msec
     * @param _timebasedfilter_msec New value for member timebasedfilter_msec
     */
    inline void timebasedfilter_msec(uint32_t _timebasedfilter_msec)
    {
        m_timebasedfilter_msec = _timebasedfilter_msec;
    }

    /*!
     * @brief This function returns the value of member timebasedfilter_msec
     * @return Value of member timebasedfilter_msec
     */
    inline uint32_t timebasedfilter_msec() const
    {
        return m_timebasedfilter_msec;
    }

    /*!
     * @brief This function returns a reference to member timebasedfilter_msec
     * @return Reference to member timebasedfilter_msec
     */
    inline uint32_t& timebasedfilter_msec()
    {
        return m_timebasedfilter_msec;
    }
    /*!
     * @brief This function copies the value in member contentbased_filter
     * @param _contentbased_filter New value to be copied in member contentbased_filter
     */
    inline void contentbased_filter(const std::string &_contentbased_filter)
    {
        m_contentbased_filter = _contentbased_filter;
    }

    /*!
     * @brief This function moves the value in member contentbased_filter
     * @param _contentbased_filter New value to be moved in member contentbased_filter
     */
    inline void contentbased_filter(std::string &&_contentbased_filter)
    {
        m_contentbased_filter = std::move(_contentbased_filter);
    }

    /*!
     * @brief This function returns a constant reference to member contentbased_filter
     * @return Constant reference to member contentbased_filter
     */
    inline const std::string& contentbased_filter() const
    {
        return m_contentbased_filter;
    }

    /*!
     * @brief This function returns a reference to member contentbased_filter
     * @return Reference to member contentbased_filter
     */
    inline std::string& contentbased_filter()
    {
        return m_contentbased_filter;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_topic_name;
    OBJK_Endpoint_QosBinary m_endpoint_qos;
    uint32_t m_timebasedfilter_msec;
    std::string m_contentbased_filter;
};
/*!
 * @brief This class represents the structure OBJK_DataWriter_Binary defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class OBJK_DataWriter_Binary
{
public:

    /*!
     * @brief Default constructor.
     */
    OBJK_DataWriter_Binary();
    
    /*!
     * @brief Default destructor.
     */
    ~OBJK_DataWriter_Binary();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object OBJK_DataWriter_Binary that will be copied.
     */
    OBJK_DataWriter_Binary(const OBJK_DataWriter_Binary &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object OBJK_DataWriter_Binary that will be copied.
     */
    OBJK_DataWriter_Binary(OBJK_DataWriter_Binary &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object OBJK_DataWriter_Binary that will be copied.
     */
    OBJK_DataWriter_Binary& operator=(const OBJK_DataWriter_Binary &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object OBJK_DataWriter_Binary that will be copied.
     */
    OBJK_DataWriter_Binary& operator=(OBJK_DataWriter_Binary &&x);
    
    /*!
     * @brief This function copies the value in member topic_name
     * @param _topic_name New value to be copied in member topic_name
     */
    inline void topic_name(const std::string &_topic_name)
    {
        m_topic_name = _topic_name;
    }

    /*!
     * @brief This function moves the value in member topic_name
     * @param _topic_name New value to be moved in member topic_name
     */
    inline void topic_name(std::string &&_topic_name)
    {
        m_topic_name = std::move(_topic_name);
    }

    /*!
     * @brief This function returns a constant reference to member topic_name
     * @return Constant reference to member topic_name
     */
    inline const std::string& topic_name() const
    {
        return m_topic_name;
    }

    /*!
     * @brief This function returns a reference to member topic_name
     * @return Reference to member topic_name
     */
    inline std::string& topic_name()
    {
        return m_topic_name;
    }
    /*!
     * @brief This function copies the value in member endpoint_qos
     * @param _endpoint_qos New value to be copied in member endpoint_qos
     */
    inline void endpoint_qos(const OBJK_Endpoint_QosBinary &_endpoint_qos)
    {
        m_endpoint_qos = _endpoint_qos;
    }

    /*!
     * @brief This function moves the value in member endpoint_qos
     * @param _endpoint_qos New value to be moved in member endpoint_qos
     */
    inline void endpoint_qos(OBJK_Endpoint_QosBinary &&_endpoint_qos)
    {
        m_endpoint_qos = std::move(_endpoint_qos);
    }

    /*!
     * @brief This function returns a constant reference to member endpoint_qos
     * @return Constant reference to member endpoint_qos
     */
    inline const OBJK_Endpoint_QosBinary& endpoint_qos() const
    {
        return m_endpoint_qos;
    }

    /*!
     * @brief This function returns a reference to member endpoint_qos
     * @return Reference to member endpoint_qos
     */
    inline OBJK_Endpoint_QosBinary& endpoint_qos()
    {
        return m_endpoint_qos;
    }
    /*!
     * @brief This function sets a value in member ownership_strength
     * @param _ownership_strength New value for member ownership_strength
     */
    inline void ownership_strength(uint32_t _ownership_strength)
    {
        m_ownership_strength = _ownership_strength;
    }

    /*!
     * @brief This function returns the value of member ownership_strength
     * @return Value of member ownership_strength
     */
    inline uint32_t ownership_strength() const
    {
        return m_ownership_strength;
    }

    /*!
     * @brief This function returns a reference to member ownership_strength
     * @return Reference to member ownership_strength
     */
    inline uint32_t& ownership_strength()
    {
        return m_ownership_strength;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::string m_topic_name;
    OBJK_Endpoint_QosBinary m_endpoint_qos;
    uint32_t m_ownership_strength;
};
/*!
 * @brief This class represents the union ObjectVariant defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ObjectVariant
{
public:

    /*!
     * @brief Default constructor.
     */
    ObjectVariant();
    
    /*!
     * @brief Default destructor.
     */
    ~ObjectVariant();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ObjectVariant that will be copied.
     */
    ObjectVariant(const ObjectVariant &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ObjectVariant that will be copied.
     */
    ObjectVariant(ObjectVariant &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ObjectVariant that will be copied.
     */
    ObjectVariant& operator=(const ObjectVariant &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ObjectVariant that will be copied.
     */
    ObjectVariant& operator=(ObjectVariant &&x);
    
    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(ObjectKind __d);
    
    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    ObjectKind _d() const;
    
    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    ObjectKind& _d();
    
    /*!
     * @brief This function copies the value in member agent
     * @param _agent New value to be copied in member agent
     */
    void agent(const AGENT_Representation &_agent);

    /*!
     * @brief This function moves the value in member agent
     * @param _agent New value to be moved in member agent
     */
    void agent(AGENT_Representation &&_agent);

    /*!
     * @brief This function returns a constant reference to member agent
     * @return Constant reference to member agent
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const AGENT_Representation& agent() const;

    /*!
     * @brief This function returns a reference to member agent
     * @return Reference to member agent
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    AGENT_Representation& agent();
    /*!
     * @brief This function copies the value in member client
     * @param _client New value to be copied in member client
     */
    void client(const CLIENT_Representation &_client);

    /*!
     * @brief This function moves the value in member client
     * @param _client New value to be moved in member client
     */
    void client(CLIENT_Representation &&_client);

    /*!
     * @brief This function returns a constant reference to member client
     * @return Constant reference to member client
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const CLIENT_Representation& client() const;

    /*!
     * @brief This function returns a reference to member client
     * @return Reference to member client
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    CLIENT_Representation& client();

    /*!
     * @brief This function copies the value in member application
     * @param _application New value to be copied in member application
     */
    void application(const OBJK_APPLICATION_Representation &_application);

    /*!
     * @brief This function moves the value in member application
     * @param _application New value to be moved in member application
     */
    void application(OBJK_APPLICATION_Representation &&_application);

    /*!
     * @brief This function returns a constant reference to member application
     * @return Constant reference to member application
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_APPLICATION_Representation& application() const;

    /*!
     * @brief This function returns a reference to member application
     * @return Reference to member application
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_APPLICATION_Representation& application();
    /*!
     * @brief This function copies the value in member participant
     * @param _participant New value to be copied in member participant
     */
    void participant(const OBJK_PARTICIPANT_Representation &_participant);

    /*!
     * @brief This function moves the value in member participant
     * @param _participant New value to be moved in member participant
     */
    void participant(OBJK_PARTICIPANT_Representation &&_participant);

    /*!
     * @brief This function returns a constant reference to member participant
     * @return Constant reference to member participant
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_PARTICIPANT_Representation& participant() const;

    /*!
     * @brief This function returns a reference to member participant
     * @return Reference to member participant
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_PARTICIPANT_Representation& participant();
    /*!
     * @brief This function copies the value in member qos_profile
     * @param _qos_profile New value to be copied in member qos_profile
     */
    void qos_profile(const OBJK_QOSPROFILE_Representation &_qos_profile);

    /*!
     * @brief This function moves the value in member qos_profile
     * @param _qos_profile New value to be moved in member qos_profile
     */
    void qos_profile(OBJK_QOSPROFILE_Representation &&_qos_profile);

    /*!
     * @brief This function returns a constant reference to member qos_profile
     * @return Constant reference to member qos_profile
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_QOSPROFILE_Representation& qos_profile() const;

    /*!
     * @brief This function returns a reference to member qos_profile
     * @return Reference to member qos_profile
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_QOSPROFILE_Representation& qos_profile();

    /*!
     * @brief This function copies the value in member type
     * @param _type New value to be copied in member type
     */
    void type(const OBJK_TYPE_Representation &_type);

    /*!
     * @brief This function moves the value in member type
     * @param _type New value to be moved in member type
     */
    void type(OBJK_TYPE_Representation &&_type);

    /*!
     * @brief This function returns a constant reference to member type
     * @return Constant reference to member type
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_TYPE_Representation& type() const;

    /*!
     * @brief This function returns a reference to member type
     * @return Reference to member type
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_TYPE_Representation& type();
    /*!
     * @brief This function copies the value in member topic
     * @param _topic New value to be copied in member topic
     */
    void topic(const OBJK_TOPIC_Representation &_topic);

    /*!
     * @brief This function moves the value in member topic
     * @param _topic New value to be moved in member topic
     */
    void topic(OBJK_TOPIC_Representation &&_topic);

    /*!
     * @brief This function returns a constant reference to member topic
     * @return Constant reference to member topic
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_TOPIC_Representation& topic() const;

    /*!
     * @brief This function returns a reference to member topic
     * @return Reference to member topic
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_TOPIC_Representation& topic();

    /*!
     * @brief This function copies the value in member publisher
     * @param _publisher New value to be copied in member publisher
     */
    void publisher(const OBJK_PUBLISHER_Representation &_publisher);

    /*!
     * @brief This function moves the value in member publisher
     * @param _publisher New value to be moved in member publisher
     */
    void publisher(OBJK_PUBLISHER_Representation &&_publisher);

    /*!
     * @brief This function returns a constant reference to member publisher
     * @return Constant reference to member publisher
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_PUBLISHER_Representation& publisher() const;

    /*!
     * @brief This function returns a reference to member publisher
     * @return Reference to member publisher
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_PUBLISHER_Representation& publisher();

    /*!
     * @brief This function copies the value in member subscriber
     * @param _subscriber New value to be copied in member subscriber
     */
    void subscriber(const OBJK_SUBSCRIBER_Representation &_subscriber);

    /*!
     * @brief This function moves the value in member subscriber
     * @param _subscriber New value to be moved in member subscriber
     */
    void subscriber(OBJK_SUBSCRIBER_Representation &&_subscriber);

    /*!
     * @brief This function returns a constant reference to member subscriber
     * @return Constant reference to member subscriber
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const OBJK_SUBSCRIBER_Representation& subscriber() const;

    /*!
     * @brief This function returns a reference to member subscriber
     * @return Reference to member subscriber
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    OBJK_SUBSCRIBER_Representation& subscriber();
    
    /*!
     * @brief This function copies the value in member data_writer
     * @param _data_writer New value to be copied in member data_writer
     */
    void data_writer(const DATAWRITER_Representation &_data_writer);

    /*!
     * @brief This function moves the value in member data_writer
     * @param _data_writer New value to be moved in member data_writer
     */
    void data_writer(DATAWRITER_Representation &&_data_writer);

    /*!
     * @brief This function returns a constant reference to member data_writer
     * @return Constant reference to member data_writer
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const DATAWRITER_Representation& data_writer() const;

    /*!
     * @brief This function returns a reference to member data_writer
     * @return Reference to member data_writer
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    DATAWRITER_Representation& data_writer();

    /*!
     * @brief This function copies the value in member data_reader
     * @param _data_reader New value to be copied in member data_reader
     */
    void data_reader(const DATAREADER_Representation &_data_reader);

    /*!
     * @brief This function moves the value in member data_reader
     * @param _data_reader New value to be moved in member data_reader
     */
    void data_reader(DATAREADER_Representation &&_data_reader);

    /*!
     * @brief This function returns a constant reference to member data_reader
     * @return Constant reference to member data_reader
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const DATAREADER_Representation& data_reader() const;

    /*!
     * @brief This function returns a reference to member data_reader
     * @return Reference to member data_reader
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    DATAREADER_Representation& data_reader();
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectKind m__d;
    
    AGENT_Representation m_agent;
    CLIENT_Representation m_client;
    OBJK_APPLICATION_Representation m_application;
    OBJK_PARTICIPANT_Representation m_participant;
    OBJK_QOSPROFILE_Representation m_qos_profile;
    OBJK_TYPE_Representation m_type;
    OBJK_TOPIC_Representation m_topic;
    OBJK_PUBLISHER_Representation m_publisher;
    OBJK_SUBSCRIBER_Representation m_subscriber;
    DATAWRITER_Representation m_data_writer;
    DATAREADER_Representation m_data_reader;
};
/*!
 * @brief This class represents the structure CreationMode defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class CreationMode
{
public:

    /*!
     * @brief Default constructor.
     */
    CreationMode();
    
    /*!
     * @brief Default destructor.
     */
    ~CreationMode();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CreationMode that will be copied.
     */
    CreationMode(const CreationMode &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object CreationMode that will be copied.
     */
    CreationMode(CreationMode &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CreationMode that will be copied.
     */
    CreationMode& operator=(const CreationMode &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object CreationMode that will be copied.
     */
    CreationMode& operator=(CreationMode &&x);
    
    /*!
     * @brief This function sets a value in member reuse
     * @param _reuse New value for member reuse
     */
    inline void reuse(bool _reuse)
    {
        m_reuse = _reuse;
    }

    /*!
     * @brief This function returns the value of member reuse
     * @return Value of member reuse
     */
    inline bool reuse() const
    {
        return m_reuse;
    }

    /*!
     * @brief This function returns a reference to member reuse
     * @return Reference to member reuse
     */
    inline bool& reuse()
    {
        return m_reuse;
    }
    /*!
     * @brief This function sets a value in member replace
     * @param _replace New value for member replace
     */
    inline void replace(bool _replace)
    {
        m_replace = _replace;
    }

    /*!
     * @brief This function returns the value of member replace
     * @return Value of member replace
     */
    inline bool replace() const
    {
        return m_replace;
    }

    /*!
     * @brief This function returns a reference to member replace
     * @return Reference to member replace
     */
    inline bool& replace()
    {
        return m_replace;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    bool m_reuse;
    bool m_replace;
};
typedef std::array<uint8_t, 2> RequestId;
/*!
 * @brief This class represents the enumeration StatusValue defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum StatusValue : uint8_t
{
    STATUS_OK						= 0x00,
    STATUS_OK_MATCHED				= 0x01,
    STATUS_ERR_DDS_ERROR			= 0x80,
    STATUS_ERR_MISMATCH				= 0x81,
    STATUS_ERR_ALREADY_EXISTS		= 0x82,
    STATUS_ERR_DENIED				= 0x83,
    STATUS_ERR_UNKNOWN_REFERENCE	= 0x84,
    STATUS_ERR_INVALID_DATA			= 0x85,
    STATUS_ERR_INCOMPATIBLE			= 0x86,
    STATUS_ERR_RESOURCES			= 0x87
};
/*!
 * @brief This class represents the structure ResultStatus defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ResultStatus
{
public:

    /*!
     * @brief Default constructor.
     */
    ResultStatus();
    
    /*!
     * @brief Default destructor.
     */
    ~ResultStatus();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ResultStatus that will be copied.
     */
    ResultStatus(const ResultStatus &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ResultStatus that will be copied.
     */
    ResultStatus(ResultStatus &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ResultStatus that will be copied.
     */
    ResultStatus& operator=(const ResultStatus &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ResultStatus that will be copied.
     */
    ResultStatus& operator=(ResultStatus &&x);
    
    /*!
     * @brief This function sets a value in member status
     * @param _status New value for member status
     */
    inline void status(StatusValue _status)
    {
        m_status = _status;
    }

    /*!
     * @brief This function returns the value of member status
     * @return Value of member status
     */
    inline StatusValue status() const
    {
        return m_status;
    }

    /*!
     * @brief This function returns a reference to member status
     * @return Reference to member status
     */
    inline StatusValue& status()
    {
        return m_status;
    }
    /*!
     * @brief This function sets a value in member implementation_status
     * @param _implementation_status New value for member implementation_status
     */
    inline void implementation_status(uint8_t _implementation_status)
    {
        m_implementation_status = _implementation_status;
    }

    /*!
     * @brief This function returns the value of member implementation_status
     * @return Value of member implementation_status
     */
    inline uint8_t implementation_status() const
    {
        return m_implementation_status;
    }

    /*!
     * @brief This function returns a reference to member implementation_status
     * @return Reference to member implementation_status
     */
    inline uint8_t& implementation_status()
    {
        return m_implementation_status;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    StatusValue m_status;
    uint8_t m_implementation_status;
};

const uint8_t STATUS_LAST_OP_NONE = 0;
const uint8_t STATUS_LAST_OP_CREATE = 1;
const uint8_t STATUS_LAST_OP_UPDATE = 2;
const uint8_t STATUS_LAST_OP_DELETE = 3;
const uint8_t STATUS_LAST_OP_LOOKUP = 4;
const uint8_t STATUS_LAST_OP_READ = 5;
const uint8_t STATUS_LAST_OP_WRITE = 6;

/*!
 * @brief This class represents the enumeration InfoMask defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum InfoMask : uint32_t
{
    INFO_CONFIGURATION	= 0x01 << 0,
    INFO_ACTIVITY		= 0x01 << 1
};

/*!
 * @brief This class represents the structure AGENT_ActivityInfo defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class AGENT_ActivityInfo
{
public:

    /*!
     * @brief Default constructor.
     */
    AGENT_ActivityInfo();
    
    /*!
     * @brief Default destructor.
     */
    ~AGENT_ActivityInfo();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AGENT_ActivityInfo that will be copied.
     */
    AGENT_ActivityInfo(const AGENT_ActivityInfo &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object AGENT_ActivityInfo that will be copied.
     */
    AGENT_ActivityInfo(AGENT_ActivityInfo &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AGENT_ActivityInfo that will be copied.
     */
    AGENT_ActivityInfo& operator=(const AGENT_ActivityInfo &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object AGENT_ActivityInfo that will be copied.
     */
    AGENT_ActivityInfo& operator=(AGENT_ActivityInfo &&x);
    
    /*!
     * @brief This function sets a value in member availability
     * @param _availability New value for member availability
     */
    inline void availability(int16_t _availability)
    {
        m_availability = _availability;
    }

    /*!
     * @brief This function returns the value of member availability
     * @return Value of member availability
     */
    inline int16_t availability() const
    {
        return m_availability;
    }

    /*!
     * @brief This function returns a reference to member availability
     * @return Reference to member availability
     */
    inline int16_t& availability()
    {
        return m_availability;
    }
    /*!
     * @brief This function copies the value in member address_seq
     * @param _address_seq New value to be copied in member address_seq
     */
    inline void address_seq(const TransportAddressSeq &_address_seq)
    {
        m_address_seq = _address_seq;
    }

    /*!
     * @brief This function moves the value in member address_seq
     * @param _address_seq New value to be moved in member address_seq
     */
    inline void address_seq(TransportAddressSeq &&_address_seq)
    {
        m_address_seq = std::move(_address_seq);
    }

    /*!
     * @brief This function returns a constant reference to member address_seq
     * @return Constant reference to member address_seq
     */
    inline const TransportAddressSeq& address_seq() const
    {
        return m_address_seq;
    }

    /*!
     * @brief This function returns a reference to member address_seq
     * @return Reference to member address_seq
     */
    inline TransportAddressSeq& address_seq()
    {
        return m_address_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    int16_t m_availability;
    TransportAddressSeq m_address_seq;
};
/*!
 * @brief This class represents the structure DATAREADER_ActivityInfo defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATAREADER_ActivityInfo
{
public:

    /*!
     * @brief Default constructor.
     */
    DATAREADER_ActivityInfo();
    
    /*!
     * @brief Default destructor.
     */
    ~DATAREADER_ActivityInfo();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATAREADER_ActivityInfo that will be copied.
     */
    DATAREADER_ActivityInfo(const DATAREADER_ActivityInfo &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATAREADER_ActivityInfo that will be copied.
     */
    DATAREADER_ActivityInfo(DATAREADER_ActivityInfo &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATAREADER_ActivityInfo that will be copied.
     */
    DATAREADER_ActivityInfo& operator=(const DATAREADER_ActivityInfo &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATAREADER_ActivityInfo that will be copied.
     */
    DATAREADER_ActivityInfo& operator=(DATAREADER_ActivityInfo &&x);
    
    /*!
     * @brief This function sets a value in member highest_acked_num
     * @param _highest_acked_num New value for member highest_acked_num
     */
    inline void highest_acked_num(uint16_t _highest_acked_num)
    {
        m_highest_acked_num = _highest_acked_num;
    }

    /*!
     * @brief This function returns the value of member highest_acked_num
     * @return Value of member highest_acked_num
     */
    inline uint16_t highest_acked_num() const
    {
        return m_highest_acked_num;
    }

    /*!
     * @brief This function returns a reference to member highest_acked_num
     * @return Reference to member highest_acked_num
     */
    inline uint16_t& highest_acked_num()
    {
        return m_highest_acked_num;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    uint16_t m_highest_acked_num;
};

/*!
 * @brief This class represents the structure DATAWRITER_ActivityInfo defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATAWRITER_ActivityInfo
{
public:

    /*!
     * @brief Default constructor.
     */
    DATAWRITER_ActivityInfo();
    
    /*!
     * @brief Default destructor.
     */
    ~DATAWRITER_ActivityInfo();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATAWRITER_ActivityInfo that will be copied.
     */
    DATAWRITER_ActivityInfo(const DATAWRITER_ActivityInfo &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATAWRITER_ActivityInfo that will be copied.
     */
    DATAWRITER_ActivityInfo(DATAWRITER_ActivityInfo &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATAWRITER_ActivityInfo that will be copied.
     */
    DATAWRITER_ActivityInfo& operator=(const DATAWRITER_ActivityInfo &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATAWRITER_ActivityInfo that will be copied.
     */
    DATAWRITER_ActivityInfo& operator=(DATAWRITER_ActivityInfo &&x);
    
    /*!
     * @brief This function sets a value in member stream_seq_num
     * @param _stream_seq_num New value for member stream_seq_num
     */
    inline void stream_seq_num(uint16_t _stream_seq_num)
    {
        m_stream_seq_num = _stream_seq_num;
    }

    /*!
     * @brief This function returns the value of member stream_seq_num
     * @return Value of member stream_seq_num
     */
    inline uint16_t stream_seq_num() const
    {
        return m_stream_seq_num;
    }

    /*!
     * @brief This function returns a reference to member stream_seq_num
     * @return Reference to member stream_seq_num
     */
    inline uint16_t& stream_seq_num()
    {
        return m_stream_seq_num;
    }
    /*!
     * @brief This function sets a value in member sample_seq_num
     * @param _sample_seq_num New value for member sample_seq_num
     */
    inline void sample_seq_num(uint64_t _sample_seq_num)
    {
        m_sample_seq_num = _sample_seq_num;
    }

    /*!
     * @brief This function returns the value of member sample_seq_num
     * @return Value of member sample_seq_num
     */
    inline uint64_t sample_seq_num() const
    {
        return m_sample_seq_num;
    }

    /*!
     * @brief This function returns a reference to member sample_seq_num
     * @return Reference to member sample_seq_num
     */
    inline uint64_t& sample_seq_num()
    {
        return m_sample_seq_num;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    uint16_t m_stream_seq_num;
    uint64_t m_sample_seq_num;
};

/*!
 * @brief This class represents the union ActivityInfoVariant defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ActivityInfoVariant
{
public:

    /*!
     * @brief Default constructor.
     */
    ActivityInfoVariant();
    
    /*!
     * @brief Default destructor.
     */
    ~ActivityInfoVariant();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ActivityInfoVariant that will be copied.
     */
    ActivityInfoVariant(const ActivityInfoVariant &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ActivityInfoVariant that will be copied.
     */
    ActivityInfoVariant(ActivityInfoVariant &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ActivityInfoVariant that will be copied.
     */
    ActivityInfoVariant& operator=(const ActivityInfoVariant &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ActivityInfoVariant that will be copied.
     */
    ActivityInfoVariant& operator=(ActivityInfoVariant &&x);
    
    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(ObjectKind __d);
    
    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    ObjectKind _d() const;
    
    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    ObjectKind& _d();

    /*!
     * @brief This function copies the value in member agent
     * @param _agent New value to be copied in member agent
     */
    void agent(const AGENT_ActivityInfo &_agent);

    /*!
     * @brief This function moves the value in member agent
     * @param _agent New value to be moved in member agent
     */
    void agent(AGENT_ActivityInfo &&_agent);

    /*!
     * @brief This function returns a constant reference to member agent
     * @return Constant reference to member agent
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const AGENT_ActivityInfo& agent() const;

    /*!
     * @brief This function returns a reference to member agent
     * @return Reference to member agent
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    AGENT_ActivityInfo& agent();

    /*!
     * @brief This function copies the value in member data_writer
     * @param _data_writer New value to be copied in member data_writer
     */
    void data_writer(const DATAWRITER_ActivityInfo &_data_writer);

    /*!
     * @brief This function moves the value in member data_writer
     * @param _data_writer New value to be moved in member data_writer
     */
    void data_writer(DATAWRITER_ActivityInfo &&_data_writer);

    /*!
     * @brief This function returns a constant reference to member data_writer
     * @return Constant reference to member data_writer
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const DATAWRITER_ActivityInfo& data_writer() const;

    /*!
     * @brief This function returns a reference to member data_writer
     * @return Reference to member data_writer
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    DATAWRITER_ActivityInfo& data_writer();

    /*!
     * @brief This function copies the value in member data_reader
     * @param _data_reader New value to be copied in member data_reader
     */
    void data_reader(const DATAREADER_ActivityInfo &_data_reader);

    /*!
     * @brief This function moves the value in member data_reader
     * @param _data_reader New value to be moved in member data_reader
     */
    void data_reader(DATAREADER_ActivityInfo &&_data_reader);

    /*!
     * @brief This function returns a constant reference to member data_reader
     * @return Constant reference to member data_reader
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const DATAREADER_ActivityInfo& data_reader() const;

    /*!
     * @brief This function returns a reference to member data_reader
     * @return Reference to member data_reader
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    DATAREADER_ActivityInfo& data_reader();
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectKind m__d;
    
    AGENT_ActivityInfo m_agent;
    DATAWRITER_ActivityInfo m_data_writer;
    DATAREADER_ActivityInfo m_data_reader;
};

/*!
 * @brief This class represents the structure ObjectInfo defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ObjectInfo
{
public:

    /*!
     * @brief Default constructor.
     */
    ObjectInfo();
    
    /*!
     * @brief Default destructor.
     */
    ~ObjectInfo();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ObjectInfo that will be copied.
     */
    ObjectInfo(const ObjectInfo &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ObjectInfo that will be copied.
     */
    ObjectInfo(ObjectInfo &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ObjectInfo that will be copied.
     */
    ObjectInfo& operator=(const ObjectInfo &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ObjectInfo that will be copied.
     */
    ObjectInfo& operator=(ObjectInfo &&x);
    
    /*!
     * @brief This function copies the value in member config
     * @param _config New value to be copied in member config
     */
    inline void config(const ObjectVariant &_config)
    {
        m_config = _config;
    }

    /*!
     * @brief This function moves the value in member config
     * @param _config New value to be moved in member config
     */
    inline void config(ObjectVariant &&_config)
    {
        m_config = std::move(_config);
    }

    inline bool has_config() const
    {
        return bool(m_config);
    }

    /*!
     * @brief This function returns a constant reference to member config
     * @return Constant reference to member config
     */
    inline const ObjectVariant& config() const
    {
        if (!m_config)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_config;
    }

    /*!
     * @brief This function returns a reference to member config
     * @return Reference to member config
     */
    inline ObjectVariant& config()
    {
        if (!m_config)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_config;
    }
    /*!
     * @brief This function copies the value in member activity
     * @param _activity New value to be copied in member activity
     */
    inline void activity(const ActivityInfoVariant &_activity)
    {
        m_activity = _activity;
    }

    /*!
     * @brief This function moves the value in member activity
     * @param _activity New value to be moved in member activity
     */
    inline void activity(ActivityInfoVariant &&_activity)
    {
        m_activity = std::move(_activity);
    }

    inline bool has_activity() const
    {
        return bool(m_activity);
    }

    /*!
     * @brief This function returns a constant reference to member activity
     * @return Constant reference to member activity
     */
    inline const ActivityInfoVariant& activity() const
    {
        if (!m_activity)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_activity;
    }

    /*!
     * @brief This function returns a reference to member activity
     * @return Reference to member activity
     */
    inline ActivityInfoVariant& activity()
    {
        if (!m_activity)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_activity;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    eprosima::Optional<ObjectVariant> m_config;
    eprosima::Optional<ActivityInfoVariant> m_activity;
};

/*!
 * @brief This class represents the structure BaseObjectRequest defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    BaseObjectRequest();
    
    /*!
     * @brief Default destructor.
     */
    ~BaseObjectRequest();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BaseObjectRequest that will be copied.
     */
    BaseObjectRequest(const BaseObjectRequest &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object BaseObjectRequest that will be copied.
     */
    BaseObjectRequest(BaseObjectRequest &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BaseObjectRequest that will be copied.
     */
    BaseObjectRequest& operator=(const BaseObjectRequest &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object BaseObjectRequest that will be copied.
     */
    BaseObjectRequest& operator=(BaseObjectRequest &&x);
    
    /*!
     * @brief This function copies the value in member request_id
     * @param _request_id New value to be copied in member request_id
     */
    inline void request_id(const RequestId &_request_id)
    {
        m_request_id = _request_id;
    }

    /*!
     * @brief This function moves the value in member request_id
     * @param _request_id New value to be moved in member request_id
     */
    inline void request_id(RequestId &&_request_id)
    {
        m_request_id = std::move(_request_id);
    }

    /*!
     * @brief This function returns a constant reference to member request_id
     * @return Constant reference to member request_id
     */
    inline const RequestId& request_id() const
    {
        return m_request_id;
    }

    /*!
     * @brief This function returns a reference to member request_id
     * @return Reference to member request_id
     */
    inline RequestId& request_id()
    {
        return m_request_id;
    }
    /*!
     * @brief This function copies the value in member object_id
     * @param _object_id New value to be copied in member object_id
     */
    inline void object_id(const ObjectId &_object_id)
    {
        m_object_id = _object_id;
    }

    /*!
     * @brief This function moves the value in member object_id
     * @param _object_id New value to be moved in member object_id
     */
    inline void object_id(ObjectId &&_object_id)
    {
        m_object_id = std::move(_object_id);
    }

    /*!
     * @brief This function returns a constant reference to member object_id
     * @return Constant reference to member object_id
     */
    inline const ObjectId& object_id() const
    {
        return m_object_id;
    }

    /*!
     * @brief This function returns a reference to member object_id
     * @return Reference to member object_id
     */
    inline ObjectId& object_id()
    {
        return m_object_id;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    RequestId m_request_id;
    ObjectId m_object_id;
};
typedef BaseObjectRequest RelatedObjectRequest;

/*!
 * @brief This class represents the structure BaseObjectReply defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class BaseObjectReply
{
public:

    /*!
     * @brief Default constructor.
     */
    BaseObjectReply();
    
    /*!
     * @brief Default destructor.
     */
    ~BaseObjectReply();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BaseObjectReply that will be copied.
     */
    BaseObjectReply(const BaseObjectReply &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object BaseObjectReply that will be copied.
     */
    BaseObjectReply(BaseObjectReply &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BaseObjectReply that will be copied.
     */
    BaseObjectReply& operator=(const BaseObjectReply &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object BaseObjectReply that will be copied.
     */
    BaseObjectReply& operator=(BaseObjectReply &&x);
    
    /*!
     * @brief This function copies the value in member related_request
     * @param _related_request New value to be copied in member related_request
     */
    inline void related_request(const BaseObjectRequest &_related_request)
    {
        m_related_request = _related_request;
    }

    /*!
     * @brief This function moves the value in member related_request
     * @param _related_request New value to be moved in member related_request
     */
    inline void related_request(BaseObjectRequest &&_related_request)
    {
        m_related_request = std::move(_related_request);
    }

    /*!
     * @brief This function returns a constant reference to member related_request
     * @return Constant reference to member related_request
     */
    inline const BaseObjectRequest& related_request() const
    {
        return m_related_request;
    }

    /*!
     * @brief This function returns a reference to member related_request
     * @return Reference to member related_request
     */
    inline BaseObjectRequest& related_request()
    {
        return m_related_request;
    }
    /*!
     * @brief This function copies the value in member result
     * @param _result New value to be copied in member result
     */
    inline void result(const ResultStatus &_result)
    {
        m_result = _result;
    }

    /*!
     * @brief This function moves the value in member result
     * @param _result New value to be moved in member result
     */
    inline void result(ResultStatus &&_result)
    {
        m_result = std::move(_result);
    }

    /*!
     * @brief This function returns a constant reference to member result
     * @return Constant reference to member result
     */
    inline const ResultStatus& result() const
    {
        return m_result;
    }

    /*!
     * @brief This function returns a reference to member result
     * @return Reference to member result
     */
    inline ResultStatus& result()
    {
        return m_result;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    BaseObjectRequest m_related_request;
    ResultStatus m_result;
};

typedef uint8_t DataFormat;
const DataFormat FORMAT_DATA              = 0x00;
const DataFormat FORMAT_SAMPLE            = 0x02;
const DataFormat FORMAT_DATA_SEQ          = 0x08;
const DataFormat FORMAT_SAMPLE_SEQ        = 0x0A;
const DataFormat FORMAT_PACKED_SAMPLES    = 0x0E;
const DataFormat FORMAT_MASK              = 0x0E;

/*!
 * @brief This class represents the structure DataDeliveryControl defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DataDeliveryControl
{
public:

    /*!
     * @brief Default constructor.
     */
    DataDeliveryControl();
    
    /*!
     * @brief Default destructor.
     */
    ~DataDeliveryControl();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DataDeliveryControl that will be copied.
     */
    DataDeliveryControl(const DataDeliveryControl &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DataDeliveryControl that will be copied.
     */
    DataDeliveryControl(DataDeliveryControl &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DataDeliveryControl that will be copied.
     */
    DataDeliveryControl& operator=(const DataDeliveryControl &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DataDeliveryControl that will be copied.
     */
    DataDeliveryControl& operator=(DataDeliveryControl &&x);
    
    /*!
     * @brief This function sets a value in member max_samples
     * @param _max_samples New value for member max_samples
     */
    inline void max_samples(uint16_t _max_samples)
    {
        m_max_samples = _max_samples;
    }

    /*!
     * @brief This function returns the value of member max_samples
     * @return Value of member max_samples
     */
    inline uint16_t max_samples() const
    {
        return m_max_samples;
    }

    /*!
     * @brief This function returns a reference to member max_samples
     * @return Reference to member max_samples
     */
    inline uint16_t& max_samples()
    {
        return m_max_samples;
    }
    /*!
     * @brief This function sets a value in member max_elapsed_time
     * @param _max_elapsed_time New value for member max_elapsed_time
     */
    inline void max_elapsed_time(uint16_t _max_elapsed_time)
    {
        m_max_elapsed_time = _max_elapsed_time;
    }

    /*!
     * @brief This function returns the value of member max_elapsed_time
     * @return Value of member max_elapsed_time
     */
    inline uint16_t max_elapsed_time() const
    {
        return m_max_elapsed_time;
    }

    /*!
     * @brief This function returns a reference to member max_elapsed_time
     * @return Reference to member max_elapsed_time
     */
    inline uint16_t& max_elapsed_time()
    {
        return m_max_elapsed_time;
    }
    /*!
     * @brief This function sets a value in member max_bytes_per_second
     * @param _max_bytes_per_second New value for member max_bytes_per_second
     */
    inline void max_bytes_per_second(uint16_t _max_bytes_per_second)
    {
        m_max_bytes_per_second = _max_bytes_per_second;
    }

    /*!
     * @brief This function returns the value of member max_bytes_per_second
     * @return Value of member max_bytes_per_second
     */
    inline uint16_t max_bytes_per_second() const
    {
        return m_max_bytes_per_second;
    }

    /*!
     * @brief This function returns a reference to member max_bytes_per_second
     * @return Reference to member max_bytes_per_second
     */
    inline uint16_t& max_bytes_per_second()
    {
        return m_max_bytes_per_second;
    }

    /*!
     * @brief This function returns the value of member min_pace_period
     * @return Value of member min_pace_period
     */
    inline uint16_t min_pace_period() const
    {
        return m_min_pace_period;
    }

    /*!
     * @brief This function returns a reference to member min_pace_period
     * @return Reference to member min_pace_period
     */
    inline uint16_t& min_pace_period()
    {
        return m_min_pace_period;
    }

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    uint16_t m_max_samples;
    uint16_t m_max_elapsed_time;
    uint16_t m_max_bytes_per_second;
    uint16_t m_min_pace_period;
};
/*!
 * @brief This class represents the structure ReadSpecification defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ReadSpecification
{
public:

    /*!
     * @brief Default constructor.
     */
    ReadSpecification();
    
    /*!
     * @brief Default destructor.
     */
    ~ReadSpecification();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ReadSpecification that will be copied.
     */
    ReadSpecification(const ReadSpecification &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ReadSpecification that will be copied.
     */
    ReadSpecification(ReadSpecification &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ReadSpecification that will be copied.
     */
    ReadSpecification& operator=(const ReadSpecification &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ReadSpecification that will be copied.
     */
    ReadSpecification& operator=(ReadSpecification &&x);

    /*!
     * @brief This function sets a value in member data_stream_id
     * @param _data_stream_id New value for member data_stream_id
     */
    inline void data_stream_id(StreamId _data_stream_id)
    {
        m_data_stream_id = _data_stream_id;
    }

    /*!
     * @brief This function returns the value of member data_stream_id
     * @return Value of member data_stream_id
     */
    inline StreamId data_stream_id() const
    {
        return m_data_stream_id;
    }

    /*!
     * @brief This function returns a reference to member data_stream_id
     * @return Reference to member data_stream_id
     */
    inline StreamId& data_stream_id()
    {
        return m_data_stream_id;
    }

    /*!
     * @brief This function sets a value in member data_format
     * @param _data_format New value for member data_format
     */
    inline void data_format(DataFormat _data_format)
    {
        m_data_format = _data_format;
    }

    /*!
     * @brief This function returns the value of member data_format
     * @return Value of member data_format
     */
    inline DataFormat data_format() const
    {
        return m_data_format;
    }

    /*!
     * @brief This function returns a reference to member data_format
     * @return Reference to member data_format
     */
    inline DataFormat& data_format()
    {
        return m_data_format;
    }

    /*!
     * @brief This function copies the value in member delivery_control
     * @param _content_filter_expression New value to be copied in member delivery_control
     */
    inline void content_filter_expression(const std::string &_content_filter_expression)
    {
        m_content_filter_expression = _content_filter_expression;
    }

    /*!
     * @brief This function moves the value in member delivery_control
     * @param _content_filter_expression New value to be moved in member delivery_control
     */
    inline void content_filter_expression(std::string &&_content_filter_expression)
    {
        m_content_filter_expression = std::move(_content_filter_expression);
    }

    inline bool has_content_filter_expression() const
    {
        return static_cast<bool>(m_content_filter_expression);
    }

    /*!
     * @brief This function returns a constant reference to member delivery_control
     * @return Constant reference to member delivery_control
     */
    inline const std::string& content_filter_expression() const
    {
        if (!m_content_filter_expression)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_content_filter_expression;
    }

    /*!
     * @brief This function returns a reference to member content_filter_expression
     * @return Reference to member content_filter_expression
     */
    inline std::string& content_filter_expression()
    {
        if (!m_content_filter_expression)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_content_filter_expression;
    }

    /*!
     * @brief This function copies the value in member delivery_control
     * @param _delivery_control New value to be copied in member delivery_control
     */
    inline void delivery_control(const DataDeliveryControl &_delivery_control)
    {
        m_delivery_control = _delivery_control;
    }

    /*!
     * @brief This function moves the value in member delivery_control
     * @param _delivery_control New value to be moved in member delivery_control
     */
    inline void delivery_control(DataDeliveryControl &&_delivery_control)
    {
        m_delivery_control = std::move(_delivery_control);
    }

    inline bool has_delivery_control() const
    {
        return static_cast<bool>(m_delivery_control);
    }

    /*!
     * @brief This function returns a constant reference to member delivery_control
     * @return Constant reference to member delivery_control
     */
    inline const DataDeliveryControl& delivery_control() const
    {
        if (!m_delivery_control)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_delivery_control;
    }

    /*!
     * @brief This function returns a reference to member delivery_control
     * @return Reference to member delivery_control
     */
    inline DataDeliveryControl& delivery_control()
    {
        if (!m_delivery_control)
        {
            throw eprosima::fastcdr::exception::BadParamException("Optional member has not been selected");
        }
        return *m_delivery_control;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    StreamId m_data_stream_id;
    DataFormat m_data_format;
    eprosima::Optional<std::string> m_content_filter_expression;
    eprosima::Optional<DataDeliveryControl> m_delivery_control;
};

/*!
 * @brief This class represents the enumeration SampleInfoFlags defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum SampleInfoFlags : uint8_t
{
    INSTANCE_STATE_UNREGISTERED	= 0x01 << 0,
    INSTANCE_STATE_DISPOSED		= 0x01 << 1,
    VIEW_STATE_NEW				= 0x01 << 2,
    SAMPLE_STATE_READ			= 0x01 << 3
};

/*!
 * @brief This class represents the structure SampleInfo defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class SampleInfo
{
public:

    /*!
     * @brief Default constructor.
     */
    SampleInfo();
    
    /*!
     * @brief Default destructor.
     */
    ~SampleInfo();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleInfo that will be copied.
     */
    SampleInfo(const SampleInfo &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleInfo that will be copied.
     */
    SampleInfo(SampleInfo &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleInfo that will be copied.
     */
    SampleInfo& operator=(const SampleInfo &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleInfo that will be copied.
     */
    SampleInfo& operator=(SampleInfo &&x);
    
    /*!
     * @brief This function sets a value in member state
     * @param _state New value for member state
     */
    inline void state(SampleInfoFlags _state)
    {
        m_state = _state;
    }

    /*!
     * @brief This function returns the value of member state
     * @return Value of member state
     */
    inline SampleInfoFlags state() const
    {
        return m_state;
    }

    /*!
     * @brief This function returns a reference to member state
     * @return Reference to member state
     */
    inline SampleInfoFlags& state()
    {
        return m_state;
    }
    /*!
     * @brief This function sets a value in member sequence_number
     * @param _sequence_number New value for member sequence_number
     */
    inline void sequence_number(uint32_t _sequence_number)
    {
        m_sequence_number = _sequence_number;
    }

    /*!
     * @brief This function returns the value of member sequence_number
     * @return Value of member sequence_number
     */
    inline uint32_t sequence_number() const
    {
        return m_sequence_number;
    }

    /*!
     * @brief This function returns a reference to member sequence_number
     * @return Reference to member sequence_number
     */
    inline uint32_t& sequence_number()
    {
        return m_sequence_number;
    }
    /*!
     * @brief This function sets a value in member session_time_offset
     * @param _session_time_offset New value for member session_time_offset
     */
    inline void session_time_offset(uint32_t _session_time_offset)
    {
        m_session_time_offset = _session_time_offset;
    }

    /*!
     * @brief This function returns the value of member session_time_offset
     * @return Value of member session_time_offset
     */
    inline uint32_t session_time_offset() const
    {
        return m_session_time_offset;
    }

    /*!
     * @brief This function returns a reference to member session_time_offset
     * @return Reference to member session_time_offset
     */
    inline uint32_t& session_time_offset()
    {
        return m_session_time_offset;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleInfoFlags m_state;
    uint32_t m_sequence_number;
    uint32_t m_session_time_offset;
};

typedef uint16_t DeciSecond;

/*!
 * @brief This class represents the structure SampleInfoDelta defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class SampleInfoDelta
{
public:

    /*!
     * @brief Default constructor.
     */
    SampleInfoDelta();
    
    /*!
     * @brief Default destructor.
     */
    ~SampleInfoDelta();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleInfoDelta that will be copied.
     */
    SampleInfoDelta(const SampleInfoDelta &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleInfoDelta that will be copied.
     */
    SampleInfoDelta(SampleInfoDelta &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleInfoDelta that will be copied.
     */
    SampleInfoDelta& operator=(const SampleInfoDelta &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleInfoDelta that will be copied.
     */
    SampleInfoDelta& operator=(SampleInfoDelta &&x);
    
    /*!
     * @brief This function sets a value in member state
     * @param _state New value for member state
     */
    inline void state(SampleInfoFlags _state)
    {
        m_state = _state;
    }

    /*!
     * @brief This function returns the value of member state
     * @return Value of member state
     */
    inline SampleInfoFlags state() const
    {
        return m_state;
    }

    /*!
     * @brief This function returns a reference to member state
     * @return Reference to member state
     */
    inline SampleInfoFlags& state()
    {
        return m_state;
    }
    /*!
     * @brief This function sets a value in member seq_number_delta
     * @param _seq_number_delta New value for member seq_number_delta
     */
    inline void seq_number_delta(uint8_t _seq_number_delta)
    {
        m_seq_number_delta = _seq_number_delta;
    }

    /*!
     * @brief This function returns the value of member seq_number_delta
     * @return Value of member seq_number_delta
     */
    inline uint8_t seq_number_delta() const
    {
        return m_seq_number_delta;
    }

    /*!
     * @brief This function returns a reference to member seq_number_delta
     * @return Reference to member seq_number_delta
     */
    inline uint8_t& seq_number_delta()
    {
        return m_seq_number_delta;
    }
    /*!
     * @brief This function sets a value in member timestamp_delta
     * @param _timestamp_delta New value for member timestamp_delta
     */
    inline void timestamp_delta(DeciSecond _timestamp_delta)
    {
        m_timestamp_delta = _timestamp_delta;
    }

    /*!
     * @brief This function returns the value of member timestamp_delta
     * @return Value of member timestamp_delta
     */
    inline DeciSecond timestamp_delta() const
    {
        return m_timestamp_delta;
    }

    /*!
     * @brief This function returns a reference to member timestamp_delta
     * @return Reference to member timestamp_delta
     */
    inline DeciSecond& timestamp_delta()
    {
        return m_timestamp_delta;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleInfoFlags m_state;
    uint8_t m_seq_number_delta;
    DeciSecond m_timestamp_delta;
};

/*!
 * @brief This class represents the structure SampleData defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class SampleData
{
public:

    /*!
     * @brief Default constructor.
     */
    SampleData();
    
    /*!
     * @brief Default destructor.
     */
    ~SampleData();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleData that will be copied.
     */
    SampleData(const SampleData &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleData that will be copied.
     */
    SampleData(SampleData &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleData that will be copied.
     */
    SampleData& operator=(const SampleData &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleData that will be copied.
     */
    SampleData& operator=(SampleData &&x);
    
    /*!
     * @brief This function copies the value in member serialized_data
     * @param _serialized_data New value to be copied in member serialized_data
     */
    inline virtual void serialized_data(const std::vector<uint8_t> &_serialized_data)
    {
        m_serialized_data = _serialized_data;
    }

    /*!
     * @brief This function moves the value in member serialized_data
     * @param _serialized_data New value to be moved in member serialized_data
     */
    inline virtual void serialized_data(std::vector<uint8_t> &&_serialized_data)
    {
        m_serialized_data = std::move(_serialized_data);
    }

    /*!
     * @brief This function returns a constant reference to member serialized_data
     * @return Constant reference to member serialized_data
     */
    inline const std::vector<uint8_t>& serialized_data() const
    {
        return m_serialized_data;
    }

    /*!
     * @brief This function returns a reference to member serialized_data
     * @return Reference to member serialized_data
     */
    inline std::vector<uint8_t>& serialized_data()
    {
        return m_serialized_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<uint8_t> m_serialized_data;
};

typedef std::vector<SampleData> SampleDataSeq;

/*!
 * @brief This class represents the structure Sample defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class Sample
{
public:

    /*!
     * @brief Default constructor.
     */
    Sample();
    
    /*!
     * @brief Default destructor.
     */
    ~Sample();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Sample that will be copied.
     */
    Sample(const Sample &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object Sample that will be copied.
     */
    Sample(Sample &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Sample that will be copied.
     */
    Sample& operator=(const Sample &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object Sample that will be copied.
     */
    Sample& operator=(Sample &&x);
    
    /*!
     * @brief This function copies the value in member info
     * @param _info New value to be copied in member info
     */
    inline void info(const SampleInfo &_info)
    {
        m_info = _info;
    }

    /*!
     * @brief This function moves the value in member info
     * @param _info New value to be moved in member info
     */
    inline void info(SampleInfo &&_info)
    {
        m_info = std::move(_info);
    }

    /*!
     * @brief This function returns a constant reference to member info
     * @return Constant reference to member info
     */
    inline const SampleInfo& info() const
    {
        return m_info;
    }

    /*!
     * @brief This function returns a reference to member info
     * @return Reference to member info
     */
    inline SampleInfo& info()
    {
        return m_info;
    }
    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    inline void data(const SampleData &_data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    inline void data(SampleData &&_data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    inline const SampleData& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    inline SampleData& data()
    {
        return m_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleInfo m_info;
    SampleData m_data;
};

typedef std::vector<Sample> SampleSeq;

/*!
 * @brief This class represents the structure SampleDelta defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class SampleDelta
{
public:

    /*!
     * @brief Default constructor.
     */
    SampleDelta();
    
    /*!
     * @brief Default destructor.
     */
    ~SampleDelta();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleDelta that will be copied.
     */
    SampleDelta(const SampleDelta &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleDelta that will be copied.
     */
    SampleDelta(SampleDelta &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleDelta that will be copied.
     */
    SampleDelta& operator=(const SampleDelta &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleDelta that will be copied.
     */
    SampleDelta& operator=(SampleDelta &&x);
    
    /*!
     * @brief This function copies the value in member info_delta
     * @param _info_delta New value to be copied in member info_delta
     */
    inline void info_delta(const SampleInfoDelta &_info_delta)
    {
        m_info_delta = _info_delta;
    }

    /*!
     * @brief This function moves the value in member info_delta
     * @param _info_delta New value to be moved in member info_delta
     */
    inline void info_delta(SampleInfoDelta &&_info_delta)
    {
        m_info_delta = std::move(_info_delta);
    }

    /*!
     * @brief This function returns a constant reference to member info_delta
     * @return Constant reference to member info_delta
     */
    inline const SampleInfoDelta& info_delta() const
    {
        return m_info_delta;
    }

    /*!
     * @brief This function returns a reference to member info_delta
     * @return Reference to member info_delta
     */
    inline SampleInfoDelta& info_delta()
    {
        return m_info_delta;
    }
    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    inline void data(const SampleData &_data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    inline void data(SampleData &&_data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    inline const SampleData& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    inline SampleData& data()
    {
        return m_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleInfoDelta m_info_delta;
    SampleData m_data;
};

/*!
 * @brief This class represents the structure PackedSamples defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class PackedSamples
{
public:

    /*!
     * @brief Default constructor.
     */
    PackedSamples();
    
    /*!
     * @brief Default destructor.
     */
    ~PackedSamples();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PackedSamples that will be copied.
     */
    PackedSamples(const PackedSamples &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object PackedSamples that will be copied.
     */
    PackedSamples(PackedSamples &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PackedSamples that will be copied.
     */
    PackedSamples& operator=(const PackedSamples &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object PackedSamples that will be copied.
     */
    PackedSamples& operator=(PackedSamples &&x);
    
    /*!
     * @brief This function copies the value in member info_base
     * @param _info_base New value to be copied in member info_base
     */
    inline void info_base(const SampleInfo &_info_base)
    {
        m_info_base = _info_base;
    }

    /*!
     * @brief This function moves the value in member info_base
     * @param _info_base New value to be moved in member info_base
     */
    inline void info_base(SampleInfo &&_info_base)
    {
        m_info_base = std::move(_info_base);
    }

    /*!
     * @brief This function returns a constant reference to member info_base
     * @return Constant reference to member info_base
     */
    inline const SampleInfo& info_base() const
    {
        return m_info_base;
    }

    /*!
     * @brief This function returns a reference to member info_base
     * @return Reference to member info_base
     */
    inline SampleInfo& info_base()
    {
        return m_info_base;
    }
    /*!
     * @brief This function copies the value in member sample_delta_seq
     * @param _sample_delta_seq New value to be copied in member sample_delta_seq
     */
    inline void sample_delta_seq(const std::vector<SampleDelta> &_sample_delta_seq)
    {
        m_sample_delta_seq = _sample_delta_seq;
    }

    /*!
     * @brief This function moves the value in member sample_delta_seq
     * @param _sample_delta_seq New value to be moved in member sample_delta_seq
     */
    inline void sample_delta_seq(std::vector<SampleDelta> &&_sample_delta_seq)
    {
        m_sample_delta_seq = std::move(_sample_delta_seq);
    }

    /*!
     * @brief This function returns a constant reference to member sample_delta_seq
     * @return Constant reference to member sample_delta_seq
     */
    inline const std::vector<SampleDelta>& sample_delta_seq() const
    {
        return m_sample_delta_seq;
    }

    /*!
     * @brief This function returns a reference to member sample_delta_seq
     * @return Reference to member sample_delta_seq
     */
    inline std::vector<SampleDelta>& sample_delta_seq()
    {
        return m_sample_delta_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleInfo m_info_base;
    std::vector<SampleDelta> m_sample_delta_seq;
};

typedef std::vector<PackedSamples> SamplePackedSeq;

/*!
 * @brief This class represents the union DataRepresentation defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DataRepresentation
{
public:

    /*!
     * @brief Default constructor.
     */
    DataRepresentation();
    
    /*!
     * @brief Default destructor.
     */
    ~DataRepresentation();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DataRepresentation that will be copied.
     */
    DataRepresentation(const DataRepresentation &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DataRepresentation that will be copied.
     */
    DataRepresentation(DataRepresentation &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DataRepresentation that will be copied.
     */
    DataRepresentation& operator=(const DataRepresentation &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DataRepresentation that will be copied.
     */
    DataRepresentation& operator=(DataRepresentation &&x);
    
    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    void _d(DataFormat __d);
    
    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    DataFormat _d() const;
    
    /*!
     * @brief This function returns a reference to the discriminator.
     * @return Reference to the discriminator.
     */
    DataFormat& _d();
    
    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    void data(const SampleData &_data);

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    void data(SampleData &&_data);

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const SampleData& data() const;

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    SampleData& data();
    /*!
     * @brief This function copies the value in member sample
     * @param _sample New value to be copied in member sample
     */
    void sample(const Sample &_sample);

    /*!
     * @brief This function moves the value in member sample
     * @param _sample New value to be moved in member sample
     */
    void sample(Sample &&_sample);

    /*!
     * @brief This function returns a constant reference to member sample
     * @return Constant reference to member sample
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const Sample& sample() const;

    /*!
     * @brief This function returns a reference to member sample
     * @return Reference to member sample
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    Sample& sample();
    /*!
     * @brief This function copies the value in member data_seq
     * @param _data_seq New value to be copied in member data_seq
     */
    void data_seq(const SampleDataSeq &_data_seq);

    /*!
     * @brief This function moves the value in member data_seq
     * @param _data_seq New value to be moved in member data_seq
     */
    void data_seq(SampleDataSeq &&_data_seq);

    /*!
     * @brief This function returns a constant reference to member data_seq
     * @return Constant reference to member data_seq
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const SampleDataSeq& data_seq() const;

    /*!
     * @brief This function returns a reference to member data_seq
     * @return Reference to member data_seq
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    SampleDataSeq& data_seq();
    /*!
     * @brief This function copies the value in member sample_seq
     * @param _sample_seq New value to be copied in member sample_seq
     */
    void sample_seq(const SampleSeq &_sample_seq);

    /*!
     * @brief This function moves the value in member sample_seq
     * @param _sample_seq New value to be moved in member sample_seq
     */
    void sample_seq(SampleSeq &&_sample_seq);

    /*!
     * @brief This function returns a constant reference to member sample_seq
     * @return Constant reference to member sample_seq
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const SampleSeq& sample_seq() const;

    /*!
     * @brief This function returns a reference to member sample_seq
     * @return Reference to member sample_seq
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    SampleSeq& sample_seq();
    /*!
     * @brief This function copies the value in member packed_samples
     * @param _packed_samples New value to be copied in member packed_samples
     */
    void packed_samples(const PackedSamples &_packed_samples);

    /*!
     * @brief This function moves the value in member packed_samples
     * @param _packed_samples New value to be moved in member packed_samples
     */
    void packed_samples(PackedSamples &&_packed_samples);

    /*!
     * @brief This function returns a constant reference to member packed_samples
     * @return Constant reference to member packed_samples
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    const PackedSamples& packed_samples() const;

    /*!
     * @brief This function returns a reference to member packed_samples
     * @return Reference to member packed_samples
     * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    PackedSamples& packed_samples();
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    DataFormat m__d;
    
    SampleData m_data;
    Sample m_sample;
    SampleDataSeq m_data_seq;
    SampleSeq m_sample_seq;
    PackedSamples m_packed_samples;
};

/*!
 * @brief This class represents the structure CREATE_CLIENT_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class CREATE_CLIENT_Payload : public BaseObjectRequest 
{
public:

    /*!
     * @brief Default constructor.
     */
    CREATE_CLIENT_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~CREATE_CLIENT_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CREATE_CLIENT_Payload that will be copied.
     */
    CREATE_CLIENT_Payload(const CREATE_CLIENT_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object CREATE_CLIENT_Payload that will be copied.
     */
    CREATE_CLIENT_Payload(CREATE_CLIENT_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CREATE_CLIENT_Payload that will be copied.
     */
    CREATE_CLIENT_Payload& operator=(const CREATE_CLIENT_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object CREATE_CLIENT_Payload that will be copied.
     */
    CREATE_CLIENT_Payload& operator=(CREATE_CLIENT_Payload &&x);
    
    /*!
     * @brief This function copies the value in member client_representation
     * @param _client_representation New value to be copied in member client_representation
     */
    inline void client_representation(const CLIENT_Representation &_client_representation)
    {
        m_client_representation = _client_representation;
    }

    /*!
     * @brief This function moves the value in member client_representation
     * @param _client_representation New value to be moved in member client_representation
     */
    inline void client_representation(CLIENT_Representation &&_client_representation)
    {
        m_client_representation = std::move(_client_representation);
    }

    /*!
     * @brief This function returns a constant reference to member client_representation
     * @return Constant reference to member client_representation
     */
    inline const CLIENT_Representation& client_representation() const
    {
        return m_client_representation;
    }

    /*!
     * @brief This function returns a reference to member client_representation
     * @return Reference to member client_representation
     */
    inline CLIENT_Representation& client_representation()
    {
        return m_client_representation;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    CLIENT_Representation m_client_representation;
};

/*!
 * @brief This class represents the structure CREATE_CLIENT_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class CREATE_Payload : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    CREATE_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~CREATE_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CREATE_Payload that will be copied.
     */
    CREATE_Payload(const CREATE_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object CREATE_Payload that will be copied.
     */
    CREATE_Payload(CREATE_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CREATE_Payload that will be copied.
     */
    CREATE_Payload& operator=(const CREATE_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object CREATE_Payload that will be copied.
     */
    CREATE_Payload& operator=(CREATE_Payload &&x);
    
    /*!
     * @brief This function copies the value in member object_representation
     * @param _object_representation New value to be copied in member object_representation
     */
    inline void object_representation(const ObjectVariant &_object_representation)
    {
        m_object_representation = _object_representation;
    }

    /*!
     * @brief This function moves the value in member object_representation
     * @param _object_representation New value to be moved in member object_representation
     */
    inline void object_representation(ObjectVariant &&_object_representation)
    {
        m_object_representation = std::move(_object_representation);
    }

    /*!
     * @brief This function returns a constant reference to member object_representation
     * @return Constant reference to member object_representation
     */
    inline const ObjectVariant& object_representation() const
    {
        return m_object_representation;
    }

    /*!
     * @brief This function returns a reference to member object_representation
     * @return Reference to member object_representation
     */
    inline ObjectVariant& object_representation()
    {
        return m_object_representation;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectVariant m_object_representation;
};

/*!
 * @brief This class represents the structure GET_INFO_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class GET_INFO_Payload : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    GET_INFO_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~GET_INFO_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GET_INFO_Payload that will be copied.
     */
    GET_INFO_Payload(const GET_INFO_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object GET_INFO_Payload that will be copied.
     */
    GET_INFO_Payload(GET_INFO_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GET_INFO_Payload that will be copied.
     */
    GET_INFO_Payload& operator=(const GET_INFO_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object GET_INFO_Payload that will be copied.
     */
    GET_INFO_Payload& operator=(GET_INFO_Payload &&x);
    
    /*!
     * @brief This function sets a value in member info_mask
     * @param _info_mask New value for member info_mask
     */
    inline void info_mask(InfoMask _info_mask)
    {
        m_info_mask = _info_mask;
    }

    /*!
     * @brief This function returns the value of member info_mask
     * @return Value of member info_mask
     */
    inline InfoMask info_mask() const
    {
        return m_info_mask;
    }

    /*!
     * @brief This function returns a reference to member info_mask
     * @return Reference to member info_mask
     */
    inline InfoMask& info_mask()
    {
        return m_info_mask;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    InfoMask m_info_mask;
};

/*!
 * @brief This class represents the structure DELETE_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DELETE_Payload : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DELETE_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~DELETE_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DELETE_Payload that will be copied.
     */
    DELETE_Payload(const DELETE_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DELETE_Payload that will be copied.
     */
    DELETE_Payload(DELETE_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DELETE_Payload that will be copied.
     */
    DELETE_Payload& operator=(const DELETE_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DELETE_Payload that will be copied.
     */
    DELETE_Payload& operator=(DELETE_Payload &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};

/*!
 * @brief This class represents the structure STATUS_AGENT_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class STATUS_AGENT_Payload : public BaseObjectReply
{
public:

    /*!
     * @brief Default constructor.
     */
    STATUS_AGENT_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~STATUS_AGENT_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object STATUS_AGENT_Payload that will be copied.
     */
    STATUS_AGENT_Payload(const STATUS_AGENT_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object STATUS_AGENT_Payload that will be copied.
     */
    STATUS_AGENT_Payload(STATUS_AGENT_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object STATUS_AGENT_Payload that will be copied.
     */
    STATUS_AGENT_Payload& operator=(const STATUS_AGENT_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object STATUS_AGENT_Payload that will be copied.
     */
    STATUS_AGENT_Payload& operator=(STATUS_AGENT_Payload &&x);
    
    /*!
     * @brief This function copies the value in member agent_info
     * @param _agent_info New value to be copied in member agent_info
     */
    inline void agent_info(const AGENT_Representation &_agent_info)
    {
        m_agent_info = _agent_info;
    }

    /*!
     * @brief This function moves the value in member agent_info
     * @param _agent_info New value to be moved in member agent_info
     */
    inline void agent_info(AGENT_Representation &&_agent_info)
    {
        m_agent_info = std::move(_agent_info);
    }

    /*!
     * @brief This function returns a constant reference to member agent_info
     * @return Constant reference to member agent_info
     */
    inline const AGENT_Representation& agent_info() const
    {
        return m_agent_info;
    }

    /*!
     * @brief This function returns a reference to member agent_info
     * @return Reference to member agent_info
     */
    inline AGENT_Representation& agent_info()
    {
        return m_agent_info;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    AGENT_Representation m_agent_info;
};

/*!
 * @brief This class represents the structure STATUS_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class STATUS_Payload : public BaseObjectReply
{
public:

    /*!
     * @brief Default constructor.
     */
    STATUS_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~STATUS_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object STATUS_Payload that will be copied.
     */
    STATUS_Payload(const STATUS_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object STATUS_Payload that will be copied.
     */
    STATUS_Payload(STATUS_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object STATUS_Payload that will be copied.
     */
    STATUS_Payload& operator=(const STATUS_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object STATUS_Payload that will be copied.
     */
    STATUS_Payload& operator=(STATUS_Payload &&x);
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);
};
/*!
 * @brief This class represents the structure INFO_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class INFO_Payload : public BaseObjectReply
{
public:

    /*!
     * @brief Default constructor.
     */
    INFO_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~INFO_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object INFO_Payload that will be copied.
     */
    INFO_Payload(const INFO_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object INFO_Payload that will be copied.
     */
    INFO_Payload(INFO_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object INFO_Payload that will be copied.
     */
    INFO_Payload& operator=(const INFO_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object INFO_Payload that will be copied.
     */
    INFO_Payload& operator=(INFO_Payload &&x);
    
    /*!
     * @brief This function copies the value in member object_info
     * @param _object_info New value to be copied in member object_info
     */
    inline void object_info(const ObjectInfo &_object_info)
    {
        m_object_info = _object_info;
    }

    /*!
     * @brief This function moves the value in member object_info
     * @param _object_info New value to be moved in member object_info
     */
    inline void object_info(ObjectInfo &&_object_info)
    {
        m_object_info = std::move(_object_info);
    }

    /*!
     * @brief This function returns a constant reference to member object_info
     * @return Constant reference to member object_info
     */
    inline const ObjectInfo& object_info() const
    {
        return m_object_info;
    }

    /*!
     * @brief This function returns a reference to member object_info
     * @return Reference to member object_info
     */
    inline ObjectInfo& object_info()
    {
        return m_object_info;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ObjectInfo m_object_info;
};

/*!
 * @brief This class represents the structure READ_DATA_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class READ_DATA_Payload : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    READ_DATA_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~READ_DATA_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object READ_DATA_Payload that will be copied.
     */
    READ_DATA_Payload(const READ_DATA_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object READ_DATA_Payload that will be copied.
     */
    READ_DATA_Payload(READ_DATA_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object READ_DATA_Payload that will be copied.
     */
    READ_DATA_Payload& operator=(const READ_DATA_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object READ_DATA_Payload that will be copied.
     */
    READ_DATA_Payload& operator=(READ_DATA_Payload &&x);
    
    /*!
     * @brief This function copies the value in member read_specification
     * @param _read_specification New value to be copied in member read_specification
     */
    inline void read_specification(const ReadSpecification &_read_specification)
    {
        m_read_specification = _read_specification;
    }

    /*!
     * @brief This function moves the value in member read_specification
     * @param _read_specification New value to be moved in member read_specification
     */
    inline void read_specification(ReadSpecification &&_read_specification)
    {
        m_read_specification = std::move(_read_specification);
    }

    /*!
     * @brief This function returns a constant reference to member read_specification
     * @return Constant reference to member read_specification
     */
    inline const ReadSpecification& read_specification() const
    {
        return m_read_specification;
    }

    /*!
     * @brief This function returns a reference to member read_specification
     * @return Reference to member read_specification
     */
    inline ReadSpecification& read_specification()
    {
        return m_read_specification;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    ReadSpecification m_read_specification;
};

/*!
 * @brief This class represents the structure WRITE_DATA_Payload_Data defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class WRITE_DATA_Payload_Data : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    WRITE_DATA_Payload_Data();
    
    /*!
     * @brief Default destructor.
     */
    ~WRITE_DATA_Payload_Data();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WRITE_DATA_Payload_Data that will be copied.
     */
    WRITE_DATA_Payload_Data(const WRITE_DATA_Payload_Data &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object WRITE_DATA_Payload_Data that will be copied.
     */
    WRITE_DATA_Payload_Data(WRITE_DATA_Payload_Data &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WRITE_DATA_Payload_Data that will be copied.
     */
    WRITE_DATA_Payload_Data& operator=(const WRITE_DATA_Payload_Data &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object WRITE_DATA_Payload_Data that will be copied.
     */
    WRITE_DATA_Payload_Data& operator=(WRITE_DATA_Payload_Data &&x);
    
    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    inline void data(const SampleData &_data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    inline void data(SampleData &&_data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    inline const SampleData& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    inline SampleData& data()
    {
        return m_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleData m_data;
};

/*!
 * @brief This class represents the structure WRITE_DATA_Payload_Sample defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class WRITE_DATA_Payload_Sample : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    WRITE_DATA_Payload_Sample();
    
    /*!
     * @brief Default destructor.
     */
    ~WRITE_DATA_Payload_Sample();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WRITE_DATA_Payload_Sample that will be copied.
     */
    WRITE_DATA_Payload_Sample(const WRITE_DATA_Payload_Sample &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object WRITE_DATA_Payload_Sample that will be copied.
     */
    WRITE_DATA_Payload_Sample(WRITE_DATA_Payload_Sample &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WRITE_DATA_Payload_Sample that will be copied.
     */
    WRITE_DATA_Payload_Sample& operator=(const WRITE_DATA_Payload_Sample &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object WRITE_DATA_Payload_Sample that will be copied.
     */
    WRITE_DATA_Payload_Sample& operator=(WRITE_DATA_Payload_Sample &&x);
    
    /*!
     * @brief This function copies the value in member sample
     * @param _sample New value to be copied in member sample
     */
    inline void sample(const Sample &_sample)
    {
        m_sample = _sample;
    }

    /*!
     * @brief This function moves the value in member sample
     * @param _sample New value to be moved in member sample
     */
    inline void sample(Sample &&_sample)
    {
        m_sample = std::move(_sample);
    }

    /*!
     * @brief This function returns a constant reference to member sample
     * @return Constant reference to member sample
     */
    inline const Sample& sample() const
    {
        return m_sample;
    }

    /*!
     * @brief This function returns a reference to member sample
     * @return Reference to member sample
     */
    inline Sample& sample()
    {
        return m_sample;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    Sample m_sample;
};

/*!
 * @brief This class represents the structure WRITE_DATA_Payload_DataSeq defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class WRITE_DATA_Payload_DataSeq : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    WRITE_DATA_Payload_DataSeq();
    
    /*!
     * @brief Default destructor.
     */
    ~WRITE_DATA_Payload_DataSeq();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WRITE_DATA_Payload_DataSeq that will be copied.
     */
    WRITE_DATA_Payload_DataSeq(const WRITE_DATA_Payload_DataSeq &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object WRITE_DATA_Payload_DataSeq that will be copied.
     */
    WRITE_DATA_Payload_DataSeq(WRITE_DATA_Payload_DataSeq &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WRITE_DATA_Payload_DataSeq that will be copied.
     */
    WRITE_DATA_Payload_DataSeq& operator=(const WRITE_DATA_Payload_DataSeq &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object WRITE_DATA_Payload_DataSeq that will be copied.
     */
    WRITE_DATA_Payload_DataSeq& operator=(WRITE_DATA_Payload_DataSeq &&x);
    
    /*!
     * @brief This function copies the value in member data_seq
     * @param _data_seq New value to be copied in member data_seq
     */
    inline void data_seq(const std::vector<SampleData> &_data_seq)
    {
        m_data_seq = _data_seq;
    }

    /*!
     * @brief This function moves the value in member data_seq
     * @param _data_seq New value to be moved in member data_seq
     */
    inline void data_seq(std::vector<SampleData> &&_data_seq)
    {
        m_data_seq = std::move(_data_seq);
    }

    /*!
     * @brief This function returns a constant reference to member data_seq
     * @return Constant reference to member data_seq
     */
    inline const std::vector<SampleData>& data_seq() const
    {
        return m_data_seq;
    }

    /*!
     * @brief This function returns a reference to member data_seq
     * @return Reference to member data_seq
     */
    inline std::vector<SampleData>& data_seq()
    {
        return m_data_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<SampleData> m_data_seq;
};

/*!
 * @brief This class represents the structure WRITE_DATA_Payload_SampleSeq defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class WRITE_DATA_Payload_SampleSeq : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    WRITE_DATA_Payload_SampleSeq();
    
    /*!
     * @brief Default destructor.
     */
    ~WRITE_DATA_Payload_SampleSeq();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WRITE_DATA_Payload_SampleSeq that will be copied.
     */
    WRITE_DATA_Payload_SampleSeq(const WRITE_DATA_Payload_SampleSeq &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object WRITE_DATA_Payload_SampleSeq that will be copied.
     */
    WRITE_DATA_Payload_SampleSeq(WRITE_DATA_Payload_SampleSeq &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WRITE_DATA_Payload_SampleSeq that will be copied.
     */
    WRITE_DATA_Payload_SampleSeq& operator=(const WRITE_DATA_Payload_SampleSeq &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object WRITE_DATA_Payload_SampleSeq that will be copied.
     */
    WRITE_DATA_Payload_SampleSeq& operator=(WRITE_DATA_Payload_SampleSeq &&x);
    
    /*!
     * @brief This function copies the value in member sample_seq
     * @param _sample_seq New value to be copied in member sample_seq
     */
    inline void sample_seq(const std::vector<Sample> &_sample_seq)
    {
        m_sample_seq = _sample_seq;
    }

    /*!
     * @brief This function moves the value in member sample_seq
     * @param _sample_seq New value to be moved in member sample_seq
     */
    inline void sample_seq(std::vector<Sample> &&_sample_seq)
    {
        m_sample_seq = std::move(_sample_seq);
    }

    /*!
     * @brief This function returns a constant reference to member sample_seq
     * @return Constant reference to member sample_seq
     */
    inline const std::vector<Sample>& sample_seq() const
    {
        return m_sample_seq;
    }

    /*!
     * @brief This function returns a reference to member sample_seq
     * @return Reference to member sample_seq
     */
    inline std::vector<Sample>& sample_seq()
    {
        return m_sample_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<Sample> m_sample_seq;
};
/*!
 * @brief This class represents the structure WRITE_DATA_Payload_PackedSamples defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class WRITE_DATA_Payload_PackedSamples : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    WRITE_DATA_Payload_PackedSamples();
    
    /*!
     * @brief Default destructor.
     */
    ~WRITE_DATA_Payload_PackedSamples();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WRITE_DATA_Payload_PackedSamples that will be copied.
     */
    WRITE_DATA_Payload_PackedSamples(const WRITE_DATA_Payload_PackedSamples &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object WRITE_DATA_Payload_PackedSamples that will be copied.
     */
    WRITE_DATA_Payload_PackedSamples(WRITE_DATA_Payload_PackedSamples &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WRITE_DATA_Payload_PackedSamples that will be copied.
     */
    WRITE_DATA_Payload_PackedSamples& operator=(const WRITE_DATA_Payload_PackedSamples &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object WRITE_DATA_Payload_PackedSamples that will be copied.
     */
    WRITE_DATA_Payload_PackedSamples& operator=(WRITE_DATA_Payload_PackedSamples &&x);
    
    /*!
     * @brief This function copies the value in member packed_samples
     * @param _packed_samples New value to be copied in member packed_samples
     */
    inline void packed_samples(const PackedSamples &_packed_samples)
    {
        m_packed_samples = _packed_samples;
    }

    /*!
     * @brief This function moves the value in member packed_samples
     * @param _packed_samples New value to be moved in member packed_samples
     */
    inline void packed_samples(PackedSamples &&_packed_samples)
    {
        m_packed_samples = std::move(_packed_samples);
    }

    /*!
     * @brief This function returns a constant reference to member packed_samples
     * @return Constant reference to member packed_samples
     */
    inline const PackedSamples& packed_samples() const
    {
        return m_packed_samples;
    }

    /*!
     * @brief This function returns a reference to member packed_samples
     * @return Reference to member packed_samples
     */
    inline PackedSamples& packed_samples()
    {
        return m_packed_samples;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    PackedSamples m_packed_samples;
};

/*!
 * @brief This class represents the structure DATA_Payload_Data defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATA_Payload_Data : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DATA_Payload_Data();
    
    /*!
     * @brief Default destructor.
     */
    ~DATA_Payload_Data();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATA_Payload_Data that will be copied.
     */
    DATA_Payload_Data(const DATA_Payload_Data &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATA_Payload_Data that will be copied.
     */
    DATA_Payload_Data(DATA_Payload_Data &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATA_Payload_Data that will be copied.
     */
    DATA_Payload_Data& operator=(const DATA_Payload_Data &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATA_Payload_Data that will be copied.
     */
    DATA_Payload_Data& operator=(DATA_Payload_Data &&x);
    
    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    inline void data(const SampleData &_data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    inline void data(SampleData &&_data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    inline const SampleData& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    inline SampleData& data()
    {
        return m_data;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    SampleData m_data;
};

/*!
 * @brief This class represents the structure DATA_Payload_Sample defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATA_Payload_Sample : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DATA_Payload_Sample();
    
    /*!
     * @brief Default destructor.
     */
    ~DATA_Payload_Sample();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATA_Payload_Sample that will be copied.
     */
    DATA_Payload_Sample(const DATA_Payload_Sample &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATA_Payload_Sample that will be copied.
     */
    DATA_Payload_Sample(DATA_Payload_Sample &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATA_Payload_Sample that will be copied.
     */
    DATA_Payload_Sample& operator=(const DATA_Payload_Sample &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATA_Payload_Sample that will be copied.
     */
    DATA_Payload_Sample& operator=(DATA_Payload_Sample &&x);
    
    /*!
     * @brief This function copies the value in member sample
     * @param _sample New value to be copied in member sample
     */
    inline void sample(const Sample &_sample)
    {
        m_sample = _sample;
    }

    /*!
     * @brief This function moves the value in member sample
     * @param _sample New value to be moved in member sample
     */
    inline void sample(Sample &&_sample)
    {
        m_sample = std::move(_sample);
    }

    /*!
     * @brief This function returns a constant reference to member sample
     * @return Constant reference to member sample
     */
    inline const Sample& sample() const
    {
        return m_sample;
    }

    /*!
     * @brief This function returns a reference to member sample
     * @return Reference to member sample
     */
    inline Sample& sample()
    {
        return m_sample;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    Sample m_sample;
};

/*!
 * @brief This class represents the structure DATA_Payload_DataSeq defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATA_Payload_DataSeq : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DATA_Payload_DataSeq();
    
    /*!
     * @brief Default destructor.
     */
    ~DATA_Payload_DataSeq();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATA_Payload_DataSeq that will be copied.
     */
    DATA_Payload_DataSeq(const DATA_Payload_DataSeq &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATA_Payload_DataSeq that will be copied.
     */
    DATA_Payload_DataSeq(DATA_Payload_DataSeq &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATA_Payload_DataSeq that will be copied.
     */
    DATA_Payload_DataSeq& operator=(const DATA_Payload_DataSeq &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATA_Payload_DataSeq that will be copied.
     */
    DATA_Payload_DataSeq& operator=(DATA_Payload_DataSeq &&x);
    
    /*!
     * @brief This function copies the value in member data_seq
     * @param _data_seq New value to be copied in member data_seq
     */
    inline void data_seq(const std::vector<SampleData> &_data_seq)
    {
        m_data_seq = _data_seq;
    }

    /*!
     * @brief This function moves the value in member data_seq
     * @param _data_seq New value to be moved in member data_seq
     */
    inline void data_seq(std::vector<SampleData> &&_data_seq)
    {
        m_data_seq = std::move(_data_seq);
    }

    /*!
     * @brief This function returns a constant reference to member data_seq
     * @return Constant reference to member data_seq
     */
    inline const std::vector<SampleData>& data_seq() const
    {
        return m_data_seq;
    }

    /*!
     * @brief This function returns a reference to member data_seq
     * @return Reference to member data_seq
     */
    inline std::vector<SampleData>& data_seq()
    {
        return m_data_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<SampleData> m_data_seq;
};

/*!
 * @brief This class represents the structure DATA_Payload_SampleSeq defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATA_Payload_SampleSeq : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DATA_Payload_SampleSeq();
    
    /*!
     * @brief Default destructor.
     */
    ~DATA_Payload_SampleSeq();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATA_Payload_SampleSeq that will be copied.
     */
    DATA_Payload_SampleSeq(const DATA_Payload_SampleSeq &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATA_Payload_SampleSeq that will be copied.
     */
    DATA_Payload_SampleSeq(DATA_Payload_SampleSeq &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATA_Payload_SampleSeq that will be copied.
     */
    DATA_Payload_SampleSeq& operator=(const DATA_Payload_SampleSeq &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATA_Payload_SampleSeq that will be copied.
     */
    DATA_Payload_SampleSeq& operator=(DATA_Payload_SampleSeq &&x);
    
    /*!
     * @brief This function copies the value in member sample_seq
     * @param _sample_seq New value to be copied in member sample_seq
     */
    inline void sample_seq(const std::vector<Sample> &_sample_seq)
    {
        m_sample_seq = _sample_seq;
    }

    /*!
     * @brief This function moves the value in member sample_seq
     * @param _sample_seq New value to be moved in member sample_seq
     */
    inline void sample_seq(std::vector<Sample> &&_sample_seq)
    {
        m_sample_seq = std::move(_sample_seq);
    }

    /*!
     * @brief This function returns a constant reference to member sample_seq
     * @return Constant reference to member sample_seq
     */
    inline const std::vector<Sample>& sample_seq() const
    {
        return m_sample_seq;
    }

    /*!
     * @brief This function returns a reference to member sample_seq
     * @return Reference to member sample_seq
     */
    inline std::vector<Sample>& sample_seq()
    {
        return m_sample_seq;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    std::vector<Sample> m_sample_seq;
};

/*!
 * @brief This class represents the structure DATA_Payload_PackedSamples defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class DATA_Payload_PackedSamples : public BaseObjectRequest
{
public:

    /*!
     * @brief Default constructor.
     */
    DATA_Payload_PackedSamples();
    
    /*!
     * @brief Default destructor.
     */
    ~DATA_Payload_PackedSamples();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DATA_Payload_PackedSamples that will be copied.
     */
    DATA_Payload_PackedSamples(const DATA_Payload_PackedSamples &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object DATA_Payload_PackedSamples that will be copied.
     */
    DATA_Payload_PackedSamples(DATA_Payload_PackedSamples &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DATA_Payload_PackedSamples that will be copied.
     */
    DATA_Payload_PackedSamples& operator=(const DATA_Payload_PackedSamples &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object DATA_Payload_PackedSamples that will be copied.
     */
    DATA_Payload_PackedSamples& operator=(DATA_Payload_PackedSamples &&x);
    
    /*!
     * @brief This function copies the value in member packed_samples
     * @param _packed_samples New value to be copied in member packed_samples
     */
    inline void packed_samples(const PackedSamples &_packed_samples)
    {
        m_packed_samples = _packed_samples;
    }

    /*!
     * @brief This function moves the value in member packed_samples
     * @param _packed_samples New value to be moved in member packed_samples
     */
    inline void packed_samples(PackedSamples &&_packed_samples)
    {
        m_packed_samples = std::move(_packed_samples);
    }

    /*!
     * @brief This function returns a constant reference to member packed_samples
     * @return Constant reference to member packed_samples
     */
    inline const PackedSamples& packed_samples() const
    {
        return m_packed_samples;
    }

    /*!
     * @brief This function returns a reference to member packed_samples
     * @return Reference to member packed_samples
     */
    inline PackedSamples& packed_samples()
    {
        return m_packed_samples;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    PackedSamples m_packed_samples;
};

/*!
 * @brief This class represents the structure ACKNACK_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class ACKNACK_Payload
{
public:

    /*!
     * @brief Default constructor.
     */
    ACKNACK_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~ACKNACK_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ACKNACK_Payload that will be copied.
     */
    ACKNACK_Payload(const ACKNACK_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object ACKNACK_Payload that will be copied.
     */
    ACKNACK_Payload(ACKNACK_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ACKNACK_Payload that will be copied.
     */
    ACKNACK_Payload& operator=(const ACKNACK_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object ACKNACK_Payload that will be copied.
     */
    ACKNACK_Payload& operator=(ACKNACK_Payload &&x);
    
    /*!
     * @brief This function sets a value in member first_unacked_seq_num
     * @param _first_unacked_seq_num New value for member first_unacked_seq_num
     */
    inline void first_unacked_seq_num(uint16_t _first_unacked_seq_num)
    {
        m_first_unacked_seq_num = _first_unacked_seq_num;
    }

    /*!
     * @brief This function returns the value of member first_unacked_seq_num
     * @return Value of member first_unacked_seq_num
     */
    inline uint16_t first_unacked_seq_num() const
    {
        return m_first_unacked_seq_num;
    }

    /*!
     * @brief This function returns a reference to member first_unacked_seq_num
     * @return Reference to member first_unacked_seq_num
     */
    inline uint16_t& first_unacked_seq_num()
    {
        return m_first_unacked_seq_num;
    }
    /*!
     * @brief This function copies the value in member nack_bitmap
     * @param _nack_bitmap New value to be copied in member nack_bitmap
     */
    inline void nack_bitmap(const std::array<uint8_t, 2> &_nack_bitmap)
    {
        m_nack_bitmap = _nack_bitmap;
    }

    /*!
     * @brief This function moves the value in member nack_bitmap
     * @param _nack_bitmap New value to be moved in member nack_bitmap
     */
    inline void nack_bitmap(std::array<uint8_t, 2> &&_nack_bitmap)
    {
        m_nack_bitmap = std::move(_nack_bitmap);
    }

    /*!
     * @brief This function returns a constant reference to member nack_bitmap
     * @return Constant reference to member nack_bitmap
     */
    inline const std::array<uint8_t, 2>& nack_bitmap() const
    {
        return m_nack_bitmap;
    }

    /*!
     * @brief This function returns a reference to member nack_bitmap
     * @return Reference to member nack_bitmap
     */
    inline std::array<uint8_t, 2>& nack_bitmap()
    {
        return m_nack_bitmap;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    uint16_t m_first_unacked_seq_num;
    std::array<uint8_t, 2> m_nack_bitmap;
};

/*!
 * @brief This class represents the structure HEARTBEAT_Payload defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
class HEARTBEAT_Payload
{
public:

    /*!
     * @brief Default constructor.
     */
    HEARTBEAT_Payload();
    
    /*!
     * @brief Default destructor.
     */
    ~HEARTBEAT_Payload();
    
    /*!
     * @brief Copy constructor.
     * @param x Reference to the object HEARTBEAT_Payload that will be copied.
     */
    HEARTBEAT_Payload(const HEARTBEAT_Payload &x);
    
    /*!
     * @brief Move constructor.
     * @param x Reference to the object HEARTBEAT_Payload that will be copied.
     */
    HEARTBEAT_Payload(HEARTBEAT_Payload &&x);
    
    /*!
     * @brief Copy assignment.
     * @param x Reference to the object HEARTBEAT_Payload that will be copied.
     */
    HEARTBEAT_Payload& operator=(const HEARTBEAT_Payload &x);
    
    /*!
     * @brief Move assignment.
     * @param x Reference to the object HEARTBEAT_Payload that will be copied.
     */
    HEARTBEAT_Payload& operator=(HEARTBEAT_Payload &&x);
    
    /*!
     * @brief This function sets a value in member first_unacked_seq_nr
     * @param _first_unacked_seq_nr New value for member first_unacked_seq_nr
     */
    inline void first_unacked_seq_nr(uint16_t _first_unacked_seq_nr)
    {
        m_first_unacked_seq_nr = _first_unacked_seq_nr;
    }

    /*!
     * @brief This function returns the value of member first_unacked_seq_nr
     * @return Value of member first_unacked_seq_nr
     */
    inline uint16_t first_unacked_seq_nr() const
    {
        return m_first_unacked_seq_nr;
    }

    /*!
     * @brief This function returns a reference to member first_unacked_seq_nr
     * @return Reference to member first_unacked_seq_nr
     */
    inline uint16_t& first_unacked_seq_nr()
    {
        return m_first_unacked_seq_nr;
    }
    /*!
     * @brief This function sets a value in member last_unacked_seq_nr
     * @param _last_unacked_seq_nr New value for member last_unacked_seq_nr
     */
    inline void last_unacked_seq_nr(uint16_t _last_unacked_seq_nr)
    {
        m_last_unacked_seq_nr = _last_unacked_seq_nr;
    }

    /*!
     * @brief This function returns the value of member last_unacked_seq_nr
     * @return Value of member last_unacked_seq_nr
     */
    inline uint16_t last_unacked_seq_nr() const
    {
        return m_last_unacked_seq_nr;
    }

    /*!
     * @brief This function returns a reference to member last_unacked_seq_nr
     * @return Reference to member last_unacked_seq_nr
     */
    inline uint16_t& last_unacked_seq_nr()
    {
        return m_last_unacked_seq_nr;
    }
    
    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    virtual size_t getCdrSerializedSize(size_t current_alignment = 0) const;

    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    virtual void deserialize(eprosima::fastcdr::Cdr &cdr);

private:
    uint16_t m_first_unacked_seq_nr;
    uint16_t m_last_unacked_seq_nr;
};
/*!
 * @brief This class represents the enumeration SubmessageId defined by the user in the IDL file.
 * @ingroup TYPESMOD
 */
enum SubmessageId : uint8_t
{
    CREATE_CLIENT   = 0,
    CREATE          = 1,
    GET_INFO        = 2,
    DELETE_ID       = 3,
    STATUS_AGENT    = 4,
    STATUS          = 5,
    INFO            = 6,
    WRITE_DATA      = 7,
    READ_DATA       = 8,
    DATA            = 9,
    ACKNACK         = 10,
    HEARTBEAT       = 11,
    RESET           = 12,
    FRAGMENT        = 13
};

} } // namespace 

#endif //_UXR_AGENT_TYPES_XRCETYPES_HPP_
