// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Basic.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "Basic.h"
#include "BasicTypeObject.h"
#include <fastcdr/Cdr.h>

#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>




EnumStruct::EnumStruct()
{
    m_my_enum = ::A;


    // Just to register all known types
    registerBasicTypes();
}

EnumStruct::~EnumStruct()
{
}

EnumStruct::EnumStruct(const EnumStruct &x)
{
    m_my_enum = x.m_my_enum;
}

EnumStruct::EnumStruct(EnumStruct &&x)
{
    m_my_enum = x.m_my_enum;
}

EnumStruct& EnumStruct::operator=(const EnumStruct &x)
{
    m_my_enum = x.m_my_enum;

    return *this;
}

EnumStruct& EnumStruct::operator=(EnumStruct &&x)
{
    m_my_enum = x.m_my_enum;

    return *this;
}

size_t EnumStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t EnumStruct::getCdrSerializedSize(const EnumStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void EnumStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint32_t)m_my_enum;
}

void EnumStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_my_enum = (MyEnum)enum_value;
    }
}

size_t EnumStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool EnumStruct::isKeyDefined()
{
    return false;
}

void EnumStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
AliasStruct::AliasStruct()
{
    m_my_alias = ::A;


    // Just to register all known types
    registerBasicTypes();
}

AliasStruct::~AliasStruct()
{
}

AliasStruct::AliasStruct(const AliasStruct &x)
{
    m_my_alias = x.m_my_alias;
}

AliasStruct::AliasStruct(AliasStruct &&x)
{
    m_my_alias = x.m_my_alias;
}

AliasStruct& AliasStruct::operator=(const AliasStruct &x)
{
    m_my_alias = x.m_my_alias;

    return *this;
}

AliasStruct& AliasStruct::operator=(AliasStruct &&x)
{
    m_my_alias = x.m_my_alias;

    return *this;
}

size_t AliasStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t AliasStruct::getCdrSerializedSize(const AliasStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void AliasStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint32_t)m_my_alias;
}

void AliasStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_my_alias = (MyAliasEnum)enum_value;
    }
}

size_t AliasStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool AliasStruct::isKeyDefined()
{
    return false;
}

void AliasStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
AliasAliasStruct::AliasAliasStruct()
{
    m_my_alias_alias = ::A;


    // Just to register all known types
    registerBasicTypes();
}

AliasAliasStruct::~AliasAliasStruct()
{
}

AliasAliasStruct::AliasAliasStruct(const AliasAliasStruct &x)
{
    m_my_alias_alias = x.m_my_alias_alias;
}

AliasAliasStruct::AliasAliasStruct(AliasAliasStruct &&x)
{
    m_my_alias_alias = x.m_my_alias_alias;
}

AliasAliasStruct& AliasAliasStruct::operator=(const AliasAliasStruct &x)
{
    m_my_alias_alias = x.m_my_alias_alias;

    return *this;
}

AliasAliasStruct& AliasAliasStruct::operator=(AliasAliasStruct &&x)
{
    m_my_alias_alias = x.m_my_alias_alias;

    return *this;
}

size_t AliasAliasStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t AliasAliasStruct::getCdrSerializedSize(const AliasAliasStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void AliasAliasStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint32_t)m_my_alias_alias;
}

void AliasAliasStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_my_alias_alias = (MyAliasAliasEnum)enum_value;
    }
}

size_t AliasAliasStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool AliasAliasStruct::isKeyDefined()
{
    return false;
}

void AliasAliasStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
BoolStruct::BoolStruct()
{
    m_my_bool = false;


    // Just to register all known types
    registerBasicTypes();
}

BoolStruct::~BoolStruct()
{
}

BoolStruct::BoolStruct(const BoolStruct &x)
{
    m_my_bool = x.m_my_bool;
}

BoolStruct::BoolStruct(BoolStruct &&x)
{
    m_my_bool = x.m_my_bool;
}

BoolStruct& BoolStruct::operator=(const BoolStruct &x)
{
    m_my_bool = x.m_my_bool;

    return *this;
}

BoolStruct& BoolStruct::operator=(BoolStruct &&x)
{
    m_my_bool = x.m_my_bool;

    return *this;
}

size_t BoolStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t BoolStruct::getCdrSerializedSize(const BoolStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void BoolStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_bool;
}

void BoolStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_bool;
}

size_t BoolStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool BoolStruct::isKeyDefined()
{
    return false;
}

void BoolStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
OctetStruct::OctetStruct()
{
    m_my_octet = 0;


    // Just to register all known types
    registerBasicTypes();
}

OctetStruct::~OctetStruct()
{
}

OctetStruct::OctetStruct(const OctetStruct &x)
{
    m_my_octet = x.m_my_octet;
}

OctetStruct::OctetStruct(OctetStruct &&x)
{
    m_my_octet = x.m_my_octet;
}

OctetStruct& OctetStruct::operator=(const OctetStruct &x)
{
    m_my_octet = x.m_my_octet;

    return *this;
}

OctetStruct& OctetStruct::operator=(OctetStruct &&x)
{
    m_my_octet = x.m_my_octet;

    return *this;
}

size_t OctetStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t OctetStruct::getCdrSerializedSize(const OctetStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void OctetStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_octet;
}

void OctetStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_octet;
}

size_t OctetStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool OctetStruct::isKeyDefined()
{
    return false;
}

void OctetStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
ShortStruct::ShortStruct()
{
    m_my_int16 = 0;


    // Just to register all known types
    registerBasicTypes();
}

ShortStruct::~ShortStruct()
{
}

ShortStruct::ShortStruct(const ShortStruct &x)
{
    m_my_int16 = x.m_my_int16;
}

ShortStruct::ShortStruct(ShortStruct &&x)
{
    m_my_int16 = x.m_my_int16;
}

ShortStruct& ShortStruct::operator=(const ShortStruct &x)
{
    m_my_int16 = x.m_my_int16;

    return *this;
}

ShortStruct& ShortStruct::operator=(ShortStruct &&x)
{
    m_my_int16 = x.m_my_int16;

    return *this;
}

size_t ShortStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t ShortStruct::getCdrSerializedSize(const ShortStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void ShortStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_int16;
}

void ShortStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_int16;
}

size_t ShortStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool ShortStruct::isKeyDefined()
{
    return false;
}

void ShortStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
LongStruct::LongStruct()
{
    m_my_int32 = 0;


    // Just to register all known types
    registerBasicTypes();
}

LongStruct::~LongStruct()
{
}

LongStruct::LongStruct(const LongStruct &x)
{
    m_my_int32 = x.m_my_int32;
}

LongStruct::LongStruct(LongStruct &&x)
{
    m_my_int32 = x.m_my_int32;
}

LongStruct& LongStruct::operator=(const LongStruct &x)
{
    m_my_int32 = x.m_my_int32;

    return *this;
}

LongStruct& LongStruct::operator=(LongStruct &&x)
{
    m_my_int32 = x.m_my_int32;

    return *this;
}

size_t LongStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t LongStruct::getCdrSerializedSize(const LongStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void LongStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_int32;
}

void LongStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_int32;
}

size_t LongStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool LongStruct::isKeyDefined()
{
    return false;
}

void LongStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
LongLongStruct::LongLongStruct()
{
    m_my_int64 = 0;


    // Just to register all known types
    registerBasicTypes();
}

LongLongStruct::~LongLongStruct()
{
}

LongLongStruct::LongLongStruct(const LongLongStruct &x)
{
    m_my_int64 = x.m_my_int64;
}

LongLongStruct::LongLongStruct(LongLongStruct &&x)
{
    m_my_int64 = x.m_my_int64;
}

LongLongStruct& LongLongStruct::operator=(const LongLongStruct &x)
{
    m_my_int64 = x.m_my_int64;

    return *this;
}

LongLongStruct& LongLongStruct::operator=(LongLongStruct &&x)
{
    m_my_int64 = x.m_my_int64;

    return *this;
}

size_t LongLongStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

size_t LongLongStruct::getCdrSerializedSize(const LongLongStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

void LongLongStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_int64;
}

void LongLongStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_int64;
}

size_t LongLongStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool LongLongStruct::isKeyDefined()
{
    return false;
}

void LongLongStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
UShortStruct::UShortStruct()
{
    m_my_uint16 = 0;


    // Just to register all known types
    registerBasicTypes();
}

UShortStruct::~UShortStruct()
{
}

UShortStruct::UShortStruct(const UShortStruct &x)
{
    m_my_uint16 = x.m_my_uint16;
}

UShortStruct::UShortStruct(UShortStruct &&x)
{
    m_my_uint16 = x.m_my_uint16;
}

UShortStruct& UShortStruct::operator=(const UShortStruct &x)
{
    m_my_uint16 = x.m_my_uint16;

    return *this;
}

UShortStruct& UShortStruct::operator=(UShortStruct &&x)
{
    m_my_uint16 = x.m_my_uint16;

    return *this;
}

size_t UShortStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

size_t UShortStruct::getCdrSerializedSize(const UShortStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    return current_alignment - initial_alignment;
}

void UShortStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_uint16;
}

void UShortStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_uint16;
}

size_t UShortStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool UShortStruct::isKeyDefined()
{
    return false;
}

void UShortStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
ULongStruct::ULongStruct()
{
    m_my_uint32 = 0;


    // Just to register all known types
    registerBasicTypes();
}

ULongStruct::~ULongStruct()
{
}

ULongStruct::ULongStruct(const ULongStruct &x)
{
    m_my_uint32 = x.m_my_uint32;
}

ULongStruct::ULongStruct(ULongStruct &&x)
{
    m_my_uint32 = x.m_my_uint32;
}

ULongStruct& ULongStruct::operator=(const ULongStruct &x)
{
    m_my_uint32 = x.m_my_uint32;

    return *this;
}

ULongStruct& ULongStruct::operator=(ULongStruct &&x)
{
    m_my_uint32 = x.m_my_uint32;

    return *this;
}

size_t ULongStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t ULongStruct::getCdrSerializedSize(const ULongStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void ULongStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_uint32;
}

void ULongStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_uint32;
}

size_t ULongStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool ULongStruct::isKeyDefined()
{
    return false;
}

void ULongStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
ULongLongStruct::ULongLongStruct()
{
    m_my_uint64 = 0;


    // Just to register all known types
    registerBasicTypes();
}

ULongLongStruct::~ULongLongStruct()
{
}

ULongLongStruct::ULongLongStruct(const ULongLongStruct &x)
{
    m_my_uint64 = x.m_my_uint64;
}

ULongLongStruct::ULongLongStruct(ULongLongStruct &&x)
{
    m_my_uint64 = x.m_my_uint64;
}

ULongLongStruct& ULongLongStruct::operator=(const ULongLongStruct &x)
{
    m_my_uint64 = x.m_my_uint64;

    return *this;
}

ULongLongStruct& ULongLongStruct::operator=(ULongLongStruct &&x)
{
    m_my_uint64 = x.m_my_uint64;

    return *this;
}

size_t ULongLongStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

size_t ULongLongStruct::getCdrSerializedSize(const ULongLongStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

void ULongLongStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_uint64;
}

void ULongLongStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_uint64;
}

size_t ULongLongStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool ULongLongStruct::isKeyDefined()
{
    return false;
}

void ULongLongStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
FloatStruct::FloatStruct()
{
    m_my_float32 = 0.0;


    // Just to register all known types
    registerBasicTypes();
}

FloatStruct::~FloatStruct()
{
}

FloatStruct::FloatStruct(const FloatStruct &x)
{
    m_my_float32 = x.m_my_float32;
}

FloatStruct::FloatStruct(FloatStruct &&x)
{
    m_my_float32 = x.m_my_float32;
}

FloatStruct& FloatStruct::operator=(const FloatStruct &x)
{
    m_my_float32 = x.m_my_float32;

    return *this;
}

FloatStruct& FloatStruct::operator=(FloatStruct &&x)
{
    m_my_float32 = x.m_my_float32;

    return *this;
}

size_t FloatStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t FloatStruct::getCdrSerializedSize(const FloatStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void FloatStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_float32;
}

void FloatStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_float32;
}

size_t FloatStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool FloatStruct::isKeyDefined()
{
    return false;
}

void FloatStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
DoubleStruct::DoubleStruct()
{
    m_my_float64 = 0.0;


    // Just to register all known types
    registerBasicTypes();
}

DoubleStruct::~DoubleStruct()
{
}

DoubleStruct::DoubleStruct(const DoubleStruct &x)
{
    m_my_float64 = x.m_my_float64;
}

DoubleStruct::DoubleStruct(DoubleStruct &&x)
{
    m_my_float64 = x.m_my_float64;
}

DoubleStruct& DoubleStruct::operator=(const DoubleStruct &x)
{
    m_my_float64 = x.m_my_float64;

    return *this;
}

DoubleStruct& DoubleStruct::operator=(DoubleStruct &&x)
{
    m_my_float64 = x.m_my_float64;

    return *this;
}

size_t DoubleStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

size_t DoubleStruct::getCdrSerializedSize(const DoubleStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    return current_alignment - initial_alignment;
}

void DoubleStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_float64;
}

void DoubleStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_float64;
}

size_t DoubleStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool DoubleStruct::isKeyDefined()
{
    return false;
}

void DoubleStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
LongDoubleStruct::LongDoubleStruct()
{
    m_my_float128 = 0.0;


    // Just to register all known types
    registerBasicTypes();
}

LongDoubleStruct::~LongDoubleStruct()
{
}

LongDoubleStruct::LongDoubleStruct(const LongDoubleStruct &x)
{
    m_my_float128 = x.m_my_float128;
}

LongDoubleStruct::LongDoubleStruct(LongDoubleStruct &&x)
{
    m_my_float128 = x.m_my_float128;
}

LongDoubleStruct& LongDoubleStruct::operator=(const LongDoubleStruct &x)
{
    m_my_float128 = x.m_my_float128;

    return *this;
}

LongDoubleStruct& LongDoubleStruct::operator=(LongDoubleStruct &&x)
{
    m_my_float128 = x.m_my_float128;

    return *this;
}

size_t LongDoubleStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 16 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8); // 128 bits, but aligned as 64


    return current_alignment - initial_alignment;
}

size_t LongDoubleStruct::getCdrSerializedSize(const LongDoubleStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 16 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8); // 128 bits, but aligned as 64


    return current_alignment - initial_alignment;
}

void LongDoubleStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_float128;
}

void LongDoubleStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_float128;
}

size_t LongDoubleStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool LongDoubleStruct::isKeyDefined()
{
    return false;
}

void LongDoubleStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
CharStruct::CharStruct()
{
    m_my_char = 0;


    // Just to register all known types
    registerBasicTypes();
}

CharStruct::~CharStruct()
{
}

CharStruct::CharStruct(const CharStruct &x)
{
    m_my_char = x.m_my_char;
}

CharStruct::CharStruct(CharStruct &&x)
{
    m_my_char = x.m_my_char;
}

CharStruct& CharStruct::operator=(const CharStruct &x)
{
    m_my_char = x.m_my_char;

    return *this;
}

CharStruct& CharStruct::operator=(CharStruct &&x)
{
    m_my_char = x.m_my_char;

    return *this;
}

size_t CharStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

size_t CharStruct::getCdrSerializedSize(const CharStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    return current_alignment - initial_alignment;
}

void CharStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_char;
}

void CharStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_char;
}

size_t CharStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool CharStruct::isKeyDefined()
{
    return false;
}

void CharStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
WCharStruct::WCharStruct()
{
    m_my_wchar = 0;


    // Just to register all known types
    registerBasicTypes();
}

WCharStruct::~WCharStruct()
{
}

WCharStruct::WCharStruct(const WCharStruct &x)
{
    m_my_wchar = x.m_my_wchar;
}

WCharStruct::WCharStruct(WCharStruct &&x)
{
    m_my_wchar = x.m_my_wchar;
}

WCharStruct& WCharStruct::operator=(const WCharStruct &x)
{
    m_my_wchar = x.m_my_wchar;

    return *this;
}

WCharStruct& WCharStruct::operator=(WCharStruct &&x)
{
    m_my_wchar = x.m_my_wchar;

    return *this;
}

size_t WCharStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t WCharStruct::getCdrSerializedSize(const WCharStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

void WCharStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_wchar;
}

void WCharStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_wchar;
}

size_t WCharStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool WCharStruct::isKeyDefined()
{
    return false;
}

void WCharStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
StringStruct::StringStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

StringStruct::~StringStruct()
{
}

StringStruct::StringStruct(const StringStruct &x)
{
    m_my_string = x.m_my_string;
}

StringStruct::StringStruct(StringStruct &&x)
{
    m_my_string = std::move(x.m_my_string);
}

StringStruct& StringStruct::operator=(const StringStruct &x)
{
    m_my_string = x.m_my_string;

    return *this;
}

StringStruct& StringStruct::operator=(StringStruct &&x)
{
    m_my_string = std::move(x.m_my_string);

    return *this;
}

size_t StringStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    return current_alignment - initial_alignment;
}

size_t StringStruct::getCdrSerializedSize(const StringStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_string().size() + 1;

    return current_alignment - initial_alignment;
}

void StringStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_string;
}

void StringStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_string;
}

size_t StringStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool StringStruct::isKeyDefined()
{
    return false;
}

void StringStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
WStringStruct::WStringStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

WStringStruct::~WStringStruct()
{
}

WStringStruct::WStringStruct(const WStringStruct &x)
{
    m_my_wstring = x.m_my_wstring;
}

WStringStruct::WStringStruct(WStringStruct &&x)
{
    m_my_wstring = std::move(x.m_my_wstring);
}

WStringStruct& WStringStruct::operator=(const WStringStruct &x)
{
    m_my_wstring = x.m_my_wstring;

    return *this;
}

WStringStruct& WStringStruct::operator=(WStringStruct &&x)
{
    m_my_wstring = std::move(x.m_my_wstring);

    return *this;
}

size_t WStringStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (255) * 4; // 32 bits

    return current_alignment - initial_alignment;
}

size_t WStringStruct::getCdrSerializedSize(const WStringStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (data.my_wstring().size()) * 4; // 32 bits

    return current_alignment - initial_alignment;
}

void WStringStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_wstring;
}

void WStringStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_wstring;
}

size_t WStringStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool WStringStruct::isKeyDefined()
{
    return false;
}

void WStringStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
LargeStringStruct::LargeStringStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

LargeStringStruct::~LargeStringStruct()
{
}

LargeStringStruct::LargeStringStruct(const LargeStringStruct &x)
{
    m_my_large_string = x.m_my_large_string;
}

LargeStringStruct::LargeStringStruct(LargeStringStruct &&x)
{
    m_my_large_string = std::move(x.m_my_large_string);
}

LargeStringStruct& LargeStringStruct::operator=(const LargeStringStruct &x)
{
    m_my_large_string = x.m_my_large_string;

    return *this;
}

LargeStringStruct& LargeStringStruct::operator=(LargeStringStruct &&x)
{
    m_my_large_string = std::move(x.m_my_large_string);

    return *this;
}

size_t LargeStringStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 41925 + 1;

    return current_alignment - initial_alignment;
}

size_t LargeStringStruct::getCdrSerializedSize(const LargeStringStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_large_string().size() + 1;

    return current_alignment - initial_alignment;
}

void LargeStringStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_large_string;
}

void LargeStringStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_large_string;
}

size_t LargeStringStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool LargeStringStruct::isKeyDefined()
{
    return false;
}

void LargeStringStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
LargeWStringStruct::LargeWStringStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

LargeWStringStruct::~LargeWStringStruct()
{
}

LargeWStringStruct::LargeWStringStruct(const LargeWStringStruct &x)
{
    m_my_large_wstring = x.m_my_large_wstring;
}

LargeWStringStruct::LargeWStringStruct(LargeWStringStruct &&x)
{
    m_my_large_wstring = std::move(x.m_my_large_wstring);
}

LargeWStringStruct& LargeWStringStruct::operator=(const LargeWStringStruct &x)
{
    m_my_large_wstring = x.m_my_large_wstring;

    return *this;
}

LargeWStringStruct& LargeWStringStruct::operator=(LargeWStringStruct &&x)
{
    m_my_large_wstring = std::move(x.m_my_large_wstring);

    return *this;
}

size_t LargeWStringStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (41925) * 4; // 32 bits

    return current_alignment - initial_alignment;
}

size_t LargeWStringStruct::getCdrSerializedSize(const LargeWStringStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (data.my_large_wstring().size()) * 4; // 32 bits

    return current_alignment - initial_alignment;
}

void LargeWStringStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_large_wstring;
}

void LargeWStringStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_large_wstring;
}

size_t LargeWStringStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool LargeWStringStruct::isKeyDefined()
{
    return false;
}

void LargeWStringStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
ArraytStruct::ArraytStruct()
{
    memset(&m_my_array, 0, (2 * 2 * 2) * 4);
    // Just to register all known types
    registerBasicTypes();
}

ArraytStruct::~ArraytStruct()
{
}

ArraytStruct::ArraytStruct(const ArraytStruct &x)
{
    m_my_array = x.m_my_array;
}

ArraytStruct::ArraytStruct(ArraytStruct &&x)
{
    m_my_array = std::move(x.m_my_array);
}

ArraytStruct& ArraytStruct::operator=(const ArraytStruct &x)
{
    m_my_array = x.m_my_array;

    return *this;
}

ArraytStruct& ArraytStruct::operator=(ArraytStruct &&x)
{
    m_my_array = std::move(x.m_my_array);

    return *this;
}

size_t ArraytStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += ((2 * 2 * 2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}

size_t ArraytStruct::getCdrSerializedSize(const ArraytStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += ((2 * 2 * 2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    return current_alignment - initial_alignment;
}

void ArraytStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_array;
}

void ArraytStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_array;
}

size_t ArraytStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool ArraytStruct::isKeyDefined()
{
    return false;
}

void ArraytStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}

ArrayArrayStruct::ArrayArrayStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

ArrayArrayStruct::~ArrayArrayStruct()
{
}

ArrayArrayStruct::ArrayArrayStruct(const ArrayArrayStruct &x)
{
    m_my_array_array = x.m_my_array_array;
}

ArrayArrayStruct::ArrayArrayStruct(ArrayArrayStruct &&x)
{
    m_my_array_array = std::move(x.m_my_array_array);
}

ArrayArrayStruct& ArrayArrayStruct::operator=(const ArrayArrayStruct &x)
{
    m_my_array_array = x.m_my_array_array;

    return *this;
}

ArrayArrayStruct& ArrayArrayStruct::operator=(ArrayArrayStruct &&x)
{
    m_my_array_array = std::move(x.m_my_array_array);

    return *this;
}

size_t ArrayArrayStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;


    for(size_t a = 0; a < (2 * 2); ++a)
    {
    current_alignment += ((2 * 2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    }
    return current_alignment - initial_alignment;
}

size_t ArrayArrayStruct::getCdrSerializedSize(const ArrayArrayStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;


    for(size_t a = 0; a < data.my_array_array().size(); ++a)
    {

        for(size_t b = 0; b < data.my_array_array().at(a).size(); ++b)
        {
                current_alignment += ((2 * 2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        }
    }
    return current_alignment - initial_alignment;
}

void ArrayArrayStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_array_array;
}

void ArrayArrayStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_array_array;
}

size_t ArrayArrayStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool ArrayArrayStruct::isKeyDefined()
{
    return false;
}

void ArrayArrayStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
SequenceStruct::SequenceStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

SequenceStruct::~SequenceStruct()
{
}

SequenceStruct::SequenceStruct(const SequenceStruct &x)
{
    m_my_sequence = x.m_my_sequence;
}

SequenceStruct::SequenceStruct(SequenceStruct &&x)
{
    m_my_sequence = std::move(x.m_my_sequence);
}

SequenceStruct& SequenceStruct::operator=(const SequenceStruct &x)
{
    m_my_sequence = x.m_my_sequence;

    return *this;
}

SequenceStruct& SequenceStruct::operator=(SequenceStruct &&x)
{
    m_my_sequence = std::move(x.m_my_sequence);

    return *this;
}

size_t SequenceStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += (2 * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



    return current_alignment - initial_alignment;
}

size_t SequenceStruct::getCdrSerializedSize(const SequenceStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += (data.my_sequence().size() * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



    return current_alignment - initial_alignment;
}

void SequenceStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_sequence;
}

void SequenceStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_sequence;
}

size_t SequenceStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool SequenceStruct::isKeyDefined()
{
    return false;
}

void SequenceStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
SequenceSequenceStruct::SequenceSequenceStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

SequenceSequenceStruct::~SequenceSequenceStruct()
{
}

SequenceSequenceStruct::SequenceSequenceStruct(const SequenceSequenceStruct &x)
{
    m_my_sequence_sequence = x.m_my_sequence_sequence;
}

SequenceSequenceStruct::SequenceSequenceStruct(SequenceSequenceStruct &&x)
{
    m_my_sequence_sequence = std::move(x.m_my_sequence_sequence);
}

SequenceSequenceStruct& SequenceSequenceStruct::operator=(const SequenceSequenceStruct &x)
{
    m_my_sequence_sequence = x.m_my_sequence_sequence;

    return *this;
}

SequenceSequenceStruct& SequenceSequenceStruct::operator=(SequenceSequenceStruct &&x)
{
    m_my_sequence_sequence = std::move(x.m_my_sequence_sequence);

    return *this;
}

size_t SequenceSequenceStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < 3; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += (2 * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    }

    return current_alignment - initial_alignment;
}

size_t SequenceSequenceStruct::getCdrSerializedSize(const SequenceSequenceStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.my_sequence_sequence().size(); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += (data.my_sequence_sequence().at(a).size() * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    }

    return current_alignment - initial_alignment;
}

void SequenceSequenceStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_sequence_sequence;
}

void SequenceSequenceStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_sequence_sequence;
}

size_t SequenceSequenceStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool SequenceSequenceStruct::isKeyDefined()
{
    return false;
}

void SequenceSequenceStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
MapStruct::MapStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

MapStruct::~MapStruct()
{
}

MapStruct::MapStruct(const MapStruct &x)
{
    m_my_map = x.m_my_map;
}

MapStruct::MapStruct(MapStruct &&x)
{
    m_my_map = std::move(x.m_my_map);
}

MapStruct& MapStruct::operator=(const MapStruct &x)
{
    m_my_map = x.m_my_map;

    return *this;
}

MapStruct& MapStruct::operator=(MapStruct &&x)
{
    m_my_map = std::move(x.m_my_map);

    return *this;
}

size_t MapStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 2; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    }

    return current_alignment - initial_alignment;
}

size_t MapStruct::getCdrSerializedSize(const MapStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



    }


    return current_alignment - initial_alignment;
}

void MapStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_map;
}

void MapStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_map;
}

size_t MapStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool MapStruct::isKeyDefined()
{
    return false;
}

void MapStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
MapMapStruct::MapMapStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

MapMapStruct::~MapMapStruct()
{
}

MapMapStruct::MapMapStruct(const MapMapStruct &x)
{
    m_my_map_map = x.m_my_map_map;
}

MapMapStruct::MapMapStruct(MapMapStruct &&x)
{
    m_my_map_map = std::move(x.m_my_map_map);
}

MapMapStruct& MapMapStruct::operator=(const MapMapStruct &x)
{
    m_my_map_map = x.m_my_map_map;

    return *this;
}

MapMapStruct& MapMapStruct::operator=(MapMapStruct &&x)
{
    m_my_map_map = std::move(x.m_my_map_map);

    return *this;
}

size_t MapMapStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 2; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        for(size_t b = 0; b < 2; ++b)
        {
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        }
    }

    return current_alignment - initial_alignment;
}

size_t MapMapStruct::getCdrSerializedSize(const MapMapStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_map())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        for(auto b : a.second)
        {
            (void)b;
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



        }


    }


    return current_alignment - initial_alignment;
}

void MapMapStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_map_map;
}

void MapMapStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_map_map;
}

size_t MapMapStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool MapMapStruct::isKeyDefined()
{
    return false;
}

void MapMapStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
StructStruct::StructStruct()
{
    m_a = 0;

    m_b = 0;


    // Just to register all known types
    registerBasicTypes();
}

StructStruct::~StructStruct()
{
}

StructStruct::StructStruct(const StructStruct &x)
{
    m_a = x.m_a;
    m_b = x.m_b;
}

StructStruct::StructStruct(StructStruct &&x)
{
    m_a = x.m_a;
    m_b = x.m_b;
}

StructStruct& StructStruct::operator=(const StructStruct &x)
{
    m_a = x.m_a;
    m_b = x.m_b;

    return *this;
}

StructStruct& StructStruct::operator=(StructStruct &&x)
{
    m_a = x.m_a;
    m_b = x.m_b;

    return *this;
}

size_t StructStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);



    return current_alignment - initial_alignment;
}

size_t StructStruct::getCdrSerializedSize(const StructStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);



    return current_alignment - initial_alignment;
}

void StructStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_a;
    scdr << m_b;
}

void StructStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_a;
    dcdr >> m_b;
}

size_t StructStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            



    return current_align;
}

bool StructStruct::isKeyDefined()
{
    return false;
}

void StructStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
	 
}
StructStructStruct::StructStructStruct()
{

    m_child_int64 = 0;


    // Just to register all known types
    registerBasicTypes();
}

StructStructStruct::~StructStructStruct()
{
}

StructStructStruct::StructStructStruct(const StructStructStruct &x)
{
    m_child_struct = x.m_child_struct;
    m_child_int64 = x.m_child_int64;
}

StructStructStruct::StructStructStruct(StructStructStruct &&x)
{
    m_child_struct = std::move(x.m_child_struct);
    m_child_int64 = x.m_child_int64;
}

StructStructStruct& StructStructStruct::operator=(const StructStructStruct &x)
{
    m_child_struct = x.m_child_struct;
    m_child_int64 = x.m_child_int64;

    return *this;
}

StructStructStruct& StructStructStruct::operator=(StructStructStruct &&x)
{
    m_child_struct = std::move(x.m_child_struct);
    m_child_int64 = x.m_child_int64;

    return *this;
}

size_t StructStructStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += StructStruct::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);



    return current_alignment - initial_alignment;
}

size_t StructStructStruct::getCdrSerializedSize(const StructStructStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += StructStruct::getCdrSerializedSize(data.child_struct(), current_alignment);
    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);



    return current_alignment - initial_alignment;
}

void StructStructStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_child_struct;
    scdr << m_child_int64;
}

void StructStructStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_child_struct;
    dcdr >> m_child_int64;
}

size_t StructStructStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            



    return current_align;
}

bool StructStructStruct::isKeyDefined()
{
    return false;
}

void StructStructStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
	 
}
SimpleUnion::SimpleUnion()
{
    m__d = A;
    m_first = 0;

    m_second = 0;

}

SimpleUnion::~SimpleUnion()
{
}

SimpleUnion::SimpleUnion(const SimpleUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }
}

SimpleUnion::SimpleUnion(SimpleUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }
}

SimpleUnion& SimpleUnion::operator=(const SimpleUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }

    return *this;
}

SimpleUnion& SimpleUnion::operator=(SimpleUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }

    return *this;
}

void SimpleUnion::_d(int32_t __d)
{
    bool b = false;

    switch(m__d)
    {
        case A:
        switch(__d)
        {
            case A:
            b = true;
            break;
            default:
            break;
        }
        break;
        case B:
        switch(__d)
        {
            case B:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

int32_t SimpleUnion::_d() const
{
    return m__d;
}

int32_t& SimpleUnion::_d()
{
    return m__d;
}

void SimpleUnion::first(int32_t _first)
{
    m_first = _first;
    m__d = A;
}

int32_t SimpleUnion::first() const
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}

int32_t& SimpleUnion::first()
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}
void SimpleUnion::second(int64_t _second)
{
    m_second = _second;
    m__d = B;
}

int64_t SimpleUnion::second() const
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

int64_t& SimpleUnion::second()
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

size_t SimpleUnion::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 8 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 8);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t SimpleUnion::getCdrSerializedSize(const SimpleUnion& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    switch(data.m__d)
    {
        case A:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        break;
        case B:
        current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);

        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void SimpleUnion::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case A:
        scdr << m_first;
        break;
        case B:
        scdr << m_second;
        break;
        default:
        break;
    }
}

void SimpleUnion::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case A:
        dcdr >> m_first;
        break;
        case B:
        dcdr >> m_second;
        break;
        default:
        break;
    }
}


UnionUnion::UnionUnion()
{
    m__d = A;
    m_first = 0;


}

UnionUnion::~UnionUnion()
{
}

UnionUnion::UnionUnion(const UnionUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }
}

UnionUnion::UnionUnion(UnionUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = std::move(x.m_second);
        break;
        default:
        break;
    }
}

UnionUnion& UnionUnion::operator=(const UnionUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }

    return *this;
}

UnionUnion& UnionUnion::operator=(UnionUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = std::move(x.m_second);
        break;
        default:
        break;
    }

    return *this;
}

void UnionUnion::_d(int32_t __d)
{
    bool b = false;

    switch(m__d)
    {
        case A:
        switch(__d)
        {
            case A:
            b = true;
            break;
            default:
            break;
        }
        break;
        case B:
        switch(__d)
        {
            case B:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

int32_t UnionUnion::_d() const
{
    return m__d;
}

int32_t& UnionUnion::_d()
{
    return m__d;
}

void UnionUnion::first(int32_t _first)
{
    m_first = _first;
    m__d = A;
}

int32_t UnionUnion::first() const
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}

int32_t& UnionUnion::first()
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}
void UnionUnion::second(const SimpleUnion &_second)
{
    m_second = _second;
    m__d = B;
}

void UnionUnion::second(SimpleUnion &&_second)
{
    m_second = std::move(_second);
    m__d = B;
}

const SimpleUnion& UnionUnion::second() const
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

SimpleUnion& UnionUnion::second()
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

size_t UnionUnion::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += SimpleUnion::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t UnionUnion::getCdrSerializedSize(const UnionUnion& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    switch(data.m__d)
    {
        case A:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        break;
        case B:
        current_alignment += SimpleUnion::getCdrSerializedSize(data.second(), current_alignment);
        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void UnionUnion::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case A:
        scdr << m_first;
        break;
        case B:
        scdr << m_second;
        break;
        default:
        break;
    }
}

void UnionUnion::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case A:
        dcdr >> m_first;
        break;
        case B:
        dcdr >> m_second;
        break;
        default:
        break;
    }
}


WCharUnion::WCharUnion()
{
    m__d = A;
    m_first = 0;

    m_second = 0;

}

WCharUnion::~WCharUnion()
{
}

WCharUnion::WCharUnion(const WCharUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }
}

WCharUnion::WCharUnion(WCharUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }
}

WCharUnion& WCharUnion::operator=(const WCharUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }

    return *this;
}

WCharUnion& WCharUnion::operator=(WCharUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_first = x.m_first;
        break;
        case B:
        m_second = x.m_second;
        break;
        default:
        break;
    }

    return *this;
}

void WCharUnion::_d(wchar_t __d)
{
    bool b = false;

    switch(m__d)
    {
        case A:
        switch(__d)
        {
            case A:
            b = true;
            break;
            default:
            break;
        }
        break;
        case B:
        switch(__d)
        {
            case B:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

wchar_t WCharUnion::_d() const
{
    return m__d;
}

wchar_t& WCharUnion::_d()
{
    return m__d;
}

void WCharUnion::first(int32_t _first)
{
    m_first = _first;
    m__d = A;
}

int32_t WCharUnion::first() const
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}

int32_t& WCharUnion::first()
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_first;
}
void WCharUnion::second(int64_t _second)
{
    m_second = _second;
    m__d = B;
}

int64_t WCharUnion::second() const
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

int64_t& WCharUnion::second()
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_second;
}

size_t WCharUnion::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 8 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 8);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t WCharUnion::getCdrSerializedSize(const WCharUnion& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    switch(data.m__d)
    {
        case A:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        break;
        case B:
        current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);

        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void WCharUnion::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case A:
        scdr << m_first;
        break;
        case B:
        scdr << m_second;
        break;
        default:
        break;
    }
}

void WCharUnion::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case A:
        dcdr >> m_first;
        break;
        case B:
        dcdr >> m_second;
        break;
        default:
        break;
    }
}


SimpleUnionStruct::SimpleUnionStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

SimpleUnionStruct::~SimpleUnionStruct()
{
}

SimpleUnionStruct::SimpleUnionStruct(const SimpleUnionStruct &x)
{
    m_my_union = x.m_my_union;
}

SimpleUnionStruct::SimpleUnionStruct(SimpleUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);
}

SimpleUnionStruct& SimpleUnionStruct::operator=(const SimpleUnionStruct &x)
{
    m_my_union = x.m_my_union;

    return *this;
}

SimpleUnionStruct& SimpleUnionStruct::operator=(SimpleUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);

    return *this;
}

size_t SimpleUnionStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += SimpleUnion::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t SimpleUnionStruct::getCdrSerializedSize(const SimpleUnionStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += SimpleUnion::getCdrSerializedSize(data.my_union(), current_alignment);

    return current_alignment - initial_alignment;
}

void SimpleUnionStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_union;
}

void SimpleUnionStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_union;
}

size_t SimpleUnionStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool SimpleUnionStruct::isKeyDefined()
{
    return false;
}

void SimpleUnionStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
UnionUnionUnionStruct::UnionUnionUnionStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

UnionUnionUnionStruct::~UnionUnionUnionStruct()
{
}

UnionUnionUnionStruct::UnionUnionUnionStruct(const UnionUnionUnionStruct &x)
{
    m_my_union = x.m_my_union;
}

UnionUnionUnionStruct::UnionUnionUnionStruct(UnionUnionUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);
}

UnionUnionUnionStruct& UnionUnionUnionStruct::operator=(const UnionUnionUnionStruct &x)
{
    m_my_union = x.m_my_union;

    return *this;
}

UnionUnionUnionStruct& UnionUnionUnionStruct::operator=(UnionUnionUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);

    return *this;
}

size_t UnionUnionUnionStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += UnionUnion::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t UnionUnionUnionStruct::getCdrSerializedSize(const UnionUnionUnionStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += UnionUnion::getCdrSerializedSize(data.my_union(), current_alignment);

    return current_alignment - initial_alignment;
}

void UnionUnionUnionStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_union;
}

void UnionUnionUnionStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_union;
}

size_t UnionUnionUnionStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool UnionUnionUnionStruct::isKeyDefined()
{
    return false;
}

void UnionUnionUnionStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}
WCharUnionStruct::WCharUnionStruct()
{

    // Just to register all known types
    registerBasicTypes();
}

WCharUnionStruct::~WCharUnionStruct()
{
}

WCharUnionStruct::WCharUnionStruct(const WCharUnionStruct &x)
{
    m_my_union = x.m_my_union;
}

WCharUnionStruct::WCharUnionStruct(WCharUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);
}

WCharUnionStruct& WCharUnionStruct::operator=(const WCharUnionStruct &x)
{
    m_my_union = x.m_my_union;

    return *this;
}

WCharUnionStruct& WCharUnionStruct::operator=(WCharUnionStruct &&x)
{
    m_my_union = std::move(x.m_my_union);

    return *this;
}

size_t WCharUnionStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += WCharUnion::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t WCharUnionStruct::getCdrSerializedSize(const WCharUnionStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += WCharUnion::getCdrSerializedSize(data.my_union(), current_alignment);

    return current_alignment - initial_alignment;
}

void WCharUnionStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_union;
}

void WCharUnionStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_union;
}

size_t WCharUnionStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool WCharUnionStruct::isKeyDefined()
{
    return false;
}

void WCharUnionStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
}