// Copyright 2019 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Topic.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "Topic.h"

#include <fastcdr/Cdr.h>

using namespace eprosima::fastcdr::exception;

#include <utility>

Topic::Topic()
    : index_(0)
    , message_()
{
}

Topic::~Topic()
{
}

Topic::Topic(const Topic &x)
{
    index_ = x.index_;
    message_ = x.message_;
}

Topic::Topic(Topic &&x)
{
    index_ = x.index_;
    message_ = std::move(x.message_);
}

Topic& Topic::operator=(const Topic &x)
{
    index_ = x.index_;
    message_ = x.message_;
    
    return *this;
}

Topic& Topic::operator=(Topic &&x)
{
    index_ = x.index_;
    message_ = std::move(x.message_);
    
    return *this;
}

size_t Topic::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;
    return current_alignment - initial_alignment;
}

size_t Topic::getCdrSerializedSize(const Topic& data, size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.message().size() + 1;
    return current_alignment - initial_alignment;
}

void Topic::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << index_;
    scdr << message_;
}

void Topic::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> index_;
    dcdr >> message_;
}

size_t Topic::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
    return current_align;
}

bool Topic::isKeyDefined()
{
    return false;
}

void Topic::serializeKey(eprosima::fastcdr::Cdr&) const
{
}
