// Copyright 2019 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file BuiltinAnnotationsTypeObject.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include <fastrtps/types/BuiltinAnnotationsTypeObject.h>
#include <utility>
#include <sstream>
#include <fastrtps/rtps/common/SerializedPayload.h>
#include <fastrtps/utils/md5.h>
#include <fastrtps/types/TypeNamesGenerator.h>
#include <fastrtps/types/AnnotationParameterValue.h>
#include <fastcdr/FastBuffer.h>
#include <fastcdr/Cdr.h>

using namespace eprosima::fastrtps::rtps;

void register_builtin_annotations_types(TypeObjectFactory* factory)
{
    factory->add_type_object("id", GetidIdentifier(true), GetidObject(true));
    factory->add_type_object("id", GetidIdentifier(false), GetidObject(false));

    factory->add_type_object("autoid", GetautoidIdentifier(true), GetautoidObject(true));
    factory->add_type_object("autoid", GetautoidIdentifier(false), GetautoidObject(false));
    {
        using namespace autoid;

        factory->add_type_object("AutoidKind", GetAutoidKindIdentifier(true), GetAutoidKindObject(true));
        factory->add_type_object("AutoidKind", GetAutoidKindIdentifier(false), GetAutoidKindObject(false));


    }
    factory->add_type_object("optional", GetoptionalIdentifier(true), GetoptionalObject(true));
    factory->add_type_object("optional", GetoptionalIdentifier(false), GetoptionalObject(false));

    factory->add_type_object("position", GetpositionIdentifier(true), GetpositionObject(true));
    factory->add_type_object("position", GetpositionIdentifier(false), GetpositionObject(false));

    factory->add_type_object("value", GetvalueIdentifier(true), GetvalueObject(true));
    factory->add_type_object("value", GetvalueIdentifier(false), GetvalueObject(false));

    factory->add_type_object("extensibility", GetextensibilityIdentifier(true), GetextensibilityObject(true));
    factory->add_type_object("extensibility", GetextensibilityIdentifier(false), GetextensibilityObject(false));
    {
        using namespace extensibility;

        factory->add_type_object("ExtensibilityKind", GetExtensibilityKindIdentifier(true), GetExtensibilityKindObject(true));
        factory->add_type_object("ExtensibilityKind", GetExtensibilityKindIdentifier(false), GetExtensibilityKindObject(false));


    }
    factory->add_type_object("final", GetfinalIdentifier(true), GetfinalObject(true));
    factory->add_type_object("final", GetfinalIdentifier(false), GetfinalObject(false));

    factory->add_type_object("appendable", GetappendableIdentifier(true), GetappendableObject(true));
    factory->add_type_object("appendable", GetappendableIdentifier(false), GetappendableObject(false));

    factory->add_type_object("mutable", GetmutableIdentifier(true), GetmutableObject(true));
    factory->add_type_object("mutable", GetmutableIdentifier(false), GetmutableObject(false));

    factory->add_type_object("key", GetkeyIdentifier(true), GetkeyObject(true));
    factory->add_type_object("key", GetkeyIdentifier(false), GetkeyObject(false));

    factory->add_type_object("must_understand", Getmust_understandIdentifier(true), Getmust_understandObject(true));
    factory->add_type_object("must_understand", Getmust_understandIdentifier(false), Getmust_understandObject(false));

    factory->add_type_object("default_literal", Getdefault_literalIdentifier(true), Getdefault_literalObject(true));
    factory->add_type_object("default_literal", Getdefault_literalIdentifier(false), Getdefault_literalObject(false));

    factory->add_type_object("default", GetdefaultIdentifier(true), GetdefaultObject(true));
    factory->add_type_object("default", GetdefaultIdentifier(false), GetdefaultObject(false));

    factory->add_type_object("range", GetrangeIdentifier(true), GetrangeObject(true));
    factory->add_type_object("range", GetrangeIdentifier(false), GetrangeObject(false));

    factory->add_type_object("min", GetminIdentifier(true), GetminObject(true));
    factory->add_type_object("min", GetminIdentifier(false), GetminObject(false));

    factory->add_type_object("max", GetmaxIdentifier(true), GetmaxObject(true));
    factory->add_type_object("max", GetmaxIdentifier(false), GetmaxObject(false));

    factory->add_type_object("unit", GetunitIdentifier(true), GetunitObject(true));
    factory->add_type_object("unit", GetunitIdentifier(false), GetunitObject(false));

    factory->add_type_object("bit_bound", Getbit_boundIdentifier(true), Getbit_boundObject(true));
    factory->add_type_object("bit_bound", Getbit_boundIdentifier(false), Getbit_boundObject(false));

    factory->add_type_object("external", GetexternalIdentifier(true), GetexternalObject(true));
    factory->add_type_object("external", GetexternalIdentifier(false), GetexternalObject(false));

    factory->add_type_object("nested", GetnestedIdentifier(true), GetnestedObject(true));
    factory->add_type_object("nested", GetnestedIdentifier(false), GetnestedObject(false));

    factory->add_type_object("verbatim", GetverbatimIdentifier(true), GetverbatimObject(true));
    factory->add_type_object("verbatim", GetverbatimIdentifier(false), GetverbatimObject(false));
    {
        using namespace verbatim;

        factory->add_type_object("PlacementKind", GetPlacementKindIdentifier(true), GetPlacementKindObject(true));
        factory->add_type_object("PlacementKind", GetPlacementKindIdentifier(false), GetPlacementKindObject(false));


    }
    factory->add_type_object("service", GetserviceIdentifier(true), GetserviceObject(true));
    factory->add_type_object("service", GetserviceIdentifier(false), GetserviceObject(false));

    factory->add_type_object("oneway", GetonewayIdentifier(true), GetonewayObject(true));
    factory->add_type_object("oneway", GetonewayIdentifier(false), GetonewayObject(false));

    factory->add_type_object("ami", GetamiIdentifier(true), GetamiObject(true));
    factory->add_type_object("ami", GetamiIdentifier(false), GetamiObject(false));

    factory->add_type_object("non_serialized", Getnon_serializedIdentifier(true), Getnon_serializedObject(true));
    factory->add_type_object("non_serialized", Getnon_serializedIdentifier(false), Getnon_serializedObject(false));

}

const TypeIdentifier* GetidIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("id", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetidObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("id", complete);
}

const TypeObject* GetidObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("id", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteidObject();
    }
    // else
    return GetMinimalidObject();
}

const TypeObject* GetMinimalidObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("id", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint32_t", false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("id", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("id", false);
}

const TypeObject* GetCompleteidObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("id", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("id");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint32_t", false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("id", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("id", true);
}


const TypeIdentifier* GetautoidIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("autoid", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetautoidObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("autoid", complete);
}

const TypeObject* GetautoidObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("autoid", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteautoidObject();
    }
    // else
    return GetMinimalautoidObject();
}

const TypeObject* GetMinimalautoidObject()
{
    using namespace autoid;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("autoid", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*GetAutoidKindIdentifier(false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("1");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("autoid", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("autoid", false);
}

const TypeObject* GetCompleteautoidObject()
{
    using namespace autoid;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("autoid", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("autoid");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*GetAutoidKindIdentifier(true));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("1");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("autoid", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("autoid", true);
}

namespace autoid
{
const TypeIdentifier* GetAutoidKindIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("AutoidKind", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetAutoidKindObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("AutoidKind", complete);
}

const TypeObject* GetAutoidKindObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("AutoidKind", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteAutoidKindObject();
    }
    // else
    return GetMinimalAutoidKindObject();
}

const TypeObject* GetMinimalAutoidKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("AutoidKind", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ENUM);

    // No flags apply
    //type_object->minimal().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->minimal().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?

    uint32_t value = 0;
    MinimalEnumeratedLiteral mel_SEQUENTIAL;
    mel_SEQUENTIAL.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().IS_KEY(false); // Doesn't apply
    mel_SEQUENTIAL.common().flags().IS_DEFAULT(false);
    mel_SEQUENTIAL.common().value(value++);
    MD5 SEQUENTIAL_hash("SEQUENTIAL");
    for(int i = 0; i < 4; ++i)
    {
        mel_SEQUENTIAL.detail().name_hash()[i] = SEQUENTIAL_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_SEQUENTIAL);

    MinimalEnumeratedLiteral mel_HASH;
    mel_HASH.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_HASH.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_HASH.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_HASH.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_HASH.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_HASH.common().flags().IS_KEY(false); // Doesn't apply
    mel_HASH.common().flags().IS_DEFAULT(false);
    mel_HASH.common().value(value++);
    MD5 HASH_hash("HASH");
    for(int i = 0; i < 4; ++i)
    {
        mel_HASH.detail().name_hash()[i] = HASH_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_HASH);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalEnumeratedType::getCdrSerializedSize(type_object->minimal().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("AutoidKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("AutoidKind", false);
}

const TypeObject* GetCompleteAutoidKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("AutoidKind", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ENUM);

    // No flags apply
    //type_object->complete().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->complete().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->complete().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->complete().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?
    //type_object->complete().enumerated_type().header().detail().ann_builtin()...
    //type_object->complete().enumerated_type().header().detail().ann_custom()...
    type_object->complete().enumerated_type().header().detail().type_name("AutoidKind");

    uint32_t value = 0;
    CompleteEnumeratedLiteral cel_SEQUENTIAL;
    cel_SEQUENTIAL.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().IS_KEY(false); // Doesn't apply
    cel_SEQUENTIAL.common().flags().IS_DEFAULT(false);
    cel_SEQUENTIAL.common().value(value++);
    cel_SEQUENTIAL.detail().name("SEQUENTIAL");
    //cel_SEQUENTIAL.detail().ann_builtin()...
    //cel_SEQUENTIAL.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_SEQUENTIAL);

    CompleteEnumeratedLiteral cel_HASH;
    cel_HASH.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_HASH.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_HASH.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_HASH.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_HASH.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_HASH.common().flags().IS_KEY(false); // Doesn't apply
    cel_HASH.common().flags().IS_DEFAULT(false);
    cel_HASH.common().value(value++);
    cel_HASH.detail().name("HASH");
    //cel_HASH.detail().ann_builtin()...
    //cel_HASH.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_HASH);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteEnumeratedType::getCdrSerializedSize(type_object->complete().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("AutoidKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("AutoidKind", true);
}



} // autoid namespace
const TypeIdentifier* GetoptionalIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("optional", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetoptionalObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("optional", complete);
}

const TypeObject* GetoptionalObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("optional", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteoptionalObject();
    }
    // else
    return GetMinimaloptionalObject();
}

const TypeObject* GetMinimaloptionalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("optional", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("optional", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("optional", false);
}

const TypeObject* GetCompleteoptionalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("optional", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("optional");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("optional", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("optional", true);
}


const TypeIdentifier* GetpositionIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("position", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetpositionObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("position", complete);
}

const TypeObject* GetpositionObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("position", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletepositionObject();
    }
    // else
    return GetMinimalpositionObject();
}

const TypeObject* GetMinimalpositionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("position", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint16_t", false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("position", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("position", false);
}

const TypeObject* GetCompletepositionObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("position", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("position");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint16_t", false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("position", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("position", true);
}


const TypeIdentifier* GetvalueIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("value", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetvalueObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("value", complete);
}

const TypeObject* GetvalueObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("value", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletevalueObject();
    }
    // else
    return GetMinimalvalueObject();
}

const TypeObject* GetMinimalvalueObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("value", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("value", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("value", false);
}

const TypeObject* GetCompletevalueObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("value", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("value");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("value", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("value", true);
}


const TypeIdentifier* GetextensibilityIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("extensibility", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetextensibilityObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("extensibility", complete);
}

const TypeObject* GetextensibilityObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("extensibility", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteextensibilityObject();
    }
    // else
    return GetMinimalextensibilityObject();
}

const TypeObject* GetMinimalextensibilityObject()
{
    using namespace extensibility;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("extensibility", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*GetExtensibilityKindIdentifier(false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("extensibility", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("extensibility", false);
}

const TypeObject* GetCompleteextensibilityObject()
{
    using namespace extensibility;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("extensibility", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("extensibility");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*GetExtensibilityKindIdentifier(true));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("extensibility", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("extensibility", true);
}

namespace extensibility
{
const TypeIdentifier* GetExtensibilityKindIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("ExtensibilityKind", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetExtensibilityKindObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("ExtensibilityKind", complete);
}

const TypeObject* GetExtensibilityKindObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ExtensibilityKind", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteExtensibilityKindObject();
    }
    // else
    return GetMinimalExtensibilityKindObject();
}

const TypeObject* GetMinimalExtensibilityKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ExtensibilityKind", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ENUM);

    // No flags apply
    //type_object->minimal().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->minimal().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?

    uint32_t value = 0;
    MinimalEnumeratedLiteral mel_FINAL;
    mel_FINAL.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_FINAL.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_FINAL.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_FINAL.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_FINAL.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_FINAL.common().flags().IS_KEY(false); // Doesn't apply
    mel_FINAL.common().flags().IS_DEFAULT(false);
    mel_FINAL.common().value(value++);
    MD5 FINAL_hash("FINAL");
    for(int i = 0; i < 4; ++i)
    {
        mel_FINAL.detail().name_hash()[i] = FINAL_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_FINAL);

    MinimalEnumeratedLiteral mel_APPENDABLE;
    mel_APPENDABLE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_APPENDABLE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_APPENDABLE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_APPENDABLE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_APPENDABLE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_APPENDABLE.common().flags().IS_KEY(false); // Doesn't apply
    mel_APPENDABLE.common().flags().IS_DEFAULT(false);
    mel_APPENDABLE.common().value(value++);
    MD5 APPENDABLE_hash("APPENDABLE");
    for(int i = 0; i < 4; ++i)
    {
        mel_APPENDABLE.detail().name_hash()[i] = APPENDABLE_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_APPENDABLE);

    MinimalEnumeratedLiteral mel_MUTABLE;
    mel_MUTABLE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_MUTABLE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_MUTABLE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_MUTABLE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_MUTABLE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_MUTABLE.common().flags().IS_KEY(false); // Doesn't apply
    mel_MUTABLE.common().flags().IS_DEFAULT(false);
    mel_MUTABLE.common().value(value++);
    MD5 MUTABLE_hash("MUTABLE");
    for(int i = 0; i < 4; ++i)
    {
        mel_MUTABLE.detail().name_hash()[i] = MUTABLE_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_MUTABLE);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalEnumeratedType::getCdrSerializedSize(type_object->minimal().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("ExtensibilityKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("ExtensibilityKind", false);
}

const TypeObject* GetCompleteExtensibilityKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ExtensibilityKind", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ENUM);

    // No flags apply
    //type_object->complete().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->complete().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->complete().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->complete().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?
    //type_object->complete().enumerated_type().header().detail().ann_builtin()...
    //type_object->complete().enumerated_type().header().detail().ann_custom()...
    type_object->complete().enumerated_type().header().detail().type_name("ExtensibilityKind");

    uint32_t value = 0;
    CompleteEnumeratedLiteral cel_FINAL;
    cel_FINAL.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_FINAL.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_FINAL.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_FINAL.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_FINAL.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_FINAL.common().flags().IS_KEY(false); // Doesn't apply
    cel_FINAL.common().flags().IS_DEFAULT(false);
    cel_FINAL.common().value(value++);
    cel_FINAL.detail().name("FINAL");
    //cel_FINAL.detail().ann_builtin()...
    //cel_FINAL.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_FINAL);

    CompleteEnumeratedLiteral cel_APPENDABLE;
    cel_APPENDABLE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_APPENDABLE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_APPENDABLE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_APPENDABLE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_APPENDABLE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_APPENDABLE.common().flags().IS_KEY(false); // Doesn't apply
    cel_APPENDABLE.common().flags().IS_DEFAULT(false);
    cel_APPENDABLE.common().value(value++);
    cel_APPENDABLE.detail().name("APPENDABLE");
    //cel_APPENDABLE.detail().ann_builtin()...
    //cel_APPENDABLE.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_APPENDABLE);

    CompleteEnumeratedLiteral cel_MUTABLE;
    cel_MUTABLE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_MUTABLE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_MUTABLE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_MUTABLE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_MUTABLE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_MUTABLE.common().flags().IS_KEY(false); // Doesn't apply
    cel_MUTABLE.common().flags().IS_DEFAULT(false);
    cel_MUTABLE.common().value(value++);
    cel_MUTABLE.detail().name("MUTABLE");
    //cel_MUTABLE.detail().ann_builtin()...
    //cel_MUTABLE.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_MUTABLE);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteEnumeratedType::getCdrSerializedSize(type_object->complete().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("ExtensibilityKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("ExtensibilityKind", true);
}



} // extensibility namespace
const TypeIdentifier* GetfinalIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("final", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetfinalObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("final", complete);
}

const TypeObject* GetfinalObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("final", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletefinalObject();
    }
    // else
    return GetMinimalfinalObject();
}

const TypeObject* GetMinimalfinalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("final", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("final", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("final", false);
}

const TypeObject* GetCompletefinalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("final", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("final");


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("final", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("final", true);
}


const TypeIdentifier* GetappendableIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("appendable", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetappendableObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("appendable", complete);
}

const TypeObject* GetappendableObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("appendable", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteappendableObject();
    }
    // else
    return GetMinimalappendableObject();
}

const TypeObject* GetMinimalappendableObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("appendable", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("appendable", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("appendable", false);
}

const TypeObject* GetCompleteappendableObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("appendable", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("appendable");


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("appendable", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("appendable", true);
}


const TypeIdentifier* GetmutableIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("mutable", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetmutableObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("mutable", complete);
}

const TypeObject* GetmutableObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("mutable", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletemutableObject();
    }
    // else
    return GetMinimalmutableObject();
}

const TypeObject* GetMinimalmutableObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("mutable", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("mutable", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("mutable", false);
}

const TypeObject* GetCompletemutableObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("mutable", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("mutable");


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("mutable", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("mutable", true);
}


const TypeIdentifier* GetkeyIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("key", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetkeyObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("key", complete);
}

const TypeObject* GetkeyObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("key", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletekeyObject();
    }
    // else
    return GetMinimalkeyObject();
}

const TypeObject* GetMinimalkeyObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("key", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("key", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("key", false);
}

const TypeObject* GetCompletekeyObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("key", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("key");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("key", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("key", true);
}


const TypeIdentifier* Getmust_understandIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("must_understand", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    Getmust_understandObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("must_understand", complete);
}

const TypeObject* Getmust_understandObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("must_understand", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletemust_understandObject();
    }
    // else
    return GetMinimalmust_understandObject();
}

const TypeObject* GetMinimalmust_understandObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("must_understand", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("must_understand", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("must_understand", false);
}

const TypeObject* GetCompletemust_understandObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("must_understand", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("must_understand");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("must_understand", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("must_understand", true);
}


const TypeIdentifier* Getdefault_literalIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("default_literal", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    Getdefault_literalObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("default_literal", complete);
}

const TypeObject* Getdefault_literalObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default_literal", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletedefault_literalObject();
    }
    // else
    return GetMinimaldefault_literalObject();
}

const TypeObject* GetMinimaldefault_literalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default_literal", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("default_literal", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("default_literal", false);
}

const TypeObject* GetCompletedefault_literalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default_literal", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("default_literal");


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("default_literal", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("default_literal", true);
}


const TypeIdentifier* GetdefaultIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("default", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetdefaultObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("default", complete);
}

const TypeObject* GetdefaultObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletedefaultObject();
    }
    // else
    return GetMinimaldefaultObject();
}

const TypeObject* GetMinimaldefaultObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("default", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("default", false);
}

const TypeObject* GetCompletedefaultObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("default", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("default");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("default", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("default", true);
}


const TypeIdentifier* GetrangeIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("range", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetrangeObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("range", complete);
}

const TypeObject* GetrangeObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("range", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleterangeObject();
    }
    // else
    return GetMinimalrangeObject();
}

const TypeObject* GetMinimalrangeObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("range", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_min;
    mam_min.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_min.name("min");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_min);

    MinimalAnnotationParameter mam_max;
    mam_max.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_max.name("max");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_max);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("range", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("range", false);
}

const TypeObject* GetCompleterangeObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("range", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("range");

    CompleteAnnotationParameter cam_min;
    cam_min.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_min.name("min");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_min);

    CompleteAnnotationParameter cam_max;
    cam_max.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_max.name("max");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_max);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("range", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("range", true);
}


const TypeIdentifier* GetminIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("min", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetminObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("min", complete);
}

const TypeObject* GetminObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("min", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteminObject();
    }
    // else
    return GetMinimalminObject();
}

const TypeObject* GetMinimalminObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("min", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("min", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("min", false);
}

const TypeObject* GetCompleteminObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("min", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("min");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("min", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("min", true);
}


const TypeIdentifier* GetmaxIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("max", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetmaxObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("max", complete);
}

const TypeObject* GetmaxObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("max", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletemaxObject();
    }
    // else
    return GetMinimalmaxObject();
}

const TypeObject* GetMinimalmaxObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("max", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("max", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("max", false);
}

const TypeObject* GetCompletemaxObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("max", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("max");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("max", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("max", true);
}


const TypeIdentifier* GetunitIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("unit", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetunitObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("unit", complete);
}

const TypeObject* GetunitObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("unit", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteunitObject();
    }
    // else
    return GetMinimalunitObject();
}

const TypeObject* GetMinimalunitObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("unit", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("unit", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("unit", false);
}

const TypeObject* GetCompleteunitObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("unit", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("unit");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("unit", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("unit", true);
}


const TypeIdentifier* Getbit_boundIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("bit_bound", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    Getbit_boundObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("bit_bound", complete);
}

const TypeObject* Getbit_boundObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("bit_bound", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletebit_boundObject();
    }
    // else
    return GetMinimalbit_boundObject();
}

const TypeObject* GetMinimalbit_boundObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("bit_bound", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint16_t", false));
    mam_value.name("value");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("bit_bound", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("bit_bound", false);
}

const TypeObject* GetCompletebit_boundObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("bit_bound", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("bit_bound");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("uint16_t", false));
    cam_value.name("value");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("bit_bound", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("bit_bound", true);
}


const TypeIdentifier* GetexternalIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("external", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetexternalObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("external", complete);
}

const TypeObject* GetexternalObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("external", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteexternalObject();
    }
    // else
    return GetMinimalexternalObject();
}

const TypeObject* GetMinimalexternalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("external", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("external", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("external", false);
}

const TypeObject* GetCompleteexternalObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("external", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("external");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("external", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("external", true);
}


const TypeIdentifier* GetnestedIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("nested", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetnestedObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("nested", complete);
}

const TypeObject* GetnestedObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("nested", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletenestedObject();
    }
    // else
    return GetMinimalnestedObject();
}

const TypeObject* GetMinimalnestedObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("nested", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("nested", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("nested", false);
}

const TypeObject* GetCompletenestedObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("nested", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("nested");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("nested", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("nested", true);
}


const TypeIdentifier* GetverbatimIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("verbatim", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetverbatimObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("verbatim", complete);
}

const TypeObject* GetverbatimObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("verbatim", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteverbatimObject();
    }
    // else
    return GetMinimalverbatimObject();
}

const TypeObject* GetMinimalverbatimObject()
{
    using namespace verbatim;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("verbatim", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_language;
    mam_language.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_language.name("language");

    AnnotationParameterValue def_value_language;
    def_value_language._d(mam_language.common().member_type_id()._d());
    def_value_language.from_string("*");
    mam_language.default_value(def_value_language);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_language);

    MinimalAnnotationParameter mam_placement;
    mam_placement.common().member_type_id(*GetPlacementKindIdentifier(false));
    mam_placement.name("placement");

    AnnotationParameterValue def_value_placement;
    def_value_placement._d(mam_placement.common().member_type_id()._d());
    def_value_placement.from_string("1");
    mam_placement.default_value(def_value_placement);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_placement);

    MinimalAnnotationParameter mam_text;
    mam_text.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_text.name("text");

    type_object->minimal().annotation_type().member_seq().emplace_back(mam_text);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("verbatim", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("verbatim", false);
}

const TypeObject* GetCompleteverbatimObject()
{
    using namespace verbatim;
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("verbatim", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("verbatim");

    CompleteAnnotationParameter cam_language;
    cam_language.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_language.name("language");

    AnnotationParameterValue def_value_language;
    def_value_language._d(cam_language.common().member_type_id()._d());
    def_value_language.from_string("*");
    cam_language.default_value(def_value_language);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_language);

    CompleteAnnotationParameter cam_placement;
    cam_placement.common().member_type_id(*GetPlacementKindIdentifier(true));
    cam_placement.name("placement");

    AnnotationParameterValue def_value_placement;
    def_value_placement._d(cam_placement.common().member_type_id()._d());
    def_value_placement.from_string("1");
    cam_placement.default_value(def_value_placement);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_placement);

    CompleteAnnotationParameter cam_text;
    cam_text.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_text.name("text");

    type_object->complete().annotation_type().member_seq().emplace_back(cam_text);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("verbatim", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("verbatim", true);
}

namespace verbatim
{
const TypeIdentifier* GetPlacementKindIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("PlacementKind", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetPlacementKindObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("PlacementKind", complete);
}

const TypeObject* GetPlacementKindObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("PlacementKind", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletePlacementKindObject();
    }
    // else
    return GetMinimalPlacementKindObject();
}

const TypeObject* GetMinimalPlacementKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("PlacementKind", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ENUM);

    // No flags apply
    //type_object->minimal().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->minimal().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->minimal().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?

    uint32_t value = 0;
    MinimalEnumeratedLiteral mel_BEGIN_FILE;
    mel_BEGIN_FILE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().IS_KEY(false); // Doesn't apply
    mel_BEGIN_FILE.common().flags().IS_DEFAULT(false);
    mel_BEGIN_FILE.common().value(value++);
    MD5 BEGIN_FILE_hash("BEGIN_FILE");
    for(int i = 0; i < 4; ++i)
    {
        mel_BEGIN_FILE.detail().name_hash()[i] = BEGIN_FILE_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_BEGIN_FILE);

    MinimalEnumeratedLiteral mel_BEFORE_DECLARATION;
    mel_BEFORE_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    mel_BEFORE_DECLARATION.common().flags().IS_DEFAULT(false);
    mel_BEFORE_DECLARATION.common().value(value++);
    MD5 BEFORE_DECLARATION_hash("BEFORE_DECLARATION");
    for(int i = 0; i < 4; ++i)
    {
        mel_BEFORE_DECLARATION.detail().name_hash()[i] = BEFORE_DECLARATION_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_BEFORE_DECLARATION);

    MinimalEnumeratedLiteral mel_BEGIN_DECLARATION;
    mel_BEGIN_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    mel_BEGIN_DECLARATION.common().flags().IS_DEFAULT(false);
    mel_BEGIN_DECLARATION.common().value(value++);
    MD5 BEGIN_DECLARATION_hash("BEGIN_DECLARATION");
    for(int i = 0; i < 4; ++i)
    {
        mel_BEGIN_DECLARATION.detail().name_hash()[i] = BEGIN_DECLARATION_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_BEGIN_DECLARATION);

    MinimalEnumeratedLiteral mel_END_DECLARATION;
    mel_END_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    mel_END_DECLARATION.common().flags().IS_DEFAULT(false);
    mel_END_DECLARATION.common().value(value++);
    MD5 END_DECLARATION_hash("END_DECLARATION");
    for(int i = 0; i < 4; ++i)
    {
        mel_END_DECLARATION.detail().name_hash()[i] = END_DECLARATION_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_END_DECLARATION);

    MinimalEnumeratedLiteral mel_AFTER_DECLARATION;
    mel_AFTER_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    mel_AFTER_DECLARATION.common().flags().IS_DEFAULT(false);
    mel_AFTER_DECLARATION.common().value(value++);
    MD5 AFTER_DECLARATION_hash("AFTER_DECLARATION");
    for(int i = 0; i < 4; ++i)
    {
        mel_AFTER_DECLARATION.detail().name_hash()[i] = AFTER_DECLARATION_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_AFTER_DECLARATION);

    MinimalEnumeratedLiteral mel_END_FILE;
    mel_END_FILE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    mel_END_FILE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    mel_END_FILE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    mel_END_FILE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    mel_END_FILE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    mel_END_FILE.common().flags().IS_KEY(false); // Doesn't apply
    mel_END_FILE.common().flags().IS_DEFAULT(false);
    mel_END_FILE.common().value(value++);
    MD5 END_FILE_hash("END_FILE");
    for(int i = 0; i < 4; ++i)
    {
        mel_END_FILE.detail().name_hash()[i] = END_FILE_hash.digest[i];
    }
    type_object->minimal().enumerated_type().literal_seq().emplace_back(mel_END_FILE);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalEnumeratedType::getCdrSerializedSize(type_object->minimal().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("PlacementKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("PlacementKind", false);
}

const TypeObject* GetCompletePlacementKindObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("PlacementKind", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ENUM);

    // No flags apply
    //type_object->complete().enumerated_type().enum_flags().IS_FINAL(false);
    //type_object->complete().enumerated_type().enum_flags().IS_APPENDABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_MUTABLE(false);
    //type_object->complete().enumerated_type().enum_flags().IS_NESTED(false);
    //type_object->complete().enumerated_type().enum_flags().IS_AUTOID_HASH(false);

    type_object->complete().enumerated_type().header().common().bit_bound(32); // TODO fixed by IDL, isn't?
    //type_object->complete().enumerated_type().header().detail().ann_builtin()...
    //type_object->complete().enumerated_type().header().detail().ann_custom()...
    type_object->complete().enumerated_type().header().detail().type_name("PlacementKind");

    uint32_t value = 0;
    CompleteEnumeratedLiteral cel_BEGIN_FILE;
    cel_BEGIN_FILE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().IS_KEY(false); // Doesn't apply
    cel_BEGIN_FILE.common().flags().IS_DEFAULT(false);
    cel_BEGIN_FILE.common().value(value++);
    cel_BEGIN_FILE.detail().name("BEGIN_FILE");
    //cel_BEGIN_FILE.detail().ann_builtin()...
    //cel_BEGIN_FILE.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_BEGIN_FILE);

    CompleteEnumeratedLiteral cel_BEFORE_DECLARATION;
    cel_BEFORE_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    cel_BEFORE_DECLARATION.common().flags().IS_DEFAULT(false);
    cel_BEFORE_DECLARATION.common().value(value++);
    cel_BEFORE_DECLARATION.detail().name("BEFORE_DECLARATION");
    //cel_BEFORE_DECLARATION.detail().ann_builtin()...
    //cel_BEFORE_DECLARATION.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_BEFORE_DECLARATION);

    CompleteEnumeratedLiteral cel_BEGIN_DECLARATION;
    cel_BEGIN_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    cel_BEGIN_DECLARATION.common().flags().IS_DEFAULT(false);
    cel_BEGIN_DECLARATION.common().value(value++);
    cel_BEGIN_DECLARATION.detail().name("BEGIN_DECLARATION");
    //cel_BEGIN_DECLARATION.detail().ann_builtin()...
    //cel_BEGIN_DECLARATION.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_BEGIN_DECLARATION);

    CompleteEnumeratedLiteral cel_END_DECLARATION;
    cel_END_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    cel_END_DECLARATION.common().flags().IS_DEFAULT(false);
    cel_END_DECLARATION.common().value(value++);
    cel_END_DECLARATION.detail().name("END_DECLARATION");
    //cel_END_DECLARATION.detail().ann_builtin()...
    //cel_END_DECLARATION.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_END_DECLARATION);

    CompleteEnumeratedLiteral cel_AFTER_DECLARATION;
    cel_AFTER_DECLARATION.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().IS_KEY(false); // Doesn't apply
    cel_AFTER_DECLARATION.common().flags().IS_DEFAULT(false);
    cel_AFTER_DECLARATION.common().value(value++);
    cel_AFTER_DECLARATION.detail().name("AFTER_DECLARATION");
    //cel_AFTER_DECLARATION.detail().ann_builtin()...
    //cel_AFTER_DECLARATION.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_AFTER_DECLARATION);

    CompleteEnumeratedLiteral cel_END_FILE;
    cel_END_FILE.common().flags().TRY_CONSTRUCT1(false); // Doesn't apply
    cel_END_FILE.common().flags().TRY_CONSTRUCT2(false); // Doesn't apply
    cel_END_FILE.common().flags().IS_EXTERNAL(false); // Doesn't apply
    cel_END_FILE.common().flags().IS_OPTIONAL(false); // Doesn't apply
    cel_END_FILE.common().flags().IS_MUST_UNDERSTAND(false); // Doesn't apply
    cel_END_FILE.common().flags().IS_KEY(false); // Doesn't apply
    cel_END_FILE.common().flags().IS_DEFAULT(false);
    cel_END_FILE.common().value(value++);
    cel_END_FILE.detail().name("END_FILE");
    //cel_END_FILE.detail().ann_builtin()...
    //cel_END_FILE.detail().ann_custom()...
    type_object->complete().enumerated_type().literal_seq().emplace_back(cel_END_FILE);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteEnumeratedType::getCdrSerializedSize(type_object->complete().enumerated_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("PlacementKind", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("PlacementKind", true);
}



} // verbatim namespace
const TypeIdentifier* GetserviceIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("service", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetserviceObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("service", complete);
}

const TypeObject* GetserviceObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("service", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteserviceObject();
    }
    // else
    return GetMinimalserviceObject();
}

const TypeObject* GetMinimalserviceObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("service", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_platform;
    mam_platform.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    mam_platform.name("platform");

    AnnotationParameterValue def_value_platform;
    def_value_platform._d(mam_platform.common().member_type_id()._d());
    def_value_platform.from_string("*");
    mam_platform.default_value(def_value_platform);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_platform);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("service", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("service", false);
}

const TypeObject* GetCompleteserviceObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("service", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("service");

    CompleteAnnotationParameter cam_platform;
    cam_platform.common().member_type_id(*TypeObjectFactory::get_instance()->get_string_identifier(255, false));
    cam_platform.name("platform");

    AnnotationParameterValue def_value_platform;
    def_value_platform._d(cam_platform.common().member_type_id()._d());
    def_value_platform.from_string("*");
    cam_platform.default_value(def_value_platform);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_platform);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("service", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("service", true);
}


const TypeIdentifier* GetonewayIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("oneway", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetonewayObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("oneway", complete);
}

const TypeObject* GetonewayObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("oneway", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteonewayObject();
    }
    // else
    return GetMinimalonewayObject();
}

const TypeObject* GetMinimalonewayObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("oneway", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("oneway", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("oneway", false);
}

const TypeObject* GetCompleteonewayObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("oneway", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("oneway");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("oneway", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("oneway", true);
}


const TypeIdentifier* GetamiIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("ami", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    GetamiObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("ami", complete);
}

const TypeObject* GetamiObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ami", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompleteamiObject();
    }
    // else
    return GetMinimalamiObject();
}

const TypeObject* GetMinimalamiObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ami", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("ami", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("ami", false);
}

const TypeObject* GetCompleteamiObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("ami", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("ami");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("ami", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("ami", true);
}


const TypeIdentifier* Getnon_serializedIdentifier(bool complete)
{
    const TypeIdentifier* c_identifier = TypeObjectFactory::get_instance()->get_type_identifier("non_serialized", complete);
    if (c_identifier != nullptr && (!complete || c_identifier->_d() == EK_COMPLETE))
    {
        return c_identifier;
    }

    Getnon_serializedObject(complete); // Generated inside
    return TypeObjectFactory::get_instance()->get_type_identifier("non_serialized", complete);
}

const TypeObject* Getnon_serializedObject(bool complete)
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("non_serialized", complete);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }
    else if (complete)
    {
        return GetCompletenon_serializedObject();
    }
    // else
    return GetMinimalnon_serializedObject();
}

const TypeObject* GetMinimalnon_serializedObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("non_serialized", false);
    if (c_type_object != nullptr)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_MINIMAL);
    type_object->minimal()._d(TK_ANNOTATION);

    MinimalAnnotationParameter mam_value;
    mam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    mam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(mam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    mam_value.default_value(def_value_value);
    type_object->minimal().annotation_type().member_seq().emplace_back(mam_value);


    TypeIdentifier identifier;
    identifier._d(EK_MINIMAL);

    SerializedPayload_t payload(static_cast<uint32_t>(
        MinimalAnnotationType::getCdrSerializedSize(type_object->minimal().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("non_serialized", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("non_serialized", false);
}

const TypeObject* GetCompletenon_serializedObject()
{
    const TypeObject* c_type_object = TypeObjectFactory::get_instance()->get_type_object("non_serialized", true);
    if (c_type_object != nullptr && c_type_object->_d() == EK_COMPLETE)
    {
        return c_type_object;
    }

    TypeObject *type_object = new TypeObject();
    type_object->_d(EK_COMPLETE);
    type_object->complete()._d(TK_ANNOTATION);

    // No flags apply
    //type_object->complete().annotation_type().annotation_flags().IS_FINAL(false);
    //type_object->complete().annotation_type().annotation_flags().IS_APPENDABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_MUTABLE(false);
    //type_object->complete().annotation_type().annotation_flags().IS_NESTED(false);
    //type_object->complete().annotation_type().annotation_flags().IS_AUTOID_HASH(false);

    //type_object->complete().annotation_type().header().detail().ann_builtin()...
    //type_object->complete().annotation_type().header().detail().ann_custom()...
    type_object->complete().annotation_type().header().annotation_name("non_serialized");

    CompleteAnnotationParameter cam_value;
    cam_value.common().member_type_id(*TypeObjectFactory::get_instance()->get_type_identifier("bool", false));
    cam_value.name("value");

    AnnotationParameterValue def_value_value;
    def_value_value._d(cam_value.common().member_type_id()._d());
    def_value_value.from_string("true");
    cam_value.default_value(def_value_value);
    type_object->complete().annotation_type().member_seq().emplace_back(cam_value);


    TypeIdentifier identifier;
    identifier._d(EK_COMPLETE);

    SerializedPayload_t payload(static_cast<uint32_t>(
        CompleteAnnotationType::getCdrSerializedSize(type_object->complete().annotation_type()) + 4));
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload.data, payload.max_size);
    // Fixed endian (Page 221, EquivalenceHash definition of Extensible and Dynamic Topic Types for DDS document)
    eprosima::fastcdr::Cdr ser(
        fastbuffer, eprosima::fastcdr::Cdr::LITTLE_ENDIANNESS,
        eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload.encapsulation = CDR_LE;

    type_object->serialize(ser);
    payload.length = (uint32_t)ser.getSerializedDataLength(); //Get the serialized length
    MD5 objectHash;
    objectHash.update((char*)payload.data, payload.length);
    objectHash.finalize();
    for(int i = 0; i < 14; ++i)
    {
        identifier.equivalence_hash()[i] = objectHash.digest[i];
    }

    TypeObjectFactory::get_instance()->add_type_object("non_serialized", &identifier, type_object);
    delete type_object;
    return TypeObjectFactory::get_instance()->get_type_object("non_serialized", true);
}
