// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*************************************************************************
 * @file MetaTestTypes.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "MetaTestTypes.h"

#include "fastcdr/Cdr.h"


#include "fastcdr/exceptions/BadParamException.h"
using namespace eprosima::fastcdr::exception;

#include <utility>



MetaTestType::MetaTestType()
{
    m_kind = ::T_RTPS_SOCKET;
    m_status = ::T_PUB_STARTS;
    m_ip_string = "";
    m_ip_port = 0;
    m_samples = 0;
    m_comment = "";
}

MetaTestType::~MetaTestType()
{
}

MetaTestType::MetaTestType(const MetaTestType &x)
{
    m_kind = x.m_kind;
    m_status = x.m_status;
    m_ip_string = x.m_ip_string;
    m_ip_port = x.m_ip_port;
    m_samples = x.m_samples;
    m_comment = x.m_comment;
}

MetaTestType::MetaTestType(MetaTestType &&x)
{
    m_kind = x.m_kind;
    m_status = x.m_status;
    m_ip_string = x.m_ip_string;
    m_ip_port = x.m_ip_port;
    m_samples = x.m_samples;
    m_comment = x.m_comment;
}

MetaTestType& MetaTestType::operator=(const MetaTestType &x)
{
    m_kind = x.m_kind;
    m_status = x.m_status;
    m_ip_string = x.m_ip_string;
    m_ip_port = x.m_ip_port;
    m_samples = x.m_samples;
    m_comment = x.m_comment;
    
    return *this;
}

MetaTestType& MetaTestType::operator=(MetaTestType &&x)
{
    m_kind = x.m_kind;
    m_status = x.m_status;
    m_ip_string = x.m_ip_string;
    m_ip_port = x.m_ip_port;
    m_samples = x.m_samples;
    m_comment = x.m_comment;
    
    return *this;
}

size_t MetaTestType::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t current_align = current_alignment;
            
    current_align += 4 + eprosima::fastcdr::Cdr::alignment(current_align, 4);
    current_align += 4 + eprosima::fastcdr::Cdr::alignment(current_align, 4);
    current_align += 4 + eprosima::fastcdr::Cdr::alignment(current_align, 4) + 255 + 1;
    current_align += 2 + eprosima::fastcdr::Cdr::alignment(current_align, 2);
    current_align += 2 + eprosima::fastcdr::Cdr::alignment(current_align, 2);
    current_align += 4 + eprosima::fastcdr::Cdr::alignment(current_align, 4) + 255 + 1;

    return current_align;
}
size_t MetaTestType::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool MetaTestType::isKeyDefined()
{
 return false;
}

void MetaTestType::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint32_t)m_kind;

    scdr << (uint32_t)m_status;

    if(m_ip_string.length() <= 255)
    scdr << m_ip_string;
    else
        throw eprosima::fastcdr::exception::BadParamException("ip_string field exceeds the maximum length");
    scdr << m_ip_port;

    scdr << m_samples;

    if(m_comment.length() <= 255)
    scdr << m_comment;
    else
        throw eprosima::fastcdr::exception::BadParamException("comment field exceeds the maximum length");
}

void MetaTestType::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> (uint32_t&)m_kind;
    dcdr >> (uint32_t&)m_status;
    dcdr >> m_ip_string;
    dcdr >> m_ip_port;
    dcdr >> m_samples;
    dcdr >> m_comment;
}

void MetaTestType::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	 
	 
	 
	 
	 
	 
}
