# set common optimization flags

if (UNIX)
  # try to get architecture from compiler
  EXECUTE_PROCESS(COMMAND ${CMAKE_CXX_COMPILER} -dumpmachine COMMAND tr -d '\n' OUTPUT_VARIABLE CXX_MACHINE)
  string(REGEX REPLACE "([a-zA-Z_0-9]+).*" "\\1" ARCHITECTURE ${CXX_MACHINE})
elseif (WIN32)
  if ("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
    set(ARCHITECTURE WIN32_i86)
  else ()
    set(ARCHITECTURE WIN64_x64)
  endif ()
endif ()

message(STATUS "Detected architecture ${ARCHITECTURE}")

if ("${ARCHITECTURE}" STREQUAL "arm") # Preselect settings for Odroid or Tegra K1
    set(USE_SSE2 0 CACHE BOOL "Compile for SSE2 (x86) using -msse2")
    set(USE_SSE4.2 0 CACHE BOOL "Compile for SSE4.2 (x86) using -mpopcnt -msse4.2")
    set(USE_AVX 0 CACHE BOOL "Compile for AVX (x86) using -mavx")
    set(USE_AVX2 0 CACHE BOOL "Compile for AVX2 (x86) using -mavx2")
    set(USE_ARMV7_CA15 1 CACHE BOOL "Compile for ARM V7 Cortex-A15 using -mcpu=cortex-a15 -mfpu=neon")
    set(USE_ARMV8_AARCH64 0 CACHE BOOL "Compile for ARM V8 64 bit using -mcpu=armv8-a -mtune=cortex-a57")
elseif ("${ARCHITECTURE}" STREQUAL "aarch64") # Preselect settings for Tegra X1
    set(USE_SSE2 0 CACHE BOOL "Compile for SSE2 (x86) using -msse2")
    set(USE_SSE4.2 0 CACHE BOOL "Compile for SSE4.2 (x86) using -mpopcnt -msse4.2")
    set(USE_AVX 0 CACHE BOOL "Compile for AVX (x86) using -mavx")
    set(USE_AVX2 0 CACHE BOOL "Compile for AVX2 (x86) using -mavx2")
    set(USE_ARMV7_CA15 0 CACHE BOOL "Compile for ARM V7 Cortex-A15 using -mcpu=cortex-a15 -mfpu=neon")
    set(USE_ARMV8_AARCH64 1 CACHE BOOL "Compile for ARM V8 64 bit using -mcpu=armv8-a -mtune=cortex-a57")
else () # Preselect settings for intel architecture
    set(USE_SSE2 1 CACHE BOOL "Compile for SSE2 (x86) using -msse2")
    set(USE_SSE4.2 1 CACHE BOOL "Compile for SSE4.2 (x86) using -mpopcnt -msse4.2")
    set(USE_AVX 1 CACHE BOOL "Compile for AVX (x86) using -mavx")
    set(USE_AVX2 1 CACHE BOOL "Compile for AVX2 (x86) using -mavx2")
    set(USE_ARMV7_CA15 0 CACHE BOOL "Compile for ARM V7 Cortex-A15 using -mcpu=cortex-a15 -mfpu=neon")
    set(USE_ARMV8_AARCH64 0 CACHE BOOL "Compile for ARM V8 64 bit using -mcpu=armv8-a -mtune=cortex-a57")
endif ()

if (CMAKE_COMPILER_IS_GNUCXX)
  set(UNROLL_LOOPS 1 CACHE BOOL "Compile using -funroll-loops")
endif ()

if (USE_SSE2)
  if (MSVC)
    add_definitions(/arch:SSE2)
  else ()
    add_definitions(-msse2)
  endif ()
endif ()

if (USE_SSE4.2)
  if (MSVC)
    add_definitions(-D__SSE4_2__)
    add_definitions(-D__POPCNT__)
  else ()
    add_definitions(-mpopcnt)
    add_definitions(-msse4.2)
  endif ()
endif ()

if (USE_AVX)
  if (MSVC)
    add_definitions(/arch:AVX)
  else ()
    add_definitions(-mavx)
  endif ()
endif ()

if (USE_AVX2)
  if (MSVC)
    add_definitions(/arch:AVX2)
  else ()
    add_definitions(-mavx2)
  endif ()
endif ()

if (USE_ARMV7_CA15)
    add_definitions(-mcpu=cortex-a15 -mfpu=neon)
endif ()

if (USE_ARMV8_AARCH64)
    add_definitions(-march=armv8-a -mtune=cortex-a57 -D__ARM_NEON__)
endif ()

if (UNROLL_LOOPS)
    add_definitions(-funroll-loops)
endif ()
