// Copyright 2015 Open Source Robotics Foundation, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef RCUTILS__VISIBILITY_CONTROL_H_
#define RCUTILS__VISIBILITY_CONTROL_H_

#ifdef __cplusplus
extern "C"
{
#endif

// This logic was borrowed (then namespaced) from the examples on the gcc wiki:
//     https://gcc.gnu.org/wiki/Visibility

#if defined _WIN32 || defined __CYGWIN__
  #ifdef __GNUC__
    #define RCUTILS_EXPORT __attribute__ ((dllexport))
    #define RCUTILS_IMPORT __attribute__ ((dllimport))
  #else
    #define RCUTILS_EXPORT __declspec(dllexport)
    #define RCUTILS_IMPORT __declspec(dllimport)
  #endif
  #ifdef RCUTILS_BUILDING_DLL
    #define RCUTILS_PUBLIC RCUTILS_EXPORT
  #else
    #define RCUTILS_PUBLIC RCUTILS_IMPORT
  #endif
  #define RCUTILS_PUBLIC_TYPE RCUTILS_PUBLIC
  #define RCUTILS_LOCAL
#else
  #define RCUTILS_EXPORT __attribute__ ((visibility("default")))
  #define RCUTILS_IMPORT
  #if __GNUC__ >= 4
    #define RCUTILS_PUBLIC __attribute__ ((visibility("default")))
    #define RCUTILS_LOCAL  __attribute__ ((visibility("hidden")))
  #else
    #define RCUTILS_PUBLIC
    #define RCUTILS_LOCAL
  #endif
  #define RCUTILS_PUBLIC_TYPE
#endif

#ifdef __cplusplus
}
#endif

#endif  // RCUTILS__VISIBILITY_CONTROL_H_
