// Copyright 2019 Bold Hearts
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef V4L2_CAMERA__FOURCC_HPP_
#define V4L2_CAMERA__FOURCC_HPP_

#include <string>

namespace v4l2_camera
{

struct FourCC
{
  inline static std::string toString(unsigned fourcc)
  {
    char chars[5];
    for (unsigned i = 0; i < 4; ++i) {
      chars[i] = ((fourcc >> (i * 8)) & 0xFF);
    }
    chars[4] = 0;
    return std::string{chars};
  }
};

}  // namespace v4l2_camera

#endif  // V4L2_CAMERA__FOURCC_HPP_
