// Copyright 2019 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file LifespanTypes.cpp
 * This header file contains the implementation of the serialization functions.
 *
 * This file was generated by the tool fastcdrgen.
 */


#include <fastcdr/FastBuffer.h>
#include <fastcdr/Cdr.h>

#include "LifespanTypes.h"

using namespace eprosima::fastrtps;
using namespace eprosima::fastrtps::rtps;

LifespanType::LifespanType() {
    setName("Lifespan");
    m_typeSize = (uint32_t)Lifespan::getMaxCdrSerializedSize() + 4 /*encapsulation*/;
    m_isGetKeyDefined = Lifespan::isKeyDefined();
    key_buffer = (unsigned char*)malloc(Lifespan::getKeyMaxCdrSerializedSize()>16 ? Lifespan::getKeyMaxCdrSerializedSize() : 16);
}

LifespanType::~LifespanType() {
    if(key_buffer!=nullptr)
        free(key_buffer);
}

bool LifespanType::serialize(void *data, SerializedPayload_t *payload) {
    Lifespan *p_type = (Lifespan*) data;
    eprosima::fastcdr::FastBuffer fastbuffer((char*) payload->data, payload->max_size); // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR);
    payload->encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
    // Serialize encapsulation
    ser.serialize_encapsulation();

    try
    {
        p_type->serialize(ser); // Serialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    payload->length = (uint32_t)ser.getSerializedDataLength(); 	//Get the serialized length
    return true;
}

bool LifespanType::deserialize(SerializedPayload_t* payload, void* data) {
    Lifespan* p_type = (Lifespan*) data; 	//Convert DATA to pointer of your type
    eprosima::fastcdr::FastBuffer fastbuffer((char*)payload->data, payload->length); 	// Object that manages the raw buffer.
    eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR); // Object that deserializes the data.
    // Deserialize encapsulation.
    deser.read_encapsulation();
    payload->encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

    try
    {
        p_type->deserialize(deser); //Deserialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    return true;
}

std::function<uint32_t()> LifespanType::getSerializedSizeProvider(void* data) {
    return [data]() -> uint32_t {
        return (uint32_t)type::getCdrSerializedSize(*static_cast<Lifespan*>(data)) + 4 /*encapsulation*/;
    };
}

void* LifespanType::createData() {
    return (void*)new Lifespan();
}

void LifespanType::deleteData(void* data) {
    delete((Lifespan*)data);
}

bool LifespanType::getKey(void *data, InstanceHandle_t* handle, bool force_md5) {
    if(!m_isGetKeyDefined)
        return false;
    Lifespan* p_type = (Lifespan*) data;
    eprosima::fastcdr::FastBuffer fastbuffer((char*)key_buffer,Lifespan::getKeyMaxCdrSerializedSize()); 	// Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS); 	// Object that serializes the data.
    p_type->serializeKey(ser);
    if(force_md5 || Lifespan::getKeyMaxCdrSerializedSize()>16)	{
        md5.init();
        md5.update(key_buffer,(unsigned int)ser.getSerializedDataLength());
        md5.finalize();
        for(uint8_t i = 0;i<16;++i)    	{
            handle->value[i] = md5.digest[i];
        }
    }
    else    {
        for(uint8_t i = 0;i<16;++i)    	{
            handle->value[i] = key_buffer[i];
        }
    }
    return true;
}
