// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

#pragma once

#include "sensor.h"
#include "stream.h"
#include "option.h"
namespace librealsense
{
     const int RS2_OPTION_DEPTH_INVALIDATION_ENABLE = static_cast<rs2_option>(RS2_OPTION_COUNT + 9); /**<  depth invalidation enabled*/

     class depth_invalidation_option: public ptr_option<bool>
     {
     public:
         depth_invalidation_option(bool min, bool max, bool step, bool def, bool* value, const std::string& desc):
             ptr_option<bool>(min, max, step, def, value, desc),
            _streaming(false){}

        void set_streaming(bool streaming)
        {
            _streaming = streaming;
        }

        bool is_enabled() const override
        {
            return !_streaming;
        }

     private:
         bool _streaming;
     };

    class frame_validator : public rs2_frame_callback
    {
    public:
        explicit frame_validator(std::shared_ptr<sensor_base> sensor, frame_callback_ptr user_callback, stream_profiles user_requests, stream_profiles validator_requests);
        virtual ~frame_validator() override;

        void on_frame(rs2_frame * f) override;
        void release() override;

    private:
        bool propagate(frame_interface* frame);
        bool is_user_requested_frame(frame_interface* frame);

        std::thread _reset_thread;
        std::atomic<bool> _stopped;
        std::atomic<bool> _validated;
        int _ir_frame_num = 0;
        frame_callback_ptr _user_callback;
        stream_profiles _user_requests;
        stream_profiles _validator_requests;
        std::shared_ptr<sensor_base> _sensor;
    };
}
