// Copyright 2019 Intelligent Robotics Lab
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef PLANSYS2_PLANNER__TYPES_HPP_
#define PLANSYS2_PLANNER__TYPES_HPP_

#include <string>
#include <vector>

namespace plansys2
{

struct PlanItem
{
  float time;
  std::string action;
  float duration;
};

typedef std::vector<PlanItem> Plan;

}  // namespace plansys2

#endif  // PLANSYS2_PLANNER__TYPES_HPP_
