/*******************************************************************************
* Copyright 2019 ROBOTIS CO., LTD.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

/* Author: Darby Lim */

#ifndef CHICONYBOT_NODE_DEVICES_RESET_HPP_
#define CHICONYBOT_NODE_DEVICES_RESET_HPP_

#include <std_srvs/srv/trigger.hpp>

#include "chiconybot_node/devices/devices.hpp"

namespace robotis
{
namespace chiconybot
{
namespace devices
{
class Reset : public Devices
{
 public:
  static void request(
    rclcpp::Client<std_srvs::srv::Trigger>::SharedPtr client,
    std_srvs::srv::Trigger::Request req);

  explicit Reset(
    std::shared_ptr<rclcpp::Node> & nh,
    std::shared_ptr<DynamixelSDKWrapper> & dxl_sdk_wrapper,
    const std::string & server_name = "reset");

  void command(const void * request, void * response) override;

 private:
  rclcpp::Service<std_srvs::srv::Trigger>::SharedPtr srv_;
};
} // devices
} // chiconybot
} // robotis
#endif // CHICONYBOT_NODE_DEVICES_SOUND_HPP_
