/*********************************************************************
 * C++ unit test for dataspeed_can_usb/MacAddr.h
 *********************************************************************/

#include <gtest/gtest.h>

// File under test
#include <dataspeed_can_usb/MacAddr.hpp>
using namespace dataspeed_can_usb;

// Test converting to string
TEST(MacAddr, constructors)
{
  uint8_t data[] =    {0x01,0x23,0x45,0x67,0x89,0xab};
  EXPECT_STRNE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xab).toString().c_str(), MacAddr().toString().c_str());
  EXPECT_STREQ(MacAddr(0x01,0x23,0x45,0x67,0x89,0xab).toString().c_str(), MacAddr(data).toString().c_str());
}

// Test converting to string
TEST(MacAddr, toString)
{
  // Default constructor
  EXPECT_STREQ("00:00:00:00:00:00", MacAddr().toString().c_str());

  // Upper case
  EXPECT_STREQ("00:00:00:00:00:00", MacAddr(0x00,0x00,0x00,0x00,0x00,0x00).toString(true).c_str());
  EXPECT_STREQ("01:01:01:01:01:01", MacAddr(0x01,0x01,0x01,0x01,0x01,0x01).toString(true).c_str());
  EXPECT_STREQ("02:02:02:02:02:02", MacAddr(0x02,0x02,0x02,0x02,0x02,0x02).toString(true).c_str());
  EXPECT_STREQ("03:03:03:03:03:03", MacAddr(0x03,0x03,0x03,0x03,0x03,0x03).toString(true).c_str());
  EXPECT_STREQ("04:04:04:04:04:04", MacAddr(0x04,0x04,0x04,0x04,0x04,0x04).toString(true).c_str());
  EXPECT_STREQ("05:05:05:05:05:05", MacAddr(0x05,0x05,0x05,0x05,0x05,0x05).toString(true).c_str());
  EXPECT_STREQ("06:06:06:06:06:06", MacAddr(0x06,0x06,0x06,0x06,0x06,0x06).toString(true).c_str());
  EXPECT_STREQ("07:07:07:07:07:07", MacAddr(0x07,0x07,0x07,0x07,0x07,0x07).toString(true).c_str());
  EXPECT_STREQ("08:08:08:08:08:08", MacAddr(0x08,0x08,0x08,0x08,0x08,0x08).toString(true).c_str());
  EXPECT_STREQ("09:09:09:09:09:09", MacAddr(0x09,0x09,0x09,0x09,0x09,0x09).toString(true).c_str());
  EXPECT_STREQ("0A:0A:0A:0A:0A:0A", MacAddr(0x0A,0x0A,0x0A,0x0A,0x0A,0x0A).toString(true).c_str());
  EXPECT_STREQ("0B:0B:0B:0B:0B:0B", MacAddr(0x0B,0x0B,0x0B,0x0B,0x0B,0x0B).toString(true).c_str());
  EXPECT_STREQ("0C:0C:0C:0C:0C:0C", MacAddr(0x0C,0x0C,0x0C,0x0C,0x0C,0x0C).toString(true).c_str());
  EXPECT_STREQ("0D:0D:0D:0D:0D:0D", MacAddr(0x0D,0x0D,0x0D,0x0D,0x0D,0x0D).toString(true).c_str());
  EXPECT_STREQ("0E:0E:0E:0E:0E:0E", MacAddr(0x0E,0x0E,0x0E,0x0E,0x0E,0x0E).toString(true).c_str());
  EXPECT_STREQ("0F:0F:0F:0F:0F:0F", MacAddr(0x0F,0x0F,0x0F,0x0F,0x0F,0x0F).toString(true).c_str());
  EXPECT_STREQ("10:10:10:10:10:10", MacAddr(0x10,0x10,0x10,0x10,0x10,0x10).toString(true).c_str());
  EXPECT_STREQ("20:20:20:20:20:20", MacAddr(0x20,0x20,0x20,0x20,0x20,0x20).toString(true).c_str());
  EXPECT_STREQ("30:30:30:30:30:30", MacAddr(0x30,0x30,0x30,0x30,0x30,0x30).toString(true).c_str());
  EXPECT_STREQ("40:40:40:40:40:40", MacAddr(0x40,0x40,0x40,0x40,0x40,0x40).toString(true).c_str());
  EXPECT_STREQ("50:50:50:50:50:50", MacAddr(0x50,0x50,0x50,0x50,0x50,0x50).toString(true).c_str());
  EXPECT_STREQ("60:60:60:60:60:60", MacAddr(0x60,0x60,0x60,0x60,0x60,0x60).toString(true).c_str());
  EXPECT_STREQ("70:70:70:70:70:70", MacAddr(0x70,0x70,0x70,0x70,0x70,0x70).toString(true).c_str());
  EXPECT_STREQ("80:80:80:80:80:80", MacAddr(0x80,0x80,0x80,0x80,0x80,0x80).toString(true).c_str());
  EXPECT_STREQ("90:90:90:90:90:90", MacAddr(0x90,0x90,0x90,0x90,0x90,0x90).toString(true).c_str());
  EXPECT_STREQ("A0:A0:A0:A0:A0:A0", MacAddr(0xA0,0xA0,0xA0,0xA0,0xA0,0xA0).toString(true).c_str());
  EXPECT_STREQ("B0:B0:B0:B0:B0:B0", MacAddr(0xB0,0xB0,0xB0,0xB0,0xB0,0xB0).toString(true).c_str());
  EXPECT_STREQ("C0:C0:C0:C0:C0:C0", MacAddr(0xC0,0xC0,0xC0,0xC0,0xC0,0xC0).toString(true).c_str());
  EXPECT_STREQ("D0:D0:D0:D0:D0:D0", MacAddr(0xD0,0xD0,0xD0,0xD0,0xD0,0xD0).toString(true).c_str());
  EXPECT_STREQ("E0:E0:E0:E0:E0:E0", MacAddr(0xE0,0xE0,0xE0,0xE0,0xE0,0xE0).toString(true).c_str());
  EXPECT_STREQ("F0:F0:F0:F0:F0:F0", MacAddr(0xF0,0xF0,0xF0,0xF0,0xF0,0xF0).toString(true).c_str());
  EXPECT_STREQ("FF:FF:FF:FF:FF:FF", MacAddr(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF).toString(true).c_str());

  // Lower case
  EXPECT_STREQ("00:00:00:00:00:00", MacAddr(0x00,0x00,0x00,0x00,0x00,0x00).toString(false).c_str());
  EXPECT_STREQ("01:01:01:01:01:01", MacAddr(0x01,0x01,0x01,0x01,0x01,0x01).toString(false).c_str());
  EXPECT_STREQ("02:02:02:02:02:02", MacAddr(0x02,0x02,0x02,0x02,0x02,0x02).toString(false).c_str());
  EXPECT_STREQ("03:03:03:03:03:03", MacAddr(0x03,0x03,0x03,0x03,0x03,0x03).toString(false).c_str());
  EXPECT_STREQ("04:04:04:04:04:04", MacAddr(0x04,0x04,0x04,0x04,0x04,0x04).toString(false).c_str());
  EXPECT_STREQ("05:05:05:05:05:05", MacAddr(0x05,0x05,0x05,0x05,0x05,0x05).toString(false).c_str());
  EXPECT_STREQ("06:06:06:06:06:06", MacAddr(0x06,0x06,0x06,0x06,0x06,0x06).toString(false).c_str());
  EXPECT_STREQ("07:07:07:07:07:07", MacAddr(0x07,0x07,0x07,0x07,0x07,0x07).toString(false).c_str());
  EXPECT_STREQ("08:08:08:08:08:08", MacAddr(0x08,0x08,0x08,0x08,0x08,0x08).toString(false).c_str());
  EXPECT_STREQ("09:09:09:09:09:09", MacAddr(0x09,0x09,0x09,0x09,0x09,0x09).toString(false).c_str());
  EXPECT_STREQ("0a:0a:0a:0a:0a:0a", MacAddr(0x0a,0x0a,0x0a,0x0a,0x0a,0x0a).toString(false).c_str());
  EXPECT_STREQ("0b:0b:0b:0b:0b:0b", MacAddr(0x0b,0x0b,0x0b,0x0b,0x0b,0x0b).toString(false).c_str());
  EXPECT_STREQ("0c:0c:0c:0c:0c:0c", MacAddr(0x0c,0x0c,0x0c,0x0c,0x0c,0x0c).toString(false).c_str());
  EXPECT_STREQ("0d:0d:0d:0d:0d:0d", MacAddr(0x0d,0x0d,0x0d,0x0d,0x0d,0x0d).toString(false).c_str());
  EXPECT_STREQ("0e:0e:0e:0e:0e:0e", MacAddr(0x0e,0x0e,0x0e,0x0e,0x0e,0x0e).toString(false).c_str());
  EXPECT_STREQ("0f:0f:0f:0f:0f:0f", MacAddr(0x0f,0x0f,0x0f,0x0f,0x0f,0x0f).toString(false).c_str());
  EXPECT_STREQ("10:10:10:10:10:10", MacAddr(0x10,0x10,0x10,0x10,0x10,0x10).toString(false).c_str());
  EXPECT_STREQ("20:20:20:20:20:20", MacAddr(0x20,0x20,0x20,0x20,0x20,0x20).toString(false).c_str());
  EXPECT_STREQ("30:30:30:30:30:30", MacAddr(0x30,0x30,0x30,0x30,0x30,0x30).toString(false).c_str());
  EXPECT_STREQ("40:40:40:40:40:40", MacAddr(0x40,0x40,0x40,0x40,0x40,0x40).toString(false).c_str());
  EXPECT_STREQ("50:50:50:50:50:50", MacAddr(0x50,0x50,0x50,0x50,0x50,0x50).toString(false).c_str());
  EXPECT_STREQ("60:60:60:60:60:60", MacAddr(0x60,0x60,0x60,0x60,0x60,0x60).toString(false).c_str());
  EXPECT_STREQ("70:70:70:70:70:70", MacAddr(0x70,0x70,0x70,0x70,0x70,0x70).toString(false).c_str());
  EXPECT_STREQ("80:80:80:80:80:80", MacAddr(0x80,0x80,0x80,0x80,0x80,0x80).toString(false).c_str());
  EXPECT_STREQ("90:90:90:90:90:90", MacAddr(0x90,0x90,0x90,0x90,0x90,0x90).toString(false).c_str());
  EXPECT_STREQ("a0:a0:a0:a0:a0:a0", MacAddr(0xa0,0xa0,0xa0,0xa0,0xa0,0xa0).toString(false).c_str());
  EXPECT_STREQ("b0:b0:b0:b0:b0:b0", MacAddr(0xb0,0xb0,0xb0,0xb0,0xb0,0xb0).toString(false).c_str());
  EXPECT_STREQ("c0:c0:c0:c0:c0:c0", MacAddr(0xc0,0xc0,0xc0,0xc0,0xc0,0xc0).toString(false).c_str());
  EXPECT_STREQ("d0:d0:d0:d0:d0:d0", MacAddr(0xd0,0xd0,0xd0,0xd0,0xd0,0xd0).toString(false).c_str());
  EXPECT_STREQ("e0:e0:e0:e0:e0:e0", MacAddr(0xe0,0xe0,0xe0,0xe0,0xe0,0xe0).toString(false).c_str());
  EXPECT_STREQ("f0:f0:f0:f0:f0:f0", MacAddr(0xf0,0xf0,0xf0,0xf0,0xf0,0xf0).toString(false).c_str());
  EXPECT_STREQ("ff:ff:ff:ff:ff:ff", MacAddr(0xff,0xff,0xff,0xff,0xff,0xff).toString(false).c_str());
}

// Test matching of two MAC addresses
TEST(MacAddr, match_other)
{
  // Invalid MAC addresses
  EXPECT_FALSE(MacAddr(0x00,0x00,0x00,0x00,0x00,0x00).match(MacAddr(0x00,0x00,0x00,0x00,0x00,0x00)));
  EXPECT_FALSE(MacAddr(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF).match(MacAddr(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF)));

  // Valid MAC addresses
  EXPECT_TRUE (MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x00,0x23,0x45,0x67,0x89,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x20,0x45,0x67,0x89,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x23,0x40,0x67,0x89,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x23,0x45,0x60,0x89,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x23,0x45,0x67,0x80,0xAB)));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(MacAddr(0x01,0x23,0x45,0x67,0x89,0xA0)));
  EXPECT_TRUE (MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0x0A,0xBB,0xCC,0xDD,0xEE,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0x0B,0xCC,0xDD,0xEE,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0xBB,0x0C,0xDD,0xEE,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0xBB,0xCC,0x0D,0xEE,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0xBB,0xCC,0xDD,0x0E,0xFF)));
  EXPECT_FALSE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0x0F)));
}

// Test matching of two MAC addresses
TEST(MacAddr, match_string)
{
  // Invalid MAC addresses
  EXPECT_FALSE(MacAddr(0x00,0x00,0x00,0x00,0x00,0x00).match("000000000000"));
  EXPECT_FALSE(MacAddr(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF).match("FFFFFFFFFFFF"));
  EXPECT_FALSE(MacAddr(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF).match("ffffffffffff"));

  // Require 12 digits
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match(""));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match("0123456789A"));
  EXPECT_TRUE (MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match("0123456789AB"));
  EXPECT_FALSE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match("0123456789ABC"));

  // Case insensitive
  EXPECT_TRUE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match("0123456789AB"));
  EXPECT_TRUE(MacAddr(0x01,0x23,0x45,0x67,0x89,0xAB).match("0123456789ab"));
  EXPECT_TRUE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match("aabbccddeeff"));
  EXPECT_TRUE(MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match("AABBCCDDEEFF"));

  // With or without colons
  EXPECT_TRUE (MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match("aa:bb:cc:dd:ee:ff"));
  EXPECT_FALSE(MacAddr(0x0A,0xBB,0xCC,0xDD,0xEE,0xFF).match("aa:bb:cc:dd:ee:ff"));
  EXPECT_TRUE (MacAddr(0xAA,0xBB,0xCC,0xDD,0xEE,0xFF).match("AA:BB:CC:DD:EE:FF"));
  EXPECT_FALSE(MacAddr(0x0A,0xBB,0xCC,0xDD,0xEE,0xFF).match("AA:BB:CC:DD:EE:FF"));
}

int main(int argc, char **argv)
{
  testing::InitGoogleTest(&argc, argv);
  return RUN_ALL_TESTS();
}
