/**
 * @file /include/ecl/converters.hpp
 *
 * @brief Type conversion functors.
 *
 * Collates all classes related to type conversions.
 *
 * @date January 2009
 **/
/*****************************************************************************
** Ifdefs
*****************************************************************************/

#ifndef ECL_CONVERTERS_HPP_
#define ECL_CONVERTERS_HPP_

/*****************************************************************************
** Primary Templates
*****************************************************************************/

#include "converters/converter.hpp"

/*****************************************************************************
** Specialisations
*****************************************************************************/

#include "converters/to_byte_array.hpp"
#include "converters/from_byte_array.hpp"
#include "converters/converter.hpp"
#include "converters/char.hpp"
#include "converters/integers.hpp"
#include "converters/char_strings.hpp"
#include "converters/string.hpp"

#endif /*ECL_UTILITIES_CONVERTERS_HPP_*/
