// BSD 3-Clause License
//
// Copyright (c) 2022, Woven Planet.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
//
// * Neither the name of the copyright holder nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#pragma once

#include <lanelet2_core/LaneletMap.h>
#include <lanelet2_core/primitives/Lanelet.h>
#include <maliput_sparse/geometry/line_string.h>
#include <maliput_sparse/parser/lane.h>

namespace maliput_osm {
namespace osm {

/// Converts a lanelet::ConstLineString3d to a maliput_sparse::geometry::LineString3d.
/// @param line_string The lanelet::ConstLineString3d to convert.
/// @returns The converted maliput_sparse::geometry::LineString3d.
maliput_sparse::geometry::LineString3d ToMaliput(const lanelet::ConstLineString3d& line_string);

/// Converts a lanelet::Lanelet to a maliput_osm::osm::Lane.
///
/// maliput_osm::osm::Lane is an struct with several fields.
///
/// @param lanelet The lanelet::Lanelet to convert.
/// @param map lanelet::LaneletMapPtr for finding adjacent and consecutive lanelets.
/// @returns The converted maliput_osm::osm::Lane.
maliput_sparse::parser::Lane ToMaliput(const lanelet::Lanelet& lanelet, const lanelet::LaneletMapPtr& map);

}  // namespace osm
}  // namespace maliput_osm
