// BSD 3-Clause License
//
// Copyright (c) 2022, Woven Planet.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
//
// * Neither the name of the copyright holder nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#pragma once

#include <memory>

#include <maliput/api/road_network.h>

#include "maliput_sparse/loader/builder_configuration.h"
#include "maliput_sparse/loader/road_geometry_loader.h"
#include "maliput_sparse/parser/parser.h"

namespace maliput_sparse {
namespace loader {

/// Loads a RoadNetwork based on a maliput_sparse::parser::Parser implementation.
/// This functor is expected to be used by the maliput backends that rely on
/// maliput_sparse to load the RoadNetwork.
class RoadNetworkLoader {
 public:
  /// Constructs a RoadNetworkLoader.
  /// @param parser The parser to use for building the RoadNetworkLoader.
  /// @param builder_configuration The configuration of the builder.
  RoadNetworkLoader(std::unique_ptr<parser::Parser> parser, const BuilderConfiguration& builder_configuration);

  /// Builds a RoadNetworkLoader.
  std::unique_ptr<maliput::api::RoadNetwork> operator()();

 private:
  const std::unique_ptr<RoadGeometryLoader> road_geometry_loader_;
  const BuilderConfiguration builder_configuration_;
};

}  // namespace loader
}  // namespace maliput_sparse
