// *****************************************************************************
//
// Copyright (C) 2013 All Right Reserved, Southwest Research Institute® (SwRI®)
//
// Contract No.  10-58058A
// Contractor    Southwest Research Institute® (SwRI®)
// Address       6220 Culebra Road, San Antonio, Texas 78228-0510
// Contact       Steve Dellenback <sdellenback@swri.org> (210) 522-3914
//
// This code was developed as part of an internal research project fully funded
// by Southwest Research Institute®.
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS__NAVSAT_PLUGIN_H_
#define MAPVIZ_PLUGINS__NAVSAT_PLUGIN_H_

#include <mapviz/mapviz_plugin.h>
#include <mapviz/map_canvas.h>
#include <mapviz_plugins/point_drawing_plugin.h>

// QT libraries
#include <QGLWidget>
#include <QObject>
#include <QWidget>

// ROS libraries
#include <rclcpp/rclcpp.hpp>
#include <tf2/transform_datatypes.h>
#include <sensor_msgs/msg/nav_sat_fix.hpp>
#include <swri_transform_util/local_xy_util.h>

// C++ standard libraries
#include <list>
#include <string>
#include <vector>

// QT autogenerated files
#include "ui_navsat_config.h"

namespace mapviz_plugins
{
class NavSatPlugin : public mapviz_plugins::PointDrawingPlugin
{
  Q_OBJECT

  public:
  NavSatPlugin();
  ~NavSatPlugin() override = default;

  bool Initialize(QGLWidget* canvas) override;
  void Shutdown() override {}

  void Draw(double x, double y, double scale) override;

  void LoadConfig(const YAML::Node& node, const std::string& path) override;
  void SaveConfig(YAML::Emitter& emitter, const std::string& path) override;

  QWidget* GetConfigWidget(QWidget* parent) override;

  protected:
  void PrintError(const std::string& message) override;
  void PrintInfo(const std::string& message) override;
  void PrintWarning(const std::string& message) override;

  protected Q_SLOTS:
  void SelectTopic();
  void TopicEdited();

  private:
  Ui::navsat_config ui_;
  QWidget* config_widget_;

  std::string topic_;

  rclcpp::Subscription<sensor_msgs::msg::NavSatFix>::SharedPtr navsat_sub_;
  bool has_message_;

  void NavSatFixCallback(const sensor_msgs::msg::NavSatFix::ConstSharedPtr navsat);
};
}   // namespace mapviz_plugins

#endif  // MAPVIZ_PLUGINS__NAVSAT_PLUGIN_H_
