Nerian visiontransfer library, Python 3 wrapper
===============================================

This library is a cython wrapper for the C++ library. The wrapper is
constructed from the current libvisiontransfer library during the
regular CMake build process.

If you wish to build it locally anyway, you have to adapt the 'incdir'
and 'libdir' settings in setup.py to point to the libvisiontransfer
header / library directory, respectively. The build steps then are:

    export LIBVISIONTRANSFER_BASE=".."
    python3 tools/autogen_docstrings.py
    python3 tools/autogen_parameters.py
    PYTHONPATH="." python3 tools/generate_sources.py
    python3 setup.py build_ext --inplace
    python3 setup.py install --user # or similar

Examples
--------

The examples/*.py files contain simple examples for using the library, e.g.:

    python3 example_qt.py

Documentation
-------------

Documentation (partially auto-generated) is installed with the module:

    pydoc3 visiontransfer

Development
-----------

Development should take place only on the visiontransfer_src/*.py.in
template files, as well as the preprocessors in tools/.
Any other files are autogenerated and will be overwritten by make.

