// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <ngraph/op/op.hpp>
#include "load.hpp"

namespace ngraph {
namespace snippets {
namespace op {

/**
 * @interface VectorLoad
 * @brief Generated by Canonicalization for a vector value load to vector register
 * @ingroup snippets
 */
class VectorLoad : public Load {
public:
    OPENVINO_OP("VectorLoad", "SnippetsOpset", ngraph::snippets::op::Load);

    VectorLoad(const Output<Node>& x);
    VectorLoad() = default;

    std::shared_ptr<Node> clone_with_new_inputs(const OutputVector& new_args) const override {
        check_new_args_count(this, new_args);
        return std::make_shared<VectorLoad>(new_args.at(0));
    }
};

} // namespace op
} // namespace snippets
} // namespace ngraph