// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <ngraph/op/op.hpp>
#include "store.hpp"

namespace ngraph {
namespace snippets {
namespace op {

/**
 * @interface VectorStore
 * @brief Generated by Canonicalization for a vector value store from vector register
 * @ingroup snippets
 */
class VectorStore : public Store {
public:
    OPENVINO_OP("VectorStore", "SnippetsOpset", ngraph::snippets::op::Store);

    VectorStore(const Output<Node>& x);
    VectorStore() = default;

    std::shared_ptr<Node> clone_with_new_inputs(const OutputVector& new_args) const override {
        check_new_args_count(this, new_args);
        return std::make_shared<VectorStore>(new_args.at(0));
    }
};

} // namespace op
} // namespace snippets
} // namespace ngraph