// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

// This collection contains one entry for each op. If an op is added it must be
// added to this list.
//
// In order to use this list you want to define a macro named exactly NGRAPH_OP
// When you are done you should undef the macro
// As an example if you wanted to make a list of all op names as strings you could do this:

#ifndef NGRAPH_OP
#warning "NGRAPH_OP not defined"
#define NGRAPH_OP(NAME, NAMESPACE, VERSION)
#endif

NGRAPH_SUPPRESS_DEPRECATED_START

NGRAPH_OP(Abs, ngraph::op::v0, 0)
NGRAPH_OP(Acos, ngraph::op::v0, 0)
NGRAPH_OP(Acosh, ngraph::op::v3, 3)
NGRAPH_OP(Add, ngraph::op::v1, 1)
NGRAPH_OP(Asin, ngraph::op::v0, 0)
NGRAPH_OP(Asinh, ngraph::op::v3, 3)
NGRAPH_OP(Atan, ngraph::op::v0, 0)
NGRAPH_OP(Atanh, ngraph::op::v3, 3)
NGRAPH_OP(AvgPool, ngraph::op::v1, 1)
NGRAPH_OP(BatchNormInference, ngraph::op::v0, 0)
NGRAPH_OP(BatchToSpace, ngraph::op::v1, 1)
NGRAPH_OP(BinaryConvolution, ngraph::op::v1, 1)
NGRAPH_OP(Broadcast, ngraph::op::v1, 1)
NGRAPH_OP(Broadcast, ngraph::op::v3, 3)
NGRAPH_OP(Bucketize, ngraph::op::v3, 3)
NGRAPH_OP(CTCGreedyDecoder, ngraph::op::v0, 0)
NGRAPH_OP(Ceiling, ngraph::op::v0, 0)
NGRAPH_OP(Clamp, ngraph::op::v0, 0)
NGRAPH_OP(Concat, ngraph::op::v0, 0)
NGRAPH_OP(Constant, ngraph::op::v0, 0)
NGRAPH_OP(Convert, ngraph::op::v0, 0)
NGRAPH_OP(ConvertLike, ngraph::op::v1, 1)
NGRAPH_OP(Convolution, ngraph::op::v1, 1)
NGRAPH_OP(ConvolutionBackpropData, ngraph::op::v1, 1)
NGRAPH_OP(Cos, ngraph::op::v0, 0)
NGRAPH_OP(Cosh, ngraph::op::v0, 0)
NGRAPH_OP(CumSum, ngraph::op::v0, 0)
NGRAPH_OP(DeformableConvolution, ngraph::op::v1, 1)
NGRAPH_OP(DeformablePSROIPooling, ngraph::op::v1, 1)
NGRAPH_OP(DepthToSpace, ngraph::op::v0, 0)
NGRAPH_OP(DetectionOutput, ngraph::op::v0, 0)
NGRAPH_OP(Divide, ngraph::op::v1, 1)
NGRAPH_OP(Elu, ngraph::op::v0, 0)
NGRAPH_OP(EmbeddingBagOffsetsSum, ngraph::op::v3, 3)
NGRAPH_OP(EmbeddingBagPackedSum, ngraph::op::v3, 3)
NGRAPH_OP(EmbeddingSegmentsSum, ngraph::op::v3, 3)
NGRAPH_OP(Equal, ngraph::op::v1, 1)
NGRAPH_OP(Erf, ngraph::op::v0, 0)
NGRAPH_OP(Exp, ngraph::op::v0, 0)
NGRAPH_OP(ExtractImagePatches, ngraph::op::v3, 3)
NGRAPH_OP(FakeQuantize, ngraph::op::v0, 0)
NGRAPH_OP(Floor, ngraph::op::v0, 0)
NGRAPH_OP(FloorMod, ngraph::op::v1, 1)
NGRAPH_OP(GRN, ngraph::op::v0, 0)
NGRAPH_OP(GRUCell, ngraph::op::v3, 3)
NGRAPH_OP(Gather, ngraph::op::v1, 1)
NGRAPH_OP(GatherND, ngraph::op::v5, 5)
NGRAPH_OP(GatherTree, ngraph::op::v1, 1)
NGRAPH_OP(Gelu, ngraph::op::v0, 0)
NGRAPH_OP(Greater, ngraph::op::v1, 1)
NGRAPH_OP(GreaterEqual, ngraph::op::v1, 1)
NGRAPH_OP(GroupConvolution, ngraph::op::v1, 1)
NGRAPH_OP(GroupConvolutionBackpropData, ngraph::op::v1, 1)
NGRAPH_OP(HardSigmoid, ngraph::op::v0, 0)
NGRAPH_OP(Interpolate, ngraph::op::v0, 0)
NGRAPH_OP(Interpolate, ngraph::op::v4, 4)
NGRAPH_OP(LRN, ngraph::op::v0, 0)
NGRAPH_OP(LSTMCell, ngraph::op::v0, 0)
NGRAPH_OP(LSTMSequence, ngraph::op::v0, 0)
NGRAPH_OP(Less, ngraph::op::v1, 1)
NGRAPH_OP(LessEqual, ngraph::op::v1, 1)
NGRAPH_OP(Log, ngraph::op::v0, 0)
NGRAPH_OP(LogicalAnd, ngraph::op::v1, 1)
NGRAPH_OP(LogicalNot, ngraph::op::v1, 1)
NGRAPH_OP(LogicalOr, ngraph::op::v1, 1)
NGRAPH_OP(LogicalXor, ngraph::op::v1, 1)
NGRAPH_OP(MVN, ngraph::op::v0, 0)
NGRAPH_OP(MatMul, ngraph::op::v0, 0)
NGRAPH_OP(MaxPool, ngraph::op::v1, 1)
NGRAPH_OP(Maximum, ngraph::op::v1, 1)
NGRAPH_OP(Minimum, ngraph::op::v1, 1)
NGRAPH_OP(Mod, ngraph::op::v1, 1)
NGRAPH_OP(Multiply, ngraph::op::v1, 1)
NGRAPH_OP(Negative, ngraph::op::v0, 0)
NGRAPH_OP(NonMaxSuppression, ngraph::op::v1, 1)
NGRAPH_OP(NonMaxSuppression, ngraph::op::v3, 3)
NGRAPH_OP(NonZero, ngraph::op::v3, 3)
NGRAPH_OP(NormalizeL2, ngraph::op::v0, 0)
NGRAPH_OP(NotEqual, ngraph::op::v1, 1)
NGRAPH_OP(OneHot, ngraph::op::v1, 1)
NGRAPH_OP(PRelu, ngraph::op::v0, 0)
NGRAPH_OP(PSROIPooling, ngraph::op::v0, 0)
NGRAPH_OP(Pad, ngraph::op::v1, 1)
NGRAPH_OP(Parameter, ngraph::op::v0, 0)
NGRAPH_OP(Power, ngraph::op::v1, 1)
NGRAPH_OP(PriorBox, ngraph::op::v0, 0)
NGRAPH_OP(PriorBoxClustered, ngraph::op::v0, 0)
NGRAPH_OP(Proposal, ngraph::op::v0, 0)
NGRAPH_OP(RNNCell, ngraph::op::v0, 0)
NGRAPH_OP(ROIPooling, ngraph::op::v0, 0)
NGRAPH_OP(Range, ngraph::op::v0, 0)
NGRAPH_OP(ReduceMax, ngraph::op::v1, 1)
NGRAPH_OP(ReduceLogicalAnd, ngraph::op::v1, 1)
NGRAPH_OP(ReduceLogicalOr, ngraph::op::v1, 1)
NGRAPH_OP(ReduceMean, ngraph::op::v1, 1)
NGRAPH_OP(ReduceMin, ngraph::op::v1, 1)
NGRAPH_OP(ReduceProd, ngraph::op::v1, 1)
NGRAPH_OP(ReduceSum, ngraph::op::v1, 1)
NGRAPH_OP(RegionYolo, ngraph::op::v0, 0)
NGRAPH_OP(Relu, ngraph::op::v0, 0)
NGRAPH_OP(ReorgYolo, ngraph::op::v0, 0)
NGRAPH_OP(Reshape, ngraph::op::v1, 1)
NGRAPH_OP(Result, ngraph::op::v0, 0)
NGRAPH_OP(Reverse, ngraph::op::v1, 1)
NGRAPH_OP(ReverseSequence, ngraph::op::v0, 0)
NGRAPH_OP(Round, ngraph::op::v5, 5)
NGRAPH_OP(ROIAlign, ngraph::op::v3, 3)
NGRAPH_OP(ScatterElementsUpdate, ngraph::op::v3, 3)
NGRAPH_OP(ScatterUpdate, ngraph::op::v3, 3)
NGRAPH_OP(Select, ngraph::op::v1, 1)
NGRAPH_OP(Selu, ngraph::op::v0, 0)
NGRAPH_OP(ShapeOf, ngraph::op::v0, 0)
NGRAPH_OP(ShapeOf, ngraph::op::v3, 3)
NGRAPH_OP(ShuffleChannels, ngraph::op::v0, 0)
NGRAPH_OP(Sigmoid, ngraph::op::v0, 0)
NGRAPH_OP(Sign, ngraph::op::v0, 0)
NGRAPH_OP(Sin, ngraph::op::v0, 0)
NGRAPH_OP(Sinh, ngraph::op::v0, 0)
NGRAPH_OP(Softmax, ngraph::op::v1, 1)
NGRAPH_OP(SpaceToBatch, ngraph::op::v1, 1)
NGRAPH_OP(SpaceToDepth, ngraph::op::v0, 0)
NGRAPH_OP(Split, ngraph::op::v1, 1)
NGRAPH_OP(Sqrt, ngraph::op::v0, 0)
NGRAPH_OP(SquaredDifference, ngraph::op::v0, 0)
NGRAPH_OP(Squeeze, ngraph::op::v0, 0)
NGRAPH_OP(StridedSlice, ngraph::op::v1, 1)
NGRAPH_OP(Subtract, ngraph::op::v1, 1)
NGRAPH_OP(Tan, ngraph::op::v0, 0)
NGRAPH_OP(Tanh, ngraph::op::v0, 0)
NGRAPH_OP(TensorIterator, ngraph::op::v0, 0)
NGRAPH_OP(Tile, ngraph::op::v0, 0)
NGRAPH_OP(TopK, ngraph::op::v1, 1)
NGRAPH_OP(Transpose, ngraph::op::v1, 1)
NGRAPH_OP(Unsqueeze, ngraph::op::v0, 0)
NGRAPH_OP(VariadicSplit, ngraph::op::v1, 1)
NGRAPH_OP(Xor, ngraph::op::v0, 0)
NGRAPH_OP(Assign, ngraph::op::v3, 3)
NGRAPH_OP(ReadValue, ngraph::op::v3, 3)

NGRAPH_SUPPRESS_DEPRECATED_END
