# Selective Build
## Introduction
Selective build or conditional compilation can significantly reduce OpenVINO™ binaries size by excluding unnecessary components for particular model's inference.

Here we enable the selective build function on oneDNN plugin.

## Workflow

Onednn path in OpenVINO:

    ./src/plugins/intel_cpu/thirdparty/onednn/

The selective build carries on under the instruction of:

    ./src/common/conditional_compilation/CMakeLists.txt

### **First build**

The first build collects the information and generate a CSV file indicating which components are going to be included and which are going to be excluded in the selected build.

*   For the first build, config cmake with option "-DENABLE_PROFILING_ITT=ON -DSELECTIVE_BUILD=COLLECT"
```
cd ./build

cmake .. \
-DCMAKE_BUILD_TYPE=Release \
-DCMAKE_BUILD_TYPE=Release \
-DENABLE_CPU_DEBUG_CAPS=ON \
-DENABLE_PROFILING_ITT=ON \
-DSELECTIVE_BUILD=COLLECT \
-DCMAKE_INSTALL_PREFIX=`pwd`/install \
-DCMAKE_INSTALL_RPATH=`pwd`/install/runtime/3rdparty/tbb/lib:`pwd`/install/runtime/3rdparty/hddl/lib:`pwd`/install/runtime/lib/intel64

cmake --build . --config Release -j 8
```


Generate statistics file (CSV): 
*   Need to build manually to get libIntelSEAPI.so with the following step first.
```
# in ./build
cd ./thirdparty/itt_collector && make
```
*   Then generate statistics file (in .csv format).
```
cd ../../../bin/intel64/Release/

python ../../../thirdparty/itt_collector/runtool/sea_runtool.py \
--bindir ./lib -o models_statistics_dir ! \
./benchmark_app -niter 1 -nireq 1 \
-m <model_path>
```


### **Second build**

The second build takes in the information in the statistics file and only build the components mentioned in the CSV file.

The generated CSV file could be found in folder:

    openvino/bin/intel64/Release/

This time, config cmake with option "-DSELECTIVE_BUILD=ON"

```
cd ../../../build

cmake .. \
-DCMAKE_BUILD_TYPE=Release \
-DENABLE_CPU_DEBUG_CAPS=ON \
-DENABLE_DEBUG_CAPS=ON \
-DSELECTIVE_BUILD=ON \
-DSELECTIVE_BUILD_STAT=<CSV_PATH> \
-DPYTHON_EXECUTABLE=/usr/bin/python3.7 \
-DCMAKE_INSTALL_PREFIX=`pwd`/install \
-DCMAKE_INSTALL_RPATH=`pwd`/install/runtime/3rdparty/tbb/lib:`pwd`/install/runtime/3rdparty/hddl/lib:`pwd`/install/runtime/lib/intel64

cmake --build . --config Release -j 8
```
As shown in 

    ./src/common/conditional_compilation/CMakeLists.txt
    
CSV file works as a SELECTIVE_BUILD_STAT and is first interpreted into a c++ head file:

    ./build/src/common/conditional_compilation/conditional_compilation_gen.h

It is generated by 'ccheader.py' and can indicate if selective build analyze process (first build) works correctly.


### **Test selective compile with benchmark**
```
cd ./bin/intel64/Release

./benchmark_app -niter 1 -nireq 1 \
-m <model_path> -d CPU 
```

## Reference 
https://github.com/openvinotoolkit/openvino/wiki/ConditionalCompilation

https://github.com/openvinotoolkit/openvino/commit/ec48fcb29bef94cca480573110a598afc3515019#

https://github.com/openvinotoolkit/openvino/commit/1f96ddfbf9030e765aa0ca0a6aafb1ae2b8c3e98#diff-de6f7126342889fe9d0b505b0ac391db2275400488d5bab9194c2542a4f4d1fe

