// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

///////////////////////////////////////////////////////////////////////////////////////////////////
#pragma once
#include "intel_gpu/primitives/reshape.hpp"
#include "primitive_inst.h"
#include "intel_gpu/runtime/error_handler.hpp"

#include <string>
#include <memory>

namespace cldnn {

template <>
struct typed_program_node<reshape> : public typed_program_node_base<reshape> {
    using parent = typed_program_node_base<reshape>;
    typed_program_node(const std::shared_ptr<reshape> prim, program& prog) : parent(prim, prog) {
        support_padding_all(true);
    }

public:
    using parent::parent;

    program_node& input() const {
        CLDNN_ERROR_LESS_THAN(id(), "the number of dependencies", dependencies.size(), "1", 1, "ERROR: the node has no input");
        return get_dependency(0);
    }

    bool is_in_place() const {
        if (this->is_output() || !this->get_fused_activations_funcs().empty())
            return false;
        return (!this->get_output_layout().data_padding && !input().get_output_layout(false).data_padding);
    }
};

using reshape_node = typed_program_node<reshape>;

template <>
class typed_primitive_inst<reshape> : public typed_primitive_inst_base<reshape> {
    using parent = typed_primitive_inst_base<reshape>;

public:
    static layout calc_output_layout(reshape_node const& node);
    static std::string to_string(reshape_node const& node);

public:
    typed_primitive_inst(network& network, reshape_node const& node);

private:
    void on_execute() override;

    void reuse_input();
};

using reshape_inst = typed_primitive_inst<reshape>;

}  // namespace cldnn
