// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#include <vector>
#include "single_layer_tests/experimental_detectron_topkrois.hpp"

using namespace ov::test;
using namespace ov::test::subgraph;

namespace {
std::vector<int64_t> maxRois {
        1000,
        1500,
        2000,
        2500
};

const std::vector<std::vector<InputShape>> staticInputShape = {
        static_shapes_to_test_representation({{3000, 4}, {3000}}),
        static_shapes_to_test_representation({{4200, 4}, {4200}}),
        static_shapes_to_test_representation({{4500, 4}, {4500}})
};

INSTANTIATE_TEST_SUITE_P(smoke_ExperimentalDetectronTopKROIs_static, ExperimentalDetectronTopKROIsLayerTest,
                         ::testing::Combine(
                                 ::testing::ValuesIn(staticInputShape),
                                 ::testing::ValuesIn(maxRois),
                                 ::testing::Values(ElementType::f32),
                                 ::testing::Values(CommonTestUtils::DEVICE_CPU)),
                         ExperimentalDetectronTopKROIsLayerTest::getTestCaseName);

const std::vector<std::vector<InputShape>> dynamicInputShape = {
        {
                {
                        {{-1, 4}, {{5000, 4}, {4000, 4}, {3500, 4}}},
                        {{-1}, {{5000}, {4000}, {3500}}}
                }
        },
        {
                {
                        {{{1000, 5000}, 4}, {{5000, 4}, {3000, 4}, {2500, 4}}},
                        {{{1000, 5000}}, {{5000}, {3000}, {2500}}}
                }
        }
};

INSTANTIATE_TEST_SUITE_P(smoke_ExperimentalROI_dynamic, ExperimentalDetectronTopKROIsLayerTest,
                         ::testing::Combine(
                                 ::testing::ValuesIn(dynamicInputShape),
                                 ::testing::ValuesIn(maxRois),
                                 ::testing::Values(ElementType::f32),
                                 ::testing::Values(CommonTestUtils::DEVICE_CPU)),
                         ExperimentalDetectronTopKROIsLayerTest::getTestCaseName);
} // namespace
