# [OpenVINO™ Toolkit](https://docs.openvino.ai/latest/index.html) - Open Model Zoo repository
[![Stable release](https://img.shields.io/badge/version-2022.2.0-green.svg)](https://github.com/openvinotoolkit/open_model_zoo/releases/tag/2022.2.0)
[![Gitter chat](https://badges.gitter.im/gitterHQ/gitter.png)](https://gitter.im/open_model_zoo/community)
[![Apache License Version 2.0](https://img.shields.io/badge/license-Apache_2.0-green.svg)](LICENSE)

This repository includes optimized deep learning models and a set of demos to expedite development of high-performance deep learning inference applications. Use these free pre-trained models instead of training your own models to speed-up the development and production deployment process.

Intel is committed to the respect of human rights and avoiding complicity in human rights abuses, a policy reflected in the [Intel Global Human Rights Principles](https://www.intel.com/content/www/us/en/policy/policy-human-rights.html). Accordingly, by accessing the Intel material on this platform you agree that you will not use the material in a product or application that causes or contributes to a violation of an internationally recognized human right.

## Repository Components:
* [Intel Pre-Trained Models](models/intel/index.md)
* [Public Pre-Trained Models](models/public/index.md)
* [Model Downloader](tools/model_tools/README.md) and other automation tools
* [Demos](demos/README.md) that demonstrate models usage with OpenVINO™ Toolkit
* [Accuracy Checker](tools/accuracy_checker/README.md) tool for models accuracy validation

## License
Open Model Zoo is licensed under [Apache License Version 2.0](LICENSE).

## Online Documentation
* [OpenVINO™ Release Notes](https://software.intel.com/en-us/articles/OpenVINO-RelNotes)
* [Pre-Trained Models](https://docs.openvino.ai/latest/model_zoo.html)
* [Demos and Samples](https://docs.openvino.ai/latest/omz_demos.html)

## Other Usage Examples
* [Open Visual Cloud](https://www.intel.com/content/www/us/en/developer/articles/technical/open-visual-cloud.html)
  * [Tutorial: Running AD Insertion on Public Cloud](https://github.com/OpenVisualCloud/Ad-Insertion-Sample/wiki/Tutorial:-Running-AD-Insertion-on-Public-Cloud)
  * [GitHub Repo for Ad Insertion Sample](https://github.com/OpenVisualCloud/Ad-Insertion-Sample)
* [OpenVINO for Smart City](https://github.com/incluit/OpenVino-For-SmartCity)
* [OpenVINO Driver Behavior](https://github.com/incluit/OpenVino-Driver-Behaviour)
* [OpenVINO Python\* Notebooks](https://github.com/openvinotoolkit/openvino_notebooks/blob/main/README.md)

## How to Contribute
We welcome community contributions to the Open Model Zoo repository. If you have an idea how to improve the product, please share it with us doing the following steps:

* Make sure you can build the product and run all the demos with your patch.
* In case of a larger feature, provide a relevant demo.
* Submit a pull request at https://github.com/openvinotoolkit/open_model_zoo/pulls

You can find additional information about model contribution [here](CONTRIBUTING.md).

We will review your contribution and, if any additional fixes or modifications are needed, may give you feedback to guide you. When accepted, your pull request will be merged into the GitHub* repositories.

Open Model Zoo is licensed under Apache License, Version 2.0. By contributing to the project, you agree to the license and copyright terms therein and release your contribution under these terms.

## Support
Please report questions, issues and suggestions using:
* [\#open_model_zoo](https://stackoverflow.com/search?q=%23open_model_zoo) tag on StackOverflow*
* [GitHub* Issues](https://github.com/openvinotoolkit/open_model_zoo/issues)
* [Forum](https://community.intel.com/t5/Intel-Distribution-of-OpenVINO/bd-p/distribution-openvino-toolkit)
* [Gitter](https://gitter.im/open_model_zoo/community)

---
\* Other names and brands may be claimed as the property of others.
