OPTIC
-----
[![GitHub Action 
Status](https://github.com/alvaro0308/optic/actions/workflows/workflow.yaml/badge.svg)](https://github.com/alvaro0308/)

The OPTIC planner from J. Benton, A. J. Coles, and A. I. Coles, ICAPS 2012 
with some modifications to make it work with Ubuntu 18.04/20.04 and GCC-9.

This package contains OPTIC, a planner for use in problems where plan cost is
determined by preferences or time-dependent goal-collection costs.  For more
details, see the paper "Temporal Planning with Preferences and Time-Dependent 
Continuous Costs", J. Benton, A. J. Coles, and A. I. Coles, ICAPS 2012.  

OPTIC is derived from the planner POPF.  In the interests of developing a
single, capable planner, the sources here also contain the TIL-abstraction 
extension of POPF described in the paper "Automated  Planning for Liner 
Shipping Fleet Repositioning", K. Tierney, A. J. Coles, A. I. Coles, C. Kroer,
A. Britt, and R. M. Jensen, ICAPS 2012.  This can be invoked with an extra
command line flag (details below).

Build Prerequisites
-------------------
```sh
sudo apt-get install cmake coinor-libcbc-dev coinor-libclp-dev \
                     coinor-libcoinutils-dev libbz2-dev bison flex
```

**GCC-9:**

Ubuntu 20.04:
```sh
sudo apt install gcc-9 g++-9
```

Ubuntu 18.04:
```sh
sudo add-apt-repository ppa:ubuntu-toolchain-r/test
sudo apt update
sudo apt install gcc-9 g++-9
```

**GSL - GNU Scientific Library:**
```sh
wget https://mirror.ibcp.fr/pub/gnu/gsl/gsl-latest.tar.gz
tar -xzf gsl-latest.tar.gz
cd gsl-2.6/
./configure
make
sudo make install
```

Compiling
---------
```sh
colcon build --symlink-install
```

Running
-------
Once compiled, run, e.g.:
```sh
ros2 run optic optic domain.pddl problem.pddl
```

Licence
-------
OPTIC is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

OPTIC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
