/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.integration;

import com.eprosima.integration.IDL;
import com.eprosima.integration.Test;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TestManager {
    public static final IDL[] ALL_IDLS = IDL.values();
    private TestLevel level;
    private ArrayList<IDL> idls;
    private String generatorName;
    private String inputPath;
    private String outputPath;
    private List<String> cMakeArgs;
    private boolean errorOutputOnly;

    public TestManager(TestLevel level, String generatorName, String inputPath, String outputPath) {
        this.level = level;
        this.idls = new ArrayList<IDL>(Arrays.asList(ALL_IDLS));
        this.generatorName = generatorName;
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.cMakeArgs = new ArrayList<String>();
        this.errorOutputOnly = true;
    }

    public void showOutputOnlyAtErrors(boolean value) {
        this.errorOutputOnly = value;
    }

    public void addCMakeArguments(String ... args) {
        this.cMakeArgs.addAll(Arrays.asList(args));
    }

    public void addTests(IDL ... args) {
        for (IDL idl : Arrays.asList(args)) {
            this.idls.add(idl);
        }
    }

    public void removeTests(IDL ... args) {
        Iterator<IDL> it = this.idls.iterator();
        while (it.hasNext()) {
            if (!Arrays.asList(args).contains((Object)it.next())) continue;
            it.remove();
        }
    }

    public boolean runTests() {
        for (IDL idl : this.idls) {
            Test test = new Test(idl, this.outputPath, this.errorOutputOnly);
            if (this.run(test)) continue;
            return false;
        }
        return true;
    }

    private boolean prepare(Test test) {
        this.printHeader(test.getIDL(), TestLevel.PREPARE);
        return this.printlnStatus(test.prepare());
    }

    public boolean generate(Test test) {
        boolean precondition = this.prepare(test);
        if (precondition && this.level.getValue() >= TestLevel.GENERATE.getValue()) {
            this.printHeader(test.getIDL(), TestLevel.GENERATE);
            boolean notRunIncludeIDL = test.getIDL() != IDL.INCLUDE;
            return this.printlnStatus(test.generate(this.generatorName, this.inputPath, this.level == TestLevel.RUN && notRunIncludeIDL));
        }
        return precondition;
    }

    public boolean configure(Test test) {
        boolean precondition = this.generate(test);
        if (precondition && this.level.getValue() >= TestLevel.CONFIGURE.getValue()) {
            this.printHeader(test.getIDL(), TestLevel.CONFIGURE);
            return this.printlnStatus(test.configure(this.cMakeArgs));
        }
        return precondition;
    }

    public boolean compile(Test test) {
        boolean precondition = this.configure(test);
        if (precondition && this.level.getValue() >= TestLevel.COMPILE.getValue()) {
            this.printHeader(test.getIDL(), TestLevel.COMPILE);
            return this.printlnStatus(test.compile());
        }
        return precondition;
    }

    private boolean run(Test test) {
        boolean precondition = this.compile(test);
        if (precondition && this.level.getValue() >= TestLevel.RUN.getValue()) {
            this.printHeader(test.getIDL(), TestLevel.RUN);
            if (test.getIDL() == IDL.INCLUDE) {
                return this.printlnStatus(true);
            }
            return this.printlnStatus(test.run());
        }
        return precondition;
    }

    private void printHeader(IDL idl, TestLevel level) {
        System.out.println("\n\n>>> " + idl.toString() + " TEST: " + level.toString() + "...");
    }

    private boolean printlnStatus(boolean status) {
        System.out.println("    RESULT: " + (status ? "OK!" : "ERROR"));
        return status;
    }

    public static enum TestLevel {
        PREPARE(0),
        GENERATE(1),
        CONFIGURE(2),
        COMPILE(3),
        RUN(4);

        private int value;

        private TestLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

