# Copyright (c) 2021 PAL Robotics S.L.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from urdf_test.description_test import (generate_urdf_test_description,
                                        TestDescriptionPublished, TestSuccessfulExit)
from launch_pal.include_utils import include_launch_py_description

# Ignore unused import warnings for the Test Classes
__all__ = ('TestDescriptionPublished', 'TestSuccessfulExit')


def generate_test_description():
    return generate_urdf_test_description(
        include_launch_py_description(
            'pmb2_description', ['launch', 'robot_state_publisher.launch.py']),

    )
