/*
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See LICENSE in the project root.
 */
#ifndef _RIOT_STATUS_H
#define _RIOT_STATUS_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum RIOT_STATUS {
    RIOT_SUCCESS = 0,
    RIOT_FAILURE = RIOT_SUCCESS + 0x80,
    RIOT_INVALID_PARAMETER,
    RIOT_LOAD_MODULE_FAILED,
    RIOT_BAD_FORMAT,
    RIOT_INVALID_BOOT_MODE,
    RIOT_INVALID_STATE,
    RIOT_INVALID_METADATA,
    RIOT_INVALID_DEVICE_ID,
    RIOT_INVALID_MODULE,
    RIOT_INVALID_MODULE_DIGEST,
    RIOT_MODULE_UPDATE_FAILED,
    RIOT_METADATA_WRITE_FAILED,
    RIOT_STATE_UPDATE_FAILED,
    RIOT_INVALID_VENDOR_SIGNING_KEY,
    RIOT_INVALID_VENDOR_SIGNATURE,
    RIOT_INVALID_DEVICE_SIGNATURE,
    RIOT_INVALID_TICKET_SIGNATURE,
    RIOT_MODULE_UPDATE_NOT_APPROVED,
    RIOT_FAILED_UPDATE_POLICY,
} RIOT_STATUS;

#ifdef __cplusplus
}
#endif

#endif
