/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.parser.typecode;

import com.eprosima.idl.parser.typecode.Bitfield;
import com.eprosima.idl.parser.typecode.MemberedTypeCode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;

public class BitsetTypeCode
extends MemberedTypeCode {
    private BitsetTypeCode m_parent = null;
    private LinkedHashMap<String, Bitfield> m_bitfields = new LinkedHashMap();
    private int m_current_base = 0;

    public BitsetTypeCode(String scope, String name) {
        super(26, scope, name);
    }

    @Override
    public String getCppTypename() {
        StringTemplate st = this.getCppTypenameFromStringTemplate();
        st.setAttribute("name", this.getScopedname());
        return st.toString();
    }

    @Override
    public String getCTypename() {
        StringTemplate st = this.getCTypenameFromStringTemplate();
        st.setAttribute("name", this.getCScopedname());
        return st.toString();
    }

    @Override
    public String getJavaTypename() {
        StringTemplate st = this.getJavaTypenameFromStringTemplate();
        st.setAttribute("name", this.getJavaScopedname());
        return st.toString();
    }

    @Override
    public String getIdlTypename() {
        StringTemplate st = this.getIdlTypenameFromStringTemplate();
        st.setAttribute("name", this.getScopedname());
        return st.toString();
    }

    public List<Bitfield> getBitfields() {
        return new ArrayList<Bitfield>(this.m_bitfields.values());
    }

    public boolean addBitfield(Bitfield bitfield) {
        if (!this.m_bitfields.containsKey(bitfield.getName())) {
            this.m_bitfields.put(bitfield.getName(), bitfield);
            bitfield.setBasePosition(this.m_current_base);
            this.m_current_base += bitfield.getSpec().getBitSize();
            return true;
        }
        return false;
    }

    public void setParent(BitsetTypeCode parent) {
        this.m_parent = parent;
    }

    @Override
    public BitsetTypeCode getParent() {
        return this.m_parent;
    }

    public int getBitSize() {
        int size = 0;
        for (Bitfield bf : this.m_bitfields.values()) {
            size += bf.getSpec().getBitSize();
        }
        return size;
    }
}

