/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.integration;

import com.eprosima.integration.Command;
import com.eprosima.integration.IDL;
import java.io.File;
import java.util.List;

public class Test {
    private IDL idl;
    private String outputPath;
    private boolean errorOutputOnly;

    public Test(IDL idl, String outputPath, boolean errorOutputOnly) {
        this.idl = idl;
        this.outputPath = outputPath + "/" + idl.toString().toLowerCase();
        this.errorOutputOnly = errorOutputOnly;
    }

    public IDL getIDL() {
        return this.idl;
    }

    public boolean prepare() {
        File outputPathFolder = new File(this.outputPath + "/build");
        boolean prepared = false;
        prepared = outputPathFolder.exists() && outputPathFolder.isDirectory() ? true : outputPathFolder.mkdirs();
        if (prepared) {
            System.out.println("Done!");
        }
        return prepared;
    }

    public boolean generate(String generatorName, String inputPath, boolean testFlag) {
        String program = "java -jar " + generatorName + ".jar";
        String flags = " -replace -example" + (testFlag ? " -test" : "");
        String output = " -d " + this.outputPath;
        String idlPaths = "";
        for (IDL aux = this.idl; aux != null; aux = aux.getRequired()) {
            idlPaths = idlPaths + " " + inputPath + "/" + aux.toString().toLowerCase() + ".idl";
        }
        String command = program + flags + output + idlPaths;
        return Command.execute(command, null, this.errorOutputOnly);
    }

    public boolean configure(List<String> cMakeArguments) {
        String arguments = cMakeArguments.toString().replaceFirst("\\[", " ").replaceAll(",|\\]", "");
        return Command.execute("cmake .." + arguments, this.outputPath + "/build", this.errorOutputOnly);
    }

    public boolean compile() {
        return Command.execute("make", this.outputPath + "/build", this.errorOutputOnly);
    }

    public boolean run() {
        boolean exitStatus = Command.execute("./" + this.idl.toString().toLowerCase() + "SerializationTest", this.outputPath + "/build", this.errorOutputOnly);
        return exitStatus;
    }
}

