/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.v4.automata.ATNFactory;
import org.antlr.v4.automata.ATNOptimizer;
import org.antlr.v4.automata.ParserATNFactory;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.misc.CharSupport;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.LexerAction;
import org.antlr.v4.runtime.atn.LexerChannelAction;
import org.antlr.v4.runtime.atn.LexerCustomAction;
import org.antlr.v4.runtime.atn.LexerModeAction;
import org.antlr.v4.runtime.atn.LexerMoreAction;
import org.antlr.v4.runtime.atn.LexerPopModeAction;
import org.antlr.v4.runtime.atn.LexerPushModeAction;
import org.antlr.v4.runtime.atn.LexerSkipAction;
import org.antlr.v4.runtime.atn.LexerTypeAction;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.TokensStartState;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.TerminalAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class LexerATNFactory
extends ParserATNFactory {
    public STGroup codegenTemplates;
    protected static final Map<String, Integer> COMMON_CONSTANTS = new HashMap<String, Integer>();
    protected Map<Integer, LexerAction> indexToActionMap = new HashMap<Integer, LexerAction>();
    protected Map<LexerAction, Integer> actionToIndexMap = new HashMap<LexerAction, Integer>();

    public LexerATNFactory(LexerGrammar g) {
        super(g);
        String language = g.getOptionString("language");
        CodeGenerator gen = new CodeGenerator(g.tool, null, language);
        this.codegenTemplates = gen.getTemplates();
    }

    @Override
    public ATN createATN() {
        Set modes = ((LexerGrammar)this.g).modes.keySet();
        for (String string : modes) {
            TokensStartState startState = this.newState(TokensStartState.class, null);
            this.atn.modeNameToStartState.put(string, startState);
            this.atn.modeToStartState.add(startState);
            this.atn.defineDecisionState(startState);
        }
        this.atn.ruleToTokenType = new int[this.g.rules.size()];
        for (Rule rule : this.g.rules.values()) {
            this.atn.ruleToTokenType[rule.index] = this.g.getTokenType(rule.name);
        }
        this._createATN(this.g.rules.values());
        this.atn.lexerActions = new LexerAction[this.indexToActionMap.size()];
        for (Map.Entry entry : this.indexToActionMap.entrySet()) {
            this.atn.lexerActions[((Integer)entry.getKey()).intValue()] = (LexerAction)entry.getValue();
        }
        for (String string : modes) {
            List rules = (List)((LexerGrammar)this.g).modes.get(string);
            TokensStartState startState = this.atn.modeNameToStartState.get(string);
            for (Rule r : rules) {
                if (r.isFragment()) continue;
                RuleStartState s = this.atn.ruleToStartState[r.index];
                this.epsilon(startState, s);
            }
        }
        ATNOptimizer.optimize(this.g, this.atn);
        return this.atn;
    }

    @Override
    public ATNFactory.Handle action(ActionAST action) {
        int ruleIndex = this.currentRule.index;
        int actionIndex = this.g.lexerActions.get(action);
        LexerCustomAction lexerAction = new LexerCustomAction(ruleIndex, actionIndex);
        return this.action(action, lexerAction);
    }

    protected int getLexerActionIndex(LexerAction lexerAction) {
        Integer lexerActionIndex = this.actionToIndexMap.get(lexerAction);
        if (lexerActionIndex == null) {
            lexerActionIndex = this.actionToIndexMap.size();
            this.actionToIndexMap.put(lexerAction, lexerActionIndex);
            this.indexToActionMap.put(lexerActionIndex, lexerAction);
        }
        return lexerActionIndex;
    }

    @Override
    public ATNFactory.Handle action(String action) {
        if (action.trim().isEmpty()) {
            ATNState left = this.newState(null);
            ATNState right = this.newState(null);
            this.epsilon(left, right);
            return new ATNFactory.Handle(left, right);
        }
        ActionAST ast = new ActionAST(new CommonToken(4, action));
        this.currentRule.defineActionInAlt(this.currentOuterAlt, ast);
        return this.action(ast);
    }

    protected ATNFactory.Handle action(GrammarAST node, LexerAction lexerAction) {
        ATNState left = this.newState(node);
        ATNState right = this.newState(node);
        boolean isCtxDependent = false;
        int lexerActionIndex = this.getLexerActionIndex(lexerAction);
        ActionTransition a = new ActionTransition(right, this.currentRule.index, lexerActionIndex, isCtxDependent);
        left.addTransition(a);
        node.atnState = left;
        ATNFactory.Handle h = new ATNFactory.Handle(left, right);
        return h;
    }

    @Override
    public ATNFactory.Handle lexerAltCommands(ATNFactory.Handle alt, ATNFactory.Handle cmds) {
        ATNFactory.Handle h = new ATNFactory.Handle(alt.left, cmds.right);
        this.epsilon(alt.right, cmds.left);
        return h;
    }

    @Override
    public ATNFactory.Handle lexerCallCommand(GrammarAST ID, GrammarAST arg) {
        LexerAction lexerAction = this.createLexerAction(ID, arg);
        if (lexerAction != null) {
            return this.action(ID, lexerAction);
        }
        ST cmdST = this.codegenTemplates.getInstanceOf("Lexer" + CharSupport.capitalize(ID.getText()) + "Command");
        if (cmdST == null) {
            this.g.tool.errMgr.grammarError(ErrorType.INVALID_LEXER_COMMAND, this.g.fileName, ID.token, ID.getText());
            return this.epsilon(ID);
        }
        if (cmdST.impl.formalArguments == null || !cmdST.impl.formalArguments.containsKey("arg")) {
            this.g.tool.errMgr.grammarError(ErrorType.UNWANTED_LEXER_COMMAND_ARGUMENT, this.g.fileName, ID.token, ID.getText());
            return this.epsilon(ID);
        }
        cmdST.add("arg", arg.getText());
        return this.action(cmdST.render());
    }

    @Override
    public ATNFactory.Handle lexerCommand(GrammarAST ID) {
        LexerAction lexerAction = this.createLexerAction(ID, null);
        if (lexerAction != null) {
            return this.action(ID, lexerAction);
        }
        ST cmdST = this.codegenTemplates.getInstanceOf("Lexer" + CharSupport.capitalize(ID.getText()) + "Command");
        if (cmdST == null) {
            this.g.tool.errMgr.grammarError(ErrorType.INVALID_LEXER_COMMAND, this.g.fileName, ID.token, ID.getText());
            return this.epsilon(ID);
        }
        if (cmdST.impl.formalArguments != null && cmdST.impl.formalArguments.containsKey("arg")) {
            this.g.tool.errMgr.grammarError(ErrorType.MISSING_LEXER_COMMAND_ARGUMENT, this.g.fileName, ID.token, ID.getText());
            return this.epsilon(ID);
        }
        return this.action(cmdST.render());
    }

    @Override
    public ATNFactory.Handle range(GrammarAST a, GrammarAST b) {
        ATNState left = this.newState(a);
        ATNState right = this.newState(b);
        int t1 = CharSupport.getCharValueFromGrammarCharLiteral(a.getText());
        int t2 = CharSupport.getCharValueFromGrammarCharLiteral(b.getText());
        left.addTransition(new RangeTransition(right, t1, t2));
        a.atnState = left;
        b.atnState = left;
        return new ATNFactory.Handle(left, right);
    }

    @Override
    public ATNFactory.Handle set(GrammarAST associatedAST, List<GrammarAST> alts, boolean invert) {
        ATNState left = this.newState(associatedAST);
        ATNState right = this.newState(associatedAST);
        IntervalSet set = new IntervalSet(new int[0]);
        for (GrammarAST t : alts) {
            if (t.getType() == 51) {
                int a = CharSupport.getCharValueFromGrammarCharLiteral(t.getChild(0).getText());
                int b = CharSupport.getCharValueFromGrammarCharLiteral(t.getChild(1).getText());
                set.add(a, b);
                continue;
            }
            if (t.getType() == 31) {
                set.addAll(this.getSetFromCharSetLiteral(t));
                continue;
            }
            if (t.getType() == 61) {
                int c = CharSupport.getCharValueFromGrammarCharLiteral(t.getText());
                if (c != -1) {
                    set.add(c);
                    continue;
                }
                this.g.tool.errMgr.grammarError(ErrorType.INVALID_LITERAL_IN_LEXER_SET, this.g.fileName, t.getToken(), t.getText());
                continue;
            }
            if (t.getType() != 65) continue;
            this.g.tool.errMgr.grammarError(ErrorType.UNSUPPORTED_REFERENCE_IN_LEXER_SET, this.g.fileName, t.getToken(), t.getText());
        }
        if (invert) {
            left.addTransition(new NotSetTransition(right, set));
        } else {
            Transition transition;
            if (set.getIntervals().size() == 1) {
                Interval interval = set.getIntervals().get(0);
                transition = new RangeTransition(right, interval.a, interval.b);
            } else {
                transition = new SetTransition(right, set);
            }
            left.addTransition(transition);
        }
        associatedAST.atnState = left;
        return new ATNFactory.Handle(left, right);
    }

    @Override
    public ATNFactory.Handle stringLiteral(TerminalAST stringLiteralAST) {
        ATNState left;
        String chars = stringLiteralAST.getText();
        chars = CharSupport.getStringFromGrammarStringLiteral(chars);
        int n = chars.length();
        ATNState prev = left = this.newState(stringLiteralAST);
        ATNState right = null;
        for (int i = 0; i < n; ++i) {
            right = this.newState(stringLiteralAST);
            prev.addTransition(new AtomTransition(right, chars.charAt(i)));
            prev = right;
        }
        stringLiteralAST.atnState = left;
        return new ATNFactory.Handle(left, right);
    }

    @Override
    public ATNFactory.Handle charSetLiteral(GrammarAST charSetAST) {
        ATNState left = this.newState(charSetAST);
        ATNState right = this.newState(charSetAST);
        IntervalSet set = this.getSetFromCharSetLiteral(charSetAST);
        left.addTransition(new SetTransition(right, set));
        charSetAST.atnState = left;
        return new ATNFactory.Handle(left, right);
    }

    public IntervalSet getSetFromCharSetLiteral(GrammarAST charSetAST) {
        String chars = charSetAST.getText();
        chars = chars.substring(1, chars.length() - 1);
        String cset = '\"' + chars + '\"';
        IntervalSet set = new IntervalSet(new int[0]);
        chars = CharSupport.getStringFromGrammarStringLiteral(cset);
        int n = chars.length();
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c == '\\' && i + 1 < n && chars.charAt(i + 1) == '-') {
                set.add(45);
                ++i;
                continue;
            }
            if (i + 2 < n && chars.charAt(i + 1) == '-') {
                char x = c;
                char y = chars.charAt(i + 2);
                if (x <= y) {
                    set.add(x, y);
                }
                i += 2;
                continue;
            }
            set.add(c);
        }
        return set;
    }

    @Override
    public ATNFactory.Handle tokenRef(TerminalAST node) {
        if (node.getText().equals("EOF")) {
            ATNState left = this.newState(node);
            ATNState right = this.newState(node);
            left.addTransition(new AtomTransition(right, -1));
            return new ATNFactory.Handle(left, right);
        }
        return this._ruleRef(node);
    }

    @Nullable
    protected LexerAction createLexerAction(@NotNull GrammarAST ID, @Nullable GrammarAST arg) {
        String command = ID.getText();
        if ("skip".equals(command) && arg == null) {
            return LexerSkipAction.INSTANCE;
        }
        if ("more".equals(command) && arg == null) {
            return LexerMoreAction.INSTANCE;
        }
        if ("popMode".equals(command) && arg == null) {
            return LexerPopModeAction.INSTANCE;
        }
        if ("mode".equals(command) && arg != null) {
            String modeName = arg.getText();
            Integer mode = this.getConstantValue(modeName, arg.getToken());
            if (mode == null) {
                return null;
            }
            return new LexerModeAction(mode);
        }
        if ("pushMode".equals(command) && arg != null) {
            String modeName = arg.getText();
            Integer mode = this.getConstantValue(modeName, arg.getToken());
            if (mode == null) {
                return null;
            }
            return new LexerPushModeAction(mode);
        }
        if ("type".equals(command) && arg != null) {
            String typeName = arg.getText();
            Integer type = this.getConstantValue(typeName, arg.getToken());
            if (type == null) {
                return null;
            }
            return new LexerTypeAction(type);
        }
        if ("channel".equals(command) && arg != null) {
            String channelName = arg.getText();
            Integer channel = this.getConstantValue(channelName, arg.getToken());
            if (channel == null) {
                return null;
            }
            return new LexerChannelAction(channel);
        }
        return null;
    }

    @Nullable
    protected Integer getConstantValue(@Nullable String name, @Nullable Token token) {
        if (name == null) {
            return null;
        }
        Integer commonConstant = COMMON_CONSTANTS.get(name);
        if (commonConstant != null) {
            return commonConstant;
        }
        int tokenType = this.g.getTokenType(name);
        if (tokenType != 0) {
            return tokenType;
        }
        ArrayList modeNames = new ArrayList(((LexerGrammar)this.g).modes.keySet());
        int mode = modeNames.indexOf(name);
        if (mode >= 0) {
            return mode;
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            this.g.tool.errMgr.grammarError(ErrorType.UNKNOWN_LEXER_CONSTANT, this.g.fileName, token, this.currentRule.name, token != null ? token.getText() : null);
            return null;
        }
    }

    static {
        COMMON_CONSTANTS.put("HIDDEN", 1);
        COMMON_CONSTANTS.put("DEFAULT_TOKEN_CHANNEL", 0);
        COMMON_CONSTANTS.put("DEFAULT_MODE", 0);
        COMMON_CONSTANTS.put("SKIP", -3);
        COMMON_CONSTANTS.put("MORE", -2);
        COMMON_CONSTANTS.put("EOF", -1);
        COMMON_CONSTANTS.put("MAX_CHAR_VALUE", 65534);
        COMMON_CONSTANTS.put("MIN_CHAR_VALUE", 0);
    }
}

