// Copyright 2020 Open Source Robotics Foundation, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <pybind11/pybind11.h>

namespace py = pybind11;

#include "rclpy_common/handle.h"

#include "handle_api.hpp"

size_t
rclpy_handle_get_pointer(py::capsule handle_capsule)
{
  void * ptr = rclpy_handle_get_pointer_from_capsule(handle_capsule.ptr(), handle_capsule.name());

  if (!ptr) {
    throw py::error_already_set();
  }

  static_assert(sizeof(size_t) >= sizeof(void *), "Need size_t capable of holding void *");
  return reinterpret_cast<size_t>(ptr);
}

namespace rclpy
{
void
define_handle_api(py::module m)
{
  m.doc() = "rclpy module for working with Handle objects.";
  m.def("rclpy_handle_get_pointer", &rclpy_handle_get_pointer, "Get handle pointer.");
}
}  // namespace rclpy
