# Copyright 2021 Kenji Brameld
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from launch import LaunchDescription
from launch.actions import DeclareLaunchArgument
from launch.substitutions import LaunchConfiguration

from launch_ros.actions import Node


def generate_launch_description():

    return LaunchDescription([
        DeclareLaunchArgument('namespace', default_value=''),
        Node(
            package='soccer_marker_generation',
            executable='ball_to_marker',
            namespace=LaunchConfiguration('namespace')
        ),
        Node(
            package='soccer_marker_generation',
            executable='goalpost_array_to_marker_array',
            namespace=LaunchConfiguration('namespace')
        ),
        Node(
            package='soccer_marker_generation',
            executable='field_line_array_to_marker_array',
            namespace=LaunchConfiguration('namespace')
        ),
        Node(
            package='soccer_marker_generation',
            executable='robot_array_to_marker_array',
            namespace=LaunchConfiguration('namespace')
        ),
        Node(
            package='soccer_marker_generation',
            executable='flag_array_to_marker_array',
            namespace=LaunchConfiguration('namespace')
        ),
    ])
