# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


import sys
import os
if os.name == 'nt' and sys.version_info >= (3, 8):  # we need to explicitly list the folders containing the DLLs
    webots_home = os.path.normpath(os.environ['WEBOTS_HOME'])
    os.add_dll_directory(os.path.join(webots_home, 'lib', 'controller'))
# MSYS2_HOME should be set by Webots or ~/.bash_profile
# if not set, we are in the case of an extern controller and a regularly installed version of Webots
    msys64_root = os.environ['MSYS2_HOME'] if 'MSYS2_HOME' in os.environ else os.path.join(webots_home, 'msys64')
    cpp_folder = os.path.join(msys64_root, 'mingw64', 'bin', 'cpp')
    if not os.path.isdir(cpp_folder):  # development environment
        cpp_folder = os.path.join(msys64_root, 'mingw64', 'bin')
    os.add_dll_directory(cpp_folder)



from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _controller
else:
    import _controller

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



class AnsiCodes(object):
    RESET = u'\u001b[0m'

    BOLD = u'\u001b[1m'
    UNDERLINE = u'\u001b[4m'

    BLACK_BACKGROUND = u'\u001b[40m'
    RED_BACKGROUND = u'\u001b[41m'
    GREEN_BACKGROUND = u'\u001b[42m'
    YELLOW_BACKGROUND = u'\u001b[43m'
    BLUE_BACKGROUND = u'\u001b[44m'
    MAGENTA_BACKGROUND = u'\u001b[45m'
    CYAN_BACKGROUND = u'\u001b[46m'
    WHITE_BACKGROUND = u'\u001b[47m'

    BLACK_FOREGROUND = u'\u001b[30m'
    RED_FOREGROUND = u'\u001b[31m'
    GREEN_FOREGROUND = u'\u001b[32m'
    YELLOW_FOREGROUND = u'\u001b[33m'
    BLUE_FOREGROUND = u'\u001b[34m'
    MAGENTA_FOREGROUND = u'\u001b[35m'
    CYAN_FOREGROUND = u'\u001b[36m'
    WHITE_FOREGROUND = u'\u001b[37m'

    CLEAR_SCREEN = u'\u001b[2J'

class Device(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _controller.delete_Device

    def getName(self):
        return _controller.Device_getName(self)

    def getModel(self):
        return _controller.Device_getModel(self)

    def getNodeType(self):
        return _controller.Device_getNodeType(self)

    def getTag(self):
        return _controller.Device_getTag(self)

    @staticmethod
    def hasType(tag, type):
        return _controller.Device_hasType(tag, type)

# Register Device in _controller:
_controller.Device_swigregister(Device)

def Device_hasType(tag, type):
    return _controller.Device_hasType(tag, type)

class Accelerometer(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Accelerometer_swiginit(self, _controller.new_Accelerometer(name))
    __swig_destroy__ = _controller.delete_Accelerometer

    def enable(self, samplingPeriod):
        return _controller.Accelerometer_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Accelerometer_disable(self)

    def getSamplingPeriod(self):
        return _controller.Accelerometer_getSamplingPeriod(self)

    def getValues(self):
        return _controller.Accelerometer_getValues(self)

    def __internalGetLookupTableSize(self):
        return _controller.Accelerometer___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.Accelerometer_getLookupTable(self)

# Register Accelerometer in _controller:
_controller.Accelerometer_swigregister(Accelerometer)

class Altimeter(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Altimeter_swiginit(self, _controller.new_Altimeter(name))
    __swig_destroy__ = _controller.delete_Altimeter

    def enable(self, samplingPeriod):
        return _controller.Altimeter_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Altimeter_disable(self)

    def getSamplingPeriod(self):
        return _controller.Altimeter_getSamplingPeriod(self)

    def getValue(self):
        return _controller.Altimeter_getValue(self)

# Register Altimeter in _controller:
_controller.Altimeter_swigregister(Altimeter)

class Brake(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ROTATIONAL = _controller.Brake_ROTATIONAL
    LINEAR = _controller.Brake_LINEAR

    def __init__(self, name):
        _controller.Brake_swiginit(self, _controller.new_Brake(name))
    __swig_destroy__ = _controller.delete_Brake

    def getType(self):
        return _controller.Brake_getType(self)

    def setDampingConstant(self, dampingConstant):
        return _controller.Brake_setDampingConstant(self, dampingConstant)

    def getMotor(self):
        return _controller.Brake_getMotor(self)

    def getPositionSensor(self):
        return _controller.Brake_getPositionSensor(self)

    def getMotorTag(self):
        return _controller.Brake_getMotorTag(self)

    def getPositionSensorTag(self):
        return _controller.Brake_getPositionSensorTag(self)
    ANGULAR = _controller.Brake_ANGULAR

    def getMotor(self):
        try:
            return self.__motor
        except AttributeError:
            self.__motor = Robot.internalGetDeviceFromTag(self.getMotorTag())
            return self.__motor
    def getPositionSensor(self):
        try:
            return self.__positionSensor
        except AttributeError:
            self.__positionSensor = Robot.internalGetDeviceFromTag(self.getPositionSensorTag())
            return self.__positionSensor


# Register Brake in _controller:
_controller.Brake_swigregister(Brake)

class CameraRecognitionObject(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    id = property(_controller.CameraRecognitionObject_id_get, _controller.CameraRecognitionObject_id_set)
    position = property(_controller.CameraRecognitionObject_position_get, _controller.CameraRecognitionObject_position_set)
    orientation = property(_controller.CameraRecognitionObject_orientation_get, _controller.CameraRecognitionObject_orientation_set)
    size = property(_controller.CameraRecognitionObject_size_get, _controller.CameraRecognitionObject_size_set)
    position_on_image = property(_controller.CameraRecognitionObject_position_on_image_get, _controller.CameraRecognitionObject_position_on_image_set)
    size_on_image = property(_controller.CameraRecognitionObject_size_on_image_get, _controller.CameraRecognitionObject_size_on_image_set)
    number_of_colors = property(_controller.CameraRecognitionObject_number_of_colors_get, _controller.CameraRecognitionObject_number_of_colors_set)
    colors = property(_controller.CameraRecognitionObject_colors_get, _controller.CameraRecognitionObject_colors_set)
    model = property(_controller.CameraRecognitionObject_model_get, _controller.CameraRecognitionObject_model_set)

    def getPosition(self):
        return _controller.CameraRecognitionObject_getPosition(self)

    def getOrientation(self):
        return _controller.CameraRecognitionObject_getOrientation(self)

    def getSize(self):
        return _controller.CameraRecognitionObject_getSize(self)

    def getPositionOnImage(self):
        return _controller.CameraRecognitionObject_getPositionOnImage(self)

    def getSizeOnImage(self):
        return _controller.CameraRecognitionObject_getSizeOnImage(self)

    def getColors(self):
        return _controller.CameraRecognitionObject_getColors(self)

    def getId(self):
        return _controller.CameraRecognitionObject_getId(self)

    def getNumberOfColors(self):
        return _controller.CameraRecognitionObject_getNumberOfColors(self)

    def getModel(self):
        return _controller.CameraRecognitionObject_getModel(self)

    def __init__(self):
        _controller.CameraRecognitionObject_swiginit(self, _controller.new_CameraRecognitionObject())
    __swig_destroy__ = _controller.delete_CameraRecognitionObject

# Register CameraRecognitionObject in _controller:
_controller.CameraRecognitionObject_swigregister(CameraRecognitionObject)

class Camera(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Camera_swiginit(self, _controller.new_Camera(name))
    __swig_destroy__ = _controller.delete_Camera

    def enable(self, samplingPeriod):
        return _controller.Camera_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Camera_disable(self)

    def getSamplingPeriod(self):
        return _controller.Camera_getSamplingPeriod(self)

    def getImage(self):
        return _controller.Camera_getImage(self)

    def getWidth(self):
        return _controller.Camera_getWidth(self)

    def getHeight(self):
        return _controller.Camera_getHeight(self)

    def getFov(self):
        return _controller.Camera_getFov(self)

    def getMaxFov(self):
        return _controller.Camera_getMaxFov(self)

    def getMinFov(self):
        return _controller.Camera_getMinFov(self)

    def setFov(self, fov):
        return _controller.Camera_setFov(self, fov)

    def getExposure(self):
        return _controller.Camera_getExposure(self)

    def setExposure(self, exposure):
        return _controller.Camera_setExposure(self, exposure)

    def getFocalLength(self):
        return _controller.Camera_getFocalLength(self)

    def getFocalDistance(self):
        return _controller.Camera_getFocalDistance(self)

    def getMaxFocalDistance(self):
        return _controller.Camera_getMaxFocalDistance(self)

    def getMinFocalDistance(self):
        return _controller.Camera_getMinFocalDistance(self)

    def setFocalDistance(self, focalDistance):
        return _controller.Camera_setFocalDistance(self, focalDistance)

    def getNear(self):
        return _controller.Camera_getNear(self)

    def saveImage(self, filename, quality):
        return _controller.Camera_saveImage(self, filename, quality)

    def hasRecognition(self):
        return _controller.Camera_hasRecognition(self)

    def recognitionEnable(self, samplingPeriod):
        return _controller.Camera_recognitionEnable(self, samplingPeriod)

    def recognitionDisable(self):
        return _controller.Camera_recognitionDisable(self)

    def getRecognitionSamplingPeriod(self):
        return _controller.Camera_getRecognitionSamplingPeriod(self)

    def getRecognitionNumberOfObjects(self):
        return _controller.Camera_getRecognitionNumberOfObjects(self)

    def getRecognitionObjects(self):
        return _controller.Camera_getRecognitionObjects(self)

    def hasRecognitionSegmentation(self):
        return _controller.Camera_hasRecognitionSegmentation(self)

    def enableRecognitionSegmentation(self):
        return _controller.Camera_enableRecognitionSegmentation(self)

    def disableRecognitionSegmentation(self):
        return _controller.Camera_disableRecognitionSegmentation(self)

    def isRecognitionSegmentationEnabled(self):
        return _controller.Camera_isRecognitionSegmentationEnabled(self)

    def getRecognitionSegmentationImage(self):
        return _controller.Camera_getRecognitionSegmentationImage(self)

    def saveRecognitionSegmentationImage(self, filename, quality):
        return _controller.Camera_saveRecognitionSegmentationImage(self, filename, quality)

    def getImageArray(self):
        return _controller.Camera_getImageArray(self)

    @staticmethod
    def imageGetRed(*args):
        return _controller.Camera_imageGetRed(*args)

    @staticmethod
    def imageGetGreen(*args):
        return _controller.Camera_imageGetGreen(*args)

    @staticmethod
    def imageGetBlue(*args):
        return _controller.Camera_imageGetBlue(*args)

    @staticmethod
    def imageGetGray(*args):
        return _controller.Camera_imageGetGray(*args)

    @staticmethod
    def imageGetGrey(*args):
        return _controller.Camera_imageGetGrey(*args)

    def getRecognitionObject(self, index):
        return _controller.Camera_getRecognitionObject(self, index)

    def getRecognitionObjects(self):
       ret = []
       for i in range(self.getRecognitionNumberOfObjects()):
         ret.append(self.getRecognitionObject(i))
       return ret


    def getRecognitionSegmentationImageArray(self):
        return _controller.Camera_getRecognitionSegmentationImageArray(self)

# Register Camera in _controller:
_controller.Camera_swigregister(Camera)

def Camera_imageGetRed(*args):
    return _controller.Camera_imageGetRed(*args)

def Camera_imageGetGreen(*args):
    return _controller.Camera_imageGetGreen(*args)

def Camera_imageGetBlue(*args):
    return _controller.Camera_imageGetBlue(*args)

def Camera_imageGetGray(*args):
    return _controller.Camera_imageGetGray(*args)

def Camera_imageGetGrey(*args):
    return _controller.Camera_imageGetGrey(*args)

class Compass(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Compass_swiginit(self, _controller.new_Compass(name))
    __swig_destroy__ = _controller.delete_Compass

    def enable(self, samplingPeriod):
        return _controller.Compass_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Compass_disable(self)

    def getSamplingPeriod(self):
        return _controller.Compass_getSamplingPeriod(self)

    def getValues(self):
        return _controller.Compass_getValues(self)

    def __internalGetLookupTableSize(self):
        return _controller.Compass___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.Compass_getLookupTable(self)

# Register Compass in _controller:
_controller.Compass_swigregister(Compass)

class Connector(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Connector_swiginit(self, _controller.new_Connector(name))
    __swig_destroy__ = _controller.delete_Connector

    def enablePresence(self, samplingPeriod):
        return _controller.Connector_enablePresence(self, samplingPeriod)

    def disablePresence(self):
        return _controller.Connector_disablePresence(self)

    def getPresenceSamplingPeriod(self):
        return _controller.Connector_getPresenceSamplingPeriod(self)

    def getPresence(self):
        return _controller.Connector_getPresence(self)

    def isLocked(self):
        return _controller.Connector_isLocked(self)

    def lock(self):
        return _controller.Connector_lock(self)

    def unlock(self):
        return _controller.Connector_unlock(self)

# Register Connector in _controller:
_controller.Connector_swigregister(Connector)

class ImageRef(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, imageRef):
        _controller.ImageRef_swiginit(self, _controller.new_ImageRef(imageRef))
    __swig_destroy__ = _controller.delete_ImageRef

    def getImageRef(self):
        return _controller.ImageRef_getImageRef(self)

# Register ImageRef in _controller:
_controller.ImageRef_swigregister(ImageRef)

class Display(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    RGB = _controller.Display_RGB
    RGBA = _controller.Display_RGBA
    ARGB = _controller.Display_ARGB
    BGRA = _controller.Display_BGRA
    ABGR = _controller.Display_ABGR

    def __init__(self, name):
        _controller.Display_swiginit(self, _controller.new_Display(name))
    __swig_destroy__ = _controller.delete_Display

    def getWidth(self):
        return _controller.Display_getWidth(self)

    def getHeight(self):
        return _controller.Display_getHeight(self)

    def setColor(self, color):
        return _controller.Display_setColor(self, color)

    def setAlpha(self, alpha):
        return _controller.Display_setAlpha(self, alpha)

    def setOpacity(self, opacity):
        return _controller.Display_setOpacity(self, opacity)

    def setFont(self, font, size, antiAliasing):
        return _controller.Display_setFont(self, font, size, antiAliasing)

    def attachCamera(self, camera):
        return _controller.Display_attachCamera(self, camera)

    def detachCamera(self):
        return _controller.Display_detachCamera(self)

    def drawPixel(self, x1, y1):
        return _controller.Display_drawPixel(self, x1, y1)

    def drawLine(self, x1, y1, x2, y2):
        return _controller.Display_drawLine(self, x1, y1, x2, y2)

    def drawRectangle(self, x, y, width, height):
        return _controller.Display_drawRectangle(self, x, y, width, height)

    def drawOval(self, cx, cy, a, b):
        return _controller.Display_drawOval(self, cx, cy, a, b)

    def __internalDrawPolygon(self, x, y, size):
        return _controller.Display___internalDrawPolygon(self, x, y, size)

    def drawText(self, txt, x, y):
        return _controller.Display_drawText(self, txt, x, y)

    def fillRectangle(self, x, y, width, height):
        return _controller.Display_fillRectangle(self, x, y, width, height)

    def fillOval(self, cx, cy, a, b):
        return _controller.Display_fillOval(self, cx, cy, a, b)

    def __internalFillPolygon(self, x, y, size):
        return _controller.Display___internalFillPolygon(self, x, y, size)

    def __internalImageNew(self, width, height, data, format):
        return _controller.Display___internalImageNew(self, width, height, data, format)

    def imageCopy(self, x, y, width, height):
        return _controller.Display_imageCopy(self, x, y, width, height)

    def imagePaste(self, ir, x, y, blend=False):
        return _controller.Display_imagePaste(self, ir, x, y, blend)

    def imageLoad(self, filename):
        return _controller.Display_imageLoad(self, filename)

    def imageSave(self, ir, filename):
        return _controller.Display_imageSave(self, ir, filename)

    def imageDelete(self, ir):
        return _controller.Display_imageDelete(self, ir)

    def imageNew(self, data, format, width=None, height=None):
      if isinstance(data, list):
        return self.__internalImageNew(len(data), len(data[0]), data, format)
      elif width is None or height is None:
        raise TypeError('imageNew : width and height must be given if data is not a list')
      else:
        return self.__internalImageNew(width, height, data, format)
    def drawPolygon(self, x, y):
      self.__internalDrawPolygon(x, y, min(len(x), len(y)))
    def fillPolygon(self, x, y):
      self.__internalFillPolygon(x, y, min(len(x), len(y)))


# Register Display in _controller:
_controller.Display_swigregister(Display)

class DistanceSensor(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    GENERIC = _controller.DistanceSensor_GENERIC
    INFRA_RED = _controller.DistanceSensor_INFRA_RED
    SONAR = _controller.DistanceSensor_SONAR
    LASER = _controller.DistanceSensor_LASER

    def __init__(self, name):
        _controller.DistanceSensor_swiginit(self, _controller.new_DistanceSensor(name))
    __swig_destroy__ = _controller.delete_DistanceSensor

    def enable(self, samplingPeriod):
        return _controller.DistanceSensor_enable(self, samplingPeriod)

    def disable(self):
        return _controller.DistanceSensor_disable(self)

    def getSamplingPeriod(self):
        return _controller.DistanceSensor_getSamplingPeriod(self)

    def getValue(self):
        return _controller.DistanceSensor_getValue(self)

    def getMaxValue(self):
        return _controller.DistanceSensor_getMaxValue(self)

    def getMinValue(self):
        return _controller.DistanceSensor_getMinValue(self)

    def getAperture(self):
        return _controller.DistanceSensor_getAperture(self)

    def __internalGetLookupTableSize(self):
        return _controller.DistanceSensor___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.DistanceSensor_getLookupTable(self)

    def getType(self):
        return _controller.DistanceSensor_getType(self)

# Register DistanceSensor in _controller:
_controller.DistanceSensor_swigregister(DistanceSensor)

class Emitter(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Emitter_swiginit(self, _controller.new_Emitter(name))
    __swig_destroy__ = _controller.delete_Emitter
    CHANNEL_BROADCAST = _controller.Emitter_CHANNEL_BROADCAST

    def send(self, data):
        return _controller.Emitter_send(self, data)

    def getBufferSize(self):
        return _controller.Emitter_getBufferSize(self)

    def setChannel(self, channel):
        return _controller.Emitter_setChannel(self, channel)

    def getChannel(self):
        return _controller.Emitter_getChannel(self)

    def getRange(self):
        return _controller.Emitter_getRange(self)

    def setRange(self, range):
        return _controller.Emitter_setRange(self, range)

# Register Emitter in _controller:
_controller.Emitter_swigregister(Emitter)

class Field(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    NO_FIELD = _controller.Field_NO_FIELD
    SF_BOOL = _controller.Field_SF_BOOL
    SF_INT32 = _controller.Field_SF_INT32
    SF_FLOAT = _controller.Field_SF_FLOAT
    SF_VEC2F = _controller.Field_SF_VEC2F
    SF_VEC3F = _controller.Field_SF_VEC3F
    SF_ROTATION = _controller.Field_SF_ROTATION
    SF_COLOR = _controller.Field_SF_COLOR
    SF_STRING = _controller.Field_SF_STRING
    SF_NODE = _controller.Field_SF_NODE
    MF = _controller.Field_MF
    MF_BOOL = _controller.Field_MF_BOOL
    MF_INT32 = _controller.Field_MF_INT32
    MF_FLOAT = _controller.Field_MF_FLOAT
    MF_VEC2F = _controller.Field_MF_VEC2F
    MF_VEC3F = _controller.Field_MF_VEC3F
    MF_ROTATION = _controller.Field_MF_ROTATION
    MF_COLOR = _controller.Field_MF_COLOR
    MF_STRING = _controller.Field_MF_STRING
    MF_NODE = _controller.Field_MF_NODE

    def getName(self):
        return _controller.Field_getName(self)

    def getType(self):
        return _controller.Field_getType(self)

    def getTypeName(self):
        return _controller.Field_getTypeName(self)

    def getCount(self):
        return _controller.Field_getCount(self)

    def enableSFTracking(self, samplingPeriod):
        return _controller.Field_enableSFTracking(self, samplingPeriod)

    def disableSFTracking(self):
        return _controller.Field_disableSFTracking(self)

    def getSFBool(self):
        return _controller.Field_getSFBool(self)

    def getSFInt32(self):
        return _controller.Field_getSFInt32(self)

    def getSFFloat(self):
        return _controller.Field_getSFFloat(self)

    def getSFVec2f(self):
        return _controller.Field_getSFVec2f(self)

    def getSFVec3f(self):
        return _controller.Field_getSFVec3f(self)

    def getSFRotation(self):
        return _controller.Field_getSFRotation(self)

    def getSFColor(self):
        return _controller.Field_getSFColor(self)

    def getSFString(self):
        return _controller.Field_getSFString(self)

    def getSFNode(self):
        return _controller.Field_getSFNode(self)

    def getMFBool(self, index):
        return _controller.Field_getMFBool(self, index)

    def getMFInt32(self, index):
        return _controller.Field_getMFInt32(self, index)

    def getMFFloat(self, index):
        return _controller.Field_getMFFloat(self, index)

    def getMFVec2f(self, index):
        return _controller.Field_getMFVec2f(self, index)

    def getMFVec3f(self, index):
        return _controller.Field_getMFVec3f(self, index)

    def getMFRotation(self, index):
        return _controller.Field_getMFRotation(self, index)

    def getMFColor(self, index):
        return _controller.Field_getMFColor(self, index)

    def getMFString(self, index):
        return _controller.Field_getMFString(self, index)

    def getMFNode(self, index):
        return _controller.Field_getMFNode(self, index)

    def setSFBool(self, value):
        return _controller.Field_setSFBool(self, value)

    def setSFInt32(self, value):
        return _controller.Field_setSFInt32(self, value)

    def setSFFloat(self, value):
        return _controller.Field_setSFFloat(self, value)

    def setSFVec2f(self, values):
        return _controller.Field_setSFVec2f(self, values)

    def setSFVec3f(self, values):
        return _controller.Field_setSFVec3f(self, values)

    def setSFRotation(self, values):
        return _controller.Field_setSFRotation(self, values)

    def setSFColor(self, values):
        return _controller.Field_setSFColor(self, values)

    def setSFString(self, value):
        return _controller.Field_setSFString(self, value)

    def setMFBool(self, index, value):
        return _controller.Field_setMFBool(self, index, value)

    def setMFInt32(self, index, value):
        return _controller.Field_setMFInt32(self, index, value)

    def setMFFloat(self, index, value):
        return _controller.Field_setMFFloat(self, index, value)

    def setMFVec2f(self, index, values):
        return _controller.Field_setMFVec2f(self, index, values)

    def setMFVec3f(self, index, values):
        return _controller.Field_setMFVec3f(self, index, values)

    def setMFRotation(self, index, values):
        return _controller.Field_setMFRotation(self, index, values)

    def setMFColor(self, index, values):
        return _controller.Field_setMFColor(self, index, values)

    def setMFString(self, index, value):
        return _controller.Field_setMFString(self, index, value)

    def insertMFBool(self, index, value):
        return _controller.Field_insertMFBool(self, index, value)

    def insertMFInt32(self, index, value):
        return _controller.Field_insertMFInt32(self, index, value)

    def insertMFFloat(self, index, value):
        return _controller.Field_insertMFFloat(self, index, value)

    def insertMFVec2f(self, index, values):
        return _controller.Field_insertMFVec2f(self, index, values)

    def insertMFVec3f(self, index, values):
        return _controller.Field_insertMFVec3f(self, index, values)

    def insertMFRotation(self, index, values):
        return _controller.Field_insertMFRotation(self, index, values)

    def insertMFColor(self, index, values):
        return _controller.Field_insertMFColor(self, index, values)

    def insertMFString(self, index, value):
        return _controller.Field_insertMFString(self, index, value)

    def removeMF(self, index):
        return _controller.Field_removeMF(self, index)

    def removeSF(self):
        return _controller.Field_removeSF(self)

    def importMFNodeFromString(self, position, nodeString):
        return _controller.Field_importMFNodeFromString(self, position, nodeString)

    def importSFNodeFromString(self, nodeString):
        return _controller.Field_importSFNodeFromString(self, nodeString)

# Register Field in _controller:
_controller.Field_swigregister(Field)

class GPS(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    LOCAL = _controller.GPS_LOCAL
    WGS84 = _controller.GPS_WGS84

    def __init__(self, name):
        _controller.GPS_swiginit(self, _controller.new_GPS(name))
    __swig_destroy__ = _controller.delete_GPS

    def enable(self, samplingPeriod):
        return _controller.GPS_enable(self, samplingPeriod)

    def disable(self):
        return _controller.GPS_disable(self)

    def getSamplingPeriod(self):
        return _controller.GPS_getSamplingPeriod(self)

    def getValues(self):
        return _controller.GPS_getValues(self)

    def getSpeed(self):
        return _controller.GPS_getSpeed(self)

    def getSpeedVector(self):
        return _controller.GPS_getSpeedVector(self)

    def getCoordinateSystem(self):
        return _controller.GPS_getCoordinateSystem(self)

    @staticmethod
    def convertToDegreesMinutesSeconds(decimalDegree):
        return _controller.GPS_convertToDegreesMinutesSeconds(decimalDegree)

# Register GPS in _controller:
_controller.GPS_swigregister(GPS)

def GPS_convertToDegreesMinutesSeconds(decimalDegree):
    return _controller.GPS_convertToDegreesMinutesSeconds(decimalDegree)

class Gyro(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Gyro_swiginit(self, _controller.new_Gyro(name))
    __swig_destroy__ = _controller.delete_Gyro

    def enable(self, samplingPeriod):
        return _controller.Gyro_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Gyro_disable(self)

    def getSamplingPeriod(self):
        return _controller.Gyro_getSamplingPeriod(self)

    def getValues(self):
        return _controller.Gyro_getValues(self)

    def __internalGetLookupTableSize(self):
        return _controller.Gyro___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.Gyro_getLookupTable(self)

# Register Gyro in _controller:
_controller.Gyro_swigregister(Gyro)

class InertialUnit(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.InertialUnit_swiginit(self, _controller.new_InertialUnit(name))
    __swig_destroy__ = _controller.delete_InertialUnit

    def enable(self, samplingPeriod):
        return _controller.InertialUnit_enable(self, samplingPeriod)

    def disable(self):
        return _controller.InertialUnit_disable(self)

    def getSamplingPeriod(self):
        return _controller.InertialUnit_getSamplingPeriod(self)

    def getRollPitchYaw(self):
        return _controller.InertialUnit_getRollPitchYaw(self)

    def getQuaternion(self):
        return _controller.InertialUnit_getQuaternion(self)

    def getNoise(self):
        return _controller.InertialUnit_getNoise(self)

# Register InertialUnit in _controller:
_controller.InertialUnit_swigregister(InertialUnit)

class Joystick(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _controller.Joystick_swiginit(self, _controller.new_Joystick())
    __swig_destroy__ = _controller.delete_Joystick

    def enable(self, samplingPeriod):
        return _controller.Joystick_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Joystick_disable(self)

    def getSamplingPeriod(self):
        return _controller.Joystick_getSamplingPeriod(self)

    def isConnected(self):
        return _controller.Joystick_isConnected(self)

    def getModel(self):
        return _controller.Joystick_getModel(self)

    def getNumberOfAxes(self):
        return _controller.Joystick_getNumberOfAxes(self)

    def getAxisValue(self, axis):
        return _controller.Joystick_getAxisValue(self, axis)

    def getNumberOfPovs(self):
        return _controller.Joystick_getNumberOfPovs(self)

    def getPovValue(self, pov):
        return _controller.Joystick_getPovValue(self, pov)

    def getPressedButton(self):
        return _controller.Joystick_getPressedButton(self)

    def setConstantForce(self, level):
        return _controller.Joystick_setConstantForce(self, level)

    def setConstantForceDuration(self, duration):
        return _controller.Joystick_setConstantForceDuration(self, duration)

    def setAutoCenteringGain(self, gain):
        return _controller.Joystick_setAutoCenteringGain(self, gain)

    def setResistanceGain(self, gain):
        return _controller.Joystick_setResistanceGain(self, gain)

    def setForceAxis(self, axis):
        return _controller.Joystick_setForceAxis(self, axis)

# Register Joystick in _controller:
_controller.Joystick_swigregister(Joystick)

class Keyboard(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    END = _controller.Keyboard_END
    HOME = _controller.Keyboard_HOME
    LEFT = _controller.Keyboard_LEFT
    UP = _controller.Keyboard_UP
    RIGHT = _controller.Keyboard_RIGHT
    DOWN = _controller.Keyboard_DOWN
    PAGEUP = _controller.Keyboard_PAGEUP
    PAGEDOWN = _controller.Keyboard_PAGEDOWN
    NUMPAD_HOME = _controller.Keyboard_NUMPAD_HOME
    NUMPAD_LEFT = _controller.Keyboard_NUMPAD_LEFT
    NUMPAD_UP = _controller.Keyboard_NUMPAD_UP
    NUMPAD_RIGHT = _controller.Keyboard_NUMPAD_RIGHT
    NUMPAD_DOWN = _controller.Keyboard_NUMPAD_DOWN
    NUMPAD_END = _controller.Keyboard_NUMPAD_END
    KEY = _controller.Keyboard_KEY
    SHIFT = _controller.Keyboard_SHIFT
    CONTROL = _controller.Keyboard_CONTROL
    ALT = _controller.Keyboard_ALT

    def __init__(self):
        _controller.Keyboard_swiginit(self, _controller.new_Keyboard())
    __swig_destroy__ = _controller.delete_Keyboard

    def enable(self, samplingPeriod):
        return _controller.Keyboard_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Keyboard_disable(self)

    def getSamplingPeriod(self):
        return _controller.Keyboard_getSamplingPeriod(self)

    def getKey(self):
        return _controller.Keyboard_getKey(self)

# Register Keyboard in _controller:
_controller.Keyboard_swigregister(Keyboard)

class LED(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.LED_swiginit(self, _controller.new_LED(name))
    __swig_destroy__ = _controller.delete_LED

    def set(self, value):
        return _controller.LED_set(self, value)

    def get(self):
        return _controller.LED_get(self)

# Register LED in _controller:
_controller.LED_swigregister(LED)

class LidarPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_controller.LidarPoint_x_get, _controller.LidarPoint_x_set)
    y = property(_controller.LidarPoint_y_get, _controller.LidarPoint_y_set)
    z = property(_controller.LidarPoint_z_get, _controller.LidarPoint_z_set)
    layer_id = property(_controller.LidarPoint_layer_id_get, _controller.LidarPoint_layer_id_set)
    time = property(_controller.LidarPoint_time_get, _controller.LidarPoint_time_set)

    def __init__(self):
        _controller.LidarPoint_swiginit(self, _controller.new_LidarPoint())
    __swig_destroy__ = _controller.delete_LidarPoint

# Register LidarPoint in _controller:
_controller.LidarPoint_swigregister(LidarPoint)

class Lidar(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Lidar_swiginit(self, _controller.new_Lidar(name))
    __swig_destroy__ = _controller.delete_Lidar

    def enable(self, samplingPeriod):
        return _controller.Lidar_enable(self, samplingPeriod)

    def enablePointCloud(self):
        return _controller.Lidar_enablePointCloud(self)

    def disable(self):
        return _controller.Lidar_disable(self)

    def disablePointCloud(self):
        return _controller.Lidar_disablePointCloud(self)

    def getSamplingPeriod(self):
        return _controller.Lidar_getSamplingPeriod(self)

    def isPointCloudEnabled(self):
        return _controller.Lidar_isPointCloudEnabled(self)

    def getRangeImage(self):
        return _controller.Lidar_getRangeImage(self)

    def getLayerRangeImage(self, layer):
        return _controller.Lidar_getLayerRangeImage(self, layer)

    def getPointCloud(self):
        return _controller.Lidar_getPointCloud(self)

    def getLayerPointCloud(self, layer):
        return _controller.Lidar_getLayerPointCloud(self, layer)

    def getNumberOfPoints(self):
        return _controller.Lidar_getNumberOfPoints(self)

    def getHorizontalResolution(self):
        return _controller.Lidar_getHorizontalResolution(self)

    def getNumberOfLayers(self):
        return _controller.Lidar_getNumberOfLayers(self)

    def getMinFrequency(self):
        return _controller.Lidar_getMinFrequency(self)

    def getMaxFrequency(self):
        return _controller.Lidar_getMaxFrequency(self)

    def getFrequency(self):
        return _controller.Lidar_getFrequency(self)

    def setFrequency(self, frequency):
        return _controller.Lidar_setFrequency(self, frequency)

    def getFov(self):
        return _controller.Lidar_getFov(self)

    def getVerticalFov(self):
        return _controller.Lidar_getVerticalFov(self)

    def getMinRange(self):
        return _controller.Lidar_getMinRange(self)

    def getMaxRange(self):
        return _controller.Lidar_getMaxRange(self)

    def __getPointCloudBuffer(self, layer):
        return _controller.Lidar___getPointCloudBuffer(self, layer)

    def __getPointCloudList(self, layer):
        return _controller.Lidar___getPointCloudList(self, layer)

    import sys

    def getPointCloud(self, data_type='list'):
      if data_type == 'list':
        return self.__getPointCloudList(-1)
      elif data_type == 'buffer':
        return self.__getPointCloudBuffer(-1)
      else:
        sys.stderr.write("Error: `data_type` cannot be `{}`! Supported values are 'list' and 'buffer'.\n".format(data_type))
        return None

    def getLayerPointCloud(self, layer, data_type='list'):
       if data_type == 'list':
         return self.__getPointCloudList(layer)
       elif data_type == 'buffer':
         return self.__getPointCloudBuffer(layer)
       else:
         sys.stderr.write("Error: `data_type` cannot be `{}`! Supported values are 'list' and 'buffer'.\n".format(data_type))
         return None


    def getRangeImageArray(self):
        return _controller.Lidar_getRangeImageArray(self)

# Register Lidar in _controller:
_controller.Lidar_swigregister(Lidar)

class LightSensor(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.LightSensor_swiginit(self, _controller.new_LightSensor(name))
    __swig_destroy__ = _controller.delete_LightSensor

    def enable(self, samplingPeriod):
        return _controller.LightSensor_enable(self, samplingPeriod)

    def disable(self):
        return _controller.LightSensor_disable(self)

    def getSamplingPeriod(self):
        return _controller.LightSensor_getSamplingPeriod(self)

    def getValue(self):
        return _controller.LightSensor_getValue(self)

    def __internalGetLookupTableSize(self):
        return _controller.LightSensor___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.LightSensor_getLookupTable(self)

# Register LightSensor in _controller:
_controller.LightSensor_swigregister(LightSensor)

class Motion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, fileName):
        _controller.Motion_swiginit(self, _controller.new_Motion(fileName))

    def isValid(self):
        return _controller.Motion_isValid(self)
    __swig_destroy__ = _controller.delete_Motion

    def play(self):
        return _controller.Motion_play(self)

    def stop(self):
        return _controller.Motion_stop(self)

    def getDuration(self):
        return _controller.Motion_getDuration(self)

    def getTime(self):
        return _controller.Motion_getTime(self)

    def setTime(self, time):
        return _controller.Motion_setTime(self, time)

    def setReverse(self, reverse):
        return _controller.Motion_setReverse(self, reverse)

    def setLoop(self, loop):
        return _controller.Motion_setLoop(self, loop)

    def isOver(self):
        return _controller.Motion_isOver(self)

# Register Motion in _controller:
_controller.Motion_swigregister(Motion)

class Motor(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ROTATIONAL = _controller.Motor_ROTATIONAL
    LINEAR = _controller.Motor_LINEAR

    def __init__(self, name):
        _controller.Motor_swiginit(self, _controller.new_Motor(name))
    __swig_destroy__ = _controller.delete_Motor

    def setPosition(self, position):
        return _controller.Motor_setPosition(self, position)

    def setVelocity(self, vel):
        return _controller.Motor_setVelocity(self, vel)

    def setAcceleration(self, acceleration):
        return _controller.Motor_setAcceleration(self, acceleration)

    def setAvailableForce(self, availableForce):
        return _controller.Motor_setAvailableForce(self, availableForce)

    def setAvailableTorque(self, availableTorque):
        return _controller.Motor_setAvailableTorque(self, availableTorque)

    def setControlPID(self, p, i, d):
        return _controller.Motor_setControlPID(self, p, i, d)

    def getTargetPosition(self):
        return _controller.Motor_getTargetPosition(self)

    def getMinPosition(self):
        return _controller.Motor_getMinPosition(self)

    def getMaxPosition(self):
        return _controller.Motor_getMaxPosition(self)

    def getVelocity(self):
        return _controller.Motor_getVelocity(self)

    def getMaxVelocity(self):
        return _controller.Motor_getMaxVelocity(self)

    def getAcceleration(self):
        return _controller.Motor_getAcceleration(self)

    def getAvailableForce(self):
        return _controller.Motor_getAvailableForce(self)

    def getMaxForce(self):
        return _controller.Motor_getMaxForce(self)

    def getAvailableTorque(self):
        return _controller.Motor_getAvailableTorque(self)

    def getMaxTorque(self):
        return _controller.Motor_getMaxTorque(self)

    def getMultiplier(self):
        return _controller.Motor_getMultiplier(self)

    def enableForceFeedback(self, samplingPeriod):
        return _controller.Motor_enableForceFeedback(self, samplingPeriod)

    def disableForceFeedback(self):
        return _controller.Motor_disableForceFeedback(self)

    def getForceFeedbackSamplingPeriod(self):
        return _controller.Motor_getForceFeedbackSamplingPeriod(self)

    def getForceFeedback(self):
        return _controller.Motor_getForceFeedback(self)

    def enableTorqueFeedback(self, samplingPeriod):
        return _controller.Motor_enableTorqueFeedback(self, samplingPeriod)

    def disableTorqueFeedback(self):
        return _controller.Motor_disableTorqueFeedback(self)

    def getTorqueFeedbackSamplingPeriod(self):
        return _controller.Motor_getTorqueFeedbackSamplingPeriod(self)

    def getTorqueFeedback(self):
        return _controller.Motor_getTorqueFeedback(self)

    def setForce(self, force):
        return _controller.Motor_setForce(self, force)

    def setTorque(self, torque):
        return _controller.Motor_setTorque(self, torque)

    def getType(self):
        return _controller.Motor_getType(self)

    def getBrake(self):
        return _controller.Motor_getBrake(self)

    def getPositionSensor(self):
        return _controller.Motor_getPositionSensor(self)

    def getBrakeTag(self):
        return _controller.Motor_getBrakeTag(self)

    def getPositionSensorTag(self):
        return _controller.Motor_getPositionSensorTag(self)

    def getBrake(self):
        try:
            return self.__brake
        except AttributeError:
            self.__brake = Robot.internalGetDeviceFromTag(self.getBrakeTag())
            return self.__brake
    def getPositionSensor(self):
        try:
            return self.__positionSensor
        except AttributeError:
            self.__positionSensor = Robot.internalGetDeviceFromTag(self.getPositionSensorTag())
            return self.__positionSensor


# Register Motor in _controller:
_controller.Motor_swigregister(Motor)

class MouseState(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    left = property(_controller.MouseState_left_get, _controller.MouseState_left_set)
    middle = property(_controller.MouseState_middle_get, _controller.MouseState_middle_set)
    right = property(_controller.MouseState_right_get, _controller.MouseState_right_set)
    u = property(_controller.MouseState_u_get, _controller.MouseState_u_set)
    v = property(_controller.MouseState_v_get, _controller.MouseState_v_set)
    x = property(_controller.MouseState_x_get, _controller.MouseState_x_set)
    y = property(_controller.MouseState_y_get, _controller.MouseState_y_set)
    z = property(_controller.MouseState_z_get, _controller.MouseState_z_set)

    def __init__(self):
        _controller.MouseState_swiginit(self, _controller.new_MouseState())
    __swig_destroy__ = _controller.delete_MouseState

# Register MouseState in _controller:
_controller.MouseState_swigregister(MouseState)

class Mouse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _controller.Mouse_swiginit(self, _controller.new_Mouse())
    __swig_destroy__ = _controller.delete_Mouse

    def enable(self, samplingPeriod):
        return _controller.Mouse_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Mouse_disable(self)

    def getSamplingPeriod(self):
        return _controller.Mouse_getSamplingPeriod(self)

    def enable3dPosition(self):
        return _controller.Mouse_enable3dPosition(self)

    def disable3dPosition(self):
        return _controller.Mouse_disable3dPosition(self)

    def is3dPositionEnabled(self):
        return _controller.Mouse_is3dPositionEnabled(self)

    def getState(self):
        return _controller.Mouse_getState(self)

# Register Mouse in _controller:
_controller.Mouse_swigregister(Mouse)

class ContactPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    point = property(_controller.ContactPoint_point_get, _controller.ContactPoint_point_set)
    node_id = property(_controller.ContactPoint_node_id_get, _controller.ContactPoint_node_id_set)

    def getPoint(self):
        return _controller.ContactPoint_getPoint(self)

    def getNodeId(self):
        return _controller.ContactPoint_getNodeId(self)

    @property
    def point(self):
        return self.getPoint()


    def __init__(self):
        _controller.ContactPoint_swiginit(self, _controller.new_ContactPoint())
    __swig_destroy__ = _controller.delete_ContactPoint

# Register ContactPoint in _controller:
_controller.ContactPoint_swigregister(ContactPoint)

class Node(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    NO_NODE = _controller.Node_NO_NODE
    APPEARANCE = _controller.Node_APPEARANCE
    BACKGROUND = _controller.Node_BACKGROUND
    BILLBOARD = _controller.Node_BILLBOARD
    BOX = _controller.Node_BOX
    CAD_SHAPE = _controller.Node_CAD_SHAPE
    CAPSULE = _controller.Node_CAPSULE
    COLOR = _controller.Node_COLOR
    CONE = _controller.Node_CONE
    COORDINATE = _controller.Node_COORDINATE
    CYLINDER = _controller.Node_CYLINDER
    DIRECTIONAL_LIGHT = _controller.Node_DIRECTIONAL_LIGHT
    ELEVATION_GRID = _controller.Node_ELEVATION_GRID
    FOG = _controller.Node_FOG
    GROUP = _controller.Node_GROUP
    IMAGE_TEXTURE = _controller.Node_IMAGE_TEXTURE
    INDEXED_FACE_SET = _controller.Node_INDEXED_FACE_SET
    INDEXED_LINE_SET = _controller.Node_INDEXED_LINE_SET
    MATERIAL = _controller.Node_MATERIAL
    MESH = _controller.Node_MESH
    MUSCLE = _controller.Node_MUSCLE
    NORMAL = _controller.Node_NORMAL
    PBR_APPEARANCE = _controller.Node_PBR_APPEARANCE
    PLANE = _controller.Node_PLANE
    POINT_LIGHT = _controller.Node_POINT_LIGHT
    POINT_SET = _controller.Node_POINT_SET
    SHAPE = _controller.Node_SHAPE
    SPHERE = _controller.Node_SPHERE
    SPOT_LIGHT = _controller.Node_SPOT_LIGHT
    TEXTURE_COORDINATE = _controller.Node_TEXTURE_COORDINATE
    TEXTURE_TRANSFORM = _controller.Node_TEXTURE_TRANSFORM
    TRANSFORM = _controller.Node_TRANSFORM
    VIEWPOINT = _controller.Node_VIEWPOINT
    ROBOT = _controller.Node_ROBOT
    ACCELEROMETER = _controller.Node_ACCELEROMETER
    ALTIMETER = _controller.Node_ALTIMETER
    BRAKE = _controller.Node_BRAKE
    CAMERA = _controller.Node_CAMERA
    COMPASS = _controller.Node_COMPASS
    CONNECTOR = _controller.Node_CONNECTOR
    DISPLAY = _controller.Node_DISPLAY
    DISTANCE_SENSOR = _controller.Node_DISTANCE_SENSOR
    EMITTER = _controller.Node_EMITTER
    GPS = _controller.Node_GPS
    GYRO = _controller.Node_GYRO
    INERTIAL_UNIT = _controller.Node_INERTIAL_UNIT
    LED = _controller.Node_LED
    LIDAR = _controller.Node_LIDAR
    LIGHT_SENSOR = _controller.Node_LIGHT_SENSOR
    LINEAR_MOTOR = _controller.Node_LINEAR_MOTOR
    PEN = _controller.Node_PEN
    POSITION_SENSOR = _controller.Node_POSITION_SENSOR
    PROPELLER = _controller.Node_PROPELLER
    RADAR = _controller.Node_RADAR
    RANGE_FINDER = _controller.Node_RANGE_FINDER
    RECEIVER = _controller.Node_RECEIVER
    ROTATIONAL_MOTOR = _controller.Node_ROTATIONAL_MOTOR
    SKIN = _controller.Node_SKIN
    SPEAKER = _controller.Node_SPEAKER
    TOUCH_SENSOR = _controller.Node_TOUCH_SENSOR
    BALL_JOINT = _controller.Node_BALL_JOINT
    BALL_JOINT_PARAMETERS = _controller.Node_BALL_JOINT_PARAMETERS
    CHARGER = _controller.Node_CHARGER
    CONTACT_PROPERTIES = _controller.Node_CONTACT_PROPERTIES
    DAMPING = _controller.Node_DAMPING
    FLUID = _controller.Node_FLUID
    FOCUS = _controller.Node_FOCUS
    HINGE_JOINT = _controller.Node_HINGE_JOINT
    HINGE_JOINT_PARAMETERS = _controller.Node_HINGE_JOINT_PARAMETERS
    HINGE_2_JOINT = _controller.Node_HINGE_2_JOINT
    IMMERSION_PROPERTIES = _controller.Node_IMMERSION_PROPERTIES
    JOINT_PARAMETERS = _controller.Node_JOINT_PARAMETERS
    LENS = _controller.Node_LENS
    LENS_FLARE = _controller.Node_LENS_FLARE
    PHYSICS = _controller.Node_PHYSICS
    RECOGNITION = _controller.Node_RECOGNITION
    SLIDER_JOINT = _controller.Node_SLIDER_JOINT
    SLOT = _controller.Node_SLOT
    SOLID = _controller.Node_SOLID
    SOLID_REFERENCE = _controller.Node_SOLID_REFERENCE
    TRACK = _controller.Node_TRACK
    TRACK_WHEEL = _controller.Node_TRACK_WHEEL
    WORLD_INFO = _controller.Node_WORLD_INFO
    ZOOM = _controller.Node_ZOOM
    MICROPHONE = _controller.Node_MICROPHONE
    RADIO = _controller.Node_RADIO

    def remove(self):
        return _controller.Node_remove(self)

    def getId(self):
        return _controller.Node_getId(self)

    def getType(self):
        return _controller.Node_getType(self)

    def getDef(self):
        return _controller.Node_getDef(self)

    def getTypeName(self):
        return _controller.Node_getTypeName(self)

    def getBaseTypeName(self):
        return _controller.Node_getBaseTypeName(self)

    def getParentNode(self):
        return _controller.Node_getParentNode(self)

    def isProto(self):
        return _controller.Node_isProto(self)

    def getFromProtoDef(self, name):
        return _controller.Node_getFromProtoDef(self, name)

    def getNumberOfFields(self):
        return _controller.Node_getNumberOfFields(self)

    def getProtoNumberOfFields(self):
        return _controller.Node_getProtoNumberOfFields(self)

    def getField(self, fieldName):
        return _controller.Node_getField(self, fieldName)

    def getProtoField(self, fieldName):
        return _controller.Node_getProtoField(self, fieldName)

    def getFieldByIndex(self, index):
        return _controller.Node_getFieldByIndex(self, index)

    def getProtoFieldByIndex(self, index):
        return _controller.Node_getProtoFieldByIndex(self, index)

    def getPosition(self):
        return _controller.Node_getPosition(self)

    def getOrientation(self):
        return _controller.Node_getOrientation(self)

    def getPose(self, *args):
        return _controller.Node_getPose(self, *args)

    def enableContactPointsTracking(self, *args):
        return _controller.Node_enableContactPointsTracking(self, *args)

    def disableContactPointsTracking(self, *args):
        return _controller.Node_disableContactPointsTracking(self, *args)

    def enablePoseTracking(self, *args):
        return _controller.Node_enablePoseTracking(self, *args)

    def disablePoseTracking(self, *args):
        return _controller.Node_disablePoseTracking(self, *args)

    def getContactPointsPrivate(self, includeDescendants):
        return _controller.Node_getContactPointsPrivate(self, includeDescendants)

    def getCenterOfMass(self):
        return _controller.Node_getCenterOfMass(self)

    def getContactPoint(self, index):
        return _controller.Node_getContactPoint(self, index)

    def getContactPointNode(self, index):
        return _controller.Node_getContactPointNode(self, index)

    def getNumberOfContactPoints(self, includeDescendants=False):
        return _controller.Node_getNumberOfContactPoints(self, includeDescendants)

    def getStaticBalance(self):
        return _controller.Node_getStaticBalance(self)

    def getVelocity(self):
        return _controller.Node_getVelocity(self)

    def exportString(self):
        return _controller.Node_exportString(self)

    def setVelocity(self, velocity):
        return _controller.Node_setVelocity(self, velocity)

    def resetPhysics(self):
        return _controller.Node_resetPhysics(self)

    def restartController(self):
        return _controller.Node_restartController(self)

    def moveViewpoint(self):
        return _controller.Node_moveViewpoint(self)

    def setVisibility(self, _from, visible):
        return _controller.Node_setVisibility(self, _from, visible)

    def addForce(self, force, relative):
        return _controller.Node_addForce(self, force, relative)

    def addForceWithOffset(self, force, offset, relative):
        return _controller.Node_addForceWithOffset(self, force, offset, relative)

    def addTorque(self, torque, relative):
        return _controller.Node_addTorque(self, torque, relative)

    def saveState(self, stateName):
        return _controller.Node_saveState(self, stateName)

    def loadState(self, stateName):
        return _controller.Node_loadState(self, stateName)

    def setJointPosition(self, position, index=1):
        return _controller.Node_setJointPosition(self, position, index)

    def __eq__(self, other):
        if self is None and other is None:
            return True
        elif self is None or other is None:
            return False
        elif self.getId() == other.getId():
            return True
        return False

    def __ne__(self, other):
        return not self.__eq__(other)

    def getContactPoints(self, includeDescendants=False):
      point_data = self.getContactPointsPrivate(includeDescendants)
      if not point_data:
        return []
      ret = []
      points, size = point_data
      for i in range(size):
        ret.append(self.getContactPointFromList(points, i))
      return ret


    def getContactPointFromList(self, points, index):
        return _controller.Node_getContactPointFromList(self, points, index)

# Register Node in _controller:
_controller.Node_swigregister(Node)

class Pen(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Pen_swiginit(self, _controller.new_Pen(name))
    __swig_destroy__ = _controller.delete_Pen

    def write(self, write):
        return _controller.Pen_write(self, write)

    def setInkColor(self, color, density):
        return _controller.Pen_setInkColor(self, color, density)

# Register Pen in _controller:
_controller.Pen_swigregister(Pen)

class PositionSensor(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ROTATIONAL = _controller.PositionSensor_ROTATIONAL
    LINEAR = _controller.PositionSensor_LINEAR

    def __init__(self, name):
        _controller.PositionSensor_swiginit(self, _controller.new_PositionSensor(name))
    __swig_destroy__ = _controller.delete_PositionSensor

    def enable(self, samplingPeriod):
        return _controller.PositionSensor_enable(self, samplingPeriod)

    def disable(self):
        return _controller.PositionSensor_disable(self)

    def getSamplingPeriod(self):
        return _controller.PositionSensor_getSamplingPeriod(self)

    def getValue(self):
        return _controller.PositionSensor_getValue(self)

    def getType(self):
        return _controller.PositionSensor_getType(self)

    def getBrake(self):
        return _controller.PositionSensor_getBrake(self)

    def getMotor(self):
        return _controller.PositionSensor_getMotor(self)

    def getBrakeTag(self):
        return _controller.PositionSensor_getBrakeTag(self)

    def getMotorTag(self):
        return _controller.PositionSensor_getMotorTag(self)
    ANGULAR = _controller.PositionSensor_ANGULAR

    def getBrake(self):
        try:
            return self.__brake
        except AttributeError:
            self.__brake = Robot.internalGetDeviceFromTag(self.getBrakeTag())
            return self.__brake
    def getMotor(self):
        try:
            return self.__motor
        except AttributeError:
            self.__motor = Robot.internalGetDeviceFromTag(self.getMotorTag())
            return self.__motor


# Register PositionSensor in _controller:
_controller.PositionSensor_swigregister(PositionSensor)

class RadarTarget(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    distance = property(_controller.RadarTarget_distance_get, _controller.RadarTarget_distance_set)
    received_power = property(_controller.RadarTarget_received_power_get, _controller.RadarTarget_received_power_set)
    speed = property(_controller.RadarTarget_speed_get, _controller.RadarTarget_speed_set)
    azimuth = property(_controller.RadarTarget_azimuth_get, _controller.RadarTarget_azimuth_set)

    def __init__(self):
        _controller.RadarTarget_swiginit(self, _controller.new_RadarTarget())
    __swig_destroy__ = _controller.delete_RadarTarget

# Register RadarTarget in _controller:
_controller.RadarTarget_swigregister(RadarTarget)

class Radar(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Radar_swiginit(self, _controller.new_Radar(name))
    __swig_destroy__ = _controller.delete_Radar

    def enable(self, samplingPeriod):
        return _controller.Radar_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Radar_disable(self)

    def getSamplingPeriod(self):
        return _controller.Radar_getSamplingPeriod(self)

    def getNumberOfTargets(self):
        return _controller.Radar_getNumberOfTargets(self)

    def getTargets(self):
        return _controller.Radar_getTargets(self)

    def getMinRange(self):
        return _controller.Radar_getMinRange(self)

    def getMaxRange(self):
        return _controller.Radar_getMaxRange(self)

    def getHorizontalFov(self):
        return _controller.Radar_getHorizontalFov(self)

    def getVerticalFov(self):
        return _controller.Radar_getVerticalFov(self)

    def getTarget(self, index):
        return _controller.Radar_getTarget(self, index)

    def getTargets(self):
       ret = []
       for i in range(self.getNumberOfTargets()):
         ret.append(self.getTarget(i))
       return ret


# Register Radar in _controller:
_controller.Radar_swigregister(Radar)

class RangeFinder(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.RangeFinder_swiginit(self, _controller.new_RangeFinder(name))
    __swig_destroy__ = _controller.delete_RangeFinder

    def enable(self, samplingPeriod):
        return _controller.RangeFinder_enable(self, samplingPeriod)

    def disable(self):
        return _controller.RangeFinder_disable(self)

    def getSamplingPeriod(self):
        return _controller.RangeFinder_getSamplingPeriod(self)

    def getRangeImage(self):
        return _controller.RangeFinder_getRangeImage(self)

    def getWidth(self):
        return _controller.RangeFinder_getWidth(self)

    def getHeight(self):
        return _controller.RangeFinder_getHeight(self)

    def getFov(self):
        return _controller.RangeFinder_getFov(self)

    def getMinRange(self):
        return _controller.RangeFinder_getMinRange(self)

    def getMaxRange(self):
        return _controller.RangeFinder_getMaxRange(self)

    def saveImage(self, filename, quality):
        return _controller.RangeFinder_saveImage(self, filename, quality)

    def __getRangeImageList(self):
        return _controller.RangeFinder___getRangeImageList(self)

    def __getRangeImageBuffer(self):
        return _controller.RangeFinder___getRangeImageBuffer(self)

    def getRangeImageArray(self):
        return _controller.RangeFinder_getRangeImageArray(self)

    def getRangeImage(self, data_type='list'):
      if data_type == 'list':
        return self.__getRangeImageList()
      elif data_type == 'buffer':
        return self.__getRangeImageBuffer()
      else:
        print("Error: `data_type` cannot be `{}`! Supported values are 'list' and 'buffer'.".format(data_type), file=sys.stderr)
        return None


    @staticmethod
    def rangeImageGetValue(im, minRange, maxRange, width, x, y):
        return _controller.RangeFinder_rangeImageGetValue(im, minRange, maxRange, width, x, y)

    @staticmethod
    def rangeImageGetDepth(*args):
        return _controller.RangeFinder_rangeImageGetDepth(*args)

# Register RangeFinder in _controller:
_controller.RangeFinder_swigregister(RangeFinder)

def RangeFinder_rangeImageGetValue(im, minRange, maxRange, width, x, y):
    return _controller.RangeFinder_rangeImageGetValue(im, minRange, maxRange, width, x, y)

def RangeFinder_rangeImageGetDepth(*args):
    return _controller.RangeFinder_rangeImageGetDepth(*args)

class Receiver(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Receiver_swiginit(self, _controller.new_Receiver(name))
    __swig_destroy__ = _controller.delete_Receiver
    CHANNEL_BROADCAST = _controller.Receiver_CHANNEL_BROADCAST

    def enable(self, samplingPeriod):
        return _controller.Receiver_enable(self, samplingPeriod)

    def disable(self):
        return _controller.Receiver_disable(self)

    def getSamplingPeriod(self):
        return _controller.Receiver_getSamplingPeriod(self)

    def setChannel(self, channel):
        return _controller.Receiver_setChannel(self, channel)

    def getChannel(self):
        return _controller.Receiver_getChannel(self)

    def getQueueLength(self):
        return _controller.Receiver_getQueueLength(self)

    def nextPacket(self):
        return _controller.Receiver_nextPacket(self)

    def getDataSize(self):
        return _controller.Receiver_getDataSize(self)

    def getData(self):
        return _controller.Receiver_getData(self)

    def getSignalStrength(self):
        return _controller.Receiver_getSignalStrength(self)

    def getEmitterDirection(self):
        return _controller.Receiver_getEmitterDirection(self)

# Register Receiver in _controller:
_controller.Receiver_swigregister(Receiver)

class Skin(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Skin_swiginit(self, _controller.new_Skin(name))
    __swig_destroy__ = _controller.delete_Skin

    def setBoneOrientation(self, index, orientation, absolute):
        return _controller.Skin_setBoneOrientation(self, index, orientation, absolute)

    def setBonePosition(self, index, position, absolute):
        return _controller.Skin_setBonePosition(self, index, position, absolute)

    def getBoneCount(self):
        return _controller.Skin_getBoneCount(self)

    def getBoneName(self, index):
        return _controller.Skin_getBoneName(self, index)

    def getBoneOrientation(self, index, absolute):
        return _controller.Skin_getBoneOrientation(self, index, absolute)

    def getBonePosition(self, index, absolute):
        return _controller.Skin_getBonePosition(self, index, absolute)

# Register Skin in _controller:
_controller.Skin_swigregister(Skin)

class Speaker(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name):
        _controller.Speaker_swiginit(self, _controller.new_Speaker(name))
    __swig_destroy__ = _controller.delete_Speaker

    @staticmethod
    def playSound(left, right, sound, volume, pitch, balance, loop):
        return _controller.Speaker_playSound(left, right, sound, volume, pitch, balance, loop)

    def isSoundPlaying(self, sound):
        return _controller.Speaker_isSoundPlaying(self, sound)

    def stop(self, sound):
        return _controller.Speaker_stop(self, sound)

    def setEngine(self, engine):
        return _controller.Speaker_setEngine(self, engine)

    def setLanguage(self, language):
        return _controller.Speaker_setLanguage(self, language)

    def getEngine(self):
        return _controller.Speaker_getEngine(self)

    def getLanguage(self):
        return _controller.Speaker_getLanguage(self)

    def speak(self, text, volume):
        return _controller.Speaker_speak(self, text, volume)

    def isSpeaking(self):
        return _controller.Speaker_isSpeaking(self)

# Register Speaker in _controller:
_controller.Speaker_swigregister(Speaker)

def Speaker_playSound(left, right, sound, volume, pitch, balance, loop):
    return _controller.Speaker_playSound(left, right, sound, volume, pitch, balance, loop)

class TouchSensor(Device):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    BUMPER = _controller.TouchSensor_BUMPER
    FORCE = _controller.TouchSensor_FORCE
    FORCE3D = _controller.TouchSensor_FORCE3D

    def __init__(self, name):
        _controller.TouchSensor_swiginit(self, _controller.new_TouchSensor(name))
    __swig_destroy__ = _controller.delete_TouchSensor

    def enable(self, samplingPeriod):
        return _controller.TouchSensor_enable(self, samplingPeriod)

    def disable(self):
        return _controller.TouchSensor_disable(self)

    def getSamplingPeriod(self):
        return _controller.TouchSensor_getSamplingPeriod(self)

    def getValue(self):
        return _controller.TouchSensor_getValue(self)

    def getValues(self):
        return _controller.TouchSensor_getValues(self)

    def __internalGetLookupTableSize(self):
        return _controller.TouchSensor___internalGetLookupTableSize(self)

    def getLookupTable(self):
        return _controller.TouchSensor_getLookupTable(self)

    def getType(self):
        return _controller.TouchSensor_getType(self)

# Register TouchSensor in _controller:
_controller.TouchSensor_swigregister(TouchSensor)

class Robot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    MODE_SIMULATION = _controller.Robot_MODE_SIMULATION
    MODE_CROSS_COMPILATION = _controller.Robot_MODE_CROSS_COMPILATION
    MODE_REMOTE_CONTROL = _controller.Robot_MODE_REMOTE_CONTROL
    EVENT_QUIT = _controller.Robot_EVENT_QUIT
    EVENT_NO_EVENT = _controller.Robot_EVENT_NO_EVENT
    EVENT_MOUSE_CLICK = _controller.Robot_EVENT_MOUSE_CLICK
    EVENT_MOUSE_MOVE = _controller.Robot_EVENT_MOUSE_MOVE
    EVENT_KEYBOARD = _controller.Robot_EVENT_KEYBOARD
    EVENT_JOYSTICK_BUTTON = _controller.Robot_EVENT_JOYSTICK_BUTTON
    EVENT_JOYSTICK_AXIS = _controller.Robot_EVENT_JOYSTICK_AXIS
    EVENT_JOYSTICK_POV = _controller.Robot_EVENT_JOYSTICK_POV

    def __init__(self):
        _controller.Robot_swiginit(self, _controller.new_Robot())
    __swig_destroy__ = _controller.delete_Robot

    def step(self, duration):
        return _controller.Robot_step(self, duration)

    def stepBegin(self, duration):
        return _controller.Robot_stepBegin(self, duration)

    def stepEnd(self):
        return _controller.Robot_stepEnd(self)

    def waitForUserInputEvent(self, event_type, timeout):
        return _controller.Robot_waitForUserInputEvent(self, event_type, timeout)

    def getName(self):
        return _controller.Robot_getName(self)

    def getUrdf(self, *args):
        return _controller.Robot_getUrdf(self, *args)

    def getTime(self):
        return _controller.Robot_getTime(self)

    def getModel(self):
        return _controller.Robot_getModel(self)

    def getCustomData(self):
        return _controller.Robot_getCustomData(self)

    def setCustomData(self, data):
        return _controller.Robot_setCustomData(self, data)

    def getMode(self):
        return _controller.Robot_getMode(self)

    def setMode(self, arg2, arg3):
        return _controller.Robot_setMode(self, arg2, arg3)

    def getSupervisor(self):
        return _controller.Robot_getSupervisor(self)

    def getSynchronization(self):
        return _controller.Robot_getSynchronization(self)

    def getProjectPath(self):
        return _controller.Robot_getProjectPath(self)

    def getWorldPath(self):
        return _controller.Robot_getWorldPath(self)

    def getBasicTimeStep(self):
        return _controller.Robot_getBasicTimeStep(self)

    def getNumberOfDevices(self):
        return _controller.Robot_getNumberOfDevices(self)

    def __internalGetDeviceByIndex(self, index):
        return _controller.Robot___internalGetDeviceByIndex(self, index)

    def __internalGetDevice(self, name):
        return _controller.Robot___internalGetDevice(self, name)

    def batterySensorEnable(self, samplingPeriod):
        return _controller.Robot_batterySensorEnable(self, samplingPeriod)

    def batterySensorDisable(self):
        return _controller.Robot_batterySensorDisable(self)

    def batterySensorGetSamplingPeriod(self):
        return _controller.Robot_batterySensorGetSamplingPeriod(self)

    def batterySensorGetValue(self):
        return _controller.Robot_batterySensorGetValue(self)

    def wwiSendText(self, text):
        return _controller.Robot_wwiSendText(self, text)

    def wwiReceiveText(self):
        return _controller.Robot_wwiReceiveText(self)

    def getData(self):
        return _controller.Robot_getData(self)

    def setData(self, data):
        return _controller.Robot_setData(self, data)

    @staticmethod
    def getDeviceFromTag(tag):
        return _controller.Robot_getDeviceFromTag(tag)

    @staticmethod
    def __internalGetDeviceTypeFromTag(tag):
        return _controller.Robot___internalGetDeviceTypeFromTag(tag)

    @staticmethod
    def __internalGetDeviceNameFromTag(tag):
        return _controller.Robot___internalGetDeviceNameFromTag(tag)

    @staticmethod
    def __internalGetDeviceTagFromIndex(index):
        return _controller.Robot___internalGetDeviceTagFromIndex(index)

    @staticmethod
    def __internalGetDeviceTagFromName(name):
        return _controller.Robot___internalGetDeviceTagFromName(name)

    __devices = []
    joystick = Joystick()
    keyboard = Keyboard()
    mouse = Mouse()
    import sys
    if sys.version_info[0] < 3:
      sys.stderr.write("DEPRECATION: Python 2.7 will reach the end of its life on January 1st, 2020. Please upgrade your Python as Python 2.7 won't be maintained after that date. A future version of Webots will drop support for Python 2.7.\n")
    def createAccelerometer(self, name):
      return Accelerometer(name)
    def getAccelerometer(self, name):
      sys.stderr.write("DEPRECATION: Robot.getAccelerometer is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.ACCELEROMETER):
        return None
      return self.__getOrCreateDevice(tag)
    def createAltimeter(self, name):
      return Altimeter(name)
    def getAltimeter(self, name):
      sys.stderr.write("DEPRECATION: Robot.getAltimeter is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.ALTIMETER):
        return None
      return self.__getOrCreateDevice(tag)
    def createBrake(self, name):
      return Brake(name)
    def getBrake(self, name):
      sys.stderr.write("DEPRECATION: Robot.getBrake is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.BRAKE):
        return None
      return self.__getOrCreateDevice(tag)
    def createCamera(self, name):
      return Camera(name)
    def getCamera(self, name):
      sys.stderr.write("DEPRECATION: Robot.getCamera is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.CAMERA):
        return None
      return self.__getOrCreateDevice(tag)
    def createCompass(self, name):
      return Compass(name)
    def getCompass(self, name):
      sys.stderr.write("DEPRECATION: Robot.getCompass is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.COMPASS):
        return None
      return self.__getOrCreateDevice(tag)
    def createConnector(self, name):
      return Connector(name)
    def getConnector(self, name):
      sys.stderr.write("DEPRECATION: Robot.getConnector is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.CONNECTOR):
        return None
      return self.__getOrCreateDevice(tag)
    def createDisplay(self, name):
      return Display(name)
    def getDisplay(self, name):
      sys.stderr.write("DEPRECATION: Robot.getDisplay is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.DISPLAY):
        return None
      return self.__getOrCreateDevice(tag)
    def createDistanceSensor(self, name):
      return DistanceSensor(name)
    def getDistanceSensor(self, name):
      sys.stderr.write("DEPRECATION: Robot.getDistanceSensor is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.DISTANCE_SENSOR):
        return None
      return self.__getOrCreateDevice(tag)
    def createEmitter(self, name):
      return Emitter(name)
    def getEmitter(self, name):
      sys.stderr.write("DEPRECATION: Robot.getEmitter is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.EMITTER):
        return None
      return self.__getOrCreateDevice(tag)
    def createGPS(self, name):
      return GPS(name)
    def getGPS(self, name):
      sys.stderr.write("DEPRECATION: Robot.getGPS is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.GPS):
        return None
      return self.__getOrCreateDevice(tag)
    def createGyro(self, name):
      return Gyro(name)
    def getGyro(self, name):
      sys.stderr.write("DEPRECATION: Robot.getGyro is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.GYRO):
        return None
      return self.__getOrCreateDevice(tag)
    def createInertialUnit(self, name):
      return InertialUnit(name)
    def getInertialUnit(self, name):
      sys.stderr.write("DEPRECATION: Robot.getInertialUnit is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.INERTIAL_UNIT):
        return None
      return self.__getOrCreateDevice(tag)
    def getJoystick(self):
      return self.joystick
    def getKeyboard(self):
      return self.keyboard
    def createLED(self, name):
      return LED(name)
    def getLED(self, name):
      sys.stderr.write("DEPRECATION: Robot.getLED is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.LED):
        return None
      return self.__getOrCreateDevice(tag)
    def createLidar(self, name):
      return Lidar(name)
    def getLidar(self, name):
      sys.stderr.write("DEPRECATION: Robot.getLidar is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.LIDAR):
        return None
      return self.__getOrCreateDevice(tag)
    def createLightSensor(self, name):
      return LightSensor(name)
    def getLightSensor(self, name):
      sys.stderr.write("DEPRECATION: Robot.getLightSensor is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.LIGHT_SENSOR):
        return None
      return self.__getOrCreateDevice(tag)
    def createMotor(self, name):
      return Motor(name)
    def getMotor(self, name):
      sys.stderr.write("DEPRECATION: Robot.getMotor is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.LINEAR_MOTOR) and not Device.hasType(tag, Node.ROTATIONAL_MOTOR):
        return None
      return self.__getOrCreateDevice(tag)
    def getMouse(self):
      return self.mouse
    def createPen(self, name):
      return Pen(name)
    def getPen(self, name):
      sys.stderr.write("DEPRECATION: Robot.getPen is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.PEN):
        return None
      return self.__getOrCreateDevice(tag)
    def createPositionSensor(self, name):
      return PositionSensor(name)
    def getPositionSensor(self, name):
      sys.stderr.write("DEPRECATION: Robot.getPositionSensor is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.POSITION_SENSOR):
        return None
      return self.__getOrCreateDevice(tag)
    def createRadar(self, name):
      return Radar(name)
    def getRadar(self, name):
      sys.stderr.write("DEPRECATION: Robot.getRadar is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.RADAR):
        return None
      return self.__getOrCreateDevice(tag)
    def createRangeFinder(self, name):
      return RangeFinder(name)
    def getRangeFinder(self, name):
      sys.stderr.write("DEPRECATION: Robot.getRangeFinder is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.RANGE_FINDER):
        return None
      return self.__getOrCreateDevice(tag)
    def createReceiver(self, name):
      return Receiver(name)
    def getReceiver(self, name):
      sys.stderr.write("DEPRECATION: Robot.getReceiver is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.RECEIVER):
        return None
      return self.__getOrCreateDevice(tag)
    def createSkin(self, name):
      return Skin(name)
    def getSkin(self, name):
      sys.stderr.write("DEPRECATION: Robot.getSkin is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.SKIN):
        return None
      return self.__getOrCreateDevice(tag)
    def createSpeaker(self, name):
      return Speaker(name)
    def getSpeaker(self, name):
      sys.stderr.write("DEPRECATION: Robot.getSpeaker is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.SPEAKER):
        return None
      return self.__getOrCreateDevice(tag)
    def createTouchSensor(self, name):
      return TouchSensor(name)
    def getTouchSensor(self, name):
      sys.stderr.write("DEPRECATION: Robot.getTouchSensor is deprecated, please use Robot.getDevice instead.\n")
      tag = self.__internalGetDeviceTagFromName(name)
      if not Device.hasType(tag, Node.TOUCH_SENSOR):
        return None
      return self.__getOrCreateDevice(tag)
    def getDeviceByIndex(self, index):
      tag = self.__internalGetDeviceTagFromIndex(index)
      return self.__getOrCreateDevice(tag)
    def getDevice(self, name):
      tag = self.__internalGetDeviceTagFromName(name)
      return self.__getOrCreateDevice(tag)
    @staticmethod
    def internalGetDeviceFromTag(tag):
      if tag == 0:
          return None
      size = len(Robot.__devices)
      if size == 0 or tag >= size:
          return None
      return Robot.__devices[tag]
    def __getOrCreateDevice(self, tag):
      if tag == 0:
          return None
      count = self.getNumberOfDevices()
      size = len(Robot.__devices)
    # if new devices have been added, then count is greater than size
    # deleted devices are not removed from the C API list and don't affect the number of devices
      if size == count + 1 and size > 0 and tag < size:
          return Robot.__devices[tag]

    # (re-)initialize Robot.__devices list
      if tag > count:
          return None
      Robot.__devices = [None] * (count + 1)
      for i in range(0, count):
          otherTag = self.__internalGetDeviceTagFromIndex(i)
          name = self.__internalGetDeviceNameFromTag(otherTag)
          nodeType = self.__internalGetDeviceTypeFromTag(otherTag)
          if nodeType == Node.ACCELEROMETER:
              Robot.__devices[otherTag] = self.createAccelerometer(name)
          elif nodeType == Node.ALTIMETER:
              Robot.__devices[otherTag] = self.createAltimeter(name)
          elif nodeType == Node.BRAKE:
              Robot.__devices[otherTag] = self.createBrake(name)
          elif nodeType == Node.CAMERA:
              Robot.__devices[otherTag] = self.createCamera(name)
          elif nodeType == Node.COMPASS:
              Robot.__devices[otherTag] = self.createCompass(name)
          elif nodeType == Node.CONNECTOR:
              Robot.__devices[otherTag] = self.createConnector(name)
          elif nodeType == Node.DISPLAY:
              Robot.__devices[otherTag] = self.createDisplay(name)
          elif nodeType == Node.DISTANCE_SENSOR:
              Robot.__devices[otherTag] = self.createDistanceSensor(name)
          elif nodeType == Node.EMITTER:
              Robot.__devices[otherTag] = self.createEmitter(name)
          elif nodeType == Node.GPS:
              Robot.__devices[otherTag] = self.createGPS(name)
          elif nodeType == Node.GYRO:
              Robot.__devices[otherTag] = self.createGyro(name)
          elif nodeType == Node.INERTIAL_UNIT:
              Robot.__devices[otherTag] = self.createInertialUnit(name)
          elif nodeType == Node.LED:
              Robot.__devices[otherTag] = self.createLED(name)
          elif nodeType == Node.LIDAR:
              Robot.__devices[otherTag] = self.createLidar(name)
          elif nodeType == Node.LIGHT_SENSOR:
              Robot.__devices[otherTag] = self.createLightSensor(name)
          elif nodeType == Node.LINEAR_MOTOR or nodeType == Node.ROTATIONAL_MOTOR:
              Robot.__devices[otherTag] = self.createMotor(name)
          elif nodeType == Node.PEN:
              Robot.__devices[otherTag] = self.createPen(name)
          elif nodeType == Node.POSITION_SENSOR:
              Robot.__devices[otherTag] = self.createPositionSensor(name)
          elif nodeType == Node.RADAR:
              Robot.__devices[otherTag] = self.createRadar(name)
          elif nodeType == Node.RANGE_FINDER:
              Robot.__devices[otherTag] = self.createRangeFinder(name)
          elif nodeType == Node.RECEIVER:
              Robot.__devices[otherTag] = self.createReceiver(name)
          elif nodeType == Node.SPEAKER:
              Robot.__devices[otherTag] = self.createSpeaker(name)
          elif nodeType == Node.TOUCH_SENSOR:
              Robot.__devices[otherTag] = self.createTouchSensor(name)
      return Robot.__devices[tag]


# Register Robot in _controller:
_controller.Robot_swigregister(Robot)

def Robot_getDeviceFromTag(tag):
    return _controller.Robot_getDeviceFromTag(tag)

def Robot___internalGetDeviceTypeFromTag(tag):
    return _controller.Robot___internalGetDeviceTypeFromTag(tag)

def Robot___internalGetDeviceNameFromTag(tag):
    return _controller.Robot___internalGetDeviceNameFromTag(tag)

def Robot___internalGetDeviceTagFromIndex(index):
    return _controller.Robot___internalGetDeviceTagFromIndex(index)

def Robot___internalGetDeviceTagFromName(name):
    return _controller.Robot___internalGetDeviceTagFromName(name)

class Supervisor(Robot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SIMULATION_MODE_PAUSE = _controller.Supervisor_SIMULATION_MODE_PAUSE
    SIMULATION_MODE_REAL_TIME = _controller.Supervisor_SIMULATION_MODE_REAL_TIME
    SIMULATION_MODE_FAST = _controller.Supervisor_SIMULATION_MODE_FAST

    def __init__(self):
        _controller.Supervisor_swiginit(self, _controller.new_Supervisor())

    @staticmethod
    def getSupervisorInstance():
        return _controller.Supervisor_getSupervisorInstance()
    __swig_destroy__ = _controller.delete_Supervisor

    def simulationQuit(self, status):
        return _controller.Supervisor_simulationQuit(self, status)

    def simulationReset(self):
        return _controller.Supervisor_simulationReset(self)

    def simulationResetPhysics(self):
        return _controller.Supervisor_simulationResetPhysics(self)

    def simulationGetMode(self):
        return _controller.Supervisor_simulationGetMode(self)

    def simulationSetMode(self, mode):
        return _controller.Supervisor_simulationSetMode(self, mode)

    def worldLoad(self, file):
        return _controller.Supervisor_worldLoad(self, file)

    def worldReload(self):
        return _controller.Supervisor_worldReload(self)

    def worldSave(self, *args):
        return _controller.Supervisor_worldSave(self, *args)

    def exportImage(self, file, quality):
        return _controller.Supervisor_exportImage(self, file, quality)

    def animationStartRecording(self, file):
        return _controller.Supervisor_animationStartRecording(self, file)

    def animationStopRecording(self):
        return _controller.Supervisor_animationStopRecording(self)

    def movieStartRecording(self, file, width, height, codec, quality, acceleration, caption):
        return _controller.Supervisor_movieStartRecording(self, file, width, height, codec, quality, acceleration, caption)

    def movieStopRecording(self):
        return _controller.Supervisor_movieStopRecording(self)

    def movieIsReady(self):
        return _controller.Supervisor_movieIsReady(self)

    def movieFailed(self):
        return _controller.Supervisor_movieFailed(self)

    def setLabel(self, *args):
        return _controller.Supervisor_setLabel(self, *args)

    def getRoot(self):
        return _controller.Supervisor_getRoot(self)

    def getSelf(self):
        return _controller.Supervisor_getSelf(self)

    def getFromDef(self, name):
        return _controller.Supervisor_getFromDef(self, name)

    def getFromId(self, id):
        return _controller.Supervisor_getFromId(self, id)

    def getFromDevice(self, device):
        return _controller.Supervisor_getFromDevice(self, device)

    def __internalGetFromDeviceTag(self, tag):
        return _controller.Supervisor___internalGetFromDeviceTag(self, tag)

    def getSelected(self):
        return _controller.Supervisor_getSelected(self)

    def virtualRealityHeadsetIsUsed(self):
        return _controller.Supervisor_virtualRealityHeadsetIsUsed(self)

    def virtualRealityHeadsetGetPosition(self):
        return _controller.Supervisor_virtualRealityHeadsetGetPosition(self)

    def virtualRealityHeadsetGetOrientation(self):
        return _controller.Supervisor_virtualRealityHeadsetGetOrientation(self)

    def simulationRevert(self):
        return _controller.Supervisor_simulationRevert(self)

    def loadWorld(self, file):
        return _controller.Supervisor_loadWorld(self, file)

    def saveWorld(self, *args):
        return _controller.Supervisor_saveWorld(self, *args)

    def simulationPhysicsReset(self):
        return _controller.Supervisor_simulationPhysicsReset(self)

    def startMovie(self, file, width, height, codec, quality, acceleration, caption):
        return _controller.Supervisor_startMovie(self, file, width, height, codec, quality, acceleration, caption)

    def stopMovie(self):
        return _controller.Supervisor_stopMovie(self)

    def getMovieStatus(self):
        return _controller.Supervisor_getMovieStatus(self)
    MOVIE_READY = _controller.Supervisor_MOVIE_READY
    MOVIE_RECORDING = _controller.Supervisor_MOVIE_RECORDING
    MOVIE_SAVING = _controller.Supervisor_MOVIE_SAVING
    MOVIE_WRITE_ERROR = _controller.Supervisor_MOVIE_WRITE_ERROR
    MOVIE_ENCODING_ERROR = _controller.Supervisor_MOVIE_ENCODING_ERROR
    MOVIE_SIMULATION_ERROR = _controller.Supervisor_MOVIE_SIMULATION_ERROR

    def movieGetStatus(self):
        return _controller.Supervisor_movieGetStatus(self)

# Register Supervisor in _controller:
_controller.Supervisor_swigregister(Supervisor)

def Supervisor_getSupervisorInstance():
    return _controller.Supervisor_getSupervisorInstance()



