How to contribute
=================

This repository is maintained by the Eclipse Foundation, Inc.

Contributions via pull requests are very welcome!
Please discuss a change you wish to make via issue (preferred), email,
or any other method with the maintainers of this repository.

Ways you can help
------------------

- *Code reviews:*
  You can help with code review to avoid bugs and increase readability.
  Be welcoming, appreciative, and helpful.
- *Communication in issues:*
  You can monitor issues and help other people who have questions about
  contributing to, or using this project.
- *Suggesting improvement:*
  If you have a suggestion of your own, search the open issues.
  If you don't see it, feel free to open a new issue.
- *Contributing solutions:*
  Concrete solution proposals are very welcome.
  Have a look at the pull request description for further details.
    
Feel free to reach out to one of the maintainers if you need help
getting started (see also below).


Pull Request Process
---------------------

Code contributions are to be submitted via pull requests.
For this fork this repository, apply the suggested changes and create a
pull request to integrate them.
Before creating the request, please ensure the following which we will check
besides a technical review:

- **No breaks**:
  - *Builds:* All required platform builds pass (github actions).
  - *Tests:* The unit tests still pass.
  - *Docs:* The documentation still builds.
- **Docs updated**: Make sure any changes and additions are appropriately
  included into the documentation (both docstrings and the docs sources).
- The new code and included third party libraries **do not infringe
  any trademark, patent, copyright, or open source compliance**.
- Please make sure to sign the [Eclipse Contributor Agreement](https://www.eclipse.org/legal/ECA.php)
  and link your GitHub Account to your Eclipse Account.

Once we received your pull request, you will get feedback from the maintainers
within 10 working days.
Once you have the sign-off of at least one maintainer you may request the
second reviewer to merge the Pull Request for you.

*We are looking forward to your contributions.*


Getting Help
-------------

1. If you're new to the project, a good place to start is the
   README.md and the quickstart section in the documentation linked in this project
   (alternatively, check out the documentation build instructions). 
2. Take a look at the user guide and API documentation.
3. If you need help getting started or implementing a change,
   open an issue with your question.
   If there is already an issue open for the feature you're working on,
   please post there.


Code of Conduct
---------------
(The following is adapted from the Contributor Covenant, version 1.4,
available at http://contributor-covenant.org/version/1/4)

**Our Pledge**

In the interest of fostering an open and welcoming environment,
we as contributors and maintainers pledge to making participation
in our project and our community a harassment-free experience for everyone,
regardless of age, body size, disability, ethnicity, gender identity and
expression, level of experience, nationality, personal appearance,
religion, or sexual identity and orientation.

**Our Standards**

Examples of behavior that contributes to creating a positive environment include:

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

- The use of sexualized language or imagery and unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or electronic address, without explicit permission
- Other conduct which could reasonably be considered inappropriate in a professional setting

**Our Responsibilities**

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action
in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem
inappropriate, threatening, offensive, or harmful.

**Scope**

This Code of Conduct applies both within project spaces and in public
spaces when an individual is representing the project or its community.
Examples of representing a project or community include using an official
project e-mail address, posting via an official social media account,
or acting as an appointed representative at an online or offline event.
Representation of a project may be further defined and clarified
by project maintainers.

**Enforcement**

Instances of abusive, harassing, or otherwise unacceptable behavior
may be reported by contacting the project team. All complaints will be
reviewed and investigated and will result in a response that is deemed
necessary and appropriate to the circumstances. The project team is obligated
to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct
in good faith may face temporary or permanent repercussions as determined
by other members of the project's leadership.
