/* ========================= eCAL LICENSE =================================
 *
 * Copyright (C) 2016 - 2019 Continental Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ========================= eCAL LICENSE =================================
*/

#pragma once

#include <QStyledItemDelegate>

#include <QStandardItemModel>

#include <functional>

class PushButtonDelegate : public QStyledItemDelegate
{
    Q_OBJECT

public:
  PushButtonDelegate(const QIcon& icon, const QString& text, const std::function<bool(const QModelIndex& index)>& is_enabled_function, QObject* parent = nullptr);
  PushButtonDelegate(const QString& text, const std::function<bool(const QModelIndex& index)>& is_enabled_function, QObject* parent = nullptr);

  PushButtonDelegate(const QIcon& icon, const std::function<QString(const QModelIndex& index)>& get_text_function, const std::function<bool(const QModelIndex& index)>& is_enabled_function, QObject* parent = nullptr);
  PushButtonDelegate(const std::function<QString(const QModelIndex& index)>& get_text_function, const std::function<bool(const QModelIndex& index)>& is_enabled_function, QObject* parent = nullptr);


  void paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const override;

  QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const override;

private:
  QIcon   icon_;
  const std::function<bool(const QModelIndex& index)> is_enabled_function_;
  const std::function<QString(const QModelIndex& index)> get_text_function_;
};