/* ========================= eCAL LICENSE =================================
 *
 * Copyright (C) 2016 - 2020 Continental Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ========================= eCAL LICENSE =================================
*/

/**
 * eCALSys Service
**/

#pragma once

#include <ecalsys/ecal_sys.h>

// protobuf remote control
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4100 4127 4146 4505 4800 4189 4592) // disable proto warnings
#endif
#include <ecal/app/pb/sys/service.pb.h>
#include <ecal/app/pb/sys/state.pb.h>
#ifdef _MSC_VER
#pragma warning(pop)
#endif

class eCALSysServiceImpl : public eCAL::pb::sys::Service
{
public:
  eCALSysServiceImpl(std::shared_ptr<EcalSys> inst) : ecalsys_instance(inst) {};

  void StartTasks(::google::protobuf::RpcController* controller,
    const ::eCAL::pb::sys::TaskRequest* request,
    ::eCAL::pb::sys::Response* response,
    ::google::protobuf::Closure* done) override;
  void StopTasks(::google::protobuf::RpcController* controller,
    const ::eCAL::pb::sys::TaskRequest* request,
    ::eCAL::pb::sys::Response* response,
    ::google::protobuf::Closure* done) override;
  void RestartTasks(::google::protobuf::RpcController* controller,
    const ::eCAL::pb::sys::TaskRequest* request,
    ::eCAL::pb::sys::Response* response,
    ::google::protobuf::Closure* done) override;
  void GetStatus(::google::protobuf::RpcController* controller,
    const ::eCAL::pb::sys::GenericRequest* request,
    ::eCAL::pb::sys::State* response,
    ::google::protobuf::Closure* done) override;
  
private:
  std::shared_ptr<EcalSys> ecalsys_instance;
};
