// *****************************************************************************
//
// Copyright (c) 2014, Southwest Research Institute® (SwRI®)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS__ROUTE_PLUGIN_H_
#define MAPVIZ_PLUGINS__ROUTE_PLUGIN_H_

#include <mapviz/mapviz_plugin.h>

// QT libraries
#include <QGLWidget>
#include <QObject>
#include <QWidget>

// ROS libraries
#include <rclcpp/rclcpp.hpp>
#include <tf2/transform_datatypes.h>
#include <marti_nav_msgs/msg/route_position.hpp>
#include <mapviz/map_canvas.h>
#include <swri_route_util/route.h>

// C++ standard libraries
#include <list>
#include <string>
#include <vector>

// QT autogenerated files
#include "ui_route_config.h"

namespace mapviz_plugins
{
class RoutePlugin : public mapviz::MapvizPlugin
{
  Q_OBJECT

  public:
  enum DrawStyle
  {
    LINES = 0,
    POINTS = 1
  };

  RoutePlugin();
  ~RoutePlugin() override = default;

  bool Initialize(QGLWidget* canvas) override;
  void Shutdown() override {}

  void Draw(double x, double y, double scale) override;

  void Transform() override {}

  void LoadConfig(const YAML::Node& node, const std::string& path) override;
  void SaveConfig(YAML::Emitter& emitter, const std::string& path) override;
  void DrawStopWaypoint(double x, double y);
  void DrawRoute(const swri_route_util::Route &route);
  void DrawRoutePoint(const swri_route_util::RoutePoint &point);

  QWidget* GetConfigWidget(QWidget* parent) override;

  protected:
  void PrintError(const std::string& message) override;
  void PrintInfo(const std::string& message) override;
  void PrintWarning(const std::string& message) override;

  protected Q_SLOTS:
  void SelectTopic();
  void SelectPositionTopic();
  void TopicEdited();
  void PositionTopicEdited();
  void SetDrawStyle(QString style);
  void DrawIcon() override;

  private:
  Ui::route_config ui_;
  QWidget* config_widget_;

  DrawStyle draw_style_;

  std::string topic_;
  std::string position_topic_;

  rclcpp::Subscription<marti_nav_msgs::msg::Route>::SharedPtr route_sub_;
  rclcpp::Subscription<marti_nav_msgs::msg::RoutePosition>::SharedPtr position_sub_;

  swri_route_util::Route src_route_;
  // marti_nav_msgs::RoutePositionConstPtr src_route_position_;
  marti_nav_msgs::msg::RoutePosition::SharedPtr src_route_position_;

  void RouteCallback(const marti_nav_msgs::msg::Route::SharedPtr msg);
  void PositionCallback(const marti_nav_msgs::msg::RoutePosition::SharedPtr msg);
};
}   // namespace mapviz_plugins

#endif  // MAPVIZ_PLUGINS__ROUTE_PLUGIN_H_
