from typing import Any, ClassVar, List

from typing import overload
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.system
import mrpt.pymrpt.mrpt.tfest
bothLists: TListIdx
descAny: TDescriptorType
descBLD: TDescriptorType
descLATCH: TDescriptorType
descLogPolarImages: TDescriptorType
descORB: TDescriptorType
descPolarImages: TDescriptorType
descSIFT: TDescriptorType
descSURF: TDescriptorType
descSpinImages: TDescriptorType
featAKAZE: TKeyPointMethod
featBeacon: TKeyPointMethod
featFAST: TKeyPointMethod
featHarris: TKeyPointMethod
featKLT: TKeyPointMethod
featLSD: TKeyPointMethod
featNotDefined: TKeyPointMethod
featORB: TKeyPointMethod
featSIFT: TKeyPointMethod
featSURF: TKeyPointMethod
firstList: TListIdx
secondList: TListIdx
status_IDLE: TFeatureTrackStatus
status_LOST: TFeatureTrackStatus
status_OOB: TFeatureTrackStatus
status_TRACKED: TFeatureTrackStatus

class CFeatureExtraction:
    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        class TAKAZEOptions:
            descriptor_channels: int
            descriptor_size: int
            descriptor_type: int
            diffusivity: int
            nOctaveLayers: int
            nOctaves: int
            threshold: float
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TAKAZEOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TAKAZEOptions: ...
    
        class TBCDOptions:
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TBCDOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TBCDOptions: ...
    
        class TBLDOptions:
            ksize_: int
            numOfOctave: int
            reductionRatio: int
            widthOfBand: int
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TBLDOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TBLDOptions: ...
    
        class TFASTOptions:
            KLT_response_half_win_size: int
            min_distance: int
            nonmax_suppression: bool
            threshold: int
            use_KLT_response: bool
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TFASTOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TFASTOptions: ...
    
        class THarrisOptions:
            k: float
            min_distance: float
            radius: int
            sigma: float
            threshold: float
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.THarrisOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.THarrisOptions: ...
    
        class TKLTOptions:
            min_distance: float
            radius: int
            threshold: float
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TKLTOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TKLTOptions: ...
    
        class TLATCHOptions:
            bytes: int
            half_ssd_size: int
            rotationInvariance: bool
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TLATCHOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TLATCHOptions: ...
    
        class TLSDOptions:
            nOctaves: int
            scale: int
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TLSDOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TLSDOptions: ...
    
        class TLogPolarImagesOptions:
            num_angles: int
            radius: int
            rho_scale: float
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TLogPolarImagesOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TLogPolarImagesOptions: ...
    
        class TORBOptions:
            extract_patch: bool
            min_distance: int
            n_levels: int
            scale_factor: float
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TORBOptions) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TORBOptions: ...
    
        class TPolarImagesOptions:
            bins_angle: int
            bins_distance: int
            radius: int
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TPolarImagesOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TPolarImagesOptions: ...
    
        class TSIFTOptions:
            edgeThreshold: float
            implementation: CFeatureExtraction.TSIFTImplementation
            octaveLayers: int
            threshold: float
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TSIFTOptions) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TSIFTOptions: ...
    
        class TSURFOptions:
            hessianThreshold: int
            nLayersPerOctave: int
            nOctaves: int
            rotation_invariant: bool
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TSURFOptions) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TSURFOptions: ...
    
        class TSpinImagesOptions:
            hist_size_distance: int
            hist_size_intensity: int
            radius: int
            std_dist: float
            std_intensity: float
            @overload
            def __init__(self, arg0: CFeatureExtraction.TOptions.TSpinImagesOptions) -> None: ...
            @overload
            def __init__(self) -> None: ...
            def assign(self) -> CFeatureExtraction.TOptions.TSpinImagesOptions: ...
        AKAZEOptions: Any
        BCDOptions: Any
        BLDOptions: Any
        FASTOptions: Any
        FIND_SUBPIXEL: bool
        KLTOptions: Any
        LATCHOptions: Any
        LSDOptions: Any
        LogPolarImagesOptions: Any
        ORBOptions: Any
        PolarImagesOptions: Any
        SIFTOptions: Any
        SURFOptions: Any
        SpinImagesOptions: Any
        addNewFeatures: bool
        featsType: TKeyPointMethod
        harrisOptions: Any
        patchSize: int
        useMask: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, ft: TKeyPointMethod) -> None: ...
        @overload
        def __init__(self, arg0: CFeatureExtraction.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CFeatureExtraction.TOptions) -> None: ...
        def assign(self) -> CFeatureExtraction.TOptions: ...
        @overload
        def loadFromConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TSIFTImplementation:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        OpenCV: ClassVar[CFeatureExtraction.TSIFTImplementation] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    OpenCV: ClassVar[CFeatureExtraction.TSIFTImplementation] = ...
    options: Any
    profiler: mrpt.pymrpt.mrpt.system.CTimeLogger
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CFeatureExtraction) -> None: ...
    def assign(self) -> CFeatureExtraction: ...
    @overload
    def computeDescriptors(self, in_img: mrpt.pymrpt.mrpt.img.CImage, inout_features: CFeatureList, in_descriptor_list: TDescriptorType) -> None: ...
    @overload
    def computeDescriptors(constclassmrpt, classmrpt, enummrpt) -> void: ...
    @overload
    def detectFeatures(self, img: mrpt.pymrpt.mrpt.img.CImage, feats: CFeatureList) -> None: ...
    @overload
    def detectFeatures(self, img: mrpt.pymrpt.mrpt.img.CImage, feats: CFeatureList, init_ID: int) -> None: ...
    @overload
    def detectFeatures(self, img: mrpt.pymrpt.mrpt.img.CImage, feats: CFeatureList, init_ID: int, nDesiredFeatures: int) -> None: ...
    @overload
    def detectFeatures(self, img: mrpt.pymrpt.mrpt.img.CImage, feats: CFeatureList, init_ID: int, nDesiredFeatures: int, ROI: TImageROI) -> None: ...

class CFeatureList:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CFeatureList) -> None: ...
    def assign(self) -> CFeatureList: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def copyListFrom(self, otherList: CFeatureList) -> None: ...
    @overload
    def copyListFrom(constclassmrpt) -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def getFeatureID(self, i: int) -> int: ...
    @overload
    def getFeatureID(size_t) -> unsignedlong: ...
    @overload
    def getFeatureResponse(self, i: int) -> float: ...
    @overload
    def getFeatureResponse(size_t) -> float: ...
    def getFeatureX(self, i: int) -> float: ...
    @overload
    def getFeatureY(self, i: int) -> float: ...
    @overload
    def getFeatureY(size_t) -> float: ...
    @overload
    def getMaxID(self) -> int: ...
    @overload
    def getMaxID() -> unsignedlong: ...
    @overload
    def getScale(self, i: int) -> float: ...
    @overload
    def getScale(size_t) -> float: ...
    def getTrackStatus(self, i: int) -> TFeatureTrackStatus: ...
    def get_type(self) -> TKeyPointMethod: ...
    @overload
    def isPointFeature(self, i: int) -> bool: ...
    @overload
    def isPointFeature(size_t) -> bool: ...
    def kdtree_distance(self, p1: float, idx_p2: int, size: int) -> float: ...
    @overload
    def kdtree_get_point_count(self) -> int: ...
    @overload
    def kdtree_get_point_count() -> size_t: ...
    @overload
    def kdtree_get_pt(self, idx: int, dim: int) -> float: ...
    @overload
    def kdtree_get_pt(size_t, int) -> float: ...
    @overload
    def loadFromTextFile(self, fileName: str) -> None: ...
    @overload
    def loadFromTextFile(conststd) -> void: ...
    @overload
    def mark_as_outdated(self) -> None: ...
    @overload
    def mark_as_outdated() -> void: ...
    @overload
    def mark_kdtree_as_outdated(self) -> None: ...
    @overload
    def mark_kdtree_as_outdated() -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def saveToTextFile(self, fileName: str) -> None: ...
    @overload
    def saveToTextFile(self, fileName: str, APPEND: bool) -> None: ...
    @overload
    def saveToTextFile(conststd, bool) -> void: ...
    @overload
    def setFeatureID(self, i: int, id: int) -> None: ...
    @overload
    def setFeatureID(size_t, unsignedlong) -> void: ...
    @overload
    def setFeatureResponse(self, i: int, r: float) -> None: ...
    @overload
    def setFeatureResponse(size_t, float) -> void: ...
    @overload
    def setFeatureX(self, i: int, x: float) -> None: ...
    @overload
    def setFeatureX(size_t, float) -> void: ...
    @overload
    def setFeatureXf(self, i: int, x: float) -> None: ...
    @overload
    def setFeatureXf(size_t, float) -> void: ...
    @overload
    def setFeatureY(self, i: int, y: float) -> None: ...
    @overload
    def setFeatureY(size_t, float) -> void: ...
    @overload
    def setFeatureYf(self, i: int, y: float) -> None: ...
    @overload
    def setFeatureYf(size_t, float) -> void: ...
    @overload
    def setScale(self, i: int, s: int) -> None: ...
    @overload
    def setScale(size_t, uint8_t) -> void: ...
    @overload
    def setTrackStatus(self, i: int, s: TFeatureTrackStatus) -> None: ...
    @overload
    def setTrackStatus(size_t, enummrpt) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CMatchedFeatureList:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CMatchedFeatureList) -> None: ...
    def assign(self) -> CMatchedFeatureList: ...
    def getBothFeatureLists(self, list1: CFeatureList, list2: CFeatureList) -> None: ...
    def getMaxID(self, idx: TListIdx, firstListID: int, secondListID: int) -> None: ...
    def get_type(self) -> TKeyPointMethod: ...
    @overload
    def saveToTextFile(self, fileName: str) -> None: ...
    @overload
    def saveToTextFile(conststd) -> void: ...
    def setLeftMaxID(self, leftID: int) -> None: ...
    def setMaxIDs(self, leftID: int, rightID: int) -> None: ...
    def setRightMaxID(self, rightID: int) -> None: ...
    @overload
    def updateMaxID(self, idx: TListIdx) -> None: ...
    @overload
    def updateMaxID(constenummrpt) -> void: ...

class CStereoRectifyMap:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CStereoRectifyMap) -> None: ...
    def assign(self) -> CStereoRectifyMap: ...
    @overload
    def enableBothCentersCoincide(self) -> None: ...
    @overload
    def enableBothCentersCoincide(self, enable: bool) -> None: ...
    @overload
    def enableBothCentersCoincide(bool) -> void: ...
    @overload
    def enableResizeOutput(self, enable: bool) -> None: ...
    @overload
    def enableResizeOutput(self, enable: bool, target_width: int) -> None: ...
    @overload
    def enableResizeOutput(self, enable: bool, target_width: int, target_height: int) -> None: ...
    @overload
    def getAlpha(self) -> float: ...
    @overload
    def getAlpha() -> double: ...
    def getCameraParams(self) -> mrpt.pymrpt.mrpt.img.TStereoCamera: ...
    def getInterpolationMethod(self) -> mrpt.pymrpt.mrpt.img.TInterpolationMethod: ...
    def getLeftCameraRot(self) -> mrpt.pymrpt.mrpt.poses.CPose3DQuat: ...
    def getRectifiedImageParams(self) -> mrpt.pymrpt.mrpt.img.TStereoCamera: ...
    def getRectifiedLeftImageParams(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    def getRectifiedRightImageParams(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    def getResizeOutputSize(self) -> mrpt.pymrpt.mrpt.img.TPixelCoord: ...
    def getRightCameraRot(self) -> mrpt.pymrpt.mrpt.poses.CPose3DQuat: ...
    @overload
    def isEnabledBothCentersCoincide(self) -> bool: ...
    @overload
    def isEnabledBothCentersCoincide() -> bool: ...
    @overload
    def isEnabledResizeOutput(self) -> bool: ...
    @overload
    def isEnabledResizeOutput() -> bool: ...
    def isSet(self) -> bool: ...
    @overload
    def rectify(self, in_left_image: mrpt.pymrpt.mrpt.img.CImage, in_right_image: mrpt.pymrpt.mrpt.img.CImage, out_left_image: mrpt.pymrpt.mrpt.img.CImage, out_right_image: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def rectify(self, stereo_image_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> None: ...
    @overload
    def rectify(self, stereo_image_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages, use_internal_mem_cache: bool) -> None: ...
    @overload
    def rectify(classmrpt, constbool) -> void: ...
    @overload
    def setAlpha(self, alpha: float) -> None: ...
    @overload
    def setAlpha(double) -> void: ...
    @overload
    def setFromCamParams(self, params: mrpt.pymrpt.mrpt.img.TStereoCamera) -> None: ...
    @overload
    def setFromCamParams(constclassmrpt) -> void: ...
    @overload
    def setFromCamParams(self, stereo_obs: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> None: ...
    @overload
    def setFromCamParams(constclassmrpt) -> void: ...
    @overload
    def setInterpolationMethod(self, interp: mrpt.pymrpt.mrpt.img.TInterpolationMethod) -> None: ...
    @overload
    def setInterpolationMethod(constenummrpt) -> void: ...

class TDescriptorType:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    descAny: ClassVar[TDescriptorType] = ...
    descBLD: ClassVar[TDescriptorType] = ...
    descLATCH: ClassVar[TDescriptorType] = ...
    descLogPolarImages: ClassVar[TDescriptorType] = ...
    descORB: ClassVar[TDescriptorType] = ...
    descPolarImages: ClassVar[TDescriptorType] = ...
    descSIFT: ClassVar[TDescriptorType] = ...
    descSURF: ClassVar[TDescriptorType] = ...
    descSpinImages: ClassVar[TDescriptorType] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TFeatureObservation:
    id_feature: int
    id_frame: int
    px: mrpt.pymrpt.mrpt.img.TPixelCoordf
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _id_feature: int, _id_frame: int, _px: mrpt.pymrpt.mrpt.img.TPixelCoordf) -> None: ...
    @overload
    def __init__(self, arg0: TFeatureObservation) -> None: ...
    def assign(self) -> TFeatureObservation: ...

class TFeatureTrackStatus:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    status_IDLE: ClassVar[TFeatureTrackStatus] = ...
    status_LOST: ClassVar[TFeatureTrackStatus] = ...
    status_OOB: ClassVar[TFeatureTrackStatus] = ...
    status_TRACKED: ClassVar[TFeatureTrackStatus] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TImageCalibData:
    detected_corners: List[mrpt.pymrpt.mrpt.img.TPixelCoordf]
    img_checkboard: mrpt.pymrpt.mrpt.img.CImage
    img_original: mrpt.pymrpt.mrpt.img.CImage
    img_rectified: mrpt.pymrpt.mrpt.img.CImage
    projectedPoints_distorted: List[mrpt.pymrpt.mrpt.img.TPixelCoordf]
    projectedPoints_undistorted: List[mrpt.pymrpt.mrpt.img.TPixelCoordf]
    reconstructed_camera_pose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self, arg0: TImageCalibData) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TImageCalibData: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...

class TImageROI:
    xMax: int
    xMin: int
    yMax: int
    yMin: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x1: int, x2: int, y1: int, y2: int) -> None: ...
    @overload
    def __init__(self, arg0: TImageROI) -> None: ...

class TKeyPointMethod:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    featAKAZE: ClassVar[TKeyPointMethod] = ...
    featBeacon: ClassVar[TKeyPointMethod] = ...
    featFAST: ClassVar[TKeyPointMethod] = ...
    featHarris: ClassVar[TKeyPointMethod] = ...
    featKLT: ClassVar[TKeyPointMethod] = ...
    featLSD: ClassVar[TKeyPointMethod] = ...
    featNotDefined: ClassVar[TKeyPointMethod] = ...
    featORB: ClassVar[TKeyPointMethod] = ...
    featSIFT: ClassVar[TKeyPointMethod] = ...
    featSURF: ClassVar[TKeyPointMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TKeyPointTraits_mrpt_vision_TKeyPoint_templ_mrpt_img_TPixelCoord_t:
    def __init__(self) -> None: ...
    def f2coord(self, *args, **kwargs) -> Any: ...

class TKeyPointTraits_mrpt_vision_TKeyPoint_templ_mrpt_img_TPixelCoordf_t:
    def __init__(self) -> None: ...
    def f2coord(self, *args, **kwargs) -> Any: ...

class TKeyPoint_templ_mrpt_img_TPixelCoordf_t:
    ID: int
    octave: int
    pt: mrpt.pymrpt.mrpt.img.TPixelCoordf
    response: float
    track_status: TFeatureTrackStatus
    user_flags: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TKeyPoint_templ_mrpt_img_TPixelCoordf_t) -> None: ...
    def assign(self) -> TKeyPoint_templ_mrpt_img_TPixelCoordf_t: ...

class TListIdx:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    bothLists: ClassVar[TListIdx] = ...
    firstList: ClassVar[TListIdx] = ...
    secondList: ClassVar[TListIdx] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TMatchingOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    class TMatchingMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        mmCorrelation: ClassVar[TMatchingOptions.TMatchingMethod] = ...
        mmDescriptorORB: ClassVar[TMatchingOptions.TMatchingMethod] = ...
        mmDescriptorSIFT: ClassVar[TMatchingOptions.TMatchingMethod] = ...
        mmDescriptorSURF: ClassVar[TMatchingOptions.TMatchingMethod] = ...
        mmSAD: ClassVar[TMatchingOptions.TMatchingMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    mmCorrelation: ClassVar[TMatchingOptions.TMatchingMethod] = ...
    mmDescriptorORB: ClassVar[TMatchingOptions.TMatchingMethod] = ...
    mmDescriptorSIFT: ClassVar[TMatchingOptions.TMatchingMethod] = ...
    mmDescriptorSURF: ClassVar[TMatchingOptions.TMatchingMethod] = ...
    mmSAD: ClassVar[TMatchingOptions.TMatchingMethod] = ...
    __hash__: ClassVar[None] = ...
    EDD_RATIO: float
    EDSD_RATIO: float
    F: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    SAD_RATIO: float
    addMatches: bool
    enable_robust_1to1_match: bool
    epipolar_TH: float
    estimateDepth: bool
    hasFundamentalMatrix: bool
    matching_method: TMatchingOptions.TMatchingMethod
    maxDepthThreshold: float
    maxEDD_TH: float
    maxEDSD_TH: float
    maxORB_dist: float
    maxSAD_TH: float
    max_disp: float
    minCC_TH: float
    minDCC_TH: float
    min_disp: float
    parallelOpticalAxis: bool
    rCC_TH: float
    useDisparityLimits: bool
    useEpipolarRestriction: bool
    useXRestriction: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMatchingOptions) -> None: ...
    @overload
    def __init__(self, arg0: TMatchingOptions) -> None: ...
    def assign(self, o: TMatchingOptions) -> None: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def __eq__(self, o: TMatchingOptions) -> bool: ...

class TMultiResDescMatchOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    highScl1: int
    highScl2: int
    lastSeenThreshold: int
    lowScl1: int
    lowScl2: int
    matchingRatioThreshold: float
    matchingThreshold: float
    minFeaturesToBeLost: int
    minFeaturesToFind: int
    oriThreshold: float
    searchAreaSize: int
    timesSeenThreshold: int
    useDepthFilter: bool
    useOriFilter: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _useOriFilter: bool, _oriThreshold: float, _useDepthFilter: bool, _th: float, _th2: float, _lwscl1: int, _lwscl2: int, _hwscl1: int, _hwscl2: int, _searchAreaSize: int, _lsth: int, _tsth: int, _minFeaturesToFind: int, _minFeaturesToBeLost: int) -> None: ...
    @overload
    def __init__(self, arg0: TMultiResDescMatchOptions) -> None: ...
    @overload
    def __init__(self, arg0: TMultiResDescMatchOptions) -> None: ...
    def assign(self) -> TMultiResDescMatchOptions: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class TMultiResDescOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    basePSize: int
    baseline: float
    blurImage: bool
    comHScl: int
    comLScl: int
    computeDepth: bool
    computeHashCoeffs: bool
    cropValue: float
    cx: float
    cy: float
    fx: float
    scales: List[float]
    sg1: float
    sg2: float
    sg3: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMultiResDescOptions) -> None: ...
    @overload
    def __init__(self, arg0: TMultiResDescOptions) -> None: ...
    def assign(self) -> TMultiResDescOptions: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class TMultiResMatchingOutput:
    firstListCorrespondences: List[int]
    firstListDistance: List[float]
    firstListFoundScales: List[int]
    nMatches: int
    secondListCorrespondences: List[int]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMultiResMatchingOutput) -> None: ...
    def assign(self) -> TMultiResMatchingOutput: ...

class TROI:
    xMax: float
    xMin: float
    yMax: float
    yMin: float
    zMax: float
    zMin: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x1: float, x2: float, y1: float, y2: float, z1: float, z2: float) -> None: ...

class TRelativeFeaturePos:
    id_frame_base: int
    pos: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _id_frame_base: int, _pos) -> None: ...

class TSequenceFeatureObservations:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, arg0: TSequenceFeatureObservations) -> None: ...
    def assign(self) -> TSequenceFeatureObservations: ...
    @overload
    def decimateCameraFrames(self, decimate_ratio: int) -> None: ...
    @overload
    def decimateCameraFrames(size_t) -> void: ...
    @overload
    def loadFromTextFile(self, filName: str) -> None: ...
    @overload
    def loadFromTextFile(conststd) -> void: ...
    @overload
    def removeFewObservedFeatures(self) -> int: ...
    @overload
    def removeFewObservedFeatures(self, minNumObservations: int) -> int: ...
    @overload
    def removeFewObservedFeatures(size_t) -> size_t: ...
    @overload
    def saveToTextFile(self, filName: str) -> None: ...
    @overload
    def saveToTextFile(self, filName: str, skipFirstCommentLine: bool) -> None: ...
    @overload
    def saveToTextFile(conststd, bool) -> void: ...

class TStereoSystemParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    class TUnc_Prop_Method:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        Prop_Linear: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
        Prop_SUT: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
        Prop_UT: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    Prop_Linear: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
    Prop_SUT: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
    Prop_UT: ClassVar[TStereoSystemParams.TUnc_Prop_Method] = ...
    F: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    K: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    baseline: float
    factor_a: float
    factor_b: float
    factor_k: float
    maxY: float
    maxZ: float
    minZ: float
    stdDisp: float
    stdPixel: float
    uncPropagation: TStereoSystemParams.TUnc_Prop_Method
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TStereoSystemParams) -> None: ...
    @overload
    def __init__(self, arg0: TStereoSystemParams) -> None: ...
    def assign(self) -> TStereoSystemParams: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

def addFeaturesToImage(*args, **kwargs) -> Any: ...
def buildIntrinsicParamsMatrix(focalLengthX: float, focalLengthY: float, centerX: float, centerY: float) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t: ...
def computeMainOrientation(*args, **kwargs) -> Any: ...
def computeMsd(list: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, Rt: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
def computeSAD(patch1: mrpt.pymrpt.mrpt.img.CImage, patch2: mrpt.pymrpt.mrpt.img.CImage) -> float: ...
def computeStereoRectificationMaps(cam1: mrpt.pymrpt.mrpt.img.TCamera, cam2: mrpt.pymrpt.mrpt.img.TCamera, rightCameraPose: mrpt.pymrpt.mrpt.poses.CPose3D, outMap1x: capsule, outMap1y: capsule, outMap2x: capsule, outMap2y: capsule) -> None: ...
def matchFeatures(*args, **kwargs) -> Any: ...
def normalizeImage(*args, **kwargs) -> Any: ...
def pixelTo3D(*args, **kwargs) -> Any: ...
def projectMatchedFeatures(*args, **kwargs) -> Any: ...
