/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.fastcdr.idl.generator;

import com.eprosima.idl.context.Context;
import com.eprosima.idl.generator.manager.TemplateManager;
import com.eprosima.idl.parser.tree.Definition;
import com.eprosima.idl.parser.tree.Export;
import com.eprosima.idl.parser.tree.Interface;
import com.eprosima.idl.parser.tree.Module;
import com.eprosima.idl.parser.tree.TypeDeclaration;
import com.eprosima.log.ColorMessage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class TypesGenerator {
    private TemplateManager tmanager_ = null;
    private StringTemplateGroup stg_ = null;
    private String outputDir_ = null;
    private boolean replace_ = false;

    public TypesGenerator(TemplateManager tmanager, String outputDir, boolean replace) {
        this.tmanager_ = tmanager;
        this.outputDir_ = outputDir;
        this.replace_ = replace;
        this.stg_ = this.tmanager_.createStringTemplateGroup("JavaType");
    }

    public boolean generate(Context context, String packagDir, String packag, String libraryName, Map<String, String> extensions) {
        ArrayList<Definition> definitions = context.getDefinitions();
        boolean returnedValue = this.processDefinitions(context, definitions, packagDir, packag, extensions);
        if (returnedValue) {
            StringTemplateGroup gradlestg = this.tmanager_.createStringTemplateGroup("gradle");
            StringTemplate gradlest = gradlestg.getInstanceOf("main");
            gradlest.setAttribute("name", libraryName);
            if (!this.writeFile(this.outputDir_ + "build.gradle", gradlest)) {
                System.out.println(ColorMessage.error() + "Cannot write file " + this.outputDir_ + "build.gradle");
                returnedValue = false;
            }
        }
        return returnedValue;
    }

    public boolean processDefinitions(Context context, ArrayList<Definition> definitions, String packagDir, String packag, Map<String, String> extensions) {
        if (definitions != null) {
            for (Definition definition : definitions) {
                TypeDeclaration typedecl;
                StringTemplate typest;
                if (definition.isIsModule()) {
                    Module module = (Module)definition;
                    String outputDir = packagDir + module.getName();
                    File dir = new File(outputDir);
                    if (!dir.exists() && !dir.mkdir()) {
                        System.out.println(ColorMessage.error() + "Cannot create directory for module " + module.getName());
                        return false;
                    }
                    if (this.processDefinitions(context, module.getDefinitions(), outputDir + File.separator, packag + "." + module.getName(), extensions)) continue;
                    return false;
                }
                if (definition.isIsInterface()) {
                    Interface ifc = (Interface)definition;
                    StringTemplate ifcst = this.stg_.getInstanceOf("interface");
                    ifcst.setAttribute("ctx", context);
                    ifcst.setAttribute("parent", ifc.getParent());
                    ifcst.setAttribute("interface", ifc);
                    StringTemplate extensionst = null;
                    String extensionname = null;
                    if (extensions != null && (extensionname = extensions.get("interface")) != null) {
                        extensionst = this.stg_.getInstanceOf(extensionname);
                        extensionst.setAttribute("ctx", context);
                        extensionst.setAttribute("parent", ifc.getParent());
                        extensionst.setAttribute("interface", ifc);
                        ifcst.setAttribute("extension", extensionst.toString());
                    }
                    if (this.processExports(context, ifc.getExports(), ifcst, extensions)) {
                        StringTemplate st = this.stg_.getInstanceOf("main");
                        st.setAttribute("ctx", context);
                        st.setAttribute("definitions", ifcst.toString());
                        st.setAttribute("package", !packag.isEmpty() ? packag : null);
                        if (extensions != null && (extensionname = extensions.get("main")) != null) {
                            extensionst = this.stg_.getInstanceOf(extensionname);
                            extensionst.setAttribute("ctx", context);
                            st.setAttribute("extension", extensionst.toString());
                        }
                        if (this.writeFile(packagDir + ifc.getName() + ".java", st)) continue;
                        System.out.println(ColorMessage.error() + "Cannot write file " + packagDir + ifc.getName() + ".java");
                        return false;
                    }
                    return false;
                }
                if (!definition.isIsTypeDeclaration() || (typest = this.processTypeDeclaration(context, typedecl = (TypeDeclaration)definition, extensions)) == null) continue;
                StringTemplate st = this.stg_.getInstanceOf("main");
                st.setAttribute("ctx", context);
                st.setAttribute("definitions", typest.toString());
                st.setAttribute("package", !packag.isEmpty() ? packag : null);
                StringTemplate extensionst = null;
                String extensionname = null;
                if (extensions != null && (extensionname = extensions.get("main")) != null) {
                    extensionst = this.stg_.getInstanceOf(extensionname);
                    extensionst.setAttribute("ctx", context);
                    st.setAttribute("extension", extensionst.toString());
                }
                if (this.writeFile(packagDir + typedecl.getName() + ".java", st)) continue;
                System.out.println(ColorMessage.error() + "Cannot write file " + packagDir + typedecl.getName() + ".java");
                return false;
            }
        }
        return true;
    }

    public boolean processExports(Context context, ArrayList<Export> exports, StringTemplate ifcst, Map<String, String> extensions) {
        for (Export export : exports) {
            TypeDeclaration typedecl;
            StringTemplate typest;
            if (!export.isIsTypeDeclaration() || (typest = this.processTypeDeclaration(context, typedecl = (TypeDeclaration)export, extensions)) == null) continue;
            ifcst.setAttribute("exports", typest.toString());
        }
        return true;
    }

    public StringTemplate processTypeDeclaration(Context context, TypeDeclaration typedecl, Map<String, String> extensions) {
        StringTemplate typest = null;
        StringTemplate extensionst = null;
        String extensionname = null;
        System.out.println("processTypesDeclaration " + typedecl.getName());
        if (typedecl.getTypeCode().getKind() == 10) {
            typest = this.stg_.getInstanceOf("struct_type");
            typest.setAttribute("struct", typedecl.getTypeCode());
            if (extensions != null && (extensionname = extensions.get("struct_type")) != null) {
                extensionst = this.stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("struct", typedecl.getTypeCode());
            }
        } else if (typedecl.getTypeCode().getKind() == 11) {
            typest = this.stg_.getInstanceOf("union_type");
            typest.setAttribute("union", typedecl.getTypeCode());
            if (extensions != null && (extensionname = extensions.get("union_type")) != null) {
                extensionst = this.stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("union", typedecl.getTypeCode());
            }
        } else if (typedecl.getTypeCode().getKind() == 12) {
            typest = this.stg_.getInstanceOf("enum_type");
            typest.setAttribute("enum", typedecl.getTypeCode());
            if (extensions != null && (extensionname = extensions.get("enum_type")) != null) {
                extensionst = this.stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("enum", typedecl.getTypeCode());
            }
        } else if (typedecl.getTypeCode().getKind() == 26) {
            typest = this.stg_.getInstanceOf("bitset_type");
            typest.setAttribute("bitset", typedecl.getTypeCode());
            if (extensions != null && (extensionname = extensions.get("bitset_type")) != null) {
                extensionst = this.stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("bitset", typedecl.getTypeCode());
            }
        }
        if (typest != null) {
            if (extensionst != null) {
                extensionst.setAttribute("ctx", context);
                extensionst.setAttribute("parent", typedecl.getParent());
                typest.setAttribute("extension", extensionst.toString());
            }
            typest.setAttribute("ctx", context);
            typest.setAttribute("parent", typedecl.getParent());
        }
        return typest;
    }

    private boolean writeFile(String file, StringTemplate template) {
        boolean returnedValue = false;
        try {
            File handle = new File(file);
            if (!handle.exists() || this.replace_) {
                FileWriter fw = new FileWriter(file);
                String data = template.toString();
                fw.write(data, 0, data.length());
                fw.close();
            } else {
                System.out.println("INFO: " + file + " exists. Skipping.");
            }
            returnedValue = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnedValue;
    }
}

