/*
 * Copyright (C) 2021 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef RMF_TASK_SEQUENCE__EVENTS__PLACEHOLDER_HPP
#define RMF_TASK_SEQUENCE__EVENTS__PLACEHOLDER_HPP

#include <rmf_task_sequence/Event.hpp>

namespace rmf_task_sequence {
namespace events {

//==============================================================================
/// A Placeholder event takes care of the boilerplate needed to define a
/// description for an event whose model does not matter and will not be used
/// for planning. The model generated by this description will not perform any
/// changes to the task state, and it will provide an estimated duration of 0.
class Placeholder
{
public:

  class Description;
  class Model;
};

//==============================================================================
class Placeholder::Description : public Event::Description
{
public:

  Description(std::string category, std::string detail);

  Activity::ConstModelPtr make_model(
    rmf_task::State invariant_initial_state,
    const rmf_task::Parameters& parameters) const override;

  rmf_task::Header generate_header(
    const rmf_task::State& initial_state,
    const rmf_task::Parameters& parameters) const override;

  class Implementation;
private:
  rmf_utils::impl_ptr<Implementation> _pimpl;
};

} // namespace events
} // namespace rmf_task_sequence

#endif // RMF_TASK_SEQUENCE__EVENTS__PLACEHOLDER_HPP
