# Setting Controller Parameters for the Schunk SVH

Setting controller parameters for the Schunk SVH requires detailed experience of the hardware.
Each finger has its on set of parameters in the respective `.xacro` file.

There exist multiple hardware versions for the Schunk SVH hand.
If you change parameter values, make sure you change them for the correct hardware version.
This version is printed during startup and looks similar to
```bash
   [SystemInterface]: The Schunk SVH is version: 2.3.

```
In this case major version `2` and minor version `3`.


---

**Warning**: Only change the values in the `.xacro` files if you know what you are doing.
Setting wrong values, especially for the current controller,
might permanently damage your hardware. There are *no* safety checks for these.
Please consult the available documentation and only change the parameter
values in small increments.

---

## Position Controller Values
The position controller evaluates the difference between desired state and
current state in `encoder ticks` and computes a motor current command for the
current controller in `[mA]`.

The following is a list of parameters for the position controller in order.
All values need to be set.


* `Reference signal minimum value` : Minimum allowed position input `[encoder ticks]`
* `Reference signal maximum value` : Maximum allowed position input `[encoder ticks]`
* `Reference signal delta maximum threshold` : Maximum allowed tick difference per control cycle `[encoder ticks]`
* `Measurement scaling` : Feedback Scaling. Set to `1` to work in ticks (should not be changed)
* `Time base of controller` : Time base of the position controller (should not be changed)
* `Integral windup minimum value` : Maximum allowed value for the integrator `[mA*tick/s]`
* `Integral windup maximum value` : Minimum allowed value for the integrator `[mA*tick/s]`
* `Proportional gain`
* `Integral gain`
* `Differential gain`

## Current Controller Values

The current controller uses the control commands of the position controller
to generate a *PWM-based* signal for the driver units. The error signal is calculated in `[mA]` and the
controlled unit are duty cycles.

---

**Note**: Pay Special attention to the output limits as well as the reference signal min and max value as these limit the
overall current that is applied to the motors

---

The following is a list of parameters for the current controller in order.
All values need to be set.

* `Reference signal minimum value` : Minimum allowed current value `[mA]`. The reference signal is generated by position controller.
* `Reference signal maximum value` : Maximum allowed current value `[mA]`. The reference signal is generated by position controller.
* `measurement scaling` : Feedback scaling. Do not change to work in [mA]
* `time base of controller` : Should not be changed. The current controller needs to work faster than the position controller.
* `Integral windup minimum value` : Minimum allowed value for the integrator `[1/(mA*s)]`
* `Integral windup maximum value` : Maximum allowed value for the integrator `[1/(mA*s)]`
* `proportional gain`
* `Integral gain`
* `Output limiter min` : The output is the duty cycle of the driver units `[-255 - 0]`
* `Output limiter max` : The output is the duty cycle of the driver units `[0-255]`

## Home Settings

The following is a list of home settings in order.
All values need to be set.

* `Movement direction for reset` : +1 or -1
* `Minimum allowed tick position` : Soft stop
* `Maximum allowed tick position` : Soft stop
* `idle position` :  finger will drive there after reset
* `Rad range` :  angle in rad that the finger is able to move (used for conversion)
* `Reset Current Factor` :  Indicates how much of the total allowed controller current must be reached to detect a hard stop. Should usually be lower than 1.0  `[0.0 - 1.0]`.
